/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ococic.opplugin.outbill;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.occ.ococic.business.channelinv.ChannelInvAccHelper;
import kd.occ.ococic.business.helper.LotHelper;
import kd.occ.ococic.business.helper.SnMainFileHelper;
import kd.occ.ococic.util.CommonUtils;
import kd.occ.ococic.validator.invacc.InvAccUpdateUnAuditValidator;
import kd.occ.ococic.validator.outbill.ChannelOutBillUnAuditSNValidator;

public class ChannelOutBillUnAuditOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        ArrayList<String> keys = new ArrayList<String>(17);
        keys.add("billno");
        keys.add("billtypeid");
        keys.add("outchannelid");
        keys.add("billentry.seq");
        keys.add("itemid");
        keys.add("lotid");
        keys.add("lotnumber");
        keys.add("projectid");
        keys.add("productdate");
        keys.add("expiredate");
        keys.add("snquantity");
        keys.add("serialnumber");
        keys.add("serialid");
        keys.add("snunit");
        keys.add("srcbillentryid");
        keys.add("serialcomment");
        keys.add("chnloutbill_sn");
        keys.add("serialid");
        keys.add("present");
        e.getFieldKeys().addAll(keys);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new ChannelOutBillUnAuditSNValidator());
        e.addValidator((AbstractValidator)new InvAccUpdateUnAuditValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        DynamicObject[] bills = e.getDataEntities();
        ArrayList<Long> billIds = new ArrayList<Long>(bills.length);
        for (DynamicObject bill : bills) {
            long billid = bill.getLong("id");
            billIds.add(billid);
        }
        this.deleteDeliveryRecord(billIds);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] bills = e.getDataEntities();
        ArrayList<Long> billIdList = new ArrayList<Long>(bills.length);
        ArrayList<Long> updateInvBillIdList = new ArrayList<Long>(bills.length);
        for (DynamicObject bill : bills) {
            billIdList.add(bill.getLong("id"));
            long billtypeid = bill.getLong("billtypeid.id");
            DynamicObject outchannel = bill.getDynamicObject("outchannelid");
            String invcontrolmode = outchannel.getString("invcontrolmode");
            if (StringUtils.equals((CharSequence)invcontrolmode, (CharSequence)"B") && billtypeid != 1640631427215145984L) continue;
            updateInvBillIdList.add(bill.getLong("id"));
        }
        SnMainFileHelper.saveSnMainFileByUnAudit(updateInvBillIdList, (String)"ococic_channeloutbill");
        LotHelper.deleteLot(billIdList, (String)"ococic_channeloutbill");
        Map errorMessageData = ChannelInvAccHelper.updateChannelInvAccByBillUnAudit(updateInvBillIdList, (String)"ococic_channeloutbill");
        if (!CommonUtils.isNull((Object)errorMessageData)) {
            for (Map.Entry errorMessageEntry : errorMessageData.entrySet()) {
                List errorMessages = (List)errorMessageEntry.getValue();
                for (DynamicObject bill : bills) {
                    OperateErrorInfo errorInfo = new OperateErrorInfo("errorcode_001", ErrorLevel.Error, bill.getPkValue());
                    errorInfo.setMessage((String)errorMessages.get(0));
                    this.operationResult.addErrorInfo(errorInfo);
                }
            }
            e.setDataEntities(new DynamicObject[0]);
        }
    }

    public void deleteDeliveryRecord(List<Long> billIds) {
        QFilter qfilter = new QFilter("deliverydetail.srcbillid", "in", billIds);
        qfilter.and("sourcebilltype", "=", (Object)"ococic_channeloutbill");
        DynamicObjectCollection records = QueryServiceHelper.query((String)"ocbsoc_delivery_record", (String)"id,billno,billstatus,deliverydetail.srcbillnumber", (QFilter[])qfilter.toArray());
        if (records == null || records.size() == 0) {
            return;
        }
        ArrayList<Long> recordIds = new ArrayList<Long>(records.size());
        StringBuilder signnumbersb = new StringBuilder();
        for (DynamicObject record : records) {
            long recordId = record.getLong("id");
            if (recordId <= 0L || recordIds.contains(recordId)) continue;
            recordIds.add(recordId);
            String signstatus = record.getString("billstatus");
            if (!"C".equalsIgnoreCase(signstatus) && !"D".equalsIgnoreCase(signstatus)) continue;
            String srcbillnumber = record.getString("deliverydetail.srcbillnumber");
            signnumbersb.append(srcbillnumber);
        }
        if (signnumbersb.length() > 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6e20\u9053\u51fa\u5e93\u5355 [%s] \u5df2\u4e0b\u63a8\u7684\u53d1\u8d27\u8bb0\u5f55\u5df2\u7b7e\u6536\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838", (String)"ChannelOutBillUnAuditOp_1", (String)"occ-ococic-opplugin", (Object[])new Object[0]), signnumbersb.toString()));
        }
        try {
            OperationResult oResult;
            if (recordIds.size() > 0 && (oResult = OperationServiceHelper.executeOperate((String)"delete", (String)"ocbsoc_delivery_record", (Object[])recordIds.toArray(), (OperateOption)OperateOption.create())) != null && !oResult.isSuccess()) {
                String msg = "";
                List errorInfoList = oResult.getAllErrorOrValidateInfo();
                if (errorInfoList != null && errorInfoList.size() > 0) {
                    for (IOperateInfo errofInfo : errorInfoList) {
                        msg = String.join((CharSequence)";", msg, errofInfo.getMessage());
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)(msg = String.join((CharSequence)"", oResult.getMessage())))) {
                    throw new KDBizException(msg);
                }
            }
        }
        catch (Exception e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5220\u9664\u53d1\u8d27\u8bb0\u5f55\u5931\u8d25\uff1a%s", (String)"ChannelOutBillUnAuditOp_2", (String)"occ-ococic-opplugin", (Object[])new Object[0]), e.getMessage()));
        }
    }
}

