/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ococic.opplugin.transbill;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.occ.ocbase.business.helper.BotpHelper;
import kd.occ.ocbase.common.pagemodel.ococic.OcocicTransbill;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ococic.validator.transbill.TransBillConfirmValidator;
import kd.occ.ococic.validator.transbill.TransBillSNValidator;

public class TransBillConfirmPushOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add(OcocicTransbill.E_itementry_id);
        fieldKeys.add("itemid");
        fieldKeys.add("auxptyid");
        fieldKeys.add("lotid");
        fieldKeys.add("lotnumber");
        fieldKeys.add("productdate");
        fieldKeys.add("expiredate");
        fieldKeys.add("outprojectid");
        fieldKeys.add("outwarehouseid");
        fieldKeys.add("outlocationid");
        fieldKeys.add("outkeeperid");
        fieldKeys.add("outkeepertype");
        fieldKeys.add("outownerid");
        fieldKeys.add("outownertype");
        fieldKeys.add("serialqty");
        fieldKeys.add("serialid");
        fieldKeys.add("serialnumber");
        fieldKeys.add("transmode");
        fieldKeys.add("outchannelid");
        fieldKeys.add("inchannelid");
        fieldKeys.add("billtypeid");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new TransBillConfirmValidator());
        e.addValidator((AbstractValidator)new TransBillSNValidator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] billDynObjs = e.getDataEntities();
        if (CommonUtils.isNull((Object)billDynObjs)) {
            return;
        }
        String outRule = "1321722640557386752";
        String inRule = "1321722769070861312";
        String formId = billDynObjs[0].getDataEntityType().getName();
        for (DynamicObject billDynObj : billDynObjs) {
            List<ListSelectedRow> needPushRowList = this.getNeedPushSelectRowList(new DynamicObject[]{billDynObj});
            List pushOutBillList = BotpHelper.getConvertResultBill(needPushRowList, (String)formId, (String)"ococic_channeloutbill", (String)outRule);
            List<Long> outBillIdList = this.autoAuditBill(pushOutBillList, "ococic_channeloutbill");
            if (CommonUtils.isNull(outBillIdList) || "1".equals(billDynObj.getString("transmode"))) continue;
            List<Long> inBillIdList = null;
            try {
                List pushInBillList = BotpHelper.getConvertResultBill(needPushRowList, (String)formId, (String)"ococic_channelinbill", (String)inRule);
                inBillIdList = this.autoAuditBill(pushInBillList, "ococic_channelinbill");
            }
            finally {
                if (CommonUtils.isNull(inBillIdList)) {
                    this.deleteAuditBill("ococic_channeloutbill", outBillIdList, true);
                }
            }
        }
        super.beforeExecuteOperationTransaction(e);
    }

    private List<ListSelectedRow> getNeedPushSelectRowList(DynamicObject[] billDynObjs) {
        ArrayList<ListSelectedRow> needPushRowList = new ArrayList<ListSelectedRow>(billDynObjs.length * 10);
        for (DynamicObject dynObj : billDynObjs) {
            DynamicObjectCollection entryColl = dynObj.getDynamicObjectCollection("itementry");
            for (DynamicObject entryDynObj : entryColl) {
                ListSelectedRow selectRow = new ListSelectedRow((Object)dynObj.getLong("id"));
                selectRow.setEntryEntityKey("itementry");
                selectRow.setEntryPrimaryKeyValue((Object)entryDynObj.getLong("id"));
                needPushRowList.add(selectRow);
            }
        }
        return needPushRowList;
    }

    private List<Long> autoAuditBill(List<DynamicObject> pushBillList, String formId) {
        if (CommonUtils.isNull(pushBillList)) {
            return new ArrayList<Long>(0);
        }
        String billName = this.getBillName(formId);
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)formId, (DynamicObject[])pushBillList.toArray(new DynamicObject[pushBillList.size()]), (OperateOption)CommonUtils.getOperateOption());
        if (!saveResult.isSuccess()) {
            throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"{0}\u81ea\u52a8\u4fdd\u5b58\u5931\u8d25:{1}", (String)"TransBillConfirmPushOp_0", (String)"occ-ococic-opplugin", (Object[])new Object[0]), billName, CommonUtils.getErrDetail((OperationResult)saveResult)));
        }
        List<Long> billIdList = saveResult.getSuccessPkIds().stream().map(obj -> Long.parseLong(obj.toString())).collect(Collectors.toList());
        OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)formId, (Object[])billIdList.toArray(), (OperateOption)CommonUtils.getOperateOption());
        if (!submitResult.isSuccess()) {
            throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"{0}\u81ea\u52a8\u63d0\u4ea4\u5931\u8d25:{1}", (String)"TransBillConfirmPushOp_1", (String)"occ-ococic-opplugin", (Object[])new Object[0]), billName, CommonUtils.getErrDetail((OperationResult)submitResult)));
        }
        OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)formId, (Object[])billIdList.toArray(), (OperateOption)CommonUtils.getOperateOption());
        if (!auditResult.isSuccess()) {
            this.deleteAuditBill(formId, billIdList, false);
            throw new KDBizException(this.getAuditMsg(formId, auditResult));
        }
        return billIdList;
    }

    private void deleteAuditBill(String formId, List<Long> billIdList, boolean isAuditSuccess) {
        QFilter qFilter = new QFilter("id", "in", billIdList);
        OperationResult operationResult = null;
        operationResult = isAuditSuccess ? OperationServiceHelper.executeOperate((String)"unaudit", (String)formId, (Object[])billIdList.toArray(), (OperateOption)CommonUtils.getOperateOption()) : OperationServiceHelper.executeOperate((String)"unsubmit", (String)formId, (Object[])billIdList.toArray(), (OperateOption)CommonUtils.getOperateOption());
        if (operationResult == null) {
            return;
        }
        if (operationResult.isSuccess()) {
            OperationResult deleteResult = OperationServiceHelper.executeOperate((String)"delete", (String)formId, (Object[])billIdList.toArray(), (OperateOption)CommonUtils.getOperateOption());
            if (!deleteResult.isSuccess()) {
                DeleteServiceHelper.delete((String)formId, (QFilter[])qFilter.toArray());
                throw new KDBizException(this.getAuditMsg(formId, deleteResult));
            }
        } else {
            DeleteServiceHelper.delete((String)formId, (QFilter[])qFilter.toArray());
            throw new KDBizException(this.getAuditMsg(formId, operationResult));
        }
    }

    private String getAuditMsg(String formId, OperationResult operationResult) {
        return MessageFormat.format(ResManager.loadKDString((String)"{0}\u81ea\u52a8\u5ba1\u6838\u5931\u8d25:{1}", (String)"TransBillConfirmPushOp_2", (String)"occ-ococic-opplugin", (Object[])new Object[0]), this.getBillName(formId), CommonUtils.getErrDetail((OperationResult)operationResult));
    }

    private String getBillName(String formId) {
        return "ococic_channeloutbill".equals(formId) ? ResManager.loadKDString((String)"\u6e20\u9053\u51fa\u5e93", (String)"TransBillConfirmPushOp_3", (String)"occ-ococic-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6e20\u9053\u5165\u5e93", (String)"TransBillConfirmPushOp_4", (String)"occ-ococic-opplugin", (Object[])new Object[0]);
    }
}

