/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ococic.validator.allotbill;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.util.CollectionUtils;
import kd.occ.ocbase.common.enums.ControlType;
import kd.occ.ocbase.common.enums.allotbill.AllotType;
import kd.occ.ocbase.common.enums.allotbill.CalculateType;
import kd.occ.ocbase.common.util.CustomerParamsUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.StringUtils;
import kd.occ.ocbase.common.validator.BatchFastValidator;
import kd.occ.ococic.business.allotbill.AllotBillHandler;

public class AllotBillValidator
extends BatchFastValidator {
    public void save(ExtendedDataEntity[] datas) {
        super.save(datas);
        for (ExtendedDataEntity data : datas) {
            this.handleDataFromImport(data);
            this.checkAllotBill(data);
        }
    }

    public void submit(ExtendedDataEntity[] datas) {
        super.submit(datas);
        for (ExtendedDataEntity data : datas) {
            this.checkAllotBill(data);
        }
    }

    public void audit(ExtendedDataEntity[] datas) {
        super.audit(datas);
        block4: for (ExtendedDataEntity data : datas) {
            DynamicObject bill = data.getDataEntity();
            long saleOrgId = DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)bill, (String)"org");
            ControlType controlType = CustomerParamsUtil.getAllotControlType((Object)saleOrgId);
            switch (controlType) {
                case STRONG_CONTROL: {
                    if (AllotBillHandler.checkBeforeAudit((DynamicObject)bill)) continue block4;
                    this.addFatalErrorMessage(data, ResManager.loadKDString((String)"\u66f4\u65b0\u53ef\u9500\u91cf\u7ed3\u679c\u8868\u4f1a\u4ea7\u751f\u8d1f\u53ef\u7528\u91cf,\u5ba1\u6838\u5931\u8d25\u3002", (String)"AllotBillValidator_0", (String)"occ-ococic-opplugin", (Object[])new Object[0]));
                    continue block4;
                }
                case WARNNING: {
                    if (AllotBillHandler.checkBeforeAudit((DynamicObject)bill)) continue block4;
                    this.addWarningMessage(data, ResManager.loadKDString((String)"\u66f4\u65b0\u53ef\u9500\u91cf\u7ed3\u679c\u8868\u4f1a\u4ea7\u751f\u8d1f\u53ef\u7528\u91cf,\u662f\u5426\u7ee7\u7eed?", (String)"AllotBillValidator_1", (String)"occ-ococic-opplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    private void checkAllotBill(ExtendedDataEntity data) {
        DynamicObject bill = data.getDataEntity();
        DynamicObjectCollection sEntries = bill.getDynamicObjectCollection("sentryentity");
        if (!CollectionUtils.isEmpty((Collection)sEntries)) {
            Map<String, List<DynamicObject>> groupedSEntries = sEntries.stream().collect(Collectors.groupingBy(r -> String.join((CharSequence)"#", DynamicObjectUtils.getDynamicObjectSPkValue((DynamicObject)r, (String)"stockorg1"), DynamicObjectUtils.getDynamicObjectSPkValue((DynamicObject)r, (String)"warehouse1"), DynamicObjectUtils.getDynamicObjectSPkValue((DynamicObject)r, (String)"material1"), DynamicObjectUtils.getDynamicObjectSPkValue((DynamicObject)r, (String)"auxpty1"))));
            List filterSEntries = groupedSEntries.values().stream().filter(r -> r.size() > 1).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(filterSEntries)) {
                this.addErrorMessage(data, MessageFormat.format(ResManager.loadKDString((String)"\u5206\u914d\u6e90 \u7b2c{0}\u884c,\u5e93\u5b58\u7ec4\u7ec7\u3001\u4ed3\u5e93\u3001 \u7269\u6599\u3001 \u8f85\u52a9\u5c5e\u6027 \u91cd\u590d,\u8bf7\u4fee\u6b63\u3002", (String)"AllotBillValidator_2", (String)"occ-ococic-opplugin", (Object[])new Object[0]), String.join((CharSequence)" ", filterSEntries.stream().map(r -> MessageFormat.format("({0})", String.join((CharSequence)",", r.stream().map(y -> y.getString("seq")).collect(Collectors.toList())))).collect(Collectors.toList()))));
            }
            for (DynamicObject sEntry : sEntries) {
                if (sEntry.getBigDecimal("allotbaseqty1").compareTo(sEntry.getBigDecimal("sumbaseqty1")) != 0) {
                    this.addErrorMessage(data, MessageFormat.format(ResManager.loadKDString((String)"\u5206\u914d\u6e90 \u7b2c{0}\u884c \u5df2\u5206\u914d\u57fa\u672c\u6570\u91cf\u9700\u7b49\u4e8e\u53ef\u7528\u57fa\u672c\u6570\u91cf,\u8bf7\u4fee\u6b63.", (String)"AllotBillValidator_3", (String)"occ-ococic-opplugin", (Object[])new Object[0]), sEntry.getString("seq")));
                }
                DynamicObjectCollection pEntries = sEntry.getDynamicObjectCollection("pentryentity");
                pEntries.stream().filter(r -> StringUtils.isEmpty((String)r.getString("ckey2"))).forEach(r -> this.addErrorMessage(data, MessageFormat.format(ResManager.loadKDString((String)"\u5206\u914d\u6e90 \u7b2c{0}\u884c\u4e0b\u5206\u914d\u660e\u7ec6\u7b2c{1}\u884c,\u6e20\u9053\u8303\u56f4 \u4e3a\u7a7a,\u8bf7\u4fee\u6b63\u3002", (String)"AllotBillValidator_4", (String)"occ-ococic-opplugin", (Object[])new Object[0]), sEntry.getString("seq"), r.getString("seq"))));
                Map<String, List<DynamicObject>> groupedPEntries = pEntries.stream().filter(r -> StringUtils.isNotEmpty((String)r.getString("ckey2"))).collect(Collectors.groupingBy(r -> String.join((CharSequence)"#", DynamicObjectUtils.getDynamicObjectSPkValue((DynamicObject)r, (String)"item2"), r.getString("ckey2"))));
                List filterPEntries = groupedPEntries.values().stream().filter(r -> r.size() > 1).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(filterPEntries)) continue;
                this.addErrorMessage(data, MessageFormat.format(ResManager.loadKDString((String)"\u5206\u914d\u6e90 \u7b2c{0}\u884c\u4e0b\u5206\u914d\u660e\u7ec6\u7b2c{1}\u884c,\u5546\u54c1\u3001\u6e20\u9053\u8303\u56f4 \u91cd\u590d,\u8bf7\u4fee\u6b63\u3002", (String)"AllotBillValidator_5", (String)"occ-ococic-opplugin", (Object[])new Object[0]), sEntry.getString("seq"), String.join((CharSequence)" ", filterPEntries.stream().map(r -> MessageFormat.format("({0})", String.join((CharSequence)",", r.stream().map(y -> y.getString("seq")).collect(Collectors.toList())))).collect(Collectors.toList()))));
            }
        } else {
            DynamicObjectCollection entries = bill.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)entries)) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u5206\u914d\u6e90\u3001\u5206\u914d\u660e\u7ec6\u3001\u6e20\u9053\u8303\u56f4\u4e3a\u7a7a\u3002", (String)"AllotBillValidator_6", (String)"occ-ococic-opplugin", (Object[])new Object[0]));
            } else {
                Map<String, List<DynamicObject>> groupedEntries = entries.stream().collect(Collectors.groupingBy(r -> String.join((CharSequence)"#", DynamicObjectUtils.getDynamicObjectSPkValue((DynamicObject)r, (String)"stockorg"), DynamicObjectUtils.getDynamicObjectSPkValue((DynamicObject)r, (String)"warehouse"), DynamicObjectUtils.getDynamicObjectSPkValue((DynamicObject)r, (String)"material"), DynamicObjectUtils.getDynamicObjectSPkValue((DynamicObject)r, (String)"auxpty"), DynamicObjectUtils.getDynamicObjectSPkValue((DynamicObject)r, (String)"baseunit"), DynamicObjectUtils.getDynamicObjectSPkValue((DynamicObject)r, (String)"item"), r.getString("ckey"))));
                List filterEntries = groupedEntries.values().stream().filter(r -> r.size() > 1).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(filterEntries)) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u5206\u914d\u6e90,\u5206\u914d\u660e\u7ec6,\u6e20\u9053\u8303\u56f4 \u5b58\u5728\u91cd\u590d\u6570\u636e.", (String)"AllotBillValidator_7", (String)"occ-ococic-opplugin", (Object[])new Object[0]));
                }
                boolean isChannelScopeEmpty = false;
                boolean isChannelScopeRepeat = false;
                for (DynamicObject entry : entries) {
                    Set channelIdSet;
                    DynamicObjectCollection subEntries = entry.getDynamicObjectCollection("subentryentity");
                    if (!isChannelScopeEmpty && CollectionUtils.isEmpty((Collection)subEntries)) {
                        isChannelScopeEmpty = true;
                        continue;
                    }
                    if (isChannelScopeRepeat || (channelIdSet = subEntries.stream().map(r -> DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)r, (String)"channel")).collect(Collectors.toSet())).size() == subEntries.size()) continue;
                    isChannelScopeRepeat = true;
                }
                if (isChannelScopeEmpty) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u6e20\u9053\u8303\u56f4 \u5b58\u5728 \u7a7a\u6570\u636e.", (String)"AllotBillValidator_8", (String)"occ-ococic-opplugin", (Object[])new Object[0]));
                }
                if (isChannelScopeRepeat) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u6e20\u9053\u8303\u56f4 \u5b58\u5728 \u91cd\u590d\u6570\u636e.", (String)"AllotBillValidator_9", (String)"occ-ococic-opplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    private void handleDataFromImport(ExtendedDataEntity data) {
        String pKey;
        DynamicObject bill = data.getDataEntity();
        DynamicObjectCollection entries = bill.getDynamicObjectCollection("entryentity");
        HashMap<String, BigDecimal> pKey2SumBaseQtyMap = new HashMap<String, BigDecimal>(entries.size());
        for (DynamicObject entry : entries) {
            AllotType allotType;
            DynamicObjectCollection subEntries = entry.getDynamicObjectCollection("subentryentity");
            if (StringUtils.isEmpty((String)entry.getString("skey"))) {
                entry.set("skey", (Object)AllotBillHandler.getSKey((DynamicObject)entry));
            }
            if (StringUtils.isEmpty((String)entry.getString("ckey"))) {
                entry.set("ckey", (Object)AllotBillHandler.getCkey((DynamicObjectCollection)subEntries));
            }
            if (StringUtils.isEmpty((String)entry.getString("pkey"))) {
                entry.set("pkey", (Object)AllotBillHandler.getPKey((DynamicObject)entry));
            }
            if (StringUtils.isEmpty((String)entry.getString("allottype")) && (allotType = AllotBillHandler.getAllotType((DynamicObjectCollection)subEntries)) != null) {
                entry.set("allottype", (Object)allotType.toString());
            }
            if (pKey2SumBaseQtyMap.containsKey(pKey = entry.getString("skey"))) {
                pKey2SumBaseQtyMap.put(pKey, ((BigDecimal)pKey2SumBaseQtyMap.get(pKey)).add(entry.getBigDecimal("baseqty")));
            } else {
                pKey2SumBaseQtyMap.put(pKey, entry.getBigDecimal("baseqty"));
            }
            int percent = entry.getInt("percent");
            BigDecimal baseQty = entry.getBigDecimal("baseqty");
            CalculateType calculateType = CalculateType.parse((String)entry.getString("calculatetype"));
            if (CalculateType.BY_PERCENT != calculateType || percent != 0 || baseQty == null || baseQty.compareTo(BigDecimal.ZERO) == 0) continue;
            entry.set("calculatetype", (Object)CalculateType.BY_QTY.toString());
        }
        for (DynamicObject entry : entries) {
            BigDecimal sumBaseQty = entry.getBigDecimal("sumbaseqty");
            if (sumBaseQty != null && sumBaseQty.compareTo(BigDecimal.ZERO) != 0) continue;
            pKey = entry.getString("skey");
            entry.set("sumbaseqty", pKey2SumBaseQtyMap.get(pKey));
        }
    }
}

