/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ococic.validator.inbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.util.BillTypeParameterHelper;
import kd.occ.ocbase.common.util.ChannelUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ococic.enums.SnStatusEnum;
import kd.occ.ococic.util.DateUtils;
import kd.occ.ococic.util.StringUtils;

public class ChannelInBillSNValidator
extends AbstractValidator {
    public void validate() {
        ValidationErrorInfo erroInfo;
        ValidationErrorInfo erroInfo2;
        Map result;
        if (this.dataEntities == null || this.dataEntities.length == 0) {
            return;
        }
        DynamicObject[] snDynObjs = this.getSNMainFileDynObjs(this.dataEntities);
        Map<String, String> existAuxsnoMap = this.getAuxsnMainFileMap(this.dataEntities, "auxsno");
        Map<String, String> existAuxsntMap = this.getAuxsnMainFileMap(this.dataEntities, "auxsnt");
        String snNumber = "";
        String auxsno = "";
        String auxsnt = "";
        String snStatus = "";
        String tipMsg = "";
        String inWay = "";
        String itemNumber = "";
        long itemId = 0L;
        long auxptyId = 0L;
        String lotNum = "";
        long projectId = 0L;
        Date productDate = null;
        Date effectDate = null;
        ArrayList<String> snList = new ArrayList<String>();
        ArrayList<String> auxsnoList = new ArrayList<String>();
        ArrayList<String> auxsntList = new ArrayList<String>();
        ArrayList<String> auxsnoRepeatList = new ArrayList<String>();
        ArrayList<String> auxsntRepeatList = new ArrayList<String>();
        DynamicObject alertbillDynObj = null;
        List billDynObjList = DynamicObjectUtils.convertDynamicObjList((ExtendedDataEntity[])this.dataEntities);
        Set inChannelIdSet = billDynObjList.stream().map(r -> r.getLong("inchannelid_id")).collect(Collectors.toSet());
        Map channelIsNotContorlSnMap = ChannelUtil.queryChannelIsNotControlSN(inChannelIdSet);
        HashSet<String> snNumberSet = new HashSet<String>();
        HashSet<String> auxsnoSet = new HashSet<String>();
        HashSet<String> auxsntSet = new HashSet<String>();
        block0: for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject billDynObj;
            alertbillDynObj = billDynObj = dataEntity.getDataEntity();
            DynamicObjectCollection entryColl = billDynObj.getDynamicObjectCollection("billentry");
            if (entryColl == null || entryColl.size() <= 0) continue;
            int seq = 0;
            String inType = this.getBillTypeParamInType(billDynObj);
            long inChannelId = billDynObj.getLong("inchannelid_id");
            boolean channelIsNotContorlSN = (Boolean)channelIsNotContorlSnMap.get(inChannelId);
            for (DynamicObject entryDynObj : entryColl) {
                String lotNumber;
                Iterator erroInfo3;
                DynamicObject itemDynObj = entryDynObj.getDynamicObject("itemid");
                if (itemDynObj == null || itemDynObj.getLong("id") == 0L) continue;
                DynamicObjectCollection snEntryColl = entryDynObj.getDynamicObjectCollection("subentryentity");
                Boolean enableserial = itemDynObj.getBoolean("enableserial");
                if (!enableserial.booleanValue() || channelIsNotContorlSN) {
                    entryDynObj.set("serialqty", (Object)0L);
                    snEntryColl.clear();
                    continue block0;
                }
                BigDecimal snQty = entryDynObj.getBigDecimal("serialqty");
                int snCount = 0;
                int auxsnoCount = 0;
                int auxsntCount = 0;
                snNumberSet.clear();
                if (snEntryColl != null && snEntryColl.size() > 0) {
                    DynamicObject serialUnit = entryDynObj.getDynamicObject("serialunit");
                    if (serialUnit == null) {
                        tipMsg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u5546\u54c1\u7684\u5e8f\u5217\u53f7\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ChannelInBillSNValidator_25", (String)"occ-ococic-opplugin", (Object[])new Object[0]), seq + 1);
                        erroInfo3 = new ValidationErrorInfo("", billDynObj.getPkValue(), dataEntity.getDataEntityIndex(), dataEntity.getRowIndex(), "errorcode_001", ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u68c0\u67e5", (String)"ChannelInBillSNValidator_1", (String)"occ-ococic-opplugin", (Object[])new Object[0]), tipMsg, ErrorLevel.Error);
                        this.validateResult.addErrorInfo((OperateErrorInfo)erroInfo3);
                        return;
                    }
                    for (DynamicObject snEntryDynObj : snEntryColl) {
                        String existSn;
                        snNumber = snEntryDynObj.getString("serialnumber");
                        if (StringUtils.isNotEmpty((String)snNumber)) {
                            snList.add(snNumber);
                            snNumberSet.add(snNumber);
                            ++snCount;
                        }
                        if (StringUtils.isNotEmpty((String)(auxsno = snEntryDynObj.getString("auxsno")))) {
                            auxsnoList.add(auxsno);
                            auxsnoSet.add(auxsno);
                            ++auxsnoCount;
                            existSn = existAuxsnoMap.get(auxsno);
                            if (existSn != null && !existSn.equals(snNumber) && !auxsnoRepeatList.contains(auxsno)) {
                                auxsnoRepeatList.add(auxsno);
                            }
                        }
                        if (!StringUtils.isNotEmpty((String)(auxsnt = snEntryDynObj.getString("auxsnt")))) continue;
                        auxsntList.add(auxsnt);
                        auxsntSet.add(auxsnt);
                        ++auxsntCount;
                        existSn = existAuxsntMap.get(auxsnt);
                        if (existSn == null || existSn.equals(snNumber) || auxsntRepeatList.contains(auxsnt)) continue;
                        auxsntRepeatList.add(auxsnt);
                    }
                }
                ++seq;
                itemNumber = itemDynObj.getString("number");
                if (CollectionUtils.isEmpty((Collection)snEntryColl) && "G".equalsIgnoreCase(inType)) continue;
                if (snQty.compareTo(BigDecimal.valueOf(snNumberSet.size())) != 0) {
                    tipMsg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u4e2d\u5546\u54c1\u7f16\u7801\u4e3a%2$s\u7684\u5e8f\u5217\u53f7\u6570\u91cf\u548c\u5e8f\u5217\u53f7\u8868\u8bb0\u5f55\u6761\u6570\u4e0d\u4e00\u81f4\u3002", (String)"ChannelInBillSNValidator_10", (String)"occ-ococic-opplugin", (Object[])new Object[0]), seq, itemNumber);
                    ValidationErrorInfo erroInfo4 = new ValidationErrorInfo("", billDynObj.getPkValue(), dataEntity.getDataEntityIndex(), dataEntity.getRowIndex(), "errorcode_002", ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u68c0\u67e5", (String)"ChannelInBillSNValidator_1", (String)"occ-ococic-opplugin", (Object[])new Object[0]), tipMsg, ErrorLevel.Error);
                    this.validateResult.addErrorInfo((OperateErrorInfo)erroInfo4);
                }
                if ((lotNumber = entryDynObj.getString("lotnumber")) != null && billDynObj.getString("inway").equals("2")) {
                    Iterator it = snNumberSet.iterator();
                    while (it.hasNext()) {
                        if (this.snMainCheckIsFalse((String)it.next(), lotNumber)) continue;
                        tipMsg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u4e2d\u5546\u54c1\u7f16\u7801\u4e3a%2$s\u7684\u5e8f\u5217\u53f7%3$s\u4e0d\u5c5e\u4e8e\u6b64\u6279\u53f7\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ChannelInBillSNValidator_11", (String)"occ-ococic-opplugin", (Object[])new Object[0]), seq, itemNumber, snNumber);
                        ValidationErrorInfo erroInfo5 = new ValidationErrorInfo("", billDynObj.getPkValue(), dataEntity.getDataEntityIndex(), dataEntity.getRowIndex(), "errorcode_005", ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u68c0\u67e5", (String)"ChannelInBillSNValidator_1", (String)"occ-ococic-opplugin", (Object[])new Object[0]), tipMsg, ErrorLevel.Error);
                        this.validateResult.addErrorInfo((OperateErrorInfo)erroInfo5);
                    }
                }
                if (snNumberSet.size() != snCount) {
                    tipMsg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u4e2d\u5546\u54c1\u7f16\u7801\u4e3a%2$s\u7684\u5e8f\u5217\u53f7\u5b58\u5728\u91cd\u590d\u3002", (String)"ChannelInBillSNValidator_12", (String)"occ-ococic-opplugin", (Object[])new Object[0]), seq, itemNumber);
                    erroInfo3 = new ValidationErrorInfo("", billDynObj.getPkValue(), dataEntity.getDataEntityIndex(), dataEntity.getRowIndex(), "errorcode_001", ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u68c0\u67e5", (String)"ChannelInBillSNValidator_1", (String)"occ-ococic-opplugin", (Object[])new Object[0]), tipMsg, ErrorLevel.Error);
                    this.validateResult.addErrorInfo((OperateErrorInfo)erroInfo3);
                    continue;
                }
                if (auxsnoSet.size() != auxsnoCount) {
                    tipMsg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u4e2d\u5546\u54c1\u7f16\u7801\u4e3a%2$s\u7684\u8f85\u5e8f\u5217\u53f71\u5b58\u5728\u91cd\u590d\u3002", (String)"ChannelInBillSNValidator_19", (String)"occ-ococic-opplugin", (Object[])new Object[0]), seq, itemNumber);
                    erroInfo3 = new ValidationErrorInfo("", billDynObj.getPkValue(), dataEntity.getDataEntityIndex(), dataEntity.getRowIndex(), "errorcode_001", ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u68c0\u67e5", (String)"ChannelInBillSNValidator_1", (String)"occ-ococic-opplugin", (Object[])new Object[0]), tipMsg, ErrorLevel.Error);
                    this.validateResult.addErrorInfo((OperateErrorInfo)erroInfo3);
                    continue;
                }
                if (auxsntSet.size() != auxsntCount) {
                    tipMsg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u4e2d\u5546\u54c1\u7f16\u7801\u4e3a%2$s\u7684\u8f85\u5e8f\u5217\u53f72\u5b58\u5728\u91cd\u590d\u3002", (String)"ChannelInBillSNValidator_20", (String)"occ-ococic-opplugin", (Object[])new Object[0]), seq, itemNumber);
                    erroInfo3 = new ValidationErrorInfo("", billDynObj.getPkValue(), dataEntity.getDataEntityIndex(), dataEntity.getRowIndex(), "errorcode_001", ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u68c0\u67e5", (String)"ChannelInBillSNValidator_1", (String)"occ-ococic-opplugin", (Object[])new Object[0]), tipMsg, ErrorLevel.Error);
                    this.validateResult.addErrorInfo((OperateErrorInfo)erroInfo3);
                    continue;
                }
                if (snQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                inWay = billDynObj.getString("inway");
                if ("2".equals(inWay)) {
                    for (DynamicObject eachSubEntry : snEntryColl) {
                        String eachNumber = eachSubEntry.getString("serialnumber");
                        boolean flag = false;
                        for (DynamicObject snDynObj : snDynObjs) {
                            if (!eachNumber.equals(snDynObj.getString("number"))) continue;
                            flag = true;
                        }
                        if (flag) continue;
                        tipMsg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u4e2d\u5546\u54c1\u7f16\u7801\u4e3a%2$s\u7684\u5e8f\u5217\u53f7\u4e0d\u5728\u5e93\uff0c\u8bf7\u68c0\u67e5", (String)"ChannelInBillSNValidator_13", (String)"occ-ococic-opplugin", (Object[])new Object[0]), seq, eachNumber);
                        ValidationErrorInfo erroInfo6 = new ValidationErrorInfo("", billDynObj.getPkValue(), dataEntity.getDataEntityIndex(), dataEntity.getRowIndex(), "errorcode_002", ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u68c0\u67e5", (String)"ChannelInBillSNValidator_1", (String)"occ-ococic-opplugin", (Object[])new Object[0]), tipMsg, ErrorLevel.Error);
                        this.validateResult.addErrorInfo((OperateErrorInfo)erroInfo6);
                    }
                }
                for (DynamicObject snDynObj : snDynObjs) {
                    String snKey;
                    Iterator erroInfo7;
                    snStatus = snDynObj.getString("snstatus");
                    snNumber = snDynObj.getString("number");
                    String billstatus = billDynObj.getString("billstatus");
                    if (billstatus.equals("C")) continue;
                    if ("1".equals(inWay) && SnStatusEnum.INSTOCK.getValue().equals(snStatus)) {
                        tipMsg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u4e2d\u5546\u54c1\u7f16\u7801\u4e3a%2$s\u7684\u5e8f\u5217\u53f7%3$s\u5df2\u5728\u5e93\u3002", (String)"ChannelInBillSNValidator_14", (String)"occ-ococic-opplugin", (Object[])new Object[0]), seq, itemNumber, snNumber);
                        erroInfo7 = new ValidationErrorInfo("", billDynObj.getPkValue(), dataEntity.getDataEntityIndex(), dataEntity.getRowIndex(), "errorcode_004", ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u68c0\u67e5", (String)"ChannelInBillSNValidator_1", (String)"occ-ococic-opplugin", (Object[])new Object[0]), tipMsg, ErrorLevel.Error);
                        this.validateResult.addErrorInfo((OperateErrorInfo)erroInfo7);
                        continue;
                    }
                    if ("1".equals(inWay) && !SnStatusEnum.ONWAY.getValue().equals(snStatus) && !SnStatusEnum.CHANNELOUTSTOCK.getValue().equals(snStatus)) {
                        tipMsg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u4e2d\u5546\u54c1\u7f16\u7801\u4e3a%2$s\u7684\u5e8f\u5217\u53f7%3$s\u4e0d\u4e3a\u5728\u9014\u6216\u6e20\u9053\u51fa\u5e93\u72b6\u6001\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ChannelInBillSNValidator_15", (String)"occ-ococic-opplugin", (Object[])new Object[0]), seq, itemNumber, snNumber);
                        erroInfo7 = new ValidationErrorInfo("", billDynObj.getPkValue(), dataEntity.getDataEntityIndex(), dataEntity.getRowIndex(), "errorcode_004", ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u68c0\u67e5", (String)"ChannelInBillSNValidator_1", (String)"occ-ococic-opplugin", (Object[])new Object[0]), tipMsg, ErrorLevel.Error);
                        this.validateResult.addErrorInfo((OperateErrorInfo)erroInfo7);
                        continue;
                    }
                    if ("2".equals(inWay) && !SnStatusEnum.INSTOCK.getValue().equals(snStatus)) {
                        tipMsg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u4e2d\u5546\u54c1\u7f16\u7801\u4e3a%2$s\u7684\u5e8f\u5217\u53f7%3$s\u4e0d\u5728\u5e93\u3002", (String)"ChannelInBillSNValidator_16", (String)"occ-ococic-opplugin", (Object[])new Object[0]), seq, itemNumber, snNumber);
                        erroInfo7 = new ValidationErrorInfo("", billDynObj.getPkValue(), dataEntity.getDataEntityIndex(), dataEntity.getRowIndex(), "errorcode_005", ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u68c0\u67e5", (String)"ChannelInBillSNValidator_1", (String)"occ-ococic-opplugin", (Object[])new Object[0]), tipMsg, ErrorLevel.Error);
                        this.validateResult.addErrorInfo((OperateErrorInfo)erroInfo7);
                        continue;
                    }
                    snNumberSet.clear();
                    for (DynamicObject snEntryDynObj : snEntryColl) {
                        if (!snNumber.equals(snEntryDynObj.getString("serialnumber"))) continue;
                        snEntryDynObj.set("serialid", (Object)snDynObj.getLong("id"));
                        snNumberSet.add(snEntryDynObj.getString("serialnumber"));
                    }
                    if (snNumberSet.size() <= 0) continue;
                    itemId = entryDynObj.getLong("itemid_id");
                    auxptyId = entryDynObj.getLong("auxptyid_id");
                    lotNum = entryDynObj.getString("lotnumber");
                    projectId = entryDynObj.getLong("projectid_id");
                    productDate = DateUtils.getDataFormat((Date)entryDynObj.getDate("producedate"), (boolean)true);
                    effectDate = DateUtils.getDataFormat((Date)entryDynObj.getDate("expirydate"), (boolean)false);
                    String billEntryKey = StringUtils.join((CharSequence)"_", (Object[])new Object[]{itemId, auxptyId, lotNum, projectId, productDate, effectDate});
                    if (billEntryKey.equals(snKey = StringUtils.join((CharSequence)"_", (Object[])new Object[]{snDynObj.getLong("itemid_id"), snDynObj.getLong("auxptyid_id"), snDynObj.getString("lotnum"), snDynObj.getLong("projectid_id"), DateUtils.getDataFormat((Date)snDynObj.getDate("productdate"), (boolean)true), DateUtils.getDataFormat((Date)snDynObj.getDate("effectivedate"), (boolean)false)}))) continue;
                    tipMsg = ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u4e2d\u5546\u54c1\u7f16\u7801\u4e3a%2$s\u7684\u5e8f\u5217\u53f7%3$s\u4e0e\u5546\u54c1\u3001\u8f85\u52a9\u5c5e\u6027\u3001\u6279\u53f7\u3001\u9879\u76ee\u53f7\u3001\u751f\u4ea7\u65e5\u671f\u3001\u6709\u6548\u65e5\u671f\u81f3\u4e0d\u4e00\u81f4\u3002", (String)"ChannelInBillSNValidator_17", (String)"occ-ococic-opplugin", (Object[])new Object[0]);
                    tipMsg = String.format(tipMsg, seq, itemNumber, snNumber);
                    ValidationErrorInfo erroInfo8 = new ValidationErrorInfo("", billDynObj.getPkValue(), dataEntity.getDataEntityIndex(), dataEntity.getRowIndex(), "errorcode_003", ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u68c0\u67e5", (String)"ChannelInBillSNValidator_1", (String)"occ-ococic-opplugin", (Object[])new Object[0]), tipMsg, ErrorLevel.Error);
                    this.validateResult.addErrorInfo((OperateErrorInfo)erroInfo8);
                }
            }
        }
        if (snList.size() > 1 && (result = snList.stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting()))) != null && result.size() > 0) {
            for (Map.Entry entry : result.entrySet()) {
                if (entry.getValue().compareTo(1L) <= 0 || alertbillDynObj == null) continue;
                tipMsg = String.format(ResManager.loadKDString((String)"\u5206\u5f55\u4e2d\u5e8f\u5217\u53f7%1$s, \u51fa\u73b0%2$s\u6b21\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ChannelInBillSNValidator_18", (String)"occ-ococic-opplugin", (Object[])new Object[0]), entry.getKey(), entry.getValue());
                erroInfo2 = new ValidationErrorInfo("", alertbillDynObj.getPkValue(), this.dataEntities[0].getDataEntityIndex(), this.dataEntities[0].getRowIndex(), "errorcode_004", ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u68c0\u67e5", (String)"ChannelInBillSNValidator_1", (String)"occ-ococic-opplugin", (Object[])new Object[0]), tipMsg, ErrorLevel.Error);
                this.validateResult.addErrorInfo((OperateErrorInfo)erroInfo2);
            }
        }
        if (auxsnoList.size() > 1 && (result = auxsnoList.stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting()))) != null && result.size() > 0) {
            for (Map.Entry entry : result.entrySet()) {
                if (entry.getValue().compareTo(1L) <= 0 || alertbillDynObj == null) continue;
                tipMsg = String.format(ResManager.loadKDString((String)"\u5206\u5f55\u4e2d\u8f85\u5e8f\u5217\u53f71 %1$s, \u51fa\u73b0%2$s\u6b21\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ChannelInBillSNValidator_21", (String)"occ-ococic-opplugin", (Object[])new Object[0]), entry.getKey(), entry.getValue());
                erroInfo2 = new ValidationErrorInfo("", alertbillDynObj.getPkValue(), this.dataEntities[0].getDataEntityIndex(), this.dataEntities[0].getRowIndex(), "errorcode_004", ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u68c0\u67e5", (String)"ChannelInBillSNValidator_1", (String)"occ-ococic-opplugin", (Object[])new Object[0]), tipMsg, ErrorLevel.Error);
                this.validateResult.addErrorInfo((OperateErrorInfo)erroInfo2);
            }
        }
        if (auxsntList.size() > 1 && (result = auxsntList.stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting()))) != null && result.size() > 0) {
            for (Map.Entry entry : result.entrySet()) {
                if (entry.getValue().compareTo(1L) <= 0 || alertbillDynObj == null) continue;
                tipMsg = String.format(ResManager.loadKDString((String)"\u5206\u5f55\u4e2d\u8f85\u5e8f\u5217\u53f72 %1$s, \u51fa\u73b0%2$s\u6b21\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ChannelInBillSNValidator_22", (String)"occ-ococic-opplugin", (Object[])new Object[0]), entry.getKey(), entry.getValue());
                erroInfo2 = new ValidationErrorInfo("", alertbillDynObj.getPkValue(), this.dataEntities[0].getDataEntityIndex(), this.dataEntities[0].getRowIndex(), "errorcode_004", ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u68c0\u67e5", (String)"ChannelInBillSNValidator_1", (String)"occ-ococic-opplugin", (Object[])new Object[0]), tipMsg, ErrorLevel.Error);
                this.validateResult.addErrorInfo((OperateErrorInfo)erroInfo2);
            }
        }
        if (auxsnoRepeatList.size() > 0 && alertbillDynObj != null) {
            tipMsg = String.format(ResManager.loadKDString((String)"\u5206\u5f55\u4e2d\u8f85\u5e8f\u5217\u53f71 %1$s, \u5728\u5546\u54c1\u5e8f\u5217\u53f7\u8868\u4e2d\u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ChannelInBillSNValidator_23", (String)"occ-ococic-opplugin", (Object[])new Object[0]), ((Object)auxsnoRepeatList).toString());
            erroInfo = new ValidationErrorInfo("", alertbillDynObj.getPkValue(), this.dataEntities[0].getDataEntityIndex(), this.dataEntities[0].getRowIndex(), "errorcode_004", ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u68c0\u67e5", (String)"ChannelInBillSNValidator_1", (String)"occ-ococic-opplugin", (Object[])new Object[0]), tipMsg, ErrorLevel.Error);
            this.validateResult.addErrorInfo((OperateErrorInfo)erroInfo);
        }
        if (auxsntRepeatList.size() > 0 && alertbillDynObj != null) {
            tipMsg = String.format(ResManager.loadKDString((String)"\u5206\u5f55\u4e2d\u8f85\u5e8f\u5217\u53f72 %1$s, \u5728\u5546\u54c1\u5e8f\u5217\u53f7\u8868\u4e2d\u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ChannelInBillSNValidator_24", (String)"occ-ococic-opplugin", (Object[])new Object[0]), ((Object)auxsntRepeatList).toString());
            erroInfo = new ValidationErrorInfo("", alertbillDynObj.getPkValue(), this.dataEntities[0].getDataEntityIndex(), this.dataEntities[0].getRowIndex(), "errorcode_004", ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u68c0\u67e5", (String)"ChannelInBillSNValidator_1", (String)"occ-ococic-opplugin", (Object[])new Object[0]), tipMsg, ErrorLevel.Error);
            this.validateResult.addErrorInfo((OperateErrorInfo)erroInfo);
        }
    }

    private boolean snMainCheckIsFalse(String serialnumber, String lotNum) {
        Boolean status = Boolean.FALSE;
        QFilter lotnumfilter = new QFilter("lotnum", "=", (Object)lotNum);
        QFilter snfilter = new QFilter("number", "=", (Object)serialnumber);
        DynamicObject[] result = BusinessDataServiceHelper.load((String)"ococic_snmainfile", (String)"id", (QFilter[])new QFilter[]{lotnumfilter, snfilter});
        if (null != result && result.length > 0) {
            status = Boolean.TRUE;
        }
        return status;
    }

    private DynamicObject[] getSNMainFileDynObjs(ExtendedDataEntity[] billDataEntities) {
        String snNumber = "";
        HashSet<String> billSNSet = new HashSet<String>();
        for (ExtendedDataEntity dataEntity : billDataEntities) {
            DynamicObject billDynObj = dataEntity.getDataEntity();
            DynamicObjectCollection entryColl = billDynObj.getDynamicObjectCollection("billentry");
            if (entryColl == null || entryColl.size() <= 0) continue;
            for (DynamicObject entryDynObj : entryColl) {
                DynamicObject itemDynObj = entryDynObj.getDynamicObject("itemid");
                if (itemDynObj == null || itemDynObj.getLong("id") == 0L) continue;
                DynamicObjectCollection snEntryColl = entryDynObj.getDynamicObjectCollection("subentryentity");
                for (DynamicObject snEntryDynObj : snEntryColl) {
                    snNumber = snEntryDynObj.getString("serialnumber");
                    if (!StringUtils.isNotEmpty((String)snNumber)) continue;
                    billSNSet.add(snNumber);
                }
            }
        }
        QFilter filter = new QFilter("number", "in", (Object)billSNSet.toArray());
        DynamicObject[] snDynObjs = BusinessDataServiceHelper.load((String)"ococic_snmainfile", (String)String.join((CharSequence)",", "id", "number", "snstatus", "lotid", "lotnum", "itemid", "auxptyid", "auxptyid", "projectid", "productdate", "effectivedate", "auxsno", "auxsnt"), (QFilter[])new QFilter[]{filter});
        return snDynObjs;
    }

    private Map<String, String> getAuxsnMainFileMap(ExtendedDataEntity[] billDataEntities, String auxsnField) {
        String auxsno = "";
        HashSet<String> auxsnoSet = new HashSet<String>();
        HashMap<String, String> auxsnMap = new HashMap<String, String>();
        for (ExtendedDataEntity dataEntity : billDataEntities) {
            DynamicObject billDynObj = dataEntity.getDataEntity();
            DynamicObjectCollection entryColl = billDynObj.getDynamicObjectCollection("billentry");
            if (entryColl == null || entryColl.size() <= 0) continue;
            for (DynamicObject entryDynObj : entryColl) {
                DynamicObject itemDynObj = entryDynObj.getDynamicObject("itemid");
                if (itemDynObj == null || itemDynObj.getLong("id") == 0L) continue;
                DynamicObjectCollection snEntryColl = entryDynObj.getDynamicObjectCollection("subentryentity");
                for (DynamicObject snEntryDynObj : snEntryColl) {
                    auxsno = snEntryDynObj.getString(auxsnField);
                    if (!StringUtils.isNotEmpty((String)auxsno)) continue;
                    auxsnoSet.add(auxsno);
                }
            }
        }
        QFilter filter = new QFilter(auxsnField, "in", (Object)auxsnoSet.toArray());
        DynamicObjectCollection auxsnDoc = QueryServiceHelper.query((String)"ococic_snmainfile", (String)String.join((CharSequence)",", "number", auxsnField), (QFilter[])new QFilter[]{filter});
        if (CollectionUtils.isEmpty((Collection)auxsnDoc)) {
            return auxsnMap;
        }
        for (DynamicObject auxsnDo : auxsnDoc) {
            String auxsn = auxsnDo.getString(auxsnField);
            String snNumber = auxsnDo.getString("number");
            auxsnMap.put(auxsn, snNumber);
        }
        return auxsnMap;
    }

    private String getBillTypeParamInType(DynamicObject bill) {
        DynamicObject billType = DynamicObjectUtils.getDynamicObject((DynamicObject)bill, (String)"billtypeid");
        DynamicObject billTypeParam = BillTypeParameterHelper.getBillTypeParameter((String)"ococic_channelinbill", (long)DynamicObjectUtils.getPkValue((DynamicObject)billType));
        return DynamicObjectUtils.getString((DynamicObject)billTypeParam, (String)"intype");
    }
}

