/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ococic.validator.inbill;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ChannelInBillUnAuditSNValidator
extends AbstractValidator {
    public void validate() {
        if (this.dataEntities == null || this.dataEntities.length == 0) {
            return;
        }
        Set<Long> notUnAuditSnFileIdSet = this.getNotUnAuditSnFileIdSet(this.dataEntities);
        long snFileId = 0L;
        String tipMsg = "";
        String itemNumber = "";
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject billDynObj = dataEntity.getDataEntity();
            DynamicObjectCollection entryColl = billDynObj.getDynamicObjectCollection("billentry");
            if (entryColl == null || entryColl.size() <= 0) continue;
            for (DynamicObject entryDynObj : entryColl) {
                DynamicObject itemDynObj = entryDynObj.getDynamicObject("itemid");
                if (itemDynObj == null || itemDynObj.getLong("id") == 0L) continue;
                DynamicObjectCollection snEntryColl = entryDynObj.getDynamicObjectCollection("subentryentity");
                itemNumber = itemDynObj.getString("number");
                for (DynamicObject snEntryDynObj : snEntryColl) {
                    snFileId = snEntryDynObj.getLong("serialid_id");
                    if (!notUnAuditSnFileIdSet.contains(snFileId)) continue;
                    tipMsg = String.format(ResManager.loadKDString((String)"\u5546\u54c1\u7f16\u7801\u4e3a%s\u7684\u5e8f\u5217\u53f7\u5df2\u53d1\u751f\u540e\u7eed\u4e1a\u52a1\u3002", (String)"ChannelInBillUnAuditSNValidator_0", (String)"occ-ococic-opplugin", (Object[])new Object[0]), itemNumber);
                    ValidationErrorInfo erroInfo = new ValidationErrorInfo("", billDynObj.getPkValue(), dataEntity.getDataEntityIndex(), dataEntity.getRowIndex(), "errorcode_001", ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u68c0\u67e5", (String)"ChannelInBillUnAuditSNValidator_1", (String)"occ-ococic-opplugin", (Object[])new Object[0]), tipMsg, ErrorLevel.Error);
                    this.validateResult.addErrorInfo((OperateErrorInfo)erroInfo);
                }
            }
        }
    }

    private Set<Long> getNotUnAuditSnFileIdSet(ExtendedDataEntity[] billDataEntities) {
        long snFileId = 0L;
        HashSet<Long> billSNSet = new HashSet<Long>();
        for (ExtendedDataEntity dataEntity : billDataEntities) {
            DynamicObject[] billDynObj = dataEntity.getDataEntity();
            DynamicObjectCollection entryColl = billDynObj.getDynamicObjectCollection("billentry");
            if (entryColl == null || entryColl.size() <= 0) continue;
            for (DynamicObject entryDynObj : entryColl) {
                DynamicObject itemDynObj = entryDynObj.getDynamicObject("itemid");
                if (itemDynObj == null || itemDynObj.getLong("id") == 0L) continue;
                DynamicObjectCollection snEntryColl = entryDynObj.getDynamicObjectCollection("subentryentity");
                for (DynamicObject snEntryDynObj : snEntryColl) {
                    snFileId = snEntryDynObj.getLong("serialid_id");
                    if (snFileId <= 0L) continue;
                    billSNSet.add(snFileId);
                }
            }
        }
        HashSet<Long> notUnAuditSnFileIdSet = new HashSet<Long>();
        if (billSNSet.size() == 0) {
            return notUnAuditSnFileIdSet;
        }
        QFilter snFileIdFilter = new QFilter("snmainfileid", "in", (Object)billSNSet.toArray());
        DynamicObject[] trackDynObjs = BusinessDataServiceHelper.load((String)"ococic_snmovetrack", (String)String.join((CharSequence)",", "id", "snmainfileid", "billid", "billentryid", "billentityid"), (QFilter[])new QFilter[]{snFileIdFilter});
        List<Object> snDynObjTrackList = new ArrayList<DynamicObject>();
        if (trackDynObjs != null && trackDynObjs.length > 0) {
            for (DynamicObject snTrackDynObj2 : trackDynObjs) {
                snDynObjTrackList.add(snTrackDynObj2);
            }
            Map<Long, List<DynamicObject>> snTrackDynObjMap = snDynObjTrackList.stream().collect(Collectors.groupingBy(snTrackDynObj -> snTrackDynObj.getLong("snmainfileid_id")));
            DynamicObject trackDynObj = null;
            for (ExtendedDataEntity dataEntity : billDataEntities) {
                DynamicObject billDynObj = dataEntity.getDataEntity();
                DynamicObjectCollection entryColl = billDynObj.getDynamicObjectCollection("billentry");
                if (entryColl == null || entryColl.size() <= 0) continue;
                for (DynamicObject entryDynObj : entryColl) {
                    DynamicObject itemDynObj = entryDynObj.getDynamicObject("itemid");
                    if (itemDynObj == null || itemDynObj.getLong("id") == 0L) continue;
                    DynamicObjectCollection snEntryColl = entryDynObj.getDynamicObjectCollection("subentryentity");
                    for (DynamicObject snEntryDynObj : snEntryColl) {
                        snFileId = snEntryDynObj.getLong("serialid_id");
                        snDynObjTrackList = snTrackDynObjMap.get(snFileId);
                        if (snDynObjTrackList == null || (trackDynObj = (DynamicObject)(snDynObjTrackList = snDynObjTrackList.stream().sorted(Comparator.comparing(snTrackDynObj -> snTrackDynObj.getLong("id"))).collect(Collectors.toList())).get(snDynObjTrackList.size() - 1)).getLong("billid") == billDynObj.getLong("id") && trackDynObj.getLong("billentryid") == entryDynObj.getLong("id") && billDynObj.getDataEntityType().getName().equals(trackDynObj.getString("billentityid_id"))) continue;
                        notUnAuditSnFileIdSet.add(snFileId);
                    }
                }
            }
        }
        return notUnAuditSnFileIdSet;
    }
}

