/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ococic.validator.inbill;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.util.ChannelUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.StringUtils;
import kd.occ.ococic.enums.SnStatusEnum;
import kd.occ.ococic.util.DateUtils;

public class ChannelInListValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] extendedDataEntityArray = this.getDataEntities();
        this.mustInputCheck(extendedDataEntityArray);
        this.snCheck(extendedDataEntityArray);
    }

    private void mustInputCheck(ExtendedDataEntity[] extendedDataEntityArray) {
        if (extendedDataEntityArray != null && extendedDataEntityArray.length > 0) {
            List billDynObjList = DynamicObjectUtils.convertDynamicObjList((ExtendedDataEntity[])extendedDataEntityArray);
            Set inChannelIdSet = billDynObjList.stream().map(r -> r.getLong("inchannelid_id")).collect(Collectors.toSet());
            Map channelIsNotContorlSnMap = ChannelUtil.queryChannelIsNotControlSN(inChannelIdSet);
            for (ExtendedDataEntity extendedDataEntity : extendedDataEntityArray) {
                DynamicObject bill = extendedDataEntity.getDataEntity();
                DynamicObject item = bill.getDynamicObject("itemid");
                String lotNumber = bill.getString("lotnumber");
                if (item.getBoolean("enablelot")) {
                    if (StringUtils.isEmpty((String)lotNumber)) {
                        this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5546\u54c1\u542f\u7528\u6279\u53f7\uff0c\u6279\u53f7\u5fc5\u5f55\u3002", (String)"ChannelInListValidator_0", (String)"occ-ococic-opplugin", (Object[])new Object[0]));
                    }
                } else {
                    bill.set("lotnumber", (Object)"");
                }
                long inChannelId = bill.getLong("inchannelid_id");
                boolean channelIsNotContorlSN = (Boolean)channelIsNotContorlSnMap.get(inChannelId);
                if (item.getBoolean("enableserial") && !channelIsNotContorlSN) {
                    BigDecimal baseqty;
                    String serialNumber = bill.getString("serialnumber");
                    if (StringUtils.isEmpty((String)serialNumber)) {
                        this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5546\u54c1\u542f\u7528\u5e8f\u5217\u53f7\uff0c\u7cfb\u5217\u53f7\u5fc5\u5f55\u3002", (String)"ChannelInListValidator_1", (String)"occ-ococic-opplugin", (Object[])new Object[0]));
                    }
                    if (BigDecimal.ONE.compareTo(baseqty = bill.getBigDecimal("baseqty")) != 0) {
                        this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5546\u54c1\u542f\u7528\u5e8f\u5217\u53f7\uff0c\u57fa\u672c\u5355\u4f4d\u6570\u91cf\u5fc5\u987b\u7b49\u4e8e1\u3002", (String)"ChannelInListValidator_2", (String)"occ-ococic-opplugin", (Object[])new Object[0]));
                    }
                } else {
                    bill.set("serialnumber", (Object)"");
                }
                DynamicObject material = bill.getDynamicObject("materialid");
                if (material == null) continue;
                if (material.getBoolean("isuseauxpty")) {
                    if (DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)bill, (String)"auxptyid") != 0L) continue;
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5546\u54c1\u7269\u6599\u542f\u7528\u8f85\u52a9\u5c5e\u6027\uff0c\u8f85\u52a9\u5c5e\u6027\u5fc5\u5f55\u3002", (String)"ChannelInListValidator_3", (String)"occ-ococic-opplugin", (Object[])new Object[0]));
                    continue;
                }
                DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)bill, (String)"auxptyid", (long)0L);
                bill.set("auxptyid", null);
            }
        }
    }

    private void snCheck(ExtendedDataEntity[] extendedDataEntityArray) {
        if (extendedDataEntityArray != null && extendedDataEntityArray.length > 0) {
            Map groupBySNExtendedDataEntityMap = Arrays.stream(extendedDataEntityArray).filter(r -> StringUtils.isNotEmpty((String)r.getDataEntity().getString("serialnumber"))).collect(Collectors.groupingBy(r -> r.getDataEntity().getString("serialnumber"), Collectors.toList()));
            HashSet<String> billSNSet = new HashSet<String>(extendedDataEntityArray.length);
            for (Map.Entry groupBySNExtendedDataEntityEntry : groupBySNExtendedDataEntityMap.entrySet()) {
                String snNumber = groupBySNExtendedDataEntityEntry.getKey();
                List extendedDataEntityList = groupBySNExtendedDataEntityEntry.getValue();
                if (CollectionUtils.isEmpty(extendedDataEntityList)) continue;
                int size = extendedDataEntityList.size();
                if (size == 1) {
                    billSNSet.add(snNumber);
                    continue;
                }
                for (ExtendedDataEntity extendedDataEntity : extendedDataEntityList) {
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u6e20\u9053\u5165\u5e93\u6e05\u5355\u4e2d\u5e8f\u5217\u53f7%s\u5b58\u5728\u91cd\u590d\u3002", (String)"ChannelInListValidator_4", (String)"occ-ococic-opplugin", (Object[])new Object[0]), snNumber));
                }
            }
            if (!CollectionUtils.isEmpty(billSNSet)) {
                Map<String, List<DynamicObject>> snDynObjMap = this.getSNMainFileDynObjMap(billSNSet);
                String inWay = "1";
                for (ExtendedDataEntity extendedDataEntity : extendedDataEntityArray) {
                    List<DynamicObject> snDynObjList;
                    DynamicObject bill = extendedDataEntity.getDataEntity();
                    String serialnumber = bill.getString("serialnumber");
                    if (!StringUtils.isNotEmpty((String)serialnumber) || !billSNSet.contains(serialnumber) || CollectionUtils.isEmpty(snDynObjList = snDynObjMap.get(serialnumber))) continue;
                    for (DynamicObject snDynObj : snDynObjList) {
                        String snKey;
                        String snStatus = snDynObj.getString("snstatus");
                        String snNumber = snDynObj.getString("number");
                        if ("1".equals(inWay) && SnStatusEnum.INSTOCK.getValue().equals(snStatus)) {
                            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u6e20\u9053\u5165\u5e93\u6e05\u5355\u4e2d\u5e8f\u5217\u53f7%s\u5df2\u5728\u5e93\u3002", (String)"ChannelInListValidator_5", (String)"occ-ococic-opplugin", (Object[])new Object[0]), snNumber));
                            continue;
                        }
                        if ("1".equals(inWay) && !SnStatusEnum.ONWAY.getValue().equals(snStatus) && !SnStatusEnum.CHANNELOUTSTOCK.getValue().equals(snStatus)) {
                            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u6e20\u9053\u5165\u5e93\u6e05\u5355\u4e2d\u5e8f\u5217\u53f7%s\u4e0d\u4e3a\u5728\u9014\u6216\u6e20\u9053\u51fa\u5e93\u72b6\u6001\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ChannelInListValidator_6", (String)"occ-ococic-opplugin", (Object[])new Object[0]), snNumber));
                            continue;
                        }
                        if ("2".equals(inWay) && !SnStatusEnum.INSTOCK.getValue().equals(snStatus)) {
                            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u6e20\u9053\u5165\u5e93\u6e05\u5355\u4e2d\u5e8f\u5217\u53f7%s\u4e0d\u5728\u5e93\u3002", (String)"ChannelInListValidator_7", (String)"occ-ococic-opplugin", (Object[])new Object[0]), snNumber));
                            continue;
                        }
                        long itemId = DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)bill, (String)"itemid");
                        long auxptyId = DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)bill, (String)"auxptyid");
                        String lotNum = bill.getString("lotnumber");
                        long projectId = 0L;
                        Date productDate = DateUtils.getDataFormat(null, (boolean)true);
                        Date effectDate = DateUtils.getDataFormat(null, (boolean)false);
                        String billEntryKey = StringUtils.join((CharSequence)"_", (Object[])new Object[]{itemId, auxptyId, lotNum, projectId, productDate, effectDate});
                        if (billEntryKey.equals(snKey = StringUtils.join((CharSequence)"_", (Object[])new Object[]{DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)snDynObj, (String)"itemid"), DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)snDynObj, (String)"auxptyid"), snDynObj.getString("lotnum"), DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)snDynObj, (String)"projectid"), DateUtils.getDataFormat((Date)snDynObj.getDate("productdate"), (boolean)true), DateUtils.getDataFormat((Date)snDynObj.getDate("effectivedate"), (boolean)false)}))) continue;
                        this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u6e20\u9053\u5165\u5e93\u6e05\u5355\u5e8f\u5217\u53f7%s\u4e0e\u5546\u54c1\u3001\u8f85\u52a9\u5c5e\u6027\u3001\u6279\u53f7\u3001\u9879\u76ee\u53f7\u3001\u751f\u4ea7\u65e5\u671f\u3001\u6709\u6548\u65e5\u671f\u81f3\u4e0d\u4e00\u81f4\u3002", (String)"ChannelInListValidator_8", (String)"occ-ococic-opplugin", (Object[])new Object[0]), snNumber));
                    }
                }
            }
        }
    }

    private Map<String, List<DynamicObject>> getSNMainFileDynObjMap(Set<String> billSNSet) {
        QFilter filter = new QFilter("number", "in", (Object)billSNSet.toArray());
        DynamicObject[] snDynObjs = BusinessDataServiceHelper.load((String)"ococic_snmainfile", (String)String.join((CharSequence)",", "id", "number", "snstatus", "lotid", "lotnum", "itemid", "auxptyid", "auxptyid", "projectid", "productdate", "effectivedate"), (QFilter[])new QFilter[]{filter});
        return Arrays.stream(snDynObjs).collect(Collectors.groupingBy(r -> r.getString("number"), Collectors.toList()));
    }
}

