/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ococic.validator.inbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.util.BillTypeParameterHelper;
import kd.occ.ocbase.common.util.ChannelUtil;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ococic.business.helper.LotHelper;
import kd.occ.ococic.util.StringUtils;

public class StockinBillCommonValidator
extends AbstractValidator {
    public void validate() {
        List billDynObjList = DynamicObjectUtils.convertDynamicObjList((ExtendedDataEntity[])this.dataEntities);
        Set inChannelIdSet = billDynObjList.stream().map(r -> r.getLong("inchannelid_id")).collect(Collectors.toSet());
        Map channelIsNotContorlSnMap = ChannelUtil.queryChannelIsNotControlSN(inChannelIdSet);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject entity = dataEntity.getDataEntity();
            this.validateBillHeader(dataEntity, entity);
            DynamicObjectCollection entries = entity.getDynamicObjectCollection("billentry");
            if (entries.size() == 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u81f3\u5c11\u8981\u6709\u4e00\u6761\u5206\u5f55", (String)"StockinBillCommonValidator_0", (String)"occ-ococic-opplugin", (Object[])new Object[0]));
            }
            for (int i = 0; i < entries.size(); ++i) {
                DynamicObject entry = (DynamicObject)entries.get(i);
                if (entry == null) continue;
                this.validateEntryData(dataEntity, entry, i, channelIsNotContorlSnMap);
            }
        }
    }

    private void validateBillHeader(ExtendedDataEntity dataEntity, DynamicObject entity) {
        String settlecurrencyid;
        String instocktime;
        String intype;
        String inway;
        String org;
        String inchannelid;
        DynamicObject billtypeid;
        String billno = entity.getString("billno");
        if (billno == null) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7f3a\u5c11\u5165\u5e93\u5355\u53f7", (String)"StockinBillCommonValidator_1", (String)"occ-ococic-opplugin", (Object[])new Object[0]));
        }
        if ((billtypeid = entity.getDynamicObject("billtypeid")) == null) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7f3a\u5c11\u5355\u636e\u7c7b\u578b", (String)"StockinBillCommonValidator_2", (String)"occ-ococic-opplugin", (Object[])new Object[0]));
        }
        if ((inchannelid = entity.getString("inchannelid")) == null) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7f3a\u5c11\u5165\u5e93\u6e20\u9053", (String)"StockinBillCommonValidator_3", (String)"occ-ococic-opplugin", (Object[])new Object[0]));
        }
        if ((org = entity.getString("org")) == null) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7f3a\u5c11\u9500\u552e\u7ec4\u7ec7", (String)"StockinBillCommonValidator_4", (String)"occ-ococic-opplugin", (Object[])new Object[0]));
        }
        if ((inway = entity.getString("inway")) == null) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7f3a\u5c11\u5165\u5e93\u65b9\u5411", (String)"StockinBillCommonValidator_5", (String)"occ-ococic-opplugin", (Object[])new Object[0]));
        }
        if (null != billtypeid) {
            String billTypeNumber = billtypeid.getString("number");
            if ("ococic_in_sys009".equals(billTypeNumber)) {
                String supplychannelid = entity.getString("supplychannelid");
                if (supplychannelid == null) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7f3a\u5c11\u4f9b\u8d27\u6e20\u9053", (String)"StockinBillCommonValidator_6", (String)"occ-ococic-opplugin", (Object[])new Object[0]));
                }
            } else {
                String saleOrg = entity.getString("saleorg");
                if (saleOrg == null) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7f3a\u5c11\u9500\u552e\u7ec4\u7ec7", (String)"StockinBillCommonValidator_4", (String)"occ-ococic-opplugin", (Object[])new Object[0]));
                }
            }
        }
        if ((intype = entity.getString("intype")) == null) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7f3a\u5c11\u5165\u5e93\u65b9\u5f0f", (String)"StockinBillCommonValidator_7", (String)"occ-ococic-opplugin", (Object[])new Object[0]));
        }
        if ((instocktime = entity.getString("instocktime")) == null) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7f3a\u5c11\u5165\u5e93\u65e5\u671f", (String)"StockinBillCommonValidator_8", (String)"occ-ococic-opplugin", (Object[])new Object[0]));
        }
        if ((settlecurrencyid = entity.getString("settlecurrencyid")) == null) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7f3a\u5c11\u5e01\u522b", (String)"StockinBillCommonValidator_9", (String)"occ-ococic-opplugin", (Object[])new Object[0]));
        }
    }

    private void validateEntryData(ExtendedDataEntity dataEntity, DynamicObject entry, int i, Map<Long, Boolean> channelIsNotContorlSnMap) {
        this.checkEntryCompulsory(dataEntity, entry, i, channelIsNotContorlSnMap);
        this.checkItemLotNumber(dataEntity, entry, i);
    }

    private void checkEntryCompulsory(ExtendedDataEntity dataEntity, DynamicObject rowObj, int rowNo, Map<Long, Boolean> channelIsNotContorlSnMap) {
        DynamicObjectCollection subRowObj;
        DynamicObject location;
        DynamicObject auxpty;
        boolean assistunit;
        DynamicObject bdmaterial;
        DynamicObject itemid = (DynamicObject)rowObj.get("itemid");
        if (null == itemid) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u5546\u54c1\u7f16\u7801\u4e0d\u5b58\u5728", (String)"StockinBillCommonValidator_32", (String)"occ-ococic-opplugin", (Object[])new Object[0]), rowNo + 1));
            return;
        }
        DynamicObject material = itemid.getDynamicObject("material");
        if (material != null && (bdmaterial = QueryServiceHelper.queryOne((String)"bd_material", (String)"isuseauxpty", (QFilter[])new QFilter[]{new QFilter("id", "=", material.getPkValue())})) != null && (assistunit = bdmaterial.getBoolean("isuseauxpty")) && (auxpty = (DynamicObject)rowObj.get("auxptyid")) == null) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u8f85\u52a9\u5c5e\u6027\u672a\u586b\u5199", (String)"StockinBillCommonValidator_33", (String)"occ-ococic-opplugin", (Object[])new Object[0]), rowNo + 1));
            return;
        }
        DynamicObject unitid = (DynamicObject)rowObj.get("unitid");
        if (unitid == null) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u8ba1\u91cf\u5355\u4f4d\u4e0d\u5b58\u5728", (String)"StockinBillCommonValidator_34", (String)"occ-ococic-opplugin", (Object[])new Object[0]), rowNo + 1));
            return;
        }
        BigDecimal qty = (BigDecimal)rowObj.get("qty");
        if (BigDecimal.ZERO.compareTo(qty) > 0) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u6570\u91cf\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5", (String)"StockinBillCommonValidator_35", (String)"occ-ococic-opplugin", (Object[])new Object[0]), rowNo + 1));
            return;
        }
        DynamicObject baseunitid = (DynamicObject)rowObj.get("baseunitid");
        if (baseunitid == null) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u57fa\u672c\u8ba1\u91cf\u5355\u4f4d\u4e0d\u5b58\u5728", (String)"StockinBillCommonValidator_36", (String)"occ-ococic-opplugin", (Object[])new Object[0]), rowNo + 1));
            return;
        }
        BigDecimal baseqty = (BigDecimal)rowObj.get("baseqty");
        if (BigDecimal.ZERO.compareTo(baseqty) >= 0) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u57fa\u672c\u6570\u91cf\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5", (String)"StockinBillCommonValidator_37", (String)"occ-ococic-opplugin", (Object[])new Object[0]), rowNo + 1));
            return;
        }
        DynamicObject warehouse = (DynamicObject)rowObj.get("warehouse");
        if (warehouse == null) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u4ed3\u5e93\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5", (String)"StockinBillCommonValidator_38", (String)"occ-ococic-opplugin", (Object[])new Object[0]), rowNo + 1));
            return;
        }
        Boolean locationStatus = (Boolean)warehouse.get("enablelocation");
        if (locationStatus.booleanValue() && (location = (DynamicObject)rowObj.get("locationid")) == null) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u4ed3\u5e93\u5df2\u542f\u7528\u4ed3\u4f4d\uff0c\u8bf7\u68c0\u67e5\u4ed3\u4f4d\u662f\u5426\u8f93\u5165", (String)"StockinBillCommonValidator_39", (String)"occ-ococic-opplugin", (Object[])new Object[0]), rowNo + 1));
            return;
        }
        DynamicObject stockstatus = (DynamicObject)rowObj.get("stockstatus");
        if (stockstatus == null) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u5e93\u5b58\u72b6\u6001\u4e0d\u5b58\u5728", (String)"StockinBillCommonValidator_40", (String)"occ-ococic-opplugin", (Object[])new Object[0]), rowNo + 1));
            return;
        }
        DynamicObject stocktype = (DynamicObject)rowObj.get("stocktype");
        if (stocktype == null) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u5e93\u5b58\u7c7b\u578b\u4e0d\u5b58\u5728", (String)"StockinBillCommonValidator_41", (String)"occ-ococic-opplugin", (Object[])new Object[0]), rowNo + 1));
            return;
        }
        DynamicObject ownerid = (DynamicObject)rowObj.get("ownerid");
        if (ownerid == null) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u8d27\u4e3b\u4e0d\u5b58\u5728", (String)"StockinBillCommonValidator_42", (String)"occ-ococic-opplugin", (Object[])new Object[0]), rowNo + 1));
            return;
        }
        String ownertype = (String)rowObj.get("ownertype");
        if (ownertype == null) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u8d27\u4e3b\u7c7b\u578b\u4e0d\u5b58\u5728", (String)"StockinBillCommonValidator_43", (String)"occ-ococic-opplugin", (Object[])new Object[0]), rowNo + 1));
            return;
        }
        DynamicObject keeperid = (DynamicObject)rowObj.get("keeperid");
        if (keeperid == null) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u4fdd\u7ba1\u8005\u4e0d\u5b58\u5728", (String)"StockinBillCommonValidator_44", (String)"occ-ococic-opplugin", (Object[])new Object[0]), rowNo + 1));
            return;
        }
        String keepertype = (String)rowObj.get("keepertype");
        if (keepertype == null) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u4fdd\u7ba1\u8005\u7c7b\u578b\u4e0d\u5b58\u5728", (String)"StockinBillCommonValidator_45", (String)"occ-ococic-opplugin", (Object[])new Object[0]), rowNo + 1));
            return;
        }
        DynamicObject bill = dataEntity.getDataEntity();
        String inType = this.getBillTypeParamInType(bill);
        long inChannelId = bill.getLong("inchannelid_id");
        boolean channelIsNotContorlSN = channelIsNotContorlSnMap.get(inChannelId);
        boolean enableserial = itemid.getBoolean("enableserial");
        if (!"G".equalsIgnoreCase(inType) && enableserial && !channelIsNotContorlSN && (subRowObj = rowObj.getDynamicObjectCollection("subentryentity")).size() == 0) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u5546\u54c1\u5df2\u542f\u7528\u5e8f\u5217\u53f7\uff0c\u8bf7\u586b\u5199\u5e8f\u5217\u53f7", (String)"StockinBillCommonValidator_46", (String)"occ-ococic-opplugin", (Object[])new Object[0]), rowNo + 1));
            return;
        }
        Date productionDate = rowObj.getDate("producedate");
        Date validtoDate = rowObj.getDate("expirydate");
        if (productionDate != null && validtoDate != null && productionDate.after(validtoDate)) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u751f\u4ea7\u65e5\u671f\u5927\u4e8e\u6709\u6548\u671f", (String)"StockinBillCommonValidator_47", (String)"occ-ococic-opplugin", (Object[])new Object[0]), rowNo + 1));
            return;
        }
    }

    private void checkItemLotNumber(ExtendedDataEntity dataEntity, DynamicObject rowObj, int rowNo) {
        if (rowObj == null || rowObj.get("itemid") == null) {
            return;
        }
        boolean enableFlag = ((DynamicObject)rowObj.get("itemid")).getBoolean("enablelot");
        if (enableFlag) {
            DynamicObject auxpty;
            boolean assistunit;
            DynamicObject dynamicObject;
            String lotNum = (String)rowObj.get("lotnumber");
            if (StringUtils.isEmpty((String)lotNum)) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u6279\u53f7\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (String)"StockinBillCommonValidator_48", (String)"occ-ococic-opplugin", (Object[])new Object[0]), rowNo + 1));
                return;
            }
            Long itemId = DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)rowObj, (String)"itemid");
            String LotNumber = rowObj.get("lotnumber").toString();
            Long auxptyId = null;
            Long materialId = ((DynamicObject)rowObj.get("itemid")).getLong("material.id");
            if (materialId > 0L && (dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bd_material", (String)"isuseauxpty", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)materialId)})) != null && (assistunit = dynamicObject.getBoolean("isuseauxpty")) && (auxpty = (DynamicObject)rowObj.get("auxptyid")) != null) {
                auxptyId = auxpty.getLong("id");
            }
            this.checkWhetherLotNumBanned(dataEntity, itemId, LotNumber, rowNo, auxptyId);
            if (this.isOppositeDirection(dataEntity, rowNo)) {
                this.checkInWayBatchArchive(dataEntity, rowNo, rowObj);
            } else {
                this.checkItemBatchNumberExists(dataEntity, rowNo, rowObj);
            }
        }
    }

    private void checkWhetherLotNumBanned(ExtendedDataEntity dataEntity, Long itemid, String number, int rowNo, Long auxptyId) {
        DynamicObject[] result;
        QFilter itemidFilter = new QFilter("itemid", "=", (Object)itemid);
        QFilter idFilter = new QFilter("number", "=", (Object)number);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"0");
        QFilter auxptyIdFilter = null;
        if (auxptyId != null) {
            auxptyIdFilter = new QFilter("auxptyid", "=", (Object)auxptyId);
        }
        if (null != (result = BusinessDataServiceHelper.load((String)"ococic_lot", (String)"id", (QFilter[])new QFilter[]{itemidFilter, idFilter, enableFilter, auxptyIdFilter})) && result.length > 0) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c,\u5546\u54c1\u5b58\u5728\u7981\u7528\u7684\u6279\u53f7\uff0c\u8bf7\u68c0\u67e5", (String)"StockinBillCommonValidator_49", (String)"occ-ococic-opplugin", (Object[])new Object[0]), rowNo + 1));
        }
    }

    private void checkItemBatchNumberExists(ExtendedDataEntity dataEntity, int rowNo, DynamicObject rowObj) {
        boolean status = false;
        if (null != rowObj) {
            status = this.checkLotExist((String)rowObj.get("lotnumber"), rowObj);
            if (!status) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u6279\u53f7\u4e0d\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58", (String)"StockinBillCommonValidator_50", (String)"occ-ococic-opplugin", (Object[])new Object[0]), rowNo + 1));
                return;
            }
            Long lotID = this.checkLotNumber(DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)rowObj, (String)"itemid"), rowObj.get("lotnumber").toString());
            if (lotID == 0L) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u6279\u53f7\u4e0e\u5546\u54c1\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5", (String)"StockinBillCommonValidator_51", (String)"occ-ococic-opplugin", (Object[])new Object[0]), rowNo + 1));
                return;
            }
        }
    }

    private void checkInWayBatchArchive(ExtendedDataEntity dataEntity, int rowNo, DynamicObject rowObj) {
        if (rowObj != null) {
            boolean existFlag = this.checkLotExist(rowObj.get("lotnumber").toString(), rowObj);
            if (!existFlag) {
                return;
            }
            long itemId = DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)rowObj, (String)"itemid");
            String LotNumber = rowObj.get("lotnumber").toString();
            DynamicObjectCollection lotColl = QueryServiceHelper.query((String)"ococic_lot", (String)String.join((CharSequence)",", "id", "auxptyid"), (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)LotNumber).and(new QFilter("itemid", "=", (Object)itemId))});
            if (CommonUtils.isNull((Object)lotColl)) {
                Long returned_data = this.checkQtyFromLOtTrace(itemId, rowObj);
                if (returned_data.compareTo(1L) > 0) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u6279\u53f7\u4e0e\u5546\u54c1\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5", (String)"StockinBillCommonValidator_51", (String)"occ-ococic-opplugin", (Object[])new Object[0]), rowNo + 1));
                    return;
                }
                if (returned_data.compareTo(2L) < 0) {
                    Long lotId = this.getLotIdFromLotTbl(itemId, rowObj);
                    ArrayList<Long> ids = new ArrayList<Long>();
                    ids.add(lotId);
                    LotHelper.deleteLot(ids, (String)"ococic_channelinbill");
                } else if (returned_data.compareTo(0L) == 0) {
                    return;
                }
            } else if ("save".equals(this.getOperateKey()) || "submit".equals(this.getOperateKey())) {
                long auxptyId = DynamicObjectUtils.getPkValue((DynamicObject)rowObj, (String)"auxptyid");
                Map<Long, List<DynamicObject>> lotMap = lotColl.stream().collect(Collectors.groupingBy(obj -> obj.getLong("auxptyid")));
                List<DynamicObject> list = lotMap.get(auxptyId);
                if (!CommonUtils.isNull(list)) {
                    rowObj.set("lotnumberid", (Object)list.get(0).getLong("id"));
                }
            }
        }
    }

    private Long getLotIdFromLotTbl(Long itemid, DynamicObject rowObj) {
        QFilter itemIdFilter;
        Long LotId = 0L;
        String LotNumber = rowObj.get("lotnumber").toString();
        QFilter lotNumberFilter = new QFilter("number", "=", (Object)LotNumber);
        DynamicObject[] result = BusinessDataServiceHelper.load((String)"ococic_lot", (String)"id", (QFilter[])new QFilter[]{lotNumberFilter, itemIdFilter = new QFilter("itemid", "=", (Object)itemid)});
        if (null != result && result.length > 0) {
            LotId = result[0].getLong("id");
        }
        return LotId;
    }

    private Long checkQtyFromLOtTrace(Long itemid, DynamicObject rowObj) {
        Long return_data = 0L;
        String LotNumber = rowObj.get("lotnumber").toString();
        Long LotId = 0L;
        QFilter lotNumberFilter = new QFilter("number", "=", (Object)LotNumber);
        QFilter itemIdFilter = new QFilter("itemid", "=", (Object)itemid);
        DynamicObject[] result = BusinessDataServiceHelper.load((String)"ococic_lot", (String)"id", (QFilter[])new QFilter[]{lotNumberFilter, itemIdFilter});
        if (null != result && result.length > 0) {
            LotId = result[0].getLong("id");
        }
        if (LotId.compareTo(0L) > 0) {
            QFilter lotIdFilter = new QFilter("lotid", "=", (Object)LotId);
            DynamicObject[] rs = BusinessDataServiceHelper.load((String)"ococic_lotmovetrack", (String)"id", (QFilter[])new QFilter[]{lotIdFilter});
            return_data = rs != null && rs.length < 2 ? Long.valueOf(1L) : Long.valueOf(2L);
        }
        return return_data;
    }

    private Boolean checkLotExist(String number, DynamicObject rowObj) {
        QFilter numberFilter;
        boolean status = false;
        if (rowObj == null) {
            return status;
        }
        DynamicObject itemid = (DynamicObject)rowObj.get("itemid");
        if (itemid == null) {
            return status;
        }
        QFilter itemIdFilter = new QFilter("itemid", "=", (Object)itemid.getLong("id"));
        DynamicObject[] result = BusinessDataServiceHelper.load((String)"ococic_lot", (String)"id", (QFilter[])new QFilter[]{itemIdFilter, numberFilter = new QFilter("number", "=", (Object)number)});
        if (null != result && result.length > 0) {
            status = true;
        }
        return status;
    }

    private Long checkLotNumber(Long itemid, String number) {
        Long rs = 0L;
        QFilter itemidFilter = new QFilter("itemid", "=", (Object)itemid);
        QFilter idFilter = new QFilter("number", "=", (Object)number);
        DynamicObject[] result = BusinessDataServiceHelper.load((String)"ococic_lot", (String)"id", (QFilter[])new QFilter[]{itemidFilter, idFilter});
        if (null != result && result.length > 0) {
            rs = result[0].getLong("id");
        }
        return rs;
    }

    private boolean isOppositeDirection(ExtendedDataEntity dataEntity, int rowNo) {
        String inWay = dataEntity.getDataEntity().getString("inway");
        if (inWay == null) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c, \u5165\u5e93\u65b9\u5411\u4e0d\u5b58\u5728", (String)"StockinBillCommonValidator_52", (String)"occ-ococic-opplugin", (Object[])new Object[0]), rowNo + 1));
        }
        return "1".equals(inWay);
    }

    private String getBillTypeParamInType(DynamicObject bill) {
        DynamicObject billType = DynamicObjectUtils.getDynamicObject((DynamicObject)bill, (String)"billtypeid");
        DynamicObject billTypeParam = BillTypeParameterHelper.getBillTypeParameter((String)"ococic_channelinbill", (long)DynamicObjectUtils.getPkValue((DynamicObject)billType));
        return DynamicObjectUtils.getString((DynamicObject)billTypeParam, (String)"intype");
    }
}

