/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ococic.validator.inbill;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ococic.util.StringUtils;

public class StockinBillWriteLotIdValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject entity = dataEntity.getDataEntity();
            DynamicObjectCollection entries = entity.getDynamicObjectCollection("billentry");
            for (int i = 0; i < entries.size(); ++i) {
                DynamicObject entry = (DynamicObject)entries.get(i);
                this.validateEntryData(dataEntity, entry, i);
            }
        }
    }

    private void validateEntryData(ExtendedDataEntity dataEntity, DynamicObject entry, int i) {
        this.checkItemLotNumber(dataEntity, entry, i);
    }

    private void checkItemLotNumber(ExtendedDataEntity dataEntity, DynamicObject rowObj, int rowNo) {
        if (rowObj == null || rowObj.get("itemid") == null) {
            return;
        }
        boolean enableFlag = ((DynamicObject)rowObj.get("itemid")).getBoolean("enablelot");
        if (enableFlag) {
            String lotNum = (String)rowObj.get("lotnumber");
            if (StringUtils.isEmpty((String)lotNum)) {
                return;
            }
            if (this.isOppositeDirection(dataEntity, rowNo)) {
                this.checkInWayBatchArchive(dataEntity, rowNo, rowObj);
            } else {
                this.checkItemBatchNumberExists(dataEntity, rowNo, rowObj);
            }
        }
    }

    private void checkItemBatchNumberExists(ExtendedDataEntity dataEntity, int rowNo, DynamicObject rowObj) {
        boolean status = false;
        if (null != rowObj) {
            status = this.checkLotExist((String)rowObj.get("lotnumber"));
            if (!status) {
                return;
            }
            Long lotID = this.checkLotNumberReverse(((DynamicObject)rowObj.get("itemid")).getPkValue().toString(), rowObj.get("lotnumber").toString());
            if (lotID.compareTo(0L) > 0) {
                rowObj.set("lotnumberid", (Object)lotID);
            }
        }
    }

    private void checkInWayBatchArchive(ExtendedDataEntity dataEntity, int rowNo, DynamicObject rowObj) {
        boolean existFlag = true;
        if (rowObj != null) {
            existFlag = this.checkLotExist(rowObj.get("lotnumber").toString());
            if (!existFlag) {
                return;
            }
            long itemId = DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)rowObj, (String)"itemid");
            String LotNumber = rowObj.getString("lotnumber");
            DynamicObjectCollection lotColl = QueryServiceHelper.query((String)"ococic_lot", (String)String.join((CharSequence)",", "id", "auxptyid"), (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)LotNumber).and(new QFilter("itemid", "=", (Object)itemId))});
            if (CommonUtils.isNull((Object)lotColl)) {
                return;
            }
            if ("save".equals(this.getOperateKey()) || "submit".equals(this.getOperateKey())) {
                long auxptyId = DynamicObjectUtils.getPkValue((DynamicObject)rowObj, (String)"auxptyid");
                Map<Long, List<DynamicObject>> lotMap = lotColl.stream().collect(Collectors.groupingBy(obj -> obj.getLong("auxptyid")));
                List<DynamicObject> list = lotMap.get(auxptyId);
                if (!CommonUtils.isNull(list)) {
                    rowObj.set("lotnumberid", (Object)list.get(0).getLong("id"));
                }
            }
        }
    }

    private Boolean checkLotExist(String number) {
        boolean status = false;
        QFilter numberFilter = new QFilter("number", "=", (Object)number);
        DynamicObject[] result = BusinessDataServiceHelper.load((String)"ococic_lot", (String)"id", (QFilter[])new QFilter[]{numberFilter});
        if (null != result && result.length > 0) {
            status = true;
        }
        return status;
    }

    private Long checkLotNumberReverse(String itemid, String number) {
        QFilter enableFilter;
        QFilter idFilter;
        Long rs = 0L;
        QFilter itemidFilter = new QFilter("itemid", "=", (Object)Long.parseLong(itemid));
        DynamicObject[] result = BusinessDataServiceHelper.load((String)"ococic_lot", (String)"id", (QFilter[])new QFilter[]{itemidFilter, idFilter = new QFilter("number", "=", (Object)number), enableFilter = new QFilter("enable", "=", (Object)"1")});
        if (null != result && result.length > 0) {
            rs = result[0].getLong("id");
        }
        return rs;
    }

    private boolean isOppositeDirection(ExtendedDataEntity dataEntity, int rowNo) {
        String inWay = dataEntity.getDataEntity().getString("inway");
        if (inWay == null) {
            // empty if block
        }
        return "1".equals(inWay);
    }
}

