/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ococic.validator.inbill;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ococic.enums.SnStatusEnum;
import kd.occ.ococic.util.DateUtils;
import kd.occ.ococic.util.StringUtils;

public class StockinBillWriteSNValidator
extends AbstractValidator {
    public void validate() {
        if (this.dataEntities == null || this.dataEntities.length == 0) {
            return;
        }
        DynamicObject[] snDynObjs = this.getSNMainFileDynObjs(this.dataEntities);
        String snNumber = "";
        String snStatus = "";
        String tipMsg = "";
        String inWay = "";
        String itemNumber = "";
        long itemId = 0L;
        long auxptyId = 0L;
        String lotNum = "";
        long projectId = 0L;
        Date productDate = null;
        Date effectDate = null;
        HashSet<String> snNumberSet = new HashSet<String>();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject billDynObj = dataEntity.getDataEntity();
            DynamicObjectCollection entryColl = billDynObj.getDynamicObjectCollection("billentry");
            if (entryColl == null || entryColl.size() <= 0) continue;
            int seq = 0;
            for (DynamicObject entryDynObj : entryColl) {
                int snSize;
                DynamicObject itemDynObj = entryDynObj.getDynamicObject("itemid");
                if (itemDynObj == null || itemDynObj.getLong("id") == 0L) continue;
                BigDecimal snQty = entryDynObj.getBigDecimal("serialqty");
                DynamicObjectCollection snEntryColl = entryDynObj.getDynamicObjectCollection("subentryentity");
                int snCount = 0;
                snNumberSet.clear();
                if (snEntryColl != null) {
                    for (DynamicObject snEntryDynObj : snEntryColl) {
                        snNumber = snEntryDynObj.getString("serialnumber");
                        if (!StringUtils.isNotEmpty((String)snNumber)) continue;
                        snNumberSet.add(snNumber);
                        ++snCount;
                    }
                }
                ++seq;
                itemNumber = itemDynObj.getString("number");
                if (snQty.compareTo(BigDecimal.valueOf(snNumberSet.size())) != 0) {
                    return;
                }
                String lotNumber = entryDynObj.getString("lotnumber");
                if (lotNumber != null && billDynObj.getString("inway").equals("2")) {
                    Iterator it = snNumberSet.iterator();
                    while (it.hasNext()) {
                        if (this.snMainCheckIsFalse((String)it.next(), lotNumber)) continue;
                        return;
                    }
                }
                if (snNumberSet.size() != snCount) {
                    return;
                }
                int n = snSize = snEntryColl == null ? 0 : snEntryColl.size();
                if (snQty.compareTo(BigDecimal.valueOf(snSize)) != 0) {
                    return;
                }
                if (snQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                inWay = billDynObj.getString("inway");
                for (DynamicObject snDynObj : snDynObjs) {
                    String snKey;
                    snStatus = snDynObj.getString("snstatus");
                    snNumber = snDynObj.getString("number");
                    if ("1".equals(inWay) && SnStatusEnum.INSTOCK.getValue().equals(snStatus)) {
                        return;
                    }
                    if ("2".equals(inWay) && !SnStatusEnum.INSTOCK.getValue().equals(snStatus)) {
                        return;
                    }
                    snNumberSet.clear();
                    for (DynamicObject snEntryDynObj : snEntryColl) {
                        if (!snNumber.equals(snEntryDynObj.getString("serialnumber"))) continue;
                        snEntryDynObj.set("serialid", (Object)snDynObj.getLong("id"));
                        snNumberSet.add(snEntryDynObj.getString("serialnumber"));
                    }
                    if (snNumberSet.size() <= 0) continue;
                    itemId = entryDynObj.getLong("itemid_id");
                    auxptyId = entryDynObj.getLong("auxptyid_id");
                    lotNum = entryDynObj.getString("lotnumber");
                    projectId = entryDynObj.getLong("projectid_id");
                    productDate = DateUtils.getDataFormat((Date)entryDynObj.getDate("producedate"), (boolean)true);
                    effectDate = DateUtils.getDataFormat((Date)entryDynObj.getDate("expirydate"), (boolean)false);
                    String billEntryKey = StringUtils.join((CharSequence)"_", (Object[])new Object[]{itemId, auxptyId, lotNum, projectId, productDate, effectDate});
                    if (billEntryKey.equals(snKey = StringUtils.join((CharSequence)"_", (Object[])new Object[]{snDynObj.getLong("itemid_id"), snDynObj.getLong("auxptyid_id"), snDynObj.getString("lotnum"), snDynObj.getLong("projectid_id"), DateUtils.getDataFormat((Date)snDynObj.getDate("productdate"), (boolean)true), DateUtils.getDataFormat((Date)snDynObj.getDate("effectivedate"), (boolean)false)}))) continue;
                    return;
                }
            }
        }
    }

    private boolean snMainCheckIsFalse(String serialnumber, String lotNum) {
        Boolean status = Boolean.FALSE;
        QFilter lotnumfilter = new QFilter("lotnum", "=", (Object)lotNum);
        QFilter snfilter = new QFilter("number", "=", (Object)serialnumber);
        DynamicObject[] result = BusinessDataServiceHelper.load((String)"ococic_snmainfile", (String)"id", (QFilter[])new QFilter[]{lotnumfilter, snfilter});
        if (null != result && result.length > 0) {
            status = Boolean.TRUE;
        }
        return status;
    }

    private DynamicObject[] getSNMainFileDynObjs(ExtendedDataEntity[] billDataEntities) {
        String snNumber = "";
        HashSet<String> billSNSet = new HashSet<String>();
        for (ExtendedDataEntity dataEntity : billDataEntities) {
            DynamicObject billDynObj = dataEntity.getDataEntity();
            DynamicObjectCollection entryColl = billDynObj.getDynamicObjectCollection("billentry");
            if (entryColl == null || entryColl.size() <= 0) continue;
            for (DynamicObject entryDynObj : entryColl) {
                DynamicObject itemDynObj = entryDynObj.getDynamicObject("itemid");
                if (itemDynObj == null || itemDynObj.getLong("id") == 0L) continue;
                DynamicObjectCollection snEntryColl = entryDynObj.getDynamicObjectCollection("subentryentity");
                for (DynamicObject snEntryDynObj : snEntryColl) {
                    snNumber = snEntryDynObj.getString("serialnumber");
                    if (!StringUtils.isNotEmpty((String)snNumber)) continue;
                    billSNSet.add(snNumber);
                }
            }
        }
        QFilter filter = new QFilter("number", "in", (Object)billSNSet.toArray());
        DynamicObject[] snDynObjs = BusinessDataServiceHelper.load((String)"ococic_snmainfile", (String)String.join((CharSequence)",", "id", "number", "snstatus", "lotid", "lotnum", "itemid", "auxptyid", "auxptyid", "projectid", "productdate", "effectivedate"), (QFilter[])new QFilter[]{filter});
        return snDynObjs;
    }
}

