/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ococic.validator.outbill;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ChannelOutBillLotValidatorNew
extends AbstractValidator {
    private List<String> searchKeys;
    private Set<Integer> lotIdIsNull = new HashSet<Integer>(1);

    public void validate() {
        int size = 0;
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObjectCollection entries = dataEntity.getDataEntity().getDynamicObjectCollection("billentry");
            size += entries.size();
        }
        this.searchKeys = new ArrayList<String>(size);
        HashMap<String, List<String>> allLotNumberAndItemidsMap = new HashMap<String, List<String>>(size);
        HashMap<String, List<String>> disAbleLotNumberAndItemidsMap = new HashMap<String, List<String>>(size);
        this.queryLotMainFileByEntities(this.dataEntities, allLotNumberAndItemidsMap, disAbleLotNumberAndItemidsMap);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject entity = dataEntity.getDataEntity();
            String billStatus = entity.getString("billstatus");
            if (!"A".equalsIgnoreCase(billStatus)) continue;
            boolean isForwardDirection = "1".equals(entity.getString("outdirection"));
            DynamicObjectCollection entries = entity.getDynamicObjectCollection("billentry");
            int i = 0;
            for (DynamicObject entry : entries) {
                ++i;
                DynamicObject item = entry.getDynamicObject("itemid");
                if (null == item || !item.getBoolean("enablelot")) continue;
                List allItemIds = (List)allLotNumberAndItemidsMap.get(entry.getString("lotnumber"));
                List disableLotIds = (List)disAbleLotNumberAndItemidsMap.get(entry.getString("lotnumber"));
                long currentItemId = item.getLong("id");
                long auxId = 0L;
                DynamicObject aux = entry.getDynamicObject("auxptyid");
                if (null != aux) {
                    auxId = aux.getLong("id");
                }
                String value = currentItemId + "-" + auxId;
                if (!CollectionUtils.isEmpty((Collection)disableLotIds) && disableLotIds.contains(value)) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u5b58\u5728\u7981\u7528\u7684\u6279\u53f7\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ChannelOutBillLotValidatorNew_0", (String)"occ-ococic-opplugin", (Object[])new Object[0]), i));
                    continue;
                }
                if (!isForwardDirection) continue;
                if (CollectionUtils.isEmpty((Collection)allItemIds)) {
                    if (this.lotIdIsNull.contains(i)) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u6279\u53f7\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ChannelOutBillLotValidatorNew_1", (String)"occ-ococic-opplugin", (Object[])new Object[0]), i));
                    continue;
                }
                if (allItemIds.contains(value)) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u6279\u53f7\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ChannelOutBillLotValidatorNew_2", (String)"occ-ococic-opplugin", (Object[])new Object[0]), i));
            }
        }
    }

    private void queryLotMainFileByEntities(ExtendedDataEntity[] dataEntities, Map<String, List<String>> map1, Map<String, List<String>> map2) {
        StringBuilder key = new StringBuilder();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject entity = dataEntity.getDataEntity();
            String billStatus = entity.getString("billstatus");
            if (!"A".equalsIgnoreCase(billStatus)) continue;
            DynamicObjectCollection entries = entity.getDynamicObjectCollection("billentry");
            int i = 0;
            for (DynamicObject entry : entries) {
                ++i;
                DynamicObject item = entry.getDynamicObject("itemid");
                if (null == item) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u672a\u9009\u62e9\u5546\u54c1\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ChannelOutBillLotValidatorNew_3", (String)"occ-ococic-opplugin", (Object[])new Object[0]), i));
                    continue;
                }
                if (!item.getBoolean("enablelot")) continue;
                String lotNumber = entry.getString("lotnumber");
                if (StringUtils.isEmpty((Object)lotNumber)) {
                    this.lotIdIsNull.add(i);
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u672a\u586b\u5199\u6279\u53f7\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ChannelOutBillLotValidatorNew_4", (String)"occ-ococic-opplugin", (Object[])new Object[0]), i));
                    continue;
                }
                Long itemId = (Long)item.getPkValue();
                key.append(itemId);
                Object auxpty = entry.get("auxptyid");
                if (auxpty instanceof DynamicObject) {
                    Long auxptyId = (Long)((DynamicObject)auxpty).getPkValue();
                    key.append(',').append(auxptyId);
                } else {
                    key.append(',').append(0);
                }
                String lotNo = entry.getString("lotnumber");
                key.append(',').append(lotNo);
                this.searchKeys.add(key.toString());
                key.setLength(0);
            }
        }
        if (!CollectionUtils.isEmpty(this.searchKeys)) {
            this.searchLotMainFiles(this.searchKeys, map1, map2);
        }
    }

    private void searchLotMainFiles(List<String> searchKeys, Map<String, List<String>> map1, Map<String, List<String>> map2) {
        QFilter master = new QFilter("itemid", "=", (Object)Long.valueOf(searchKeys.get(0).split(",")[0])).and("auxptyid", "=", (Object)Long.valueOf(searchKeys.get(0).split(",")[1])).and("number", "=", (Object)searchKeys.get(0).split(",")[2]);
        for (int i = 1; i < searchKeys.size(); ++i) {
            String[] keySplit = searchKeys.get(i).split(",");
            master.or(new QFilter("itemid", "=", (Object)Long.valueOf(keySplit[0])).and("auxptyid", "=", (Object)Long.valueOf(keySplit[1])).and("number", "=", (Object)keySplit[2]));
        }
        DynamicObject[] lots = BusinessDataServiceHelper.load((String)"ococic_lot", (String)"id,number,itemid,enable,auxptyid", (QFilter[])master.toArray());
        if (null != lots && lots.length > 0) {
            for (DynamicObject lot : lots) {
                String key = lot.getString("number");
                String value = lot.getString("itemid_id") + "-" + lot.getString("auxptyid_id");
                boolean isEnable = lot.getBoolean("enable");
                map1.putIfAbsent(key, new ArrayList());
                map1.get(key).add(value);
                if (isEnable) continue;
                map2.putIfAbsent(key, new ArrayList());
                map2.get(key).add(value);
            }
        }
    }
}

