/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ococic.validator.outbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.util.BillTypeParameterHelper;
import kd.occ.ocbase.common.util.ChannelUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ococic.enums.SnStatusEnum;
import kd.occ.ococic.util.DateUtils;
import kd.occ.ococic.util.StringUtils;

public class ChannelOutBillSNValidator
extends AbstractValidator {
    public void validate() {
        if (this.dataEntities == null || this.dataEntities.length == 0) {
            return;
        }
        this.checkSNNumberDuplication(this.dataEntities);
        Map<String, List<DynamicObject>> snDynObjMap = this.getSNDynObjMap(this.dataEntities);
        String snNumber = "";
        String key = "";
        long itemId = 0L;
        long auxptyId = 0L;
        String lotNum = "";
        long projectId = 0L;
        Date productDate = null;
        Date effectDate = null;
        String snStatus = "";
        String tipMsg = "";
        String outWay = "";
        String itemNumber = "";
        List<DynamicObject> snDynObjList = null;
        List billDynObjList = DynamicObjectUtils.convertDynamicObjList((ExtendedDataEntity[])this.dataEntities);
        Set outChannelIdSet = billDynObjList.stream().map(r -> r.getLong("outchannelid_id")).collect(Collectors.toSet());
        Map channelIsNotContorlSnMap = ChannelUtil.queryChannelIsNotControlSN(outChannelIdSet);
        HashSet<String> snNumberSet = new HashSet<String>();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObjectCollection entryColl;
            DynamicObject billDynObj = dataEntity.getDataEntity();
            if ("C".equalsIgnoreCase(billDynObj.getString("billstatus")) || CollectionUtils.isEmpty((Collection)(entryColl = billDynObj.getDynamicObjectCollection("billentry")))) continue;
            int seq = 0;
            outWay = billDynObj.getString("outdirection");
            String outType = this.getBillTypeParamOutType(billDynObj);
            long outChannelId = billDynObj.getLong("outchannelid_id");
            boolean channelIsNotContorlSN = (Boolean)channelIsNotContorlSnMap.get(outChannelId);
            for (DynamicObject entryDynObj : entryColl) {
                ValidationErrorInfo erroInfo;
                DynamicObject itemDynObj = entryDynObj.getDynamicObject("itemid");
                if (itemDynObj == null || itemDynObj.getLong("id") == 0L) continue;
                itemId = entryDynObj.getLong("itemid_id");
                auxptyId = entryDynObj.getLong("auxptyid_id");
                lotNum = entryDynObj.getString("lotnumber");
                projectId = entryDynObj.getLong("projectid_id");
                productDate = DateUtils.getDataFormat((Date)entryDynObj.getDate("productdate"), (boolean)true);
                effectDate = DateUtils.getDataFormat((Date)entryDynObj.getDate("expiredate"), (boolean)false);
                key = StringUtils.join((CharSequence)"_", (Object[])new Object[]{itemId, auxptyId, lotNum, projectId, productDate, effectDate});
                BigDecimal snQty = entryDynObj.getBigDecimal("snquantity");
                DynamicObjectCollection snEntryColl = entryDynObj.getDynamicObjectCollection("chnloutbill_sn");
                int snCount = 0;
                snNumberSet.clear();
                int subSeq = 0;
                if (CollectionUtils.isEmpty((Collection)snEntryColl) && "F".equalsIgnoreCase(outType) || channelIsNotContorlSN) continue;
                for (DynamicObject snEntryDynObj : snEntryColl) {
                    DynamicObject snUnit = entryDynObj.getDynamicObject("snunit");
                    if (snUnit == null) {
                        tipMsg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u5546\u54c1\u7684\u5e8f\u5217\u53f7\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ChannelOutBillSNValidator_23", (String)"occ-ococic-opplugin", (Object[])new Object[0]), seq + 1);
                        ValidationErrorInfo erroInfo2 = new ValidationErrorInfo("", billDynObj.getPkValue(), dataEntity.getDataEntityIndex(), dataEntity.getRowIndex(), "errorcode_001", ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u68c0\u67e5", (String)"ChannelOutBillSNValidator_1", (String)"occ-ococic-opplugin", (Object[])new Object[0]), tipMsg, ErrorLevel.Error);
                        this.validateResult.addErrorInfo((OperateErrorInfo)erroInfo2);
                        return;
                    }
                    snNumber = snEntryDynObj.getString("serialnumber");
                    if (StringUtils.isNotEmpty((String)snNumber)) {
                        ValidationErrorInfo erroInfo3;
                        DynamicObject snDynObj;
                        DynamicObject[] snDynObjs = BusinessDataServiceHelper.load((String)"ococic_snmainfile", (String)String.join((CharSequence)",", "id", "number", "snstatus", "lotid", "lotnum", "itemid", "auxptyid", "auxptyid", "projectid", "productdate", "effectivedate", "channelstockid", "channellocationid", "channelstockstatusid", "channelstocktypeid", "ownertype", "ownerid", "keepertype", "keeperid"), (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)snNumber)});
                        if (snDynObjs.length == 0 && "1".equals(outWay)) {
                            tipMsg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u5546\u54c1\u7684\u5e8f\u5217\u53f7\u5b50\u5206\u5f55\uff0c\u7b2c%2$s\u884c\u4e0d\u5b58\u5728\u3002", (String)"ChannelOutBillSNValidator_12", (String)"occ-ococic-opplugin", (Object[])new Object[0]), seq + 1, subSeq + 1);
                            ValidationErrorInfo erroInfo4 = new ValidationErrorInfo("", billDynObj.getPkValue(), dataEntity.getDataEntityIndex(), dataEntity.getRowIndex(), "errorcode_001", ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u68c0\u67e5", (String)"ChannelOutBillSNValidator_1", (String)"occ-ococic-opplugin", (Object[])new Object[0]), tipMsg, ErrorLevel.Error);
                            this.validateResult.addErrorInfo((OperateErrorInfo)erroInfo4);
                            return;
                        }
                        if (snDynObjs.length > 0 && "1".equals(outWay)) {
                            snDynObj = snDynObjs[0];
                            String snKey = StringUtils.join((CharSequence)"_", (Object[])new Object[]{snDynObj.getLong("itemid_id"), snDynObj.getLong("auxptyid_id"), snDynObj.getString("lotnum"), snDynObj.getLong("projectid_id"), DateUtils.getDataFormat((Date)snDynObj.getDate("productdate"), (boolean)true), DateUtils.getDataFormat((Date)snDynObj.getDate("effectivedate"), (boolean)false)});
                            if (!key.equals(snKey)) {
                                tipMsg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u5e8f\u5217\u53f7\u4e0e\u5546\u54c1\u6216\u8f85\u52a9\u5c5e\u6027\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ChannelOutBillSNValidator_13", (String)"occ-ococic-opplugin", (Object[])new Object[0]), subSeq + 1);
                                ValidationErrorInfo erroInfo5 = new ValidationErrorInfo("", billDynObj.getPkValue(), dataEntity.getDataEntityIndex(), dataEntity.getRowIndex(), "errorcode_002", ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u68c0\u67e5", (String)"ChannelOutBillSNValidator_1", (String)"occ-ococic-opplugin", (Object[])new Object[0]), tipMsg, ErrorLevel.Error);
                                this.validateResult.addErrorInfo((OperateErrorInfo)erroInfo5);
                                return;
                            }
                            snNumberSet.add(snNumber);
                            ++snCount;
                        } else if (snDynObjs.length > 0 && "2".equals(outWay)) {
                            snDynObj = snDynObjs[0];
                            if (SnStatusEnum.INSTOCK.getValue().equals(snDynObj.getString("snstatus"))) {
                                tipMsg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u5e8f\u5217\u53f7%2$s\u72b6\u6001\u4e3a\u201c\u5728\u5e93\u201d\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u5165\u5e93\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ChannelOutBillSNValidator_14", (String)"occ-ococic-opplugin", (Object[])new Object[0]), subSeq + 1, snDynObj.getString("number"));
                                erroInfo3 = new ValidationErrorInfo("", billDynObj.getPkValue(), dataEntity.getDataEntityIndex(), dataEntity.getRowIndex(), "errorcode_003", ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u68c0\u67e5", (String)"ChannelOutBillSNValidator_1", (String)"occ-ococic-opplugin", (Object[])new Object[0]), tipMsg, ErrorLevel.Error);
                                this.validateResult.addErrorInfo((OperateErrorInfo)erroInfo3);
                            }
                            snNumberSet.add(snNumber);
                            ++snCount;
                        } else if (snDynObjs.length == 0 && "2".equals(outWay)) {
                            snNumberSet.add(snNumber);
                            ++snCount;
                        }
                        if (snDynObjs.length > 0) {
                            snDynObj = snDynObjs[0];
                            if (entryDynObj.getLong(String.join((CharSequence)"_", "stockid", "id")) != snDynObj.getLong(String.join((CharSequence)"_", "channelstockid", "id")) || entryDynObj.getLong(String.join((CharSequence)"_", "stockaddrid", "id")) != snDynObj.getLong(String.join((CharSequence)"_", "channellocationid", "id")) || entryDynObj.getLong(String.join((CharSequence)"_", "stockstatusid", "id")) != snDynObj.getLong(String.join((CharSequence)"_", "channelstockstatusid", "id")) || entryDynObj.getLong(String.join((CharSequence)"_", "stocktypeid", "id")) != snDynObj.getLong(String.join((CharSequence)"_", "channelstocktypeid", "id")) || !snDynObj.getString("ownertype").equals(entryDynObj.getString("ownertype")) || entryDynObj.getLong(String.join((CharSequence)"_", "ownerid", "id")) != snDynObj.getLong(String.join((CharSequence)"_", "ownerid", "id")) || !snDynObj.getString("keepertype").equals(entryDynObj.getString("keepertype")) || entryDynObj.getLong(String.join((CharSequence)"_", "keeperid", "id")) != snDynObj.getLong(String.join((CharSequence)"_", "keeperid", "id"))) {
                                tipMsg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u5e8f\u5217\u53f7%2$s\u4e2d\u7684\u4ed3\u5e93\u3001\u4ed3\u4f4d\u3001\u5e93\u5b58\u72b6\u6001\u3001\u5e93\u5b58\u7c7b\u578b\u3001\u8d27\u4e3b\u7c7b\u578b\u3001\u8d27\u4e3b\u3001\u4fdd\u7ba1\u8005\u7c7b\u578b\u3001\u4fdd\u7ba1\u8005\u4e0e\u5206\u5f55\u884c\u5f55\u5165\u6570\u636e\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ChannelOutBillSNValidator_15", (String)"occ-ococic-opplugin", (Object[])new Object[0]), subSeq + 1, snDynObj.getString("number"));
                                erroInfo3 = new ValidationErrorInfo("", billDynObj.getPkValue(), dataEntity.getDataEntityIndex(), dataEntity.getRowIndex(), "errordatacode_003", ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u68c0\u67e5", (String)"ChannelOutBillSNValidator_1", (String)"occ-ococic-opplugin", (Object[])new Object[0]), tipMsg, ErrorLevel.Error);
                                this.validateResult.addErrorInfo((OperateErrorInfo)erroInfo3);
                            }
                        }
                    }
                    ++subSeq;
                }
                ++seq;
                itemNumber = itemDynObj.getString("number");
                if (snQty.compareTo(BigDecimal.valueOf(snNumberSet.size())) != 0) {
                    tipMsg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u4e2d\u5546\u54c1\u7f16\u7801\u4e3a%2$s\u7684\u5e8f\u5217\u53f7\u6570\u91cf\u4e0e\u548c\u5e8f\u5217\u53f7\u8868\u8bb0\u5f55\u6761\u6570\u4e0d\u4e00\u81f4\u3002", (String)"ChannelOutBillSNValidator_16", (String)"occ-ococic-opplugin", (Object[])new Object[0]), seq, itemNumber);
                    erroInfo = new ValidationErrorInfo("", billDynObj.getPkValue(), dataEntity.getDataEntityIndex(), dataEntity.getRowIndex(), "errorcode_002", ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u68c0\u67e5", (String)"ChannelOutBillSNValidator_1", (String)"occ-ococic-opplugin", (Object[])new Object[0]), tipMsg, ErrorLevel.Error);
                    this.validateResult.addErrorInfo((OperateErrorInfo)erroInfo);
                }
                if (snNumberSet.size() < snCount) {
                    tipMsg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u4e2d\u5546\u54c1\u7f16\u7801\u4e3a%2$s\u7684\u5e8f\u5217\u53f7\u5b58\u5728\u91cd\u590d\u3002", (String)"ChannelOutBillSNValidator_17", (String)"occ-ococic-opplugin", (Object[])new Object[0]), seq, itemNumber);
                    erroInfo = new ValidationErrorInfo("", billDynObj.getPkValue(), dataEntity.getDataEntityIndex(), dataEntity.getRowIndex(), "errorcode_004", ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u68c0\u67e5", (String)"ChannelOutBillSNValidator_1", (String)"occ-ococic-opplugin", (Object[])new Object[0]), tipMsg, ErrorLevel.Error);
                    this.validateResult.addErrorInfo((OperateErrorInfo)erroInfo);
                }
                if (snQty.compareTo(BigDecimal.ZERO) <= 0 || snQty.compareTo(BigDecimal.valueOf(snNumberSet.size())) != 0) continue;
                if (CollectionUtils.isEmpty(snDynObjMap) && "1".equals(outWay)) {
                    tipMsg = ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u4e2d\u5546\u54c1\u7f16\u7801\u4e3a%2$s\u7684\u5e8f\u5217\u53f7\u4e0d\u5b58\u5728\u3002", (String)"ChannelOutBillSNValidator_18", (String)"occ-ococic-opplugin", (Object[])new Object[0]);
                    tipMsg = String.format(tipMsg, seq, itemNumber);
                    erroInfo = new ValidationErrorInfo("", billDynObj.getPkValue(), dataEntity.getDataEntityIndex(), dataEntity.getRowIndex(), "errorcode_005", ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u68c0\u67e5", (String)"ChannelOutBillSNValidator_1", (String)"occ-ococic-opplugin", (Object[])new Object[0]), tipMsg, ErrorLevel.Error);
                    this.validateResult.addErrorInfo((OperateErrorInfo)erroInfo);
                }
                if (CollectionUtils.isEmpty(snDynObjMap) || (snDynObjList = snDynObjMap.get(key)) == null) continue;
                for (DynamicObject snDynObj : snDynObjList) {
                    ValidationErrorInfo erroInfo6;
                    snStatus = snDynObj.getString("snstatus");
                    snNumber = snDynObj.getString("number");
                    if ("1".equals(outWay) && !SnStatusEnum.INSTOCK.getValue().equals(snStatus)) {
                        tipMsg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u4e2d\u5546\u54c1\u7f16\u7801\u4e3a%2$s\u7684\u5e8f\u5217\u53f7%3$s\u4e0d\u5728\u5e93\u3002", (String)"ChannelOutBillSNValidator_19", (String)"occ-ococic-opplugin", (Object[])new Object[0]), seq, itemNumber, snNumber);
                        erroInfo6 = new ValidationErrorInfo("", billDynObj.getPkValue(), dataEntity.getDataEntityIndex(), dataEntity.getRowIndex(), "errorcode_006", ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u68c0\u67e5", (String)"ChannelOutBillSNValidator_1", (String)"occ-ococic-opplugin", (Object[])new Object[0]), tipMsg, ErrorLevel.Error);
                        this.validateResult.addErrorInfo((OperateErrorInfo)erroInfo6);
                    }
                    if (!"2".equals(outWay) || !SnStatusEnum.INSTOCK.getValue().equals(snStatus)) continue;
                    tipMsg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u4e2d\u5546\u54c1\u7f16\u7801\u4e3a%2$s\u7684\u5e8f\u5217\u53f7%3$s\u5df2\u5728\u5e93\u3002", (String)"ChannelOutBillSNValidator_20", (String)"occ-ococic-opplugin", (Object[])new Object[0]), seq, itemNumber, snNumber);
                    erroInfo6 = new ValidationErrorInfo("", billDynObj.getPkValue(), dataEntity.getDataEntityIndex(), dataEntity.getRowIndex(), "errorcode_007", ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u68c0\u67e5", (String)"ChannelOutBillSNValidator_1", (String)"occ-ococic-opplugin", (Object[])new Object[0]), tipMsg, ErrorLevel.Error);
                    this.validateResult.addErrorInfo((OperateErrorInfo)erroInfo6);
                }
            }
        }
    }

    private void checkSNNumberDuplication(ExtendedDataEntity[] billDataEntities) {
        HashSet<String> snNumberSet = new HashSet<String>();
        HashMap<String, String> allBillSnNumMap = new HashMap<String, String>();
        for (ExtendedDataEntity billDataEntity : billDataEntities) {
            DynamicObjectCollection entries = billDataEntity.getDataEntity().getDynamicObjectCollection("billentry");
            snNumberSet.clear();
            int i = 0;
            for (DynamicObject entry : entries) {
                ++i;
                DynamicObject item = entry.getDynamicObject("itemid");
                if (null == item || !item.getBoolean("enableserial")) continue;
                DynamicObjectCollection subEntries = entry.getDynamicObjectCollection("chnloutbill_sn");
                for (DynamicObject subEntry : subEntries) {
                    ValidationErrorInfo erroInfo;
                    String tipMsg;
                    String snNumber = subEntry.getString("serialnumber");
                    if (snNumberSet.contains(snNumber)) {
                        tipMsg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u4e2d\u5546\u54c1\u7684\u5e8f\u5217\u53f7%2$s\u91cd\u590d\u3002", (String)"ChannelOutBillSNValidator_21", (String)"occ-ococic-opplugin", (Object[])new Object[0]), i, snNumber);
                        erroInfo = new ValidationErrorInfo("", billDataEntity.getDataEntity().getPkValue(), billDataEntity.getDataEntityIndex(), billDataEntity.getRowIndex(), "errorcode_008", ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u68c0\u67e5", (String)"ChannelOutBillSNValidator_1", (String)"occ-ococic-opplugin", (Object[])new Object[0]), tipMsg, ErrorLevel.Error);
                        this.validateResult.addErrorInfo((OperateErrorInfo)erroInfo);
                    }
                    snNumberSet.add(snNumber);
                    if (allBillSnNumMap.containsKey(snNumber)) {
                        tipMsg = String.format(ResManager.loadKDString((String)"\u5355\u636e:%1$s\u4e0e\u5355\u636e\uff1a%2$s,\u6709\u91cd\u590d\u7684\u5e8f\u5217\u53f7%3$s\u3002", (String)"ChannelOutBillSNValidator_22", (String)"occ-ococic-opplugin", (Object[])new Object[0]), billDataEntity.getDataEntity().getString("billno"), allBillSnNumMap.get(snNumber), snNumber);
                        erroInfo = new ValidationErrorInfo("", billDataEntity.getDataEntity().getPkValue(), billDataEntity.getDataEntityIndex(), billDataEntity.getRowIndex(), "errorcode_008", ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u68c0\u67e5", (String)"ChannelOutBillSNValidator_1", (String)"occ-ococic-opplugin", (Object[])new Object[0]), tipMsg, ErrorLevel.Error);
                        this.validateResult.addErrorInfo((OperateErrorInfo)erroInfo);
                    }
                    allBillSnNumMap.put(snNumber, billDataEntity.getDataEntity().getString("billno"));
                }
            }
        }
    }

    private Map<String, List<DynamicObject>> getSNDynObjMap(ExtendedDataEntity[] billDataEntities) {
        String snNumber = "";
        HashSet<String> billSNSet = new HashSet<String>();
        for (ExtendedDataEntity extendedDataEntity : billDataEntities) {
            DynamicObject billDynObj = extendedDataEntity.getDataEntity();
            DynamicObjectCollection entryColl = billDynObj.getDynamicObjectCollection("billentry");
            if (entryColl == null || entryColl.size() <= 0) continue;
            for (DynamicObject entryDynObj : entryColl) {
                DynamicObject itemDynObj = entryDynObj.getDynamicObject("itemid");
                if (itemDynObj == null || itemDynObj.getLong("id") == 0L) continue;
                DynamicObjectCollection snEntryColl = entryDynObj.getDynamicObjectCollection("chnloutbill_sn");
                for (DynamicObject snEntryDynObj : snEntryColl) {
                    snNumber = snEntryDynObj.getString("serialnumber");
                    if (!StringUtils.isNotEmpty((String)snNumber)) continue;
                    billSNSet.add(snNumber);
                }
            }
        }
        QFilter filter = new QFilter("number", "in", (Object)billSNSet.toArray());
        DynamicObject[] snDynObjs = BusinessDataServiceHelper.load((String)"ococic_snmainfile", (String)String.join((CharSequence)",", "id", "number", "snstatus", "lotid", "lotnum", "itemid", "auxptyid", "auxptyid", "projectid", "productdate", "effectivedate"), (QFilter[])new QFilter[]{filter});
        ArrayList<DynamicObject> snDynObjList = new ArrayList<DynamicObject>();
        if (snDynObjs != null && snDynObjs.length > 0) {
            for (DynamicObject snDynObj2 : snDynObjs) {
                snDynObjList.add(snDynObj2);
            }
        }
        Map<String, List<DynamicObject>> map = snDynObjList.stream().collect(Collectors.groupingBy(snDynObj -> StringUtils.join((CharSequence)"_", (Object[])new Object[]{snDynObj.getLong("itemid_id"), snDynObj.getLong("auxptyid_id"), snDynObj.getString("lotnum"), snDynObj.getLong("projectid_id"), DateUtils.getDataFormat((Date)snDynObj.getDate("productdate"), (boolean)true), DateUtils.getDataFormat((Date)snDynObj.getDate("effectivedate"), (boolean)false)})));
        return map;
    }

    private String getBillTypeParamOutType(DynamicObject bill) {
        DynamicObject billType = DynamicObjectUtils.getDynamicObject((DynamicObject)bill, (String)"billtypeid");
        DynamicObject billTypeParam = BillTypeParameterHelper.getBillTypeParameter((String)"ococic_channeloutbill", (long)DynamicObjectUtils.getPkValue((DynamicObject)billType));
        return DynamicObjectUtils.getString((DynamicObject)billTypeParam, (String)"outtype");
    }
}

