/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ococic.validator.outbill;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class StockoutBillSaveValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject entity = dataEntity.getDataEntity();
            DynamicObjectCollection entries = entity.getDynamicObjectCollection("billentry");
            for (int i = 0; i < entries.size(); ++i) {
                DynamicObject entry = (DynamicObject)entries.get(i);
                this.validateEntryData(dataEntity, entry, i);
            }
        }
    }

    private void validateEntryData(ExtendedDataEntity dataEntity, DynamicObject entry, int i) {
        this.checkItemQuantity(dataEntity, entry, i);
        this.checkAssistantProperties(dataEntity, entry, i);
        this.checkStockLocation(dataEntity, entry, i);
    }

    private void checkStockLocation(ExtendedDataEntity entity, DynamicObject rowEntity, int i) {
        DynamicObject stockLocation;
        boolean enablelocation;
        DynamicObject stock;
        if (null != rowEntity && null != (stock = rowEntity.getDynamicObject("stockid")) && (enablelocation = stock.getBoolean("enablelocation")) && null == (stockLocation = rowEntity.getDynamicObject("stockaddrid"))) {
            this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u4ed3\u4f4d\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"StockoutBillSaveValidator_4", (String)"occ-ococic-opplugin", (Object[])new Object[0]), i + 1));
        }
    }

    private void checkItemQuantity(ExtendedDataEntity entity, DynamicObject rowEntity, int rowNo) {
        BigDecimal quantity;
        if (null != rowEntity && (null == (quantity = (BigDecimal)rowEntity.get("quantity")) || BigDecimal.ZERO.compareTo(quantity) >= 0)) {
            this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c \u5546\u54c1\u6570\u91cf\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"StockoutBillSaveValidator_5", (String)"occ-ococic-opplugin", (Object[])new Object[0]), rowNo + 1));
        }
    }

    private void checkAssistantProperties(ExtendedDataEntity entity, DynamicObject rowEntity, int rowNo) {
        DynamicObject auxpty;
        boolean assistunit;
        DynamicObject bdmaterial;
        DynamicObject material;
        DynamicObject item;
        if (null != rowEntity && null != (item = rowEntity.getDynamicObject("itemid")) && (material = item.getDynamicObject("material")) != null && (bdmaterial = QueryServiceHelper.queryOne((String)"bd_material", (String)"isuseauxpty", (QFilter[])new QFilter[]{new QFilter("id", "=", material.getPkValue())})) != null && (assistunit = bdmaterial.getBoolean("isuseauxpty")) && null == (auxpty = rowEntity.getDynamicObject("auxptyid"))) {
            this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u5546\u54c1\u542f\u7528\u3010\u8f85\u52a9\u5c5e\u6027\u3011\uff0c\u5176\u4e3a\u5fc5\u5f55\u5b57\u6bb5\u3002", (String)"StockoutBillSaveValidator_6", (String)"occ-ococic-opplugin", (Object[])new Object[0]), rowNo + 1));
        }
    }
}

