/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ococic.validator.transbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.occ.ocbase.common.util.ChannelUtil;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.StringUtils;
import kd.occ.ococic.enums.SnStatusEnum;

public class TransBillSNValidator
extends AbstractValidator {
    public void validate() {
        if (this.dataEntities == null || this.dataEntities.length == 0) {
            return;
        }
        String snNumber = "";
        String snStatus = SnStatusEnum.INSTOCK.toString();
        String tipMsg = "";
        String itemNumber = "";
        long itemId = 0L;
        long auxptyId = 0L;
        long lotId = 0L;
        long projectId = 0L;
        Date productDate = null;
        Date effectDate = null;
        ArrayList<String> snList = new ArrayList<String>();
        List billDynObjList = DynamicObjectUtils.convertDynamicObjList((ExtendedDataEntity[])this.dataEntities);
        Set outChannelIdSet = billDynObjList.stream().map(r -> r.getLong("outchannelid_id")).collect(Collectors.toSet());
        Map outChannelIsNotContorlSnMap = ChannelUtil.queryChannelIsNotControlSN(outChannelIdSet);
        Set inChannelIdSet = billDynObjList.stream().map(r -> r.getLong("inchannelid_id")).collect(Collectors.toSet());
        Map inChannelIsNotContorlSnMap = ChannelUtil.queryChannelIsNotControlSN(inChannelIdSet);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject billDynObj = dataEntity.getDataEntity();
            DynamicObjectCollection entryColl = billDynObj.getDynamicObjectCollection("itementry");
            if (entryColl == null || entryColl.isEmpty()) continue;
            int seq = 0;
            long outChannelId = billDynObj.getLong("outchannelid_id");
            boolean outChannelIsNotContorlSN = (Boolean)outChannelIsNotContorlSnMap.get(outChannelId);
            long inChannelId = billDynObj.getLong("inchannelid_id");
            boolean inChannelIsNotContorlSN = (Boolean)inChannelIsNotContorlSnMap.get(inChannelId);
            String transmode = billDynObj.getString("transmode");
            block1: for (DynamicObject entryDynObj : entryColl) {
                ++seq;
                DynamicObject itemDynObj = entryDynObj.getDynamicObject("itemid");
                if (itemDynObj == null || itemDynObj.getLong("id") == 0L) continue;
                if (outChannelIsNotContorlSN && !inChannelIsNotContorlSN && "0".equals(transmode) && itemDynObj.getBoolean("enableserial")) {
                    tipMsg = ResManager.loadKDString((String)"\u8c03\u5165\u6e20\u9053\u9700\u8981\u5546\u54c1\u5e8f\u5217\u53f7\uff0c\u4e0d\u80fd\u6267\u884c\u4e00\u952e\u8c03\u62e8\uff0c\u8bf7\u9009\u7528\u5206\u6b65\u8c03\u62e8\u3002", (String)"TransBillSNValidator_8", (String)"occ-ococic-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(dataEntity, tipMsg);
                    continue;
                }
                itemNumber = itemDynObj.getString("number");
                DynamicObjectCollection snEntryColl = entryDynObj.getDynamicObjectCollection("subentryentity");
                if (!itemDynObj.getBoolean("enableserial") || outChannelIsNotContorlSN) {
                    entryDynObj.set("serialqty", (Object)BigDecimal.ZERO);
                    snEntryColl.clear();
                    continue;
                }
                if (entryDynObj.getBigDecimal("serialqty").compareTo(BigDecimal.valueOf(snEntryColl.size())) != 0) {
                    tipMsg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u4e2d\u5546\u54c1\u7f16\u7801\u4e3a%2$s\u7684\u5e8f\u5217\u53f7\u6570\u91cf\u548c\u5e8f\u5217\u53f7\u8868\u8bb0\u5f55\u6761\u6570\u4e0d\u4e00\u81f4\u3002", (String)"TransBillSNValidator_0", (String)"occ-ococic-opplugin", (Object[])new Object[0]), seq, itemNumber);
                    this.addErrorMessage(dataEntity, tipMsg);
                    continue;
                }
                snStatus = SnStatusEnum.INSTOCK.toString();
                itemId = entryDynObj.getLong("itemid_id");
                auxptyId = entryDynObj.getLong("auxptyid_id");
                lotId = entryDynObj.getLong("lotid_id");
                projectId = entryDynObj.getLong("outprojectid_id");
                productDate = entryDynObj.getDate("productdate");
                effectDate = entryDynObj.getDate("expiredate");
                for (DynamicObject snEntryDynObj : snEntryColl) {
                    snNumber = snEntryDynObj.getString("serialnumber");
                    DynamicObject pageSerial = snEntryDynObj.getDynamicObject("serialid");
                    tipMsg = "";
                    if (snStatus.equals(pageSerial.getString("snstatus"))) {
                        tipMsg = ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u4e2d\u5546\u54c1\u7f16\u7801\u4e3a%2$s\u7684\u5e8f\u5217\u53f7%3$s\u4e0d\u662f\u5728\u5e93\u72b6\u6001\u3002", (String)"TransBillSNValidator_1", (String)"occ-ococic-opplugin", (Object[])new Object[0]);
                        tipMsg = String.format(tipMsg, seq, itemNumber, snNumber);
                    } else if (pageSerial.getLong("itemid_id") != itemId) {
                        tipMsg = ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u4e2d\u5546\u54c1\u7f16\u7801\u4e3a%2$s\u7684\u5e8f\u5217\u53f7%3$s\u4e0e\u5546\u54c1\u4e0d\u4e00\u81f4\u3002", (String)"TransBillSNValidator_2", (String)"occ-ococic-opplugin", (Object[])new Object[0]);
                        tipMsg = String.format(tipMsg, seq, itemNumber, snNumber);
                    } else if (pageSerial.getLong("auxptyid_id") != auxptyId) {
                        tipMsg = ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u4e2d\u5546\u54c1\u7f16\u7801\u4e3a%2$s\u7684\u5e8f\u5217\u53f7%3$s\u4e0e\u5546\u54c1\u7684\u8f85\u52a9\u5c5e\u6027\u4e0d\u4e00\u81f4\u3002", (String)"TransBillSNValidator_3", (String)"occ-ococic-opplugin", (Object[])new Object[0]);
                        tipMsg = String.format(tipMsg, seq, itemNumber, snNumber);
                    } else if (pageSerial.getLong("lotid_id") != lotId) {
                        tipMsg = ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u4e2d\u5546\u54c1\u7f16\u7801\u4e3a%2$s\u7684\u5e8f\u5217\u53f7%3$s\u4e0e\u5206\u5f55\u7684\u6279\u53f7\u4e0d\u4e00\u81f4\u3002", (String)"TransBillSNValidator_4", (String)"occ-ococic-opplugin", (Object[])new Object[0]);
                        tipMsg = String.format(tipMsg, seq, itemNumber, snNumber);
                    } else if (pageSerial.getLong("projectid_id") != projectId) {
                        tipMsg = ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u4e2d\u5546\u54c1\u7f16\u7801\u4e3a%2$s\u7684\u5e8f\u5217\u53f7%3$s\u4e0e\u5206\u5f55\u7684\u9879\u76ee\u53f7\u4e0d\u4e00\u81f4\u3002", (String)"TransBillSNValidator_5", (String)"occ-ococic-opplugin", (Object[])new Object[0]);
                        tipMsg = String.format(tipMsg, seq, itemNumber, snNumber);
                    } else if (!this.isSameDate(pageSerial.getDate("productdate"), productDate) || !this.isSameDate(pageSerial.getDate("effectivedate"), effectDate)) {
                        tipMsg = ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u4e2d\u5546\u54c1\u7f16\u7801\u4e3a%2$s\u7684\u5e8f\u5217\u53f7%3$s\u4e0e\u5206\u5f55\u7684\u751f\u4ea7\u65e5\u671f\u548c\u6709\u6548\u65e5\u671f\u4e0d\u4e00\u81f4\u3002", (String)"TransBillSNValidator_6", (String)"occ-ococic-opplugin", (Object[])new Object[0]);
                        tipMsg = String.format(tipMsg, seq, itemNumber, snNumber);
                    }
                    if (snList.contains(snNumber)) {
                        tipMsg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u4e2d\u5546\u54c1\u7f16\u7801\u4e3a%2$s\u7684\u5e8f\u5217\u53f7\u5b58\u5728\u91cd\u590d\u3002", (String)"TransBillSNValidator_7", (String)"occ-ococic-opplugin", (Object[])new Object[0]), seq, itemNumber);
                    }
                    snList.add(snNumber);
                    if (!StringUtils.isNotEmpty((String)tipMsg)) continue;
                    this.addErrorMessage(dataEntity, tipMsg);
                    continue block1;
                }
            }
        }
    }

    private boolean isSameDate(Date date1, Date date2) {
        if (date1 == null && date2 == null) {
            return true;
        }
        return date1 != null && date2 != null && DateUtil.formatDate((Date)date1).equals(DateUtil.formatDate((Date)date2));
    }
}

