/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ococic.formplugin.allot;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.business.b2b.ChannelHelper;
import kd.occ.ocbase.business.helper.ChannelAuthorizeHelper;
import kd.occ.ocbase.business.helper.OcocicHelper;
import kd.occ.ocbase.common.enums.allotbill.AllotType;
import kd.occ.ocbase.common.enums.allotbill.CalculateType;
import kd.occ.ocbase.common.pojo.ocic.EntityInvQueryResult;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.SaleOrderUtil;
import kd.occ.ocbase.common.util.StringUtils;
import kd.occ.ocbase.formplugin.base.OcbaseBasePlugin;
import kd.occ.ococic.business.allotbill.AllotBillHandler;

public class AllotBillEdit
extends OcbaseBasePlugin
implements BeforeF7SelectListener,
RowClickEventListener {
    private static final Map<String, String> S2E_MAP = new HashMap<String, String>();
    private static final Map<String, String> P2E_MAP = new HashMap<String, String>();

    public void propertyChanged(PropertyChangedArgs e) {
        switch (e.getProperty().getName()) {
            case "stockorg1": {
                this.propertyChangedStockOrg(e);
                this.propertyChangedClearQty(e);
                break;
            }
            case "warehouse1": {
                this.propertyChangedClearQty(e);
                break;
            }
            case "material1": {
                this.propertyChangedMaterial(e);
                this.propertyChangedClearQty(e);
                break;
            }
            case "auxpty1": {
                this.propertyChangedClearQty(e);
                break;
            }
            case "allotbaseqty1": {
                this.propertyChangedAllotBaseQty(e);
                break;
            }
            case "percent2": {
                this.propertyChangedPercent(e);
                break;
            }
            case "calculatetype2": {
                this.propertyChangedCalculateType(e);
                break;
            }
            case "baseqty2": {
                this.propertyChangedBaseQty();
                break;
            }
        }
        this.propertyChangedSetEntry(e);
    }

    public void registerListener(EventObject e) {
        EntryGrid pentry;
        super.registerListener(e);
        this.addF7Listener(this, new String[]{"warehouse1", "warehouse1", "material1", "item2"});
        EntryGrid sentry = (EntryGrid)this.getControl("sentryentity");
        if (sentry != null) {
            sentry.addRowClickListener((RowClickEventListener)this);
        }
        if ((pentry = (EntryGrid)this.getControl("pentryentity")) != null) {
            pentry.addRowClickListener((RowClickEventListener)this);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String key;
        super.afterDoOperation(e);
        switch (key = e.getOperateKey()) {
            case "newsubentry": {
                if (StringUtils.isEmpty((String)this.getCurrentRowSPKey("pentryentity", "pkey2"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u5206\u914d\u660e\u7ec6\u3002", (String)"AllotBillEdit_0", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
                    break;
                }
                ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(1);
                if (this.getF7Value("org") != null) {
                    Set channelIdSet = ChannelAuthorizeHelper.getSubChannelBySaleOrgId((long)((Long)this.getF7PKValue("org")));
                    qFilterList.add(new QFilter("id", "in", (Object)channelIdSet));
                }
                ChannelHelper.showChannelF7View((IFormView)this.getView(), (boolean)true, qFilterList, (IFormPlugin)this, (String)key);
                break;
            }
            case "newsentry": {
                this.addSEntryRow();
                break;
            }
            case "newpentry": {
                this.addPEntryRow();
                break;
            }
            case "save": 
            case "unsubmit": 
            case "unaudit": {
                if (!e.getOperationResult().isSuccess()) break;
                this.resetSPEntryFromEntry();
                break;
            }
            case "invimport": {
                OcocicHelper.showEntityInvetoryQuery((IFormView)this.getView(), (IFormPlugin)this, (String)key);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        switch (e.getActionId()) {
            case "newsubentry": {
                this.closedCallBackNewSubEntry(e);
                break;
            }
            case "invimport": {
                this.closedCallBackInvImport(e);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.resetSPEntryFromEntry();
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        int rowIndex = e.getRow();
        switch (key) {
            case "warehouse1": {
                DynamicObject stockOrg = this.getEntryF7Value("sentryentity", "stockorg1", rowIndex);
                if (stockOrg == null) {
                    e.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"AllotBillEdit_1", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
                    break;
                }
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)new QFilter("id", "in", (Object)SaleOrderUtil.getWarehouseIdByStockOrgId((long)stockOrg.getLong("id"))));
                break;
            }
            case "item2": {
                DynamicObject pEntry = this.getModel().getEntryRowEntity("pentryentity", rowIndex);
                DynamicObject sEntry = (DynamicObject)pEntry.getParent();
                long materialId = DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)sEntry, (String)"material1");
                if (materialId > 0L) {
                    F7Utils.addF7Filter((BeforeF7SelectEvent)e, this.buildItemFilter(materialId));
                    break;
                }
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7269\u6599\u3002", (String)"AllotBillEdit_2", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        String entryName;
        super.beforeDeleteRow(e);
        switch (entryName = e.getEntryProp().getName()) {
            case "pentryentity": {
                this.checkNotEmpty(e);
                if (e.isCancel()) break;
                this.deletePEntries(e.getRowIndexs());
                break;
            }
            case "sentryentity": {
                this.deleteSEntries(e.getRowIndexs());
                break;
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        String entryName;
        super.afterDeleteRow(e);
        switch (entryName = e.getEntryProp().getName()) {
            case "pentryentity": {
                this.selectAllotBillEntry();
                this.propertyChangedBaseQty();
                break;
            }
            case "sentryentity": {
                this.selectAllotBillEntry();
                break;
            }
            case "subentryentity": {
                this.resetPEntryAllotType();
                break;
            }
        }
    }

    public void entryRowClick(RowClickEvent e) {
        int row = e.getRow();
        switch (((Control)e.getSource()).getKey()) {
            case "pentryentity": 
            case "sentryentity": {
                if (row < 0) break;
                this.selectAllotBillEntry();
                break;
            }
        }
    }

    private int getMatchPKeyEntryRowIndex(IDataModel model, String pKey) {
        int index = -1;
        HashSet<String> pKeySet = new HashSet<String>(1);
        pKeySet.add(pKey);
        int[] indexs = this.getMatchSPKeyEntryRowIndexs(model, null, pKeySet);
        if (indexs != null && indexs.length > 0) {
            index = indexs[0];
        }
        return index;
    }

    private int[] getMatchPKeyEntryRowIndexs(IDataModel model, Set<String> pKeySet) {
        return this.getMatchSPKeyEntryRowIndexs(model, null, pKeySet);
    }

    private int[] getMatchSKeyEntryRowIndexs(IDataModel model, String sKey) {
        HashSet<String> sKeySet = new HashSet<String>(1);
        sKeySet.add(sKey);
        return this.getMatchSKeyEntryRowIndexs(model, sKeySet);
    }

    private int[] getMatchSKeyEntryRowIndexs(IDataModel model, Set<String> sKeySet) {
        return this.getMatchSPKeyEntryRowIndexs(model, sKeySet, null);
    }

    private int[] getMatchSPKeyEntryRowIndexs(IDataModel model, Set<String> sKeySet, Set<String> pKeySet) {
        return model.getEntryEntity("entryentity").stream().filter(r -> !(!CollectionUtils.isEmpty((Collection)sKeySet) && !sKeySet.contains(r.getString("skey")) || !CollectionUtils.isEmpty((Collection)pKeySet) && !pKeySet.contains(r.getString("pkey")))).mapToInt(r -> r.getInt("seq") - 1).toArray();
    }

    private String getSKey1(DynamicObject sEntry) {
        return sEntry.getString("skey1");
    }

    private String getPKey2(DynamicObject pEntry) {
        return pEntry.getString("pkey2");
    }

    private DynamicObject addPEntry(DynamicObject sEntry, long itemId, int percent, BigDecimal baseQty) {
        DynamicObjectCollection pEntries = sEntry.getDynamicObjectCollection("pentryentity");
        DynamicObject pEntry = pEntries.addNew();
        pEntry.set("seq", (Object)pEntries.size());
        String pKey2 = this.getUniqeKey(pEntry.getInt("seq"));
        pEntry.set("pkey2", (Object)pKey2);
        pEntry.set("calculatetype2", (Object)CalculateType.BY_PERCENT.toString());
        pEntry.set("percent2", (Object)percent);
        pEntry.set("baseqty2", (Object)baseQty);
        if (itemId > 0L) {
            DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)pEntry, (String)"item2", (long)itemId);
        }
        return pEntry;
    }

    private DynamicObject addPEntry(DynamicObject sEntry, long itemId) {
        return this.addPEntry(sEntry, itemId, 0, BigDecimal.ZERO);
    }

    private String getUniqeKey(int index) {
        return String.valueOf(new Date().getTime()) + "_" + String.valueOf(index);
    }

    private void checkNotEmpty(BeforeDeleteRowEventArgs e) {
        DynamicObjectCollection pEntries;
        int[] deleteIndexs = e.getRowIndexs();
        String entryName = e.getEntryProp().getName();
        if (deleteIndexs != null && deleteIndexs.length > 0 && (pEntries = this.getModel().getEntryEntity(entryName)).size() == deleteIndexs.length) {
            e.setCancel(true);
            switch (entryName) {
                case "pentryentity": {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u914d\u6e90\u4e0b\u81f3\u5c11\u9700\u8981\u4e00\u6761\u5206\u914d\u660e\u7ec6\u3002", (String)"AllotBillEdit_3", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    private void deletePEntries(int[] deleteIndexs) {
        if (deleteIndexs != null && deleteIndexs.length > 0) {
            DynamicObjectCollection pEntries = this.getModel().getEntryEntity("pentryentity");
            HashSet<String> pKey2Set = new HashSet<String>(deleteIndexs.length);
            for (int index : deleteIndexs) {
                pKey2Set.add(this.getPKey2((DynamicObject)pEntries.get(index)));
            }
            this.getModel().deleteEntryRows("entryentity", this.getMatchPKeyEntryRowIndexs(this.getModel(), pKey2Set));
            this.getView().updateView("entryentity");
        }
    }

    private void deleteSEntries(int[] deleteIndexs) {
        if (deleteIndexs != null && deleteIndexs.length > 0) {
            DynamicObjectCollection sEntries = this.getModel().getEntryEntity("sentryentity");
            HashSet<String> sKey1Set = new HashSet<String>(deleteIndexs.length);
            for (int index : deleteIndexs) {
                sKey1Set.add(this.getSKey1((DynamicObject)sEntries.get(index)));
            }
            this.getModel().deleteEntryRows("entryentity", this.getMatchSKeyEntryRowIndexs(this.getModel(), sKey1Set));
            this.getView().updateView("entryentity");
        }
    }

    private void sEntryCopy2Entry(DynamicObject entry, DynamicObject sEntry) {
        for (Map.Entry<String, String> e2s : S2E_MAP.entrySet()) {
            if (sEntry.get(e2s.getKey()) == null) {
                switch (e2s.getKey()) {
                    case "material1": 
                    case "auxpty1": 
                    case "stockorg1": 
                    case "warehouse1": 
                    case "baseunit1": {
                        entry.set(e2s.getValue() + "_id", sEntry.get(e2s.getKey() + "_id"));
                    }
                }
                continue;
            }
            entry.set(e2s.getValue(), sEntry.get(e2s.getKey()));
        }
    }

    private void pEntryCopy2Entry(DynamicObject entry, DynamicObject pEntry) {
        for (Map.Entry<String, String> p2e : P2E_MAP.entrySet()) {
            if (pEntry.get(p2e.getKey()) == null) {
                switch (p2e.getKey()) {
                    case "item2": {
                        entry.set(p2e.getValue() + "_id", pEntry.get(p2e.getKey() + "_id"));
                    }
                }
                continue;
            }
            entry.set(p2e.getValue(), pEntry.get(p2e.getKey()));
        }
    }

    private void entryCopy2SEntry(DynamicObject entry, DynamicObject sEntry) {
        for (Map.Entry<String, String> e2s : S2E_MAP.entrySet()) {
            sEntry.set(e2s.getKey(), entry.get(e2s.getValue()));
        }
    }

    private void entryCopy2PEntry(DynamicObject entry, DynamicObject pEntry) {
        for (Map.Entry<String, String> p2e : P2E_MAP.entrySet()) {
            pEntry.set(p2e.getKey(), entry.get(p2e.getValue()));
        }
    }

    private void propertyChangedClearQty(PropertyChangedArgs e) {
        int rowIndex = this.getRowIndex(e);
        this.setValue("invbaseqty1", BigDecimal.ZERO, rowIndex);
        this.setValue("allotbaseqty1", BigDecimal.ZERO, rowIndex);
    }

    private void propertyChangedMaterial(PropertyChangedArgs e) {
        Object newValue = e.getChangeSet()[0].getNewValue();
        int rowIndex = this.getRowIndex(e);
        DynamicObject material = (DynamicObject)newValue;
        long itemId = 0L;
        DynamicObject sEntry = this.getModel().getEntryRowEntity("sentryentity", rowIndex);
        if (DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)sEntry, (String)"auxpty1") > 0L) {
            this.setValue("auxpty1", null, rowIndex);
        }
        if (material == null) {
            if (DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)sEntry, (String)"baseunit1") > 0L) {
                this.setValue("baseunit1", null, rowIndex);
            }
        } else {
            long baseUnitId = DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)material, (String)"baseunit");
            this.setValue("baseunit1", baseUnitId, rowIndex);
            Set<Long> itemIdSet = this.queryItemIdSet(material.getLong("id"));
            if (!CollectionUtils.isEmpty(itemIdSet) && itemIdSet.size() == 1) {
                itemId = (Long)itemIdSet.stream().findFirst().get();
            }
        }
        DynamicObjectCollection pEntries = sEntry.getDynamicObjectCollection("pentryentity");
        for (DynamicObject pEntry : pEntries) {
            int index = pEntry.getInt("seq") - 1;
            if (DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)pEntry, (String)"item2") > 0L) {
                this.setValue("item2", itemId > 0L ? Long.valueOf(itemId) : null, index);
                continue;
            }
            if (itemId <= 0L) continue;
            this.setValue("item2", itemId, index);
        }
    }

    private void propertyChangedStockOrg(PropertyChangedArgs e) {
        int rowIndex = this.getRowIndex(e);
        this.setValue("warehouse1", null, rowIndex);
    }

    private void propertyChangedPercent(PropertyChangedArgs e) {
        Object newValue = e.getChangeSet()[0].getNewValue();
        int rowIndex = this.getRowIndex(e);
        int percent = (Integer)newValue;
        DynamicObject pEntry = this.getModel().getEntryRowEntity("pentryentity", rowIndex);
        DynamicObject sEntry = (DynamicObject)pEntry.getParent();
        this.setValue("baseqty2", sEntry.getBigDecimal("allotbaseqty1").multiply(BigDecimal.valueOf(percent)).divide(BigDecimal.valueOf(100L)), rowIndex);
    }

    private void propertyChangedCalculateType(PropertyChangedArgs e) {
        Object newValue = e.getChangeSet()[0].getNewValue();
        if (newValue != null) {
            int rowIndex = this.getRowIndex(e);
            CalculateType calculateType = CalculateType.parse((String)newValue.toString());
            switch (calculateType) {
                case BY_PERCENT: {
                    this.setValue("baseqty2", BigDecimal.ZERO, rowIndex);
                    break;
                }
                case BY_QTY: {
                    this.setValue("percent2", 0, rowIndex);
                }
            }
        }
    }

    private void propertyChangedBaseQty() {
        int index = this.getModel().getEntryCurrentRowIndex("sentryentity");
        DynamicObject sEntry = this.getModel().getEntryRowEntity("sentryentity", index);
        BigDecimal sumQty = sEntry.getDynamicObjectCollection("pentryentity").stream().map(r -> r.getBigDecimal("baseqty2")).reduce(BigDecimal.ZERO, BigDecimal::add);
        this.setValue("sumbaseqty1", sumQty, index);
    }

    private void propertyChangedAllotBaseQty(PropertyChangedArgs e) {
        Object newValue = e.getChangeSet()[0].getNewValue();
        int rowIndex = this.getRowIndex(e);
        BigDecimal allotBaseQty = newValue == null ? BigDecimal.ZERO : (BigDecimal)newValue;
        DynamicObject sEntry = this.getModel().getEntryRowEntity("sentryentity", rowIndex);
        DynamicObjectCollection pEntries = sEntry.getDynamicObjectCollection("pentryentity");
        for (DynamicObject pEntry : pEntries) {
            if (CalculateType.BY_PERCENT != CalculateType.parse((String)pEntry.getString("calculatetype2"))) continue;
            BigDecimal percent = pEntry.getBigDecimal("percent2");
            BigDecimal baseQty = pEntry.getBigDecimal("baseqty2");
            BigDecimal baseQtyNew = allotBaseQty.multiply(percent).divide(BigDecimal.valueOf(100L));
            if (baseQtyNew.compareTo(baseQty) == 0) continue;
            this.setValue("baseqty2", baseQtyNew, pEntry.getInt("seq") - 1);
        }
    }

    private void propertyChangedSetEntry(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        int rowIndex = this.getRowIndex(e);
        switch (key) {
            case "skey1": 
            case "pkey2": {
                break;
            }
            default: {
                Object newValue = e.getChangeSet()[0].getNewValue();
                if (S2E_MAP.containsKey(key)) {
                    int[] matchSPKeyEntryRowIndexs;
                    String sKey = this.getStringValue("skey1", rowIndex);
                    for (int i : matchSPKeyEntryRowIndexs = this.getMatchSKeyEntryRowIndexs(this.getModel(), sKey)) {
                        this.setValue(S2E_MAP.get(key), newValue, i);
                    }
                    break;
                }
                if (!P2E_MAP.containsKey(key)) break;
                String pKey = this.getStringValue("pkey2", rowIndex);
                this.setValue(P2E_MAP.get(key), newValue, this.getMatchPKeyEntryRowIndex(this.getModel(), pKey));
            }
        }
    }

    private void closedCallBackInvImport(ClosedCallBackEvent e) {
        List results = OcocicHelper.closedCallBackEntityInvetoryQuery((ClosedCallBackEvent)e);
        if (!CollectionUtils.isEmpty((Collection)results)) {
            Map<String, List<EntityInvQueryResult>> groupedResultMap1 = results.stream().collect(Collectors.groupingBy(r -> String.join((CharSequence)"#", String.valueOf(r.getItemId()), String.valueOf(r.getMaterialId()), String.valueOf(r.getAuxptyId()), String.valueOf(r.getStockOrgId()), String.valueOf(r.getWarehouseId()), String.valueOf(r.getBaseUnitId()))));
            List groupedResultList1 = groupedResultMap1.values().stream().map(r -> {
                EntityInvQueryResult result = new EntityInvQueryResult();
                for (EntityInvQueryResult tempResult : r) {
                    result.setItemId(tempResult.getItemId());
                    result.setMaterialId(tempResult.getMaterialId());
                    result.setAuxptyId(tempResult.getAuxptyId());
                    result.setStockOrgId(tempResult.getStockOrgId());
                    result.setWarehouseId(tempResult.getWarehouseId());
                    result.setBaseUnitId(tempResult.getBaseUnitId());
                    result.setBaseQty(result.getBaseQty().add(tempResult.getBaseQty()));
                }
                return result;
            }).collect(Collectors.toList());
            Map<String, List<EntityInvQueryResult>> groupedResultMap2 = groupedResultList1.stream().collect(Collectors.groupingBy(r -> String.join((CharSequence)"#", String.valueOf(r.getMaterialId()), String.valueOf(r.getAuxptyId()), String.valueOf(r.getStockOrgId()), String.valueOf(r.getWarehouseId()), String.valueOf(r.getBaseUnitId()))));
            DynamicObjectCollection sEntries = this.getModel().getEntryEntity("sentryentity");
            Map<String, DynamicObject> groupedSEntryMap = sEntries.stream().collect(Collectors.toMap(r -> String.join((CharSequence)"#", DynamicObjectUtils.getDynamicObjectSPkValue((DynamicObject)r, (String)"material1"), DynamicObjectUtils.getDynamicObjectSPkValue((DynamicObject)r, (String)"auxpty1"), DynamicObjectUtils.getDynamicObjectSPkValue((DynamicObject)r, (String)"stockorg1"), DynamicObjectUtils.getDynamicObjectSPkValue((DynamicObject)r, (String)"warehouse1"), DynamicObjectUtils.getDynamicObjectSPkValue((DynamicObject)r, (String)"baseunit1")), r -> r, (t1, t2) -> t1));
            boolean isChange = false;
            for (Map.Entry<String, List<EntityInvQueryResult>> groupedReusltEntry : groupedResultMap2.entrySet()) {
                boolean isFirst;
                List<EntityInvQueryResult> groupedResultList2 = groupedReusltEntry.getValue();
                String key = groupedReusltEntry.getKey();
                DynamicObject sEntry = groupedSEntryMap.get(key);
                if (sEntry == null) {
                    sEntry = sEntries.addNew();
                    isChange = true;
                    isFirst = true;
                    for (EntityInvQueryResult result : groupedResultList2) {
                        if (isFirst) {
                            sEntry.set("seq", (Object)sEntries.size());
                            sEntry.set("skey1", (Object)this.getUniqeKey(sEntry.getInt("seq")));
                            DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)sEntry, (String)"stockorg1", (long)result.getStockOrgId());
                            DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)sEntry, (String)"warehouse1", (long)result.getWarehouseId());
                            DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)sEntry, (String)"material1", (long)result.getMaterialId());
                            DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)sEntry, (String)"auxpty1", (long)result.getAuxptyId());
                            DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)sEntry, (String)"baseunit1", (long)result.getBaseUnitId());
                            sEntry.set("invbaseqty1", (Object)result.getBaseQty());
                            if (BigDecimal.ZERO.compareTo(result.getBaseQty()) < 0) {
                                sEntry.set("allotbaseqty1", (Object)result.getBaseQty());
                                sEntry.set("sumbaseqty1", (Object)result.getBaseQty());
                            }
                        }
                        DynamicObject pEntry = isFirst ? this.addPEntry(sEntry, result.getItemId(), 100, sEntry.getBigDecimal("allotbaseqty1")) : this.addPEntry(sEntry, result.getItemId());
                        this.getModel().updateEntryCache(sEntries);
                        this.addAllotBillEntry(pEntry);
                        isFirst = false;
                    }
                    continue;
                }
                isFirst = true;
                Set existItemIdSet = sEntry.getDynamicObjectCollection("pentryentity").stream().map(r -> DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)r, (String)"item2")).collect(Collectors.toSet());
                for (EntityInvQueryResult result : groupedResultList2) {
                    if (isFirst) {
                        sEntry.set("invbaseqty1", (Object)result.getBaseQty());
                        if (BigDecimal.ZERO.compareTo(sEntry.getBigDecimal("allotbaseqty1")) == 0 && BigDecimal.ZERO.compareTo(result.getBaseQty()) < 0) {
                            sEntry.set("allotbaseqty1", (Object)result.getBaseQty());
                        }
                        this.getModel().updateEntryCache(sEntries);
                        isChange = true;
                    }
                    if (!existItemIdSet.contains(result.getItemId())) {
                        DynamicObject pEntry = this.addPEntry(sEntry, result.getItemId());
                        this.addAllotBillEntry(pEntry);
                        isChange = true;
                    }
                    isFirst = false;
                }
            }
            if (isChange) {
                this.getView().updateView("sentryentity");
                this.getView().updateView("entryentity");
                this.selectEntryRow("sentryentity", 0, true);
                this.selectEntryRow("pentryentity", 0, true);
                this.selectAllotBillEntry();
            }
        }
    }

    private void closedCallBackNewSubEntry(ClosedCallBackEvent e) {
        ListSelectedRowCollection rows;
        Object returnData = e.getReturnData();
        if (returnData instanceof ListSelectedRowCollection && !CollectionUtils.isEmpty((Collection)(rows = (ListSelectedRowCollection)returnData))) {
            DynamicObjectCollection subEntries = this.getModel().getEntryEntity("subentryentity");
            Set existChannelIdSet = subEntries.stream().map(r -> DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)r, (String)"channel")).collect(Collectors.toSet());
            List channelIds = rows.stream().map(r -> (Long)r.getPrimaryKeyValue()).filter(r -> !existChannelIdSet.contains(r)).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(channelIds)) {
                for (Long channelId : channelIds) {
                    DynamicObject subEntry = subEntries.addNew();
                    DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)subEntry, (String)"channel", (long)channelId);
                }
                BusinessDataServiceHelper.loadRefence((Object[])subEntries.toArray(), (IDataEntityType)subEntries.getDynamicObjectType());
                this.getView().updateView("subentryentity");
                this.resetPEntryAllotType();
            }
        }
    }

    private void resetPEntryAllotType() {
        String oldCKey;
        String newCKey;
        AllotType newAllotType;
        DynamicObjectCollection subEntries = this.getModel().getEntryEntity("subentryentity");
        int pEntryIndex = this.getModel().getEntryCurrentRowIndex("pentryentity");
        AllotType oldAllotType = AllotType.parse((String)this.getStringValue("allottype2", pEntryIndex));
        if (oldAllotType != (newAllotType = AllotBillHandler.getAllotType((DynamicObjectCollection)subEntries))) {
            this.getModel().setValue("allottype2", (Object)(newAllotType == null ? "" : newAllotType.toString()), pEntryIndex);
        }
        if (!(newCKey = AllotBillHandler.getCkey((DynamicObjectCollection)subEntries)).equals(oldCKey = (String)this.getModel().getValue("ckey2", pEntryIndex))) {
            this.getModel().setValue("ckey2", (Object)newCKey, pEntryIndex);
        }
    }

    private void resetSPEntryFromEntry() {
        DynamicObjectCollection entries = this.getModel().getEntryEntity("entryentity");
        if (!CollectionUtils.isEmpty((Collection)entries)) {
            DynamicObjectCollection sEntries = this.getModel().getEntryEntity("sentryentity");
            sEntries.clear();
            Map<String, List<DynamicObject>> groupedEntryMap = entries.stream().collect(Collectors.groupingBy(r -> r.getString("skey")));
            for (List<DynamicObject> groupedEntryList : groupedEntryMap.values()) {
                DynamicObject sEntry = sEntries.addNew();
                for (DynamicObject groupedEntry : groupedEntryList) {
                    if (StringUtils.isEmpty((String)sEntry.getString("skey1"))) {
                        this.entryCopy2SEntry(groupedEntry, sEntry);
                    }
                    DynamicObject pEntry = sEntry.getDynamicObjectCollection("pentryentity").addNew();
                    pEntry.set("seq", (Object)sEntry.getDynamicObjectCollection("pentryentity").size());
                    this.entryCopy2PEntry(groupedEntry, pEntry);
                }
            }
            this.getView().updateView("sentryentity");
            this.selectEntryRow("sentryentity", 0, true);
            this.selectEntryRow("pentryentity", 0, true);
            this.selectAllotBillEntry();
        }
    }

    private void addSEntryRow() {
        int sIndex = this.getModel().createNewEntryRow("sentryentity");
        String sKey1 = this.getUniqeKey(sIndex + 1);
        this.setValue("skey1", sKey1, sIndex);
        this.selectEntryRow("sentryentity", sIndex, true);
        int pIndex = this.getModel().createNewEntryRow("pentryentity");
        String pKey2 = this.getUniqeKey(pIndex + 1);
        this.setValue("pkey2", pKey2, pIndex);
        DynamicObject pEntry = this.getModel().getEntryRowEntity("pentryentity", pIndex);
        this.addAllotBillEntry(pEntry);
        this.getView().updateView("entryentity");
        this.selectAllotBillEntry();
        this.setValue("percent2", 100, pIndex);
    }

    private void addPEntryRow() {
        if (StringUtils.isNotEmpty((String)this.getCurrentRowSPKey("sentryentity", "skey1"))) {
            Set<Long> itemIdSet;
            int pIndex = this.getModel().createNewEntryRow("pentryentity");
            DynamicObject pEntry = this.getModel().getEntryRowEntity("pentryentity", pIndex);
            String pKey2 = this.getUniqeKey(pIndex + 1);
            this.setValue("pkey2", pKey2, pIndex);
            this.selectEntryRow("pentryentity", pIndex, true);
            this.addAllotBillEntry(pEntry);
            this.getView().updateView("entryentity");
            this.selectAllotBillEntry();
            DynamicObject sEntry = (DynamicObject)pEntry.getParent();
            long materialId = DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)sEntry, (String)"material1");
            long itemId = DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)pEntry, (String)"item2");
            if (materialId > 0L && itemId == 0L && !CollectionUtils.isEmpty(itemIdSet = this.queryItemIdSet(materialId)) && itemIdSet.size() == 1) {
                this.setValue("item2", itemIdSet.stream().findFirst().get(), pIndex);
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u6761\u5206\u914d\u6e90\u3002", (String)"AllotBillEdit_4", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
        }
    }

    private void addAllotBillEntry(DynamicObject pEntry) {
        DynamicObject sEntry = (DynamicObject)pEntry.getParent();
        DynamicObjectCollection entries = this.getModel().getEntryEntity("entryentity");
        DynamicObject entry = entries.addNew();
        entry.set("seq", (Object)(entries.indexOf((Object)entry) + 1));
        this.sEntryCopy2Entry(entry, sEntry);
        this.pEntryCopy2Entry(entry, pEntry);
        this.getModel().updateEntryCache(entries);
    }

    private void selectEntryRow(String entity, int index, boolean forceRefocus) {
        ((EntryGrid)this.getView().getControl(entity)).selectRows(index, forceRefocus);
    }

    private void autoSelectRow(String entity) {
        int[] selectedIndexs = ((EntryGrid)this.getView().getControl(entity)).getSelectRows();
        if (selectedIndexs.length == 0) {
            this.selectEntryRow(entity, this.getCurrentRowIndex(entity), false);
        }
    }

    private String getCurrentRowSPKey(String entity, String key) {
        String spKey = "";
        int index = this.getCurrentRowIndex(entity);
        if (index >= 0) {
            DynamicObject entry = this.getModel().getEntryRowEntity(entity, index);
            spKey = entry == null ? "" : entry.getString(key);
        }
        return spKey;
    }

    private void selectAllotBillEntry() {
        String pKey2 = this.getCurrentRowSPKey("pentryentity", "pkey2");
        if (StringUtils.isNotEmpty((String)pKey2)) {
            int matchEntryIndex;
            String pKey = this.getCurrentRowSPKey("entryentity", "pkey");
            if (!pKey2.equals(pKey) && (matchEntryIndex = this.getMatchPKeyEntryRowIndex(this.getModel(), pKey2)) >= 0) {
                this.selectEntryRow("entryentity", matchEntryIndex, true);
            }
            this.autoSelectRow("sentryentity");
            this.autoSelectRow("pentryentity");
            this.autoSelectRow("entryentity");
        }
    }

    private List<QFilter> buildItemFilter(long materialId) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(F7Utils.getEnableFilter());
        qFilters.add(new QFilter("material", "=", (Object)materialId));
        return qFilters;
    }

    private Set<Long> queryItemIdSet(long materialId) {
        List<QFilter> qFilterList = this.buildItemFilter(materialId);
        DynamicObjectCollection itemCol = QueryServiceHelper.query((String)"ocdbd_iteminfo", (String)"id", (QFilter[])((QFilter[])qFilterList.stream().toArray(QFilter[]::new)));
        return itemCol.stream().map(r -> r.getLong("id")).collect(Collectors.toSet());
    }

    static {
        S2E_MAP.put("material1", "material");
        S2E_MAP.put("auxpty1", "auxpty");
        S2E_MAP.put("stockorg1", "stockorg");
        S2E_MAP.put("warehouse1", "warehouse");
        S2E_MAP.put("baseunit1", "baseunit");
        S2E_MAP.put("invbaseqty1", "invbaseqty");
        S2E_MAP.put("allotbaseqty1", "allotbaseqty");
        S2E_MAP.put("sumbaseqty1", "sumbaseqty");
        S2E_MAP.put("skey1", "skey");
        P2E_MAP.put("calculatetype2", "calculatetype");
        P2E_MAP.put("percent2", "percent");
        P2E_MAP.put("baseqty2", "baseqty");
        P2E_MAP.put("allottype2", "allottype");
        P2E_MAP.put("item2", "item");
        P2E_MAP.put("pkey2", "pkey");
        P2E_MAP.put("ckey2", "ckey");
    }
}

