/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ococic.formplugin.botp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.StringUtils;

public class ChannelInListPushChannelInPlugin
extends AbstractConvertPlugIn {
    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        String tgtMainType = this.getTgtMainType().toString();
        if (entitySet == null) {
            return;
        }
        ExtendedDataEntity[] extendedDataEntityArray = entitySet.FindByEntityKey(tgtMainType);
        Map<Long, Long> defaultWarehouseMap = this.getDefaultWarehouseMap(extendedDataEntityArray);
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntityArray) {
            DynamicObject channelInBill = extendedDataEntity.getDataEntity();
            long channelId = DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)channelInBill, (String)"inchannelid");
            Long defaultWarehouseId = defaultWarehouseMap.get(channelId);
            if (defaultWarehouseId == null) continue;
            for (DynamicObject entry : channelInBill.getDynamicObjectCollection("billentry")) {
                DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)entry, (String)"warehouse", (long)defaultWarehouseId);
            }
        }
        BusinessDataServiceHelper.loadRefence((Object[])Arrays.stream(extendedDataEntityArray).map(r -> r.getDataEntity()).toArray(DynamicObject[]::new), (IDataEntityType)extendedDataEntityArray[0].getDataEntity().getDataEntityType());
        this.removeEmptySubEntry(extendedDataEntityArray);
    }

    private void removeEmptySubEntry(ExtendedDataEntity[] extendedDataEntityArray) {
        if (extendedDataEntityArray != null && extendedDataEntityArray.length > 0) {
            for (ExtendedDataEntity extendedDataEntity : extendedDataEntityArray) {
                DynamicObject bill = extendedDataEntity.getDataEntity();
                for (DynamicObject entry : bill.getDynamicObjectCollection("billentry")) {
                    DynamicObjectCollection subEntryEntityCol = entry.getDynamicObjectCollection("subentryentity");
                    ArrayList<DynamicObject> emptySubEntryEntityList = new ArrayList<DynamicObject>(subEntryEntityCol.size());
                    for (DynamicObject subEntry : subEntryEntityCol) {
                        if (!StringUtils.isEmpty((String)subEntry.getString("serialnumber"))) continue;
                        emptySubEntryEntityList.add(subEntry);
                    }
                    if (CollectionUtils.isEmpty(emptySubEntryEntityList)) continue;
                    subEntryEntityCol.removeAll(emptySubEntryEntityList);
                }
            }
        }
    }

    private Map<Long, Long> getDefaultWarehouseMap(ExtendedDataEntity[] extendedDataEntities) {
        HashMap<Long, Long> result = new HashMap<Long, Long>(0);
        if (extendedDataEntities != null && extendedDataEntities.length > 0) {
            Set channelIdSet = Arrays.stream(extendedDataEntities).map(r -> DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)r.getDataEntity(), (String)"inchannelid")).filter(r -> r > 0L).collect(Collectors.toSet());
            QFilter qFilter = F7Utils.getCommonStatusFilter();
            qFilter.and("ownerchannelid", "in", channelIdSet);
            DynamicObjectCollection warehouseCol = QueryServiceHelper.query((String)"ococic_warehouse", (String)F7Utils.getSelectCols((String[])new String[]{"id", "isdefault", "ownerchannelid"}), (QFilter[])qFilter.toArray());
            result = new HashMap(warehouseCol.size());
            for (DynamicObject warehouse : warehouseCol) {
                long warehouseId = warehouse.getLong("id");
                long channelId = warehouse.getLong("ownerchannelid");
                boolean isDefault = warehouse.getBoolean("isdefault");
                if (result.containsKey(channelId)) {
                    if (!isDefault) continue;
                    result.put(channelId, warehouseId);
                    continue;
                }
                result.put(channelId, warehouseId);
            }
        }
        return result;
    }
}

