/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ococic.formplugin.botp;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.occ.ocbase.business.b2b.ChannelHelper;
import kd.occ.ocbase.business.helper.changemodel.AmountHelper;
import kd.occ.ocbase.business.helper.changemodel.CurrencyHelper;

public class StockOutPushDeliveryRecorderPlugin
extends AbstractConvertPlugIn {
    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntity[] extendedDataEntities;
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        String tgtMainType = this.getTgtMainType().toString();
        if (entitySet == null) {
            return;
        }
        HashMap<Long, Long> channelStockMap = new HashMap<Long, Long>();
        HashMap<Long, Long> stockLocationMap = new HashMap<Long, Long>();
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities = entitySet.FindByEntityKey(tgtMainType)) {
            DynamicObject deliveryrecord = extendedDataEntity.getDataEntity();
            DynamicObjectCollection deliverydetails = deliveryrecord.getDynamicObjectCollection("deliverydetail");
            List saleOrderIdset = deliverydetails.stream().filter(r -> r.getLong("mainbillid") != 0L).map(t -> t.getLong("mainbillid")).distinct().collect(Collectors.toList());
            if (saleOrderIdset != null && !saleOrderIdset.isEmpty()) {
                MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"ocbsoc_saleorder");
                DynamicObject[] saleOrderArray = BusinessDataServiceHelper.load((Object[])saleOrderIdset.toArray(), (DynamicObjectType)entityType);
                this.initDeliveryRecordInfoBySaleOrder(saleOrderArray, deliveryrecord);
            }
            for (DynamicObject entry : deliverydetails) {
                long receiveChannelId = entry.getLong("orderchannelid_id");
                long stockId = 0L;
                if (channelStockMap.containsKey(receiveChannelId)) {
                    stockId = (Long)channelStockMap.get(receiveChannelId);
                    entry.set("stockid_id", (Object)stockId);
                } else {
                    stockId = ChannelHelper.getChannelDefaultStockId((long)receiveChannelId);
                    if (stockId != 0L) {
                        channelStockMap.put(receiveChannelId, stockId);
                        entry.set("stockid_id", (Object)stockId);
                    }
                }
                if (stockId == 0L) continue;
                if (stockLocationMap.containsKey(stockId)) {
                    entry.set("stockaddrid_id", stockLocationMap.get(stockId));
                    continue;
                }
                long locationId = ChannelHelper.getDefaultLocationId((long)stockId);
                if (locationId == 0L) continue;
                stockLocationMap.put(stockId, locationId);
                entry.set("stockaddrid_id", (Object)locationId);
            }
        }
    }

    public void initDeliveryRecordInfoBySaleOrder(DynamicObject[] saleOrderArray, DynamicObject deliveryrecord) {
        if (saleOrderArray == null || saleOrderArray.length == 0) {
            return;
        }
        deliveryrecord.set("saleorgid", saleOrderArray[0].get("saleorgid"));
        deliveryrecord.set("owner", saleOrderArray[0].get("salechannelid"));
        deliveryrecord.set("hastax", saleOrderArray[0].get("istax"));
        deliveryrecord.set("settlecurrency", saleOrderArray[0].get("settlecurrencyid"));
        DynamicObject billTypeParameter = (DynamicObject)SystemParamServiceHelper.getBillTypeParameter((String)"ocbsoc_saleorder", (String)"ocbsoc_saleorder_btparam", (long)saleOrderArray[0].getLong("billtypeid_id"));
        String tradetype = billTypeParameter.getString("tradetype");
        deliveryrecord.set("pursalemodel", (Object)tradetype);
        HashMap<Long, DynamicObject> saleorderEntryMap = new HashMap<Long, DynamicObject>();
        for (DynamicObject saleOrder : saleOrderArray) {
            DynamicObjectCollection saleorderEntryCollection = saleOrder.getDynamicObjectCollection("itementry");
            for (DynamicObject saleOrderEntry : saleorderEntryCollection) {
                List subEntryIds = saleOrderEntry.getDynamicObjectCollection("subentryentity").stream().map(r -> r.getLong("id")).collect(Collectors.toList());
                Iterator iterator = subEntryIds.iterator();
                while (iterator.hasNext()) {
                    long subEntryId = (Long)iterator.next();
                    saleorderEntryMap.put(subEntryId, saleOrderEntry);
                }
            }
            saleorderEntryMap.putAll(saleorderEntryCollection.stream().collect(Collectors.toMap(r -> r.getLong("id"), k -> k, (key1, key2) -> key2)));
        }
        DynamicObjectCollection deliveryrecordEntryCollection = deliveryrecord.getDynamicObjectCollection("deliverydetail");
        for (DynamicObject deliveryrecordEntry : deliveryrecordEntryCollection) {
            long mainBillEntryId = deliveryrecordEntry.getLong("mainbillentryid");
            if (!saleorderEntryMap.containsKey(mainBillEntryId)) continue;
            DynamicObject saleorderEntry = (DynamicObject)saleorderEntryMap.get(mainBillEntryId);
            deliveryrecordEntry.set("taxprice", saleorderEntry.get("taxprice"));
            deliveryrecordEntry.set("price", saleorderEntry.get("price"));
            deliveryrecordEntry.set("discountamount", saleorderEntry.get("discountamount"));
            deliveryrecordEntry.set("taxamount", saleorderEntry.get("tax"));
            deliveryrecordEntry.set("taxrate", saleorderEntry.get("taxrate"));
        }
        this.processAmount(saleOrderArray[0], deliveryrecord);
    }

    private void processAmount(DynamicObject bill, DynamicObject deliveryorder) {
        boolean isTax = bill.getBoolean("istax");
        BigDecimal exChangeRate = null;
        int settlePrecision = 10;
        int currencyPrecision = 10;
        exChangeRate = bill.getBigDecimal("exchangerate");
        DynamicObject settleCurrency = bill.getDynamicObject("settlecurrencyid");
        DynamicObject currency = bill.getDynamicObject("basecurrencyid");
        DynamicObject exRateTable = bill.getDynamicObject("exchangeratetable");
        DynamicObject org = bill.getDynamicObject("settleorgid");
        if (org != null) {
            Long orgId = (Long)org.getPkValue();
            if (currency == null) {
                currency = CurrencyHelper.getCurrency((Long)orgId);
            }
            if (currency != null) {
                currencyPrecision = currency.getInt("amtprecision");
            }
            if (settleCurrency != null) {
                settlePrecision = settleCurrency.getInt("amtprecision");
            }
            if (exRateTable == null) {
                exRateTable = CurrencyHelper.getExRateTable((Long)orgId);
            }
        }
        if (exChangeRate == null || exChangeRate.compareTo(BigDecimal.ZERO) == 0) {
            Date bizTime = bill.getDate("exratedate");
            if (currency != null && settleCurrency != null && exRateTable != null && bizTime != null) {
                Long curId = (Long)currency.getPkValue();
                Long settleCurId = (Long)settleCurrency.getPkValue();
                Long exRateTableId = (Long)exRateTable.getPkValue();
                exChangeRate = CurrencyHelper.getExChangeRate((Long)settleCurId, (Long)curId, (Long)exRateTableId, (Date)bizTime);
            }
        }
        DynamicObjectCollection entrys = deliveryorder.getDynamicObjectCollection("deliverydetail");
        for (DynamicObject entry : entrys) {
            BigDecimal qty = entry.getBigDecimal("deliverqty");
            BigDecimal price = entry.getBigDecimal("price");
            BigDecimal priceAndTax = entry.getBigDecimal("taxprice");
            BigDecimal taxRate = entry.getBigDecimal("taxrate");
            String discountType = null;
            BigDecimal discountRate = null;
            discountType = null;
            discountRate = entry.getBigDecimal("discount");
            if (qty == null) continue;
            Map amountMap = AmountHelper.getAmount((BigDecimal)qty, (boolean)isTax, (BigDecimal)price, (BigDecimal)priceAndTax, (BigDecimal)taxRate, discountType, (BigDecimal)discountRate, (BigDecimal)exChangeRate, (Integer)settlePrecision, (Integer)currencyPrecision);
            entry.set("amount", amountMap.get("amount"));
            entry.set("amountandtax", amountMap.get("amountandtax"));
        }
    }
}

