/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ococic.formplugin.entityinv;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.BillList;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.enums.ococic.EntityInvQueryGroupByEnum;
import kd.occ.ocbase.common.pojo.ocic.EntityInvQueryBatchParam;
import kd.occ.ocbase.common.pojo.ocic.EntityInvQueryResult;
import kd.occ.ocbase.common.util.CustomParamUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.ItemNSaleControlUtil;
import kd.occ.ocbase.common.util.MultiBaseDataUtil;
import kd.occ.ocbase.common.util.OrgUtil;
import kd.occ.ocbase.common.util.SaleOrderUtil;
import kd.occ.ococic.business.helper.EntityInvQueryHelper;

public class EntityInvQueryPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String ID_REGEX = "#";

    public void initialize() {
        super.initialize();
        this.addExecutionListDataProvider();
    }

    public void afterCreateNewData(EventObject e) {
        this.initMultiBaseDataEditValues("itemscope");
        this.initMultiBaseDataEditValues("stockorgscope");
        this.initMultiBaseDataEditValues("warehousescope");
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        long saleOrgId = CustomParamUtil.getLongCustomParam((IFormView)this.getView(), (String)"saleorgid");
        long saleChannelId = CustomParamUtil.getLongCustomParam((IFormView)this.getView(), (String)"salechannelid");
        long orderChannelId = CustomParamUtil.getLongCustomParam((IFormView)this.getView(), (String)"orderchannelid");
        switch (fieldKey) {
            case "itemscope": {
                if (saleOrgId == 0L && saleChannelId == 0L && orderChannelId == 0L) {
                    F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)F7Utils.getEnableFilter());
                    break;
                }
                ArrayList<QFilter> allQFilters = ItemNSaleControlUtil.getItemFilterBySaleChannel((long)saleOrgId, (long)saleChannelId, (long)orderChannelId);
                if (allQFilters == null) {
                    allQFilters = new ArrayList<QFilter>(1);
                    allQFilters.add(new QFilter("id", "=", (Object)0));
                }
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (List)allQFilters);
                break;
            }
            case "stockorgscope": {
                if (saleOrgId == 0L && saleChannelId == 0L && orderChannelId == 0L) {
                    F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)F7Utils.getEnableFilter());
                    break;
                }
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)new QFilter("id", "in", (Object)OrgUtil.getInventoryOrgFromSaleOrg((long)saleOrgId)));
                break;
            }
            case "warehousescope": {
                Set stockOrgIdSet = MultiBaseDataUtil.getMultiF7PKValueSet((IDataModel)this.getModel(), (String)"stockorgscope");
                if (CollectionUtils.isEmpty((Collection)stockOrgIdSet)) {
                    e.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"EntityInvQueryPlugin_0", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
                }
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)new QFilter("id", "in", (Object)SaleOrderUtil.getWarehouseIdByStockOrgId((Set)stockOrgIdSet)));
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        super.propertyChanged(e);
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        Object oldValue = valueSet[0].getOldValue();
        if (null != newValue && newValue.equals(oldValue)) {
            return;
        }
        switch (propName = e.getProperty().getName()) {
            case "stockorgscope": {
                this.getModel().setValue("warehousescope", null);
                break;
            }
        }
        if (!CollectionUtils.isEmpty((Collection)MultiBaseDataUtil.getMultiF7PKValueSet((IDataModel)this.getModel(), (String)"itemscope")) && !CollectionUtils.isEmpty((Collection)MultiBaseDataUtil.getMultiF7PKValueSet((IDataModel)this.getModel(), (String)"stockorgscope"))) {
            BillList list = (BillList)this.getView().getControl("billlistap");
            list.refresh();
        }
    }

    private void initMultiBaseDataEditValues(String key) {
        Set idSet = CustomParamUtil.getLongSetCustomParam((IFormView)this.getView(), (String)key);
        long saleOrgId = CustomParamUtil.getLongCustomParam((IFormView)this.getView(), (String)"saleorgid");
        if (!CollectionUtils.isEmpty((Collection)idSet)) {
            this.getModel().setValue(key, (Object)idSet.toArray());
        } else if ("stockorgscope".equals(key) && saleOrgId > 0L && this.isInventoryOrg(saleOrgId)) {
            this.getModel().setValue(key, (Object)new Long[]{saleOrgId});
        }
    }

    private boolean isInventoryOrg(long orgId) {
        boolean isInventoryOrg = false;
        DynamicObject org = BusinessDataServiceHelper.loadSingle((Object)orgId, (String)"bos_org", (String)"fisinventory");
        if (org != null) {
            isInventoryOrg = org.getBoolean("fisinventory");
        }
        return isInventoryOrg;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btnquery"});
        this.addF7Listener(this, "itemscope", "stockorgscope", "warehousescope");
    }

    public void click(EventObject e) {
        Control c = (Control)e.getSource();
        String key = c.getKey();
        if ("btnok".equalsIgnoreCase(key)) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (selectedRows != null && selectedRows.size() > 0) {
                List returnData = selectedRows.stream().map(r -> {
                    String id = r.getPrimaryKeyValue().toString();
                    String[] ids = id.split(ID_REGEX);
                    EntityInvQueryResult result = new EntityInvQueryResult();
                    result.setItemId(Long.parseLong(ids[0]));
                    result.setMaterialId(Long.parseLong(ids[1]));
                    result.setAuxptyId(Long.parseLong(ids[2]));
                    result.setStockOrgId(Long.parseLong(ids[3]));
                    result.setWarehouseId(Long.parseLong(ids[4]));
                    result.setInvTypeId(Long.parseLong(ids[5]));
                    result.setUnitId(Long.parseLong(ids[6]));
                    result.setQty(new BigDecimal(ids[7]));
                    result.setReserveQty(new BigDecimal(ids[8]));
                    result.setAvbbQty(new BigDecimal(ids[9]));
                    result.setBaseUnitId(Long.parseLong(ids[10]));
                    result.setBaseQty(new BigDecimal(ids[11]));
                    result.setReserveBaseQty(new BigDecimal(ids[12]));
                    result.setAvbbBaseQty(new BigDecimal(ids[13]));
                    return result;
                }).collect(Collectors.toList());
                this.getView().returnDataToParent(returnData);
                this.getView().close();
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u4e2d\u4e00\u6761\u6570\u636e\u540e\uff0c\u518d\u8fd4\u56de\u6570\u636e.", (String)"EntityInvQueryPlugin_1", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        BasedataEdit f7 = null;
        int len = f7Name.length;
        for (int i = 0; i < len; ++i) {
            f7 = (BasedataEdit)this.getControl(f7Name[i]);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener(form);
        }
    }

    private void addExecutionListDataProvider() {
        BillList list = (BillList)this.getView().getControl("billlistap");
        if (list == null) {
            return;
        }
        list.addCreateListDataProviderListener(new CreateListDataProviderListener(){

            public void createListDataProvider(BeforeCreateListDataProviderArgs e) {
                e.setListDataProvider((IListDataProvider)new ListDataProvider(){

                    public DynamicObjectCollection getData(int start, int limit) {
                        DynamicObjectCollection rows = super.getData(1, 1);
                        rows.clear();
                        DynamicObjectType rowType = rows.getDynamicObjectType();
                        EntityInvQueryBatchParam param = new EntityInvQueryBatchParam(MultiBaseDataUtil.getMultiF7PKValueSet((IDataModel)EntityInvQueryPlugin.this.getModel(), (String)"itemscope"), MultiBaseDataUtil.getMultiF7PKValueSet((IDataModel)EntityInvQueryPlugin.this.getModel(), (String)"stockorgscope"), MultiBaseDataUtil.getMultiF7PKValueSet((IDataModel)EntityInvQueryPlugin.this.getModel(), (String)"warehousescope"));
                        List results = EntityInvQueryHelper.queryEntityInventory((EntityInvQueryBatchParam)param, (EntityInvQueryGroupByEnum)EntityInvQueryGroupByEnum.ISWAIUB);
                        int index = 0;
                        for (EntityInvQueryResult result : results) {
                            DynamicObject row = new DynamicObject(rowType);
                            DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)row, (String)"item", (long)result.getItemId());
                            DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)row, (String)"auxpty", (long)result.getAuxptyId());
                            DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)row, (String)"stockorg", (long)result.getStockOrgId());
                            DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)row, (String)"warehouse", (long)result.getWarehouseId());
                            DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)row, (String)"invtype", (long)result.getInvTypeId());
                            DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)row, (String)"unit", (long)result.getUnitId());
                            DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)row, (String)"baseunit", (long)result.getBaseUnitId());
                            row.set("qty", (Object)result.getQty());
                            row.set("reserveqty", (Object)result.getReserveQty());
                            row.set("avbbqty", (Object)result.getAvbbQty());
                            row.set("baseqty", (Object)result.getBaseQty());
                            row.set("reservebaseqty", (Object)result.getReserveBaseQty());
                            row.set("avbbbaseqty", (Object)result.getAvbbBaseQty());
                            row.set("id", (Object)String.join((CharSequence)EntityInvQueryPlugin.ID_REGEX, String.valueOf(result.getItemId()), String.valueOf(result.getMaterialId()), String.valueOf(result.getAuxptyId()), String.valueOf(result.getStockOrgId()), String.valueOf(result.getWarehouseId()), String.valueOf(result.getInvTypeId()), String.valueOf(result.getUnitId()), result.getQty().toPlainString(), result.getReserveQty().toPlainString(), result.getAvbbQty().toPlainString(), String.valueOf(result.getBaseUnitId()), result.getBaseQty().toPlainString(), result.getReserveBaseQty().toPlainString(), result.getAvbbBaseQty().toPlainString(), String.valueOf(index++)));
                            rows.add((Object)row);
                        }
                        BusinessDataServiceHelper.loadRefence((Object[])rows.stream().collect(Collectors.toList()).toArray(), (IDataEntityType)rowType);
                        return rows;
                    }
                });
            }
        });
    }
}

