/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ococic.formplugin.invacc;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.business.helper.UnitConvertHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ococic.formplugin.invacc.ChannelInvAccListDataProvider;

public class ChannelInvAccList
extends AbstractListPlugin {
    private static final String KEY_SERIALQTY = "serialqty";
    private static final String KEY_EXCEPTIONHANDLING = "exceptionhandling";
    private static final String CHANNEL_IN_VACC_COLS = String.join((CharSequence)",", "channelid", "itemid", "auxptyid", "saleorgid", "channelstocktypeid", "materialid", "channelstockstatusid", "channelstockid", "channellocationid", "ownerid", "ownertype", "keeperid", "keepertype", "lotnum", "stockqty", "stockunitid", "baseqty", "baseunitid", "assistqty", "assistunitid", "productdate", "effectivedate", "projectid", "lotid");
    private static final String SNMAIN_FILE_COLS = String.join((CharSequence)",", "channelid", "itemid", "auxptyid", "saleorgid", "channelstocktypeid", "channelstockstatusid", "channelstockid", "channellocationid", "ownerid", "ownertype", "keeperid", "keepertype", "lotnum", "effectivedate", "productdate");

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.setOrderBy("modifytime desc,createtime desc");
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ChannelInvAccListDataProvider());
    }

    public void billListHyperLinkClick(HyperLinkClickArgs evt) {
        evt.setCancel(true);
        String fileName = evt.getFieldName();
        QFilter pkFilter = new QFilter("id", "=", this.getFocusRowPkId());
        DynamicObject channelInvAcc = BusinessDataServiceHelper.loadSingle((String)"ococic_channelinvacc", (String)CHANNEL_IN_VACC_COLS, (QFilter[])pkFilter.toArray());
        if (KEY_SERIALQTY.equalsIgnoreCase(fileName)) {
            this.showSnmainFileListView(channelInvAcc);
        } else if (KEY_EXCEPTIONHANDLING.equalsIgnoreCase(fileName)) {
            BigDecimal serialQty = this.calculateSerialQty(channelInvAcc);
            BigDecimal stockQty = channelInvAcc.getBigDecimal("stockqty");
            BigDecimal changeQty = stockQty.subtract(serialQty).abs();
            if (stockQty.compareTo(serialQty) > 0) {
                this.showChannelOutbBillForm(channelInvAcc, changeQty);
            } else if (stockQty.compareTo(serialQty) < 0) {
                this.showChannelInbBillForm(channelInvAcc, changeQty);
            }
        }
    }

    private void showChannelInbBillForm(DynamicObject channelInvAcc, BigDecimal changeQty) {
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setFormId("ococic_channelinbill");
        billShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        billShowParameter.setBillStatus(BillOperationStatus.ADDNEW);
        billShowParameter.setStatus(OperationStatus.ADDNEW);
        Map<String, Object> paramMap = this.buildChannelInBillParam(channelInvAcc, changeQty);
        billShowParameter.setCustomParams(paramMap);
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    private void showChannelOutbBillForm(DynamicObject channelInvAcc, BigDecimal changeQty) {
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setFormId("ococic_channeloutbill");
        billShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        billShowParameter.setBillStatus(BillOperationStatus.ADDNEW);
        billShowParameter.setStatus(OperationStatus.ADDNEW);
        Map<String, Object> paramMap = this.buildChannelOutBillParam(channelInvAcc, changeQty);
        billShowParameter.setCustomParams(paramMap);
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    private Map<String, Object> buildChannelInBillParam(DynamicObject channelInvAcc, BigDecimal changeQty) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(26);
        paramMap.put("isfromchannelinvacc", true);
        paramMap.put("inchannelid", DynamicObjectUtils.getPkValue((DynamicObject)channelInvAcc, (String)"channelid"));
        paramMap.put("billtypeid", 1640633200499768320L);
        paramMap.put("saleorg", DynamicObjectUtils.getPkValue((DynamicObject)channelInvAcc, (String)"saleorgid"));
        paramMap.put("org", DynamicObjectUtils.getPkValue((DynamicObject)channelInvAcc, (String)"saleorgid"));
        DynamicObject channel = channelInvAcc.getDynamicObject("channelid");
        paramMap.put("settlecurrencyid", DynamicObjectUtils.getPkValue((DynamicObject)channel, (String)"currency"));
        paramMap.put("sumqty", changeQty);
        paramMap.put("itemid", DynamicObjectUtils.getPkValue((DynamicObject)channelInvAcc, (String)"itemid"));
        long materialId = DynamicObjectUtils.getPkValue((DynamicObject)channelInvAcc, (String)"materialid");
        paramMap.put("materialid", materialId);
        paramMap.put("auxptyid", DynamicObjectUtils.getPkValue((DynamicObject)channelInvAcc, (String)"auxptyid"));
        paramMap.put("lotnumber", DynamicObjectUtils.getString((DynamicObject)channelInvAcc, (String)"lotnum"));
        paramMap.put("lotnumberid", DynamicObjectUtils.getPkValue((DynamicObject)channelInvAcc, (String)"lotid"));
        paramMap.put("projectid", DynamicObjectUtils.getPkValue((DynamicObject)channelInvAcc, (String)"projectid"));
        paramMap.put("producedate", DynamicObjectUtils.getDate((DynamicObject)channelInvAcc, (String)"productdate"));
        paramMap.put("expirydate", DynamicObjectUtils.getDate((DynamicObject)channelInvAcc, (String)"effectivedate"));
        long unitId = DynamicObjectUtils.getPkValue((DynamicObject)channelInvAcc, (String)"stockunitid");
        paramMap.put("unitid", unitId);
        paramMap.put("qty", changeQty);
        long baseUnitId = DynamicObjectUtils.getPkValue((DynamicObject)channelInvAcc, (String)"baseunitid");
        paramMap.put("baseunitid", baseUnitId);
        BigDecimal baseQty = UnitConvertHelper.calculateDestQty((BigDecimal)changeQty, (Long)materialId, (Long)unitId, (Long)baseUnitId);
        paramMap.put("baseqty", baseQty);
        long assUnitId = DynamicObjectUtils.getPkValue((DynamicObject)channelInvAcc, (String)"assistunitid");
        paramMap.put("assistunitid", assUnitId);
        BigDecimal assQty = UnitConvertHelper.calculateDestQty((BigDecimal)changeQty, (Long)materialId, (Long)unitId, (Long)assUnitId);
        paramMap.put("assistqty", assQty);
        paramMap.put("warehouse", DynamicObjectUtils.getPkValue((DynamicObject)channelInvAcc, (String)"channelstockid"));
        paramMap.put("locationid", DynamicObjectUtils.getPkValue((DynamicObject)channelInvAcc, (String)"channellocationid"));
        paramMap.put("stockstatus", DynamicObjectUtils.getPkValue((DynamicObject)channelInvAcc, (String)"channelstockstatusid"));
        paramMap.put("stocktype", DynamicObjectUtils.getPkValue((DynamicObject)channelInvAcc, (String)"channelstocktypeid"));
        paramMap.put("ownertype", DynamicObjectUtils.getString((DynamicObject)channelInvAcc, (String)"ownertype"));
        paramMap.put("ownerid", DynamicObjectUtils.getPkValue((DynamicObject)channelInvAcc, (String)"ownerid"));
        paramMap.put("keepertype", DynamicObjectUtils.getString((DynamicObject)channelInvAcc, (String)"keepertype"));
        paramMap.put("keeperid", DynamicObjectUtils.getPkValue((DynamicObject)channelInvAcc, (String)"keeperid"));
        paramMap.put("serialunit", DynamicObjectUtils.getPkValue((DynamicObject)channelInvAcc, (String)"stockunitid"));
        paramMap.put(KEY_SERIALQTY, DynamicObjectUtils.getBigDecimal((DynamicObject)channelInvAcc, (String)"stockqty"));
        return paramMap;
    }

    private Map<String, Object> buildChannelOutBillParam(DynamicObject channelInvAcc, BigDecimal changeQty) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(26);
        paramMap.put("isfromchannelinvacc", true);
        paramMap.put("outchannelid", DynamicObjectUtils.getPkValue((DynamicObject)channelInvAcc, (String)"channelid"));
        paramMap.put("billtypeid", 1640631427215145984L);
        paramMap.put("org", DynamicObjectUtils.getPkValue((DynamicObject)channelInvAcc, (String)"saleorgid"));
        paramMap.put("sumqty", changeQty);
        DynamicObject channel = channelInvAcc.getDynamicObject("channelid");
        paramMap.put("currencyid", DynamicObjectUtils.getPkValue((DynamicObject)channel, (String)"currency"));
        paramMap.put("itemid", DynamicObjectUtils.getPkValue((DynamicObject)channelInvAcc, (String)"itemid"));
        long materialId = DynamicObjectUtils.getPkValue((DynamicObject)channelInvAcc, (String)"materialid");
        paramMap.put("materielid", materialId);
        paramMap.put("auxptyid", DynamicObjectUtils.getPkValue((DynamicObject)channelInvAcc, (String)"auxptyid"));
        paramMap.put("lotnumber", DynamicObjectUtils.getString((DynamicObject)channelInvAcc, (String)"lotnum"));
        paramMap.put("lotid", DynamicObjectUtils.getPkValue((DynamicObject)channelInvAcc, (String)"lotid"));
        paramMap.put("projectid", DynamicObjectUtils.getPkValue((DynamicObject)channelInvAcc, (String)"projectid"));
        paramMap.put("productdate", DynamicObjectUtils.getDate((DynamicObject)channelInvAcc, (String)"productdate"));
        paramMap.put("expiredate", DynamicObjectUtils.getDate((DynamicObject)channelInvAcc, (String)"effectivedate"));
        long unitId = DynamicObjectUtils.getPkValue((DynamicObject)channelInvAcc, (String)"stockunitid");
        paramMap.put("unitid", unitId);
        paramMap.put("quantity", changeQty);
        long baseUnitId = DynamicObjectUtils.getPkValue((DynamicObject)channelInvAcc, (String)"baseunitid");
        paramMap.put("baseunitid", baseUnitId);
        BigDecimal baseQty = UnitConvertHelper.calculateDestQty((BigDecimal)changeQty, (Long)materialId, (Long)unitId, (Long)baseUnitId);
        paramMap.put("basequantity", baseQty);
        paramMap.put("auxptyunitid", DynamicObjectUtils.getPkValue((DynamicObject)channelInvAcc, (String)"assistunitid"));
        paramMap.put("auxquantity", DynamicObjectUtils.getBigDecimal((DynamicObject)channelInvAcc, (String)"assistqty"));
        paramMap.put("stockid", DynamicObjectUtils.getPkValue((DynamicObject)channelInvAcc, (String)"channelstockid"));
        paramMap.put("stockaddrid", DynamicObjectUtils.getPkValue((DynamicObject)channelInvAcc, (String)"channellocationid"));
        paramMap.put("stockstatusid", DynamicObjectUtils.getPkValue((DynamicObject)channelInvAcc, (String)"channelstockstatusid"));
        paramMap.put("stocktypeid", DynamicObjectUtils.getPkValue((DynamicObject)channelInvAcc, (String)"channelstocktypeid"));
        paramMap.put("ownertype", DynamicObjectUtils.getString((DynamicObject)channelInvAcc, (String)"ownertype"));
        paramMap.put("ownerid", DynamicObjectUtils.getPkValue((DynamicObject)channelInvAcc, (String)"ownerid"));
        paramMap.put("keepertype", DynamicObjectUtils.getString((DynamicObject)channelInvAcc, (String)"keepertype"));
        paramMap.put("keeperid", DynamicObjectUtils.getPkValue((DynamicObject)channelInvAcc, (String)"keeperid"));
        paramMap.put("snunit", DynamicObjectUtils.getPkValue((DynamicObject)channelInvAcc, (String)"stockunitid"));
        paramMap.put("snquantity", DynamicObjectUtils.getBigDecimal((DynamicObject)channelInvAcc, (String)"stockqty"));
        return paramMap;
    }

    private BigDecimal calculateSerialQty(DynamicObject channelInvAcc) {
        QFilter filter = new QFilter("channelid", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)channelInvAcc, (String)"channelid"));
        filter.and("itemid", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)channelInvAcc, (String)"itemid"));
        filter.and("auxptyid", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)channelInvAcc, (String)"auxptyid"));
        filter.and("saleorgid", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)channelInvAcc, (String)"saleorgid"));
        filter.and("channelstocktypeid", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)channelInvAcc, (String)"channelstocktypeid"));
        filter.and("channelstockstatusid", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)channelInvAcc, (String)"channelstockstatusid"));
        filter.and("channelstockid", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)channelInvAcc, (String)"channelstockid"));
        filter.and("channellocationid", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)channelInvAcc, (String)"channellocationid"));
        filter.and("ownerid", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)channelInvAcc, (String)"ownerid"));
        filter.and("ownertype", "=", (Object)channelInvAcc.getString("ownertype"));
        filter.and("keeperid", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)channelInvAcc, (String)"keeperid"));
        filter.and("keepertype", "=", (Object)channelInvAcc.getString("keepertype"));
        filter.and("lotnum", "=", (Object)channelInvAcc.getString("lotnum"));
        filter.and("snstatus", "=", (Object)"2");
        filter.and("effectivedate", "=", (Object)channelInvAcc.getDate("effectivedate"));
        filter.and("productdate", "=", (Object)channelInvAcc.getDate("productdate"));
        DataSet itemSerialQtyDataSet = QueryServiceHelper.queryDataSet((String)ChannelInvAccList.class.getName(), (String)"ococic_snmainfile", (String)SNMAIN_FILE_COLS, (QFilter[])filter.toArray(), null);
        DataSet qtyDataSet = itemSerialQtyDataSet.executeSql("select count(*) itemqty, " + SNMAIN_FILE_COLS + " group by " + SNMAIN_FILE_COLS);
        if (qtyDataSet.hasNext()) {
            return qtyDataSet.next().getBigDecimal("itemqty");
        }
        return BigDecimal.ZERO;
    }

    private void showSnmainFileListView(DynamicObject channelInvAcc) {
        ListShowParameter parameter = new ListShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setFormId("bos_list");
        parameter.setBillFormId("ococic_snmainfile");
        QFilter filter = new QFilter("channelid", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)channelInvAcc, (String)"channelid"));
        filter.and("itemid", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)channelInvAcc, (String)"itemid"));
        filter.and("auxptyid", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)channelInvAcc, (String)"auxptyid"));
        filter.and("saleorgid", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)channelInvAcc, (String)"saleorgid"));
        filter.and("channelstocktypeid", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)channelInvAcc, (String)"channelstocktypeid"));
        filter.and("channelstockstatusid", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)channelInvAcc, (String)"channelstockstatusid"));
        filter.and("channelstockid", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)channelInvAcc, (String)"channelstockid"));
        filter.and("channellocationid", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)channelInvAcc, (String)"channellocationid"));
        filter.and("ownerid", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)channelInvAcc, (String)"ownerid"));
        filter.and("ownertype", "=", (Object)channelInvAcc.getString("ownertype"));
        filter.and("keeperid", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)channelInvAcc, (String)"keeperid"));
        filter.and("keepertype", "=", (Object)channelInvAcc.getString("keepertype"));
        filter.and("lotnum", "=", (Object)channelInvAcc.getString("lotnum"));
        filter.and("snstatus", "=", (Object)"2");
        filter.and("productdate", "=", (Object)channelInvAcc.getDate("productdate"));
        filter.and("effectivedate", "=", (Object)channelInvAcc.getDate("effectivedate"));
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        listFilterParameter.setFilter(filter);
        parameter.setListFilterParameter(listFilterParameter);
        this.getView().showForm((FormShowParameter)parameter);
    }
}

