/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ococic.formplugin.invacc;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ococic.formplugin.invacc.ChannelInvAccList;

public class ChannelInvAccListDataProvider
extends ListDataProvider {
    private static final String KEY_SERIALQTY = "serialqty";
    private static final String KEY_ABNORMALSTATUS = "abnormalstatus";
    private static final String KEY_EXCEPTIONHANDLING = "exceptionhandling";

    public DynamicObjectCollection getData(int arg0, int arg1) {
        DynamicObjectCollection rows = super.getData(arg0, arg1);
        if (rows.isEmpty()) {
            return rows;
        }
        DataEntityPropertyCollection properties = ((DynamicObject)rows.get(0)).getDataEntityType().getProperties();
        if (!(properties.containsKey((Object)KEY_SERIALQTY) && properties.containsKey((Object)KEY_ABNORMALSTATUS) && properties.containsKey((Object)KEY_EXCEPTIONHANDLING))) {
            return rows;
        }
        this.updateSerialQtyValues(rows);
        return rows;
    }

    private void updateSerialQtyValues(DynamicObjectCollection rows) {
        List itemIdList = rows.stream().map(v -> DynamicObjectUtils.getPkValue((DynamicObject)v, (String)"itemid")).collect(Collectors.toList());
        QFilter filter = new QFilter("itemid", "in", itemIdList);
        filter.and("snstatus", "=", (Object)"2");
        String snmainFileColNames = String.join((CharSequence)",", "channelid", "itemid", "auxptyid", "saleorgid", "channelstocktypeid", "channelstockstatusid", "channelstockid", "channellocationid", "ownerid", "ownertype", "keeperid", "keepertype", "lotnum", "productdate", "effectivedate");
        DataSet dateSet1 = QueryServiceHelper.queryDataSet((String)ChannelInvAccList.class.getName(), (String)"ococic_snmainfile", (String)snmainFileColNames, (QFilter[])filter.toArray(), null);
        DataSet dataSet2 = dateSet1.executeSql("select count(*) itemqty, " + snmainFileColNames + " group by " + snmainFileColNames);
        HashMap<String, BigDecimal> itemQtyMap = new HashMap<String, BigDecimal>(100);
        for (Row row : dataSet2) {
            String key = this.getGroupKey(row);
            BigDecimal value = (BigDecimal)itemQtyMap.get(key);
            value = value == null ? row.getBigDecimal("itemqty") : row.getBigDecimal("itemqty").add(value);
            itemQtyMap.put(key, value);
        }
        for (Row row : rows) {
            DynamicObject item = row.getDynamicObject("itemid");
            if (!DynamicObjectUtils.getBoolean((DynamicObject)item, (String)"enableserial")) continue;
            String key = this.getChannelInvAccKey((DynamicObject)row);
            BigDecimal itemQty = (BigDecimal)itemQtyMap.get(key);
            if (itemQty == null) {
                itemQty = BigDecimal.ZERO;
            }
            row.set(KEY_SERIALQTY, (Object)itemQty);
            BigDecimal stockQty = row.getBigDecimal("stockqty");
            if (stockQty.compareTo(itemQty) == 0) {
                row.set(KEY_ABNORMALSTATUS, (Object)"A");
                continue;
            }
            if (stockQty.compareTo(itemQty) > 0) {
                row.set(KEY_ABNORMALSTATUS, (Object)"B");
                row.set(KEY_EXCEPTIONHANDLING, (Object)"A");
                continue;
            }
            if (stockQty.compareTo(itemQty) >= 0) continue;
            row.set(KEY_ABNORMALSTATUS, (Object)"B");
            row.set(KEY_EXCEPTIONHANDLING, (Object)"B");
        }
    }

    private String getChannelInvAccKey(DynamicObject row) {
        return row.getLong("channelid.id") + "_" + row.getLong("itemid.id") + "_" + row.getLong("auxptyid.id") + "_" + row.getLong("saleorgid.id") + "_" + row.getLong("channelstocktypeid.id") + "_" + row.getLong("channelstockstatusid.id") + "_" + row.getLong("ownerid.id") + "_" + row.getString("ownertype") + "_" + row.getLong("keeperid.id") + "_" + row.getString("keepertype") + "_" + row.getLong("channelstockid.id") + "_" + row.getLong("channellocationid.id") + "_" + row.getString("lotnum") + row.getDate("productdate") + row.getDate("effectivedate");
    }

    private String getGroupKey(Row row) {
        return row.getLong("channelid") + "_" + row.getLong("itemid") + "_" + row.getLong("auxptyid") + "_" + row.getLong("saleorgid") + "_" + row.getLong("channelstocktypeid") + "_" + row.getLong("channelstockstatusid") + "_" + row.getLong("ownerid") + "_" + row.getString("ownertype") + "_" + row.getLong("keeperid") + "_" + row.getString("keepertype") + "_" + row.getLong("channelstockid") + "_" + row.getLong("channellocationid") + "_" + row.getString("lotnum") + row.getDate("productdate") + row.getDate("effectivedate");
    }
}

