/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ococic.formplugin.inventoryreport;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.constants.OcocicLotConst;
import kd.occ.ocbase.common.enums.EnableStatusEnum;
import kd.occ.ocbase.common.enums.StatusEnum;
import kd.occ.ocbase.common.enums.channel.SystemPresetChannelFuction;
import kd.occ.ocbase.common.helper.CUserHelper;
import kd.occ.ocbase.common.helper.LspWapper;
import kd.occ.ocbase.common.util.BigDecimalUtil;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.ItemNSaleControlUtil;
import kd.occ.ocbase.common.util.QueryUtil;
import kd.occ.ocbase.common.util.StringUtils;
import kd.occ.ocbase.formplugin.base.OcbaseBasePlugin;
import kd.occ.ococic.business.helper.InventoryReportHelper;

public class InventoryReportEdit
extends OcbaseBasePlugin
implements BeforeF7SelectListener {
    private static final String REPORTCHANNELCHANGE = "reportchannelchange";

    protected List<Long> getAuthorizedChannelIdList() {
        return CUserHelper.getAuthorizedChannelIdList();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, new String[]{"reportchannelid", "itemid", "unitid", "assistunitid", "warehouseid", "locationid", "lotnumberid"});
        this.addClickListeners(new String[]{"lotnumber"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (!this.triggerChangeEvent) {
            return;
        }
        String propertyKey = e.getProperty().getName();
        int rowIndex = this.getRowIndex(e);
        Object oldValue = e.getChangeSet()[0].getOldValue();
        switch (propertyKey) {
            case "itemid": {
                this.setEntryRowValueByItemChange(rowIndex);
                break;
            }
            case "auxptyid": {
                this.setValue("lotnumber", null, rowIndex);
                this.setValue("lotnumberid", null, rowIndex);
                break;
            }
            case "lotnumber": {
                this.setValue("lotnumberid", null, rowIndex);
                this.setValue("productdate", null, rowIndex);
                this.setValue("expiredate", null, rowIndex);
                String lotNumber = this.getStringValue("lotnumber", rowIndex);
                if (!StringUtils.isNotEmpty((String)lotNumber)) break;
                this.setLotInfoByLot(0L, 0L, lotNumber, rowIndex);
                break;
            }
            case "qty": 
            case "unitid": {
                InventoryReportHelper.calQtysByItemApproveQty((IDataModel)this.getModel(), (int)rowIndex);
                break;
            }
            case "assistqty": {
                InventoryReportHelper.calQtysByItemAssistApproveQty((IDataModel)this.getModel(), (int)rowIndex);
                break;
            }
            case "reportchannelid": {
                if (this.isFromImport()) break;
                DynamicObjectCollection entryColl = this.getModel().getEntryEntity("entryentity");
                if (oldValue == null || CommonUtils.isNull((Object)entryColl)) break;
                String oldChannelId = DynamicObjectUtils.getStrPkValue((DynamicObject)((DynamicObject)oldValue));
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(REPORTCHANNELCHANGE, (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u4e0a\u62a5\u6e20\u9053\u53d1\u751f\u53d8\u66f4\uff0c\u786e\u8ba4\u5220\u9664\u5206\u5f55\u5417\uff1f", (String)"InventoryReportEdit_0", (String)"occ-ococic-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks, null, oldChannelId);
                break;
            }
            case "warehouseid": {
                this.setDefaultLocationId(rowIndex);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        int rowIndex = e.getRow();
        switch (key) {
            case "reportchannelid": {
                this.setReportchannelIdF7Select(e);
                break;
            }
            case "itemid": {
                this.setItemIdEntryF7Select(e);
                break;
            }
            case "unitid": {
                this.setUnitIdEntryF7Select(e, rowIndex);
                break;
            }
            case "assistunitid": {
                this.setAssistUnitIdEntryF7Select(e, rowIndex);
                break;
            }
            case "warehouseid": {
                if (!this.verifyReportChannel()) {
                    e.setCancel(true);
                    return;
                }
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)new QFilter("ownerchannelid", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("reportchannelid"))));
                break;
            }
            case "locationid": {
                if (!this.verifyWarehouse(rowIndex)) {
                    e.setCancel(true);
                    return;
                }
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)new QFilter("warehouseid", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("warehouseid", rowIndex))));
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callKey = e.getCallBackId();
        if (REPORTCHANNELCHANGE.equals(callKey)) {
            if (e.getResult() == MessageBoxResult.Yes) {
                this.getModel().deleteEntryData("entryentity");
                this.getModel().createNewEntryRow("entryentity");
            } else {
                String customVaule = e.getCustomVaule();
                this.setValue("reportchannelid", customVaule, false);
            }
        }
    }

    public void click(EventObject e) {
        super.click(e);
        String controlKey = ((Control)e.getSource()).getKey();
        if ("lotnumber".equals(controlKey)) {
            int rowIndex = this.getCurrentRowIndex("entryentity");
            if (!this.verifyItem(rowIndex)) {
                return;
            }
            this.showLotInfoF7(null, rowIndex);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("lotnumber".equals(actionId)) {
            Object returnData = closedCallBackEvent.getReturnData();
            if (returnData == null) {
                return;
            }
            ListSelectedRowCollection rowInfo = (ListSelectedRowCollection)returnData;
            Object entryPk = rowInfo.getEntryPrimaryKeyValues()[0];
            Object pk = rowInfo.getPrimaryKeyValues()[0];
            int rowIndex = this.getCurrentRowIndex("entryentity");
            this.setLotInfoByLot(Long.parseLong(pk.toString()), Long.parseLong(entryPk.toString()), null, rowIndex);
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        DynamicObjectCollection entryColl = this.getModel().getEntryEntity("entryentity");
        int size = entryColl.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject entryDynObj = (DynamicObject)entryColl.get(i);
            this.setValueByImport("itemid", DynamicObjectUtils.getPkId((DynamicObject)entryDynObj, (String)"itemid"), i);
            this.setValueByImport("qty", DynamicObjectUtils.getPkId((DynamicObject)entryDynObj, (String)"qty"), i);
            this.setValueByImport("lotnumber", DynamicObjectUtils.getPkId((DynamicObject)entryDynObj, (String)"lotnumber"), i);
            this.setValueByImport("warehouseid", DynamicObjectUtils.getPkId((DynamicObject)entryDynObj, (String)"warehouseid"), i);
        }
    }

    private void propertyChangedByData(String propertyKey, int rowIndex, Object oldValue) {
        switch (propertyKey) {
            case "itemid": {
                this.setEntryRowValueByItemChange(rowIndex);
                break;
            }
            case "auxptyid": {
                this.setValue("lotnumber", null, rowIndex);
                this.setValue("lotnumberid", null, rowIndex);
                break;
            }
            case "lotnumber": {
                this.setValueByImport("lotnumberid", null, rowIndex);
                this.setValueByImport("productdate", null, rowIndex);
                this.setValueByImport("expiredate", null, rowIndex);
                String lotNumber = this.getStringValue("lotnumber", rowIndex);
                if (!StringUtils.isNotEmpty((String)lotNumber)) break;
                this.setLotInfoByLot(0L, 0L, lotNumber, rowIndex);
                break;
            }
            case "qty": 
            case "unitid": {
                InventoryReportHelper.calQtysByItemApproveQty((IDataModel)this.getModel(), (int)rowIndex);
                break;
            }
            case "assistqty": {
                InventoryReportHelper.calQtysByItemAssistApproveQty((IDataModel)this.getModel(), (int)rowIndex);
                break;
            }
            case "reportchannelid": {
                if (this.isFromImport()) break;
                DynamicObjectCollection entryColl = this.getModel().getEntryEntity("entryentity");
                if (oldValue == null || CommonUtils.isNull((Object)entryColl)) break;
                String oldChannelId = DynamicObjectUtils.getStrPkValue((DynamicObject)((DynamicObject)oldValue));
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(REPORTCHANNELCHANGE, (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u4e0a\u62a5\u6e20\u9053\u53d1\u751f\u53d8\u66f4\uff0c\u786e\u8ba4\u5220\u9664\u5206\u5f55\u5417\uff1f", (String)"InventoryReportEdit_0", (String)"occ-ococic-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks, null, oldChannelId);
                break;
            }
            case "warehouseid": {
                this.setDefaultLocationId(rowIndex);
                break;
            }
        }
    }

    private void setEntryRowValueByItemChange(int rowIndex) {
        DynamicObject itemDynObj = this.getF7Value("itemid", rowIndex);
        this.setValueByImport("materialid", DynamicObjectUtils.getObjectLong((DynamicObject)itemDynObj, (String)"material"), rowIndex);
        this.setValueByImport("baseunitid", DynamicObjectUtils.getObjectLong((DynamicObject)itemDynObj, (String)"baseunit"), rowIndex);
        this.setValueByImport("assistunitid", DynamicObjectUtils.getObjectLong((DynamicObject)itemDynObj, (String)"assistunit"), rowIndex);
        DynamicObject reportchannel = this.getF7Value("reportchannelid");
        Object reportChannelPk = DynamicObjectUtils.getObjectLong((DynamicObject)reportchannel, (String)"id");
        this.setValueByImport("ownertype", "ocdbd_channel", rowIndex);
        this.setValueByImport("ownerid", reportChannelPk, rowIndex);
        this.setValueByImport("keepertype", "ocdbd_channel", rowIndex);
        this.setValueByImport("keeperid", reportChannelPk, rowIndex);
        if (!this.isFromImport()) {
            this.setValue("unitid", DynamicObjectUtils.getObjectLong((DynamicObject)itemDynObj, (String)"stockunit"), rowIndex);
            this.setValue("stockstatusid", 1042689155454212096L, rowIndex);
            this.setValue("stocktypeid", 1042808009622820864L, rowIndex);
            long warehouseId = InventoryReportHelper.getDefaultWareHouseId((long)DynamicObjectUtils.getPkValue((DynamicObject)reportchannel));
            this.setValue("warehouseid", warehouseId > 0L ? Long.valueOf(warehouseId) : null, rowIndex);
            this.setValue("auxptyid", null, rowIndex);
            this.setValue("lotnumberid", null, rowIndex);
            this.setValue("lotnumber", null, rowIndex);
            this.setValue("productdate", null, rowIndex);
            this.setValue("expiredate", null, rowIndex);
            this.setValue("qty", null, rowIndex);
            this.setValue("locationid", null, rowIndex);
            this.clearAllSubEntryRows(rowIndex);
        }
    }

    private void clearAllSubEntryRows(int rowIndex) {
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", rowIndex);
        DynamicObjectCollection subEntries = entryRowEntity.getDynamicObjectCollection("chnloutbill_sn");
        int rowCount = subEntries.getRowCount();
        ArrayList<Integer> rows = new ArrayList<Integer>(rowCount);
        for (int i = 0; i < rowCount; ++i) {
            rows.add(i);
        }
        int[] deleteIndexs = rows.stream().mapToInt(Integer::valueOf).toArray();
        this.getModel().deleteEntryRows("chnloutbill_sn", deleteIndexs);
    }

    private void setReportchannelIdF7Select(BeforeF7SelectEvent e) {
        if (!this.verifyOrg()) {
            e.setCancel(true);
            return;
        }
        QFilter filter = new QFilter("channelfunctions.fbasedataid.id", "=", (Object)SystemPresetChannelFuction.STORAGE.toLong());
        filter.and(new QFilter("invcontrolmode", "=", (Object)"B"));
        filter.and(new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue()));
        filter.and(new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue()));
        filter.and(new QFilter("id", "in", this.getAuthorizedChannelIdList()));
        F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)filter);
    }

    private void setItemIdEntryF7Select(BeforeF7SelectEvent e) {
        if (!this.verifyReportChannel()) {
            e.setCancel(true);
            return;
        }
        long channelId = DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("reportchannelid"));
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(ItemNSaleControlUtil.getMyItemFilter((long)channelId, (boolean)false));
        filters.add(new QFilter("goodsbelong", "!=", (Object)"1"));
        F7Utils.addF7Filter((BeforeF7SelectEvent)e, filters);
    }

    private void setUnitIdEntryF7Select(BeforeF7SelectEvent e, int rowIndex) {
        if (!this.verifyItem(rowIndex)) {
            e.setCancel(true);
            return;
        }
        Object materialId = this.getEntryF7PKValue("entryentity", "materialid", rowIndex);
        Object baseUnitId = this.getEntryF7PKValue("entryentity", "baseunitid", rowIndex);
        List fixconunitlist = QueryUtil.getAssistMUListResult((Long)(materialId == null ? Long.valueOf(0L) : Long.valueOf(materialId.toString())), (Long)(baseUnitId == null ? Long.valueOf(0L) : Long.valueOf(baseUnitId.toString())), (String)"1");
        QFilter fixconFilter = new QFilter("id", "in", (Object)fixconunitlist);
        F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)fixconFilter);
    }

    private void setAssistUnitIdEntryF7Select(BeforeF7SelectEvent e, int rowIndex) {
        if (!this.verifyItem(rowIndex)) {
            e.setCancel(true);
            return;
        }
        Object materialId = this.getEntryF7PKValue("entryentity", "materialid", rowIndex);
        Object baseUnitId = this.getEntryF7PKValue("entryentity", "baseunitid", rowIndex);
        List floatconunitlist = QueryUtil.getAssistMUListResult((Long)(materialId == null ? Long.valueOf(0L) : Long.valueOf(materialId.toString())), (Long)(baseUnitId == null ? Long.valueOf(0L) : Long.valueOf(baseUnitId.toString())), (String)"2");
        QFilter floatconFilter = new QFilter("id", "in", (Object)floatconunitlist);
        F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)floatconFilter);
    }

    private boolean verifyItem(int rowIndex) {
        Object itemId = this.getEntryF7PKValue("entryentity", "itemid", rowIndex);
        if (itemId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5546\u54c1\u3002", (String)"InventoryReportEdit_1", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean verifyReportChannel() {
        DynamicObject reportChannelDynObj = this.getF7Value("reportchannelid");
        if (reportChannelDynObj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e0a\u62a5\u6e20\u9053\u3002", (String)"InventoryReportEdit_2", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean verifyOrg() {
        DynamicObject orgDynObj = this.getF7Value("org");
        if (orgDynObj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6e20\u9053\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"InventoryReportEdit_3", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean verifyWarehouse(int rowIndex) {
        DynamicObject dynObj = this.getF7Value("warehouseid", rowIndex);
        if (dynObj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4ed3\u5e93\u3002", (String)"InventoryReportEdit_4", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void setLotInfoByLot(long lotId, long lotEntryId, String lotNumber, int rowIndex) {
        List<QFilter> filterList = this.getLotFilterByItemId(rowIndex);
        if (lotId > 0L) {
            filterList.add(new QFilter("id", "=", (Object)lotId));
        }
        if (lotEntryId > 0L) {
            filterList.add(new QFilter(String.join((CharSequence)".", "ococic_lotdate", "id"), "=", (Object)lotEntryId));
        }
        QFilter lotNumberFilter = null;
        if (StringUtils.isNotEmpty((String)lotNumber)) {
            lotNumberFilter = new QFilter("number", "=", (Object)lotNumber);
            filterList.add(lotNumberFilter);
        }
        DynamicObjectCollection lotDynObjColl = null;
        if (!CommonUtils.isNull(filterList)) {
            lotDynObjColl = QueryServiceHelper.query((String)"ococic_lot", (String)String.join((CharSequence)",", "number", "id", "auxptyid", OcocicLotConst.EF_lotdate_productdate, OcocicLotConst.EF_lotdate_expiredate), (QFilter[])filterList.toArray(new QFilter[filterList.size()]));
        }
        if (lotDynObjColl != null && lotDynObjColl.size() == 1) {
            DynamicObject lotDynObj = (DynamicObject)lotDynObjColl.get(0);
            long auxptyId = lotDynObj.getLong("auxptyid");
            if (this.getF7PKValue("auxptyid", rowIndex) == null && auxptyId > 0L) {
                this.setValueByImport("auxptyid", auxptyId, rowIndex);
            }
            this.setValueByImport("lotnumberid", lotDynObj.getLong("id"), rowIndex, false);
            this.setValueByImport("lotnumber", lotDynObj.getString("number"), rowIndex, false);
            this.setValueByImport("productdate", lotDynObj.getDate(OcocicLotConst.EF_lotdate_productdate), rowIndex, false);
            this.setValueByImport("expiredate", lotDynObj.getString(OcocicLotConst.EF_lotdate_expiredate), rowIndex, false);
        } else if (lotDynObjColl != null && lotDynObjColl.size() > 1) {
            if (!this.verifyItem(rowIndex)) {
                return;
            }
            this.showLotInfoF7(lotNumberFilter, rowIndex);
        }
    }

    private void showLotInfoF7(QFilter filter, int rowIndex) {
        ArrayList<String> showFields = new ArrayList<String>(10);
        showFields.add("number");
        showFields.add("productdate");
        showFields.add("expiredate");
        ListShowParameter listShowParam = ShowFormHelper.createShowListForm((String)"ococic_lot", (boolean)false, (int)2);
        listShowParam.setCustomParam("entity", (Object)"ococic_lot");
        listShowParam.setCustomParam("entry", (Object)"ococic_lotdate");
        listShowParam.setCustomParam("isEntryMain", (Object)Boolean.TRUE);
        listShowParam.setCustomParam("showFields", showFields);
        LspWapper lspWapper = new LspWapper(listShowParam);
        lspWapper.clearPlugins();
        lspWapper.registerScript("kingdee.occ.occba.mainpage.dynamicformlistscriptplugin");
        lspWapper.setMergeRow(false);
        listShowParam.setAppId("ococic");
        ListFilterParameter listFilter = new ListFilterParameter();
        List<QFilter> filterList = this.getLotFilterByItemId(rowIndex);
        if (filter != null) {
            filterList.add(filter);
        }
        listFilter.setQFilters(filterList);
        listShowParam.setListFilterParameter(listFilter);
        listShowParam.setCaption(ResManager.loadKDString((String)"\u5546\u54c1\u6279\u53f7", (String)"InventoryReportEdit_5", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "lotnumber");
        listShowParam.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)listShowParam);
    }

    private List<QFilter> getLotFilterByItemId(int rowIndex) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(3);
        DynamicObject itemDynObj = this.getF7Value("itemid", rowIndex);
        long itemId = DynamicObjectUtils.getPkValue((DynamicObject)itemDynObj);
        if (itemId == 0L) {
            return filterList;
        }
        filterList.add(new QFilter("itemid", "=", (Object)itemId));
        filterList.add(new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue()));
        long auxptyId = DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("auxptyid", rowIndex));
        if (auxptyId > 0L) {
            filterList.add(new QFilter("auxptyid", "=", (Object)auxptyId));
        }
        return filterList;
    }

    private void setDefaultLocationId(int rowIndex) {
        DynamicObject warehouseDynObj = this.getF7Value("warehouseid", rowIndex);
        DynamicObjectCollection locationColl = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)warehouseDynObj, (String)"entryentity");
        Object locationPK = null;
        if (!CommonUtils.isNull((Object)locationColl)) {
            locationPK = ((DynamicObject)locationColl.get(0)).getPkValue();
            for (DynamicObject dynObj : locationColl) {
                if (!dynObj.getBoolean("defaultlocation")) continue;
                locationPK = dynObj.getPkValue();
                break;
            }
        }
        this.setValueByImport("locationid", locationPK, rowIndex);
    }

    private void setValueByImport(String propertyKey, Object value, int rowIndex) {
        boolean isImport = this.isFromImport();
        if (value != null && value.toString().equals("0")) {
            value = null;
        }
        if (isImport) {
            if (this.getValue(propertyKey, rowIndex) == null || this.getValue(propertyKey, rowIndex) instanceof BigDecimal && BigDecimalUtil.toBigDecimal((Object)this.getValue(propertyKey, rowIndex)).compareTo(ZERO) == 0) {
                this.setValue(propertyKey, value, rowIndex);
            }
            this.propertyChangedByData(propertyKey, rowIndex, null);
        } else {
            this.setValue(propertyKey, value, rowIndex);
        }
    }

    private void setValueByImport(String propertyKey, Object value, int rowIndex, boolean isTriggerChangeEvent) {
        boolean isImport = this.isFromImport();
        if (value != null && value.toString().equals("0")) {
            value = null;
        }
        if (isImport) {
            if (this.getValue(propertyKey, rowIndex) == null || this.getValue(propertyKey, rowIndex) instanceof BigDecimal && BigDecimalUtil.toBigDecimal((Object)this.getValue(propertyKey, rowIndex)).compareTo(ZERO) == 0) {
                this.setValue(propertyKey, value, rowIndex, isTriggerChangeEvent);
            }
            if (isTriggerChangeEvent) {
                this.propertyChangedByData(propertyKey, rowIndex, null);
            }
        } else {
            this.setValue(propertyKey, value, rowIndex, isTriggerChangeEvent);
        }
    }
}

