/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ococic.formplugin.stockinPlugins;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.QtyProp;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.occ.ocbase.business.helper.UnitConvertHelper;
import kd.occ.ocbase.common.enums.GoodsTypeEnum;
import kd.occ.ocbase.common.helper.CUserHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.ItemNSaleControlUtil;
import kd.occ.ocbase.common.util.QueryUtil;
import kd.occ.ocbase.formplugin.base.OcbaseBasePlugin;

public class ChannelInListEdit
extends OcbaseBasePlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, new String[]{"itemid", "materialid", "inchannelid", "unitid"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.itemPropertyChanged(true);
        this.materialPropertyChanged(true);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        switch (e.getProperty().getName()) {
            case "itemid": {
                this.itemPropertyChanged(false);
                break;
            }
            case "materialid": {
                this.materialPropertyChanged(false);
                break;
            }
            case "qty": {
                this.qtyPropertyChanged(false);
                break;
            }
            case "unitid": {
                this.qtyPropertyChanged(false);
                break;
            }
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        QtyProp srcQtyProp = (QtyProp)this.getModel().getProperty("qty");
        QtyProp distQtyProp = (QtyProp)this.getModel().getProperty("baseqty");
        kd.bos.servicehelper.UnitConvertHelper.convertQty((QtyProp)srcQtyProp, (QtyProp)distQtyProp, (IDataModel)this.getModel(), (StringBuilder)new StringBuilder());
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        switch (e.getProperty().getName()) {
            case "inchannelid": {
                F7Utils.addCustomF7Filter((BeforeF7SelectEvent)e, (QFilter)CUserHelper.getAuthorizedChannelFilter());
                break;
            }
            case "itemid": {
                long inChannelId = this.getInChannelId();
                if (inChannelId == 0L) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5165\u5e93\u6e20\u9053", (String)"ChannelInListEdit_0", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                QFilter itemFilter = ItemNSaleControlUtil.getMyItemFilter((long)this.getInChannelId(), (boolean)false);
                itemFilter.and(new QFilter("itemtypeid", "!=", (Object)Long.parseLong(GoodsTypeEnum.COMBINEGOODS.getValue())));
                F7Utils.addCustomF7Filter((BeforeF7SelectEvent)e, (QFilter)itemFilter);
                break;
            }
            case "unitid": {
                this.setUnitIdEntryF7Select(e);
                break;
            }
        }
    }

    private void setUnitIdEntryF7Select(BeforeF7SelectEvent e) {
        if (!this.verifyItem()) {
            e.setCancel(true);
            return;
        }
        Object materialId = this.getF7PKValue("materialid");
        Object baseUnitId = this.getF7PKValue("baseunitid");
        List fixconunitlist = QueryUtil.getAssistMUListResult((Long)(materialId == null ? Long.valueOf(0L) : Long.valueOf(materialId.toString())), (Long)(baseUnitId == null ? Long.valueOf(0L) : Long.valueOf(baseUnitId.toString())), (String)"1");
        QFilter fixconFilter = new QFilter("id", "in", (Object)fixconunitlist);
        F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)fixconFilter);
    }

    private boolean verifyItem() {
        Object itemId = this.getF7PKValue("itemid");
        if (itemId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5546\u54c1\u3002", (String)"ChannelInListEdit_1", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void itemPropertyChanged(boolean isOnlySetControl) {
        DynamicObject item = this.getF7Value("itemid");
        if (item != null) {
            DynamicObject inChannel;
            String snmanager;
            boolean isenablelot = item.getBoolean("enablelot");
            this.setMustInput("lotnumber", isenablelot);
            this.setEnable("lotnumber", isenablelot);
            this.setEnable("producedate", isenablelot);
            this.setEnable("expirydate", isenablelot);
            boolean isenableserial = item.getBoolean("enableserial");
            if (isenableserial && !(snmanager = DynamicObjectUtils.getString((DynamicObject)(inChannel = (DynamicObject)this.getModel().getValue("inchannelid")), (String)"snmanager")).equals("A")) {
                isenableserial = false;
            }
            this.setMustInput("serialnumber", isenableserial);
            this.setEnable("serialnumber", isenableserial);
            this.setEnable("auxsno", isenableserial);
            this.setEnable("auxsnt", isenableserial);
            this.setEnable("outboxno", isenableserial);
            this.setEnable("packageno", isenableserial);
        } else {
            this.setMustInput("lotnumber", false);
            this.setEnable("lotnumber", false);
            this.setEnable("producedate", false);
            this.setEnable("expirydate", false);
            this.setMustInput("serialnumber", false);
            this.setEnable("serialnumber", false);
            this.setEnable("auxsno", false);
            this.setEnable("auxsnt", false);
            this.setEnable("outboxno", false);
            this.setEnable("packageno", false);
        }
    }

    private void materialPropertyChanged(boolean isOnlySetControl) {
        DynamicObject material = this.getF7Value("materialid");
        if (material != null) {
            this.enableControl("auxptyid", material.getBoolean("isuseauxpty"), isOnlySetControl);
        } else {
            this.enableControl("auxptyid", false, isOnlySetControl);
        }
    }

    private void qtyPropertyChanged(boolean isOnlySetControl) {
        BigDecimal qty = (BigDecimal)this.getModel().getValue("qty");
        DynamicObject materiel = this.getF7Value("materialid");
        long materielId = 0L;
        if (materiel != null) {
            materielId = (Long)materiel.getPkValue();
        }
        DynamicObject unit = this.getF7Value("unitid");
        long srcUnitId = 0L;
        if (unit != null) {
            srcUnitId = (Long)unit.getPkValue();
        }
        DynamicObject baseunit = this.getF7Value("baseunitid");
        long baseUnitId = 0L;
        BigDecimal baseQty = BigDecimal.ZERO;
        if (baseunit != null) {
            baseUnitId = (Long)baseunit.getPkValue();
            baseQty = UnitConvertHelper.calculateDestQty((BigDecimal)qty, (Long)materielId, (Long)srcUnitId, (Long)baseUnitId);
        }
        this.setValue("baseqty", baseQty);
    }

    private void enableControl(String key, boolean isEnable, boolean isOnlySetControl) {
        if (isEnable) {
            this.setMustInput(key, true);
            this.setEnable(new String[]{key});
        } else {
            this.setMustInput(key, false);
            this.setUnEnable(new String[]{key});
            if (isOnlySetControl) {
                this.setValue(key, null);
            }
        }
    }

    private void setEnable(String key, boolean isEnable) {
        if (isEnable) {
            this.setEnable(new String[]{key});
        } else {
            this.setUnEnable(new String[]{key});
        }
    }

    private long getInChannelId() {
        Object obj = this.getF7PKValue("inchannelid");
        return obj == null ? 0L : (Long)obj;
    }
}

