/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ococic.formplugin.stockinPlugins;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.occ.ocbase.business.b2b.B2BUserHelper;
import kd.occ.ocbase.business.b2b.ItemBusinessHelper;
import kd.occ.ocbase.common.enums.Checked;
import kd.occ.ocbase.common.enums.GoodsTypeEnum;
import kd.occ.ocbase.common.status.Status;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ococic.formplugin.stockinPlugins.StockInBillEdit;

public class StockInBillB2bEdit
extends StockInBillEdit
implements BeforeF7SelectListener {
    private static final String BILLTYPEDATA = "billtypedata";
    private static final String SUPPLIERID = "supplierid";

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setValue(BILLTYPEDATA, this.getModel().getValue("billtypeid"));
        this.setValue(SUPPLIERID, B2BUserHelper.getLoginSupplyRelationId());
        this.setValue("inchannelid", B2BUserHelper.getLoginChannelId());
        super.setOrgAndChannel();
        super.setCurrency();
        DynamicObject supplier = (DynamicObject)this.getModel().getValue(SUPPLIERID);
        this.setDefaultChannel(supplier);
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.getModel().beginInit();
        this.setValue(BILLTYPEDATA, this.getModel().getValue("billtypeid"), false);
        this.getModel().setDataChanged(false);
    }

    @Override
    public void afterBindData(EventObject e) {
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"org"});
        super.afterBindData(e);
    }

    @Override
    public void registerListener(EventObject e) {
        this.addF7Listener(this, new String[]{SUPPLIERID, BILLTYPEDATA});
        super.registerListener(e);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String propName;
        switch (propName = e.getProperty().getName()) {
            case "supplierid": {
                QFilter filter = new QFilter("enable", "=", (Object)Checked.YES.toString());
                filter.and("orderchannel", "=", (Object)B2BUserHelper.getLoginChannelId());
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)filter);
                break;
            }
            case "billtypedata": {
                QFilter filter = new QFilter("enable", "=", (Object)Checked.YES.toString());
                filter.and("status", "=", (Object)Status.AUDITED.toString());
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)filter);
                break;
            }
            case "itemid": {
                QFilter filter = ItemBusinessHelper.getDpItemFilter();
                filter.and("itemtypeid", "!=", (Object)Long.parseLong(GoodsTypeEnum.COMBINEGOODS.getValue()));
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)filter);
                break;
            }
            default: {
                super.beforeF7Select(e);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e, String key) {
        super.propertyChanged(e, key);
        switch (key) {
            case "billtypedata": {
                this.getModel().setValue("billtypeid", this.getModel().getValue(BILLTYPEDATA));
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"supplychannelid"});
                break;
            }
            case "billtypeid": {
                break;
            }
            case "supplierid": {
                DynamicObject supplier = (DynamicObject)e.getChangeSet()[0].getNewValue();
                this.setDefaultChannel(supplier);
                break;
            }
        }
    }

    private void setDefaultChannel(DynamicObject supplier) {
        DynamicObject supplyChannel = null;
        DynamicObject saleOrg = null;
        if (supplier != null) {
            supplyChannel = supplier.getDynamicObject("salechannel");
            saleOrg = supplier.getDynamicObject("saleorg");
        }
        this.getModel().setValue("saleorg", saleOrg);
        this.getModel().setValue("supplychannelid", (Object)supplyChannel);
    }
}

