/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ococic.formplugin.stockinPlugins;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.occ.ocbase.business.helper.UnitConvertHelper;
import kd.occ.ocbase.common.enums.Enable;
import kd.occ.ocbase.common.enums.GoodsTypeEnum;
import kd.occ.ocbase.common.helper.CSerialHelper;
import kd.occ.ocbase.common.helper.CUserHelper;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.ItemNSaleControlUtil;
import kd.occ.ocbase.common.util.QueryUtil;
import kd.occ.ocbase.formplugin.base.OcbaseBasePlugin;
import kd.occ.ococic.enums.SnStatusEnum;
import org.apache.commons.lang3.StringUtils;

public class StockInBillEdit
extends OcbaseBasePlugin
implements BeforeF7SelectListener {
    private BigDecimal MAX_QTY = new BigDecimal("999999999999.999999999");
    private static final String SNBATCHINPUT = "snbatchinput";
    private static final String SNINPUT = "sninput";
    private static final String CALLBACK_SAVE_CHECKSERIALNUMBER = "save_checkserialnumber";
    private static final String CALLBACK_SUBMIT_CHECKSERIALNUMBER = "submit_checkserialnumber";

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        IFormView formView = this.getView().getParentView();
        if (formView instanceof ListView) {
            ListView lstFormView = (ListView)this.getView().getParentView();
            lstFormView.getFormShowParameter().setCustomParam("isfromb2bbillclose", (Object)true);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"lotnumber"});
        this.addClickListeners(new String[]{"serialnumber"});
        this.addClickListeners(new String[]{SNBATCHINPUT});
        this.addF7Listener(this, new String[]{"inchannelid", "supplychannelid", "saleorg", "warehouse", "locationid", "unitid", "itemid", "lotnumberid", "materialid", "serialid"});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "lotnumber": {
                BasedataEdit lotnumberid = (BasedataEdit)this.getControl("lotnumberid");
                if (null == lotnumberid) break;
                List<Long> lotIds = this.filterLotIdByItemId();
                QFilter idFilter = new QFilter("id", "in", lotIds);
                lotnumberid.setQFilter(idFilter);
                lotnumberid.setF7MultipleSelect(false);
                lotnumberid.click();
                break;
            }
            case "serialnumber": {
                BasedataEdit EF_serialnumberid = (BasedataEdit)this.getControl("serialid");
                if (null == EF_serialnumberid) break;
                List<Long> SNIds = this.filterSQNIdByItemId();
                QFilter SNFilter = new QFilter("id", "in", SNIds);
                EF_serialnumberid.setQFilter(SNFilter);
                EF_serialnumberid.setF7MultipleSelect(false);
                EF_serialnumberid.click();
                break;
            }
            case "snbatchinput": {
                FormShowParameter parameter = new FormShowParameter();
                parameter.setFormId("ococic_batchinputserial");
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SNBATCHINPUT));
                this.getView().showForm(parameter);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if (event.getResult().equals((Object)MessageBoxResult.Yes)) {
            String callBackId = event.getCallBackId();
            if (CALLBACK_SAVE_CHECKSERIALNUMBER.equalsIgnoreCase(callBackId)) {
                DynamicObject dataEntity = this.getModel().getDataEntity(true);
                OperateOption option = OperateOption.create();
                option.setVariableValue("ignoreValidation", String.valueOf(true));
                OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"ococic_channelinbill", (DynamicObject[])new DynamicObject[]{dataEntity}, (OperateOption)option);
                if (result != null && !result.isSuccess()) {
                    this.getView().showOperationResult(result);
                } else {
                    this.getView().updateView("billstatus");
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"StockInBillEdit_3", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
                }
            } else if (CALLBACK_SUBMIT_CHECKSERIALNUMBER.equalsIgnoreCase(callBackId)) {
                DynamicObject dataEntity = this.getModel().getDataEntity(true);
                OperateOption option = OperateOption.create();
                option.setVariableValue("ignoreValidation", String.valueOf(true));
                OperationResult result = OperationServiceHelper.executeOperate((String)"submit", (String)"ococic_channelinbill", (DynamicObject[])new DynamicObject[]{dataEntity}, (OperateOption)option);
                if (result != null && !result.isSuccess()) {
                    this.getView().showOperationResult(result);
                } else {
                    this.getView().updateView("billstatus");
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f\u3002", (String)"StockInBillEdit_4", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String propName = e.getProperty().getName();
        int currentRowIndex = e.getRow();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        switch (propName) {
            case "inchannelid": {
                showParameter.getListFilterParameter().setQFilters(this.getinChannelFilters());
                break;
            }
            case "warehouse": {
                List<Long> warehouseIds = this.getIdsFromOcocicWareHouse();
                qFilters.add(new QFilter("id", "in", warehouseIds));
                showParameter.getListFilterParameter().setQFilters(qFilters);
                break;
            }
            case "locationid": {
                boolean warehouseStatus = this.whetherWarehouseChoose();
                if (!warehouseStatus) {
                    e.setCancel(true);
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4ed3\u5e93", (String)"StockInBillEdit_5", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
                    break;
                }
                long wid = ((DynamicObject)this.getModel().getEntryRowEntity("billentry", currentRowIndex).get("warehouse")).getLong("id");
                QFilter qf2 = new QFilter("warehouseid", "=", (Object)wid);
                showParameter.getListFilterParameter().setFilter(qf2);
                break;
            }
            case "supplychannelid": {
                if (null == this.getInChannelObject()) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5165\u5e93\u6e20\u9053", (String)"StockInBillEdit_6", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                qFilters.add(new QFilter("enable", "=", (Object)"1"));
                qFilters.add(new QFilter("id", "in", this.getSaleChannelsFromOcdbdChannelAuthorize()));
                showParameter.getListFilterParameter().setQFilters(qFilters);
                break;
            }
            case "saleorg": {
                if (null == this.getInChannelObject()) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5165\u5e93\u6e20\u9053", (String)"StockInBillEdit_6", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                qFilters.add(new QFilter("enable", "=", (Object)"1"));
                qFilters.add(new QFilter("id", "in", this.getSaleOrgsFromOcdbdChannelAuthorize()));
                showParameter.getListFilterParameter().setQFilters(qFilters);
                break;
            }
            case "itemid": {
                QFilter itemFilter = this.getItemFilter();
                itemFilter.and(new QFilter("itemtypeid", "!=", (Object)Long.parseLong(GoodsTypeEnum.COMBINEGOODS.getValue())));
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)itemFilter);
                break;
            }
            case "unitid": {
                this.setUnitIdEntryF7Select(e, currentRowIndex);
            }
        }
    }

    private List<Long> filterLotIdByItemId() {
        DynamicObject[] result;
        ArrayList<Long> ids = new ArrayList<Long>();
        DynamicObject rowObj = this.getCurrentRowInfo("billentry");
        if (null == rowObj) {
            return ids;
        }
        DynamicObject itemObj = (DynamicObject)rowObj.get("itemid");
        if (null == itemObj) {
            return ids;
        }
        Long itemId = (Long)itemObj.getPkValue();
        QFilter itemIdFilter = new QFilter("itemid", "=", (Object)itemId);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter auxptyFilter = null;
        DynamicObject auxpty = (DynamicObject)rowObj.get("auxptyid");
        if (null != auxpty) {
            Long auxptyId = (Long)auxpty.getPkValue();
            auxptyFilter = new QFilter("auxptyid", "=", (Object)auxptyId);
        }
        if ((result = BusinessDataServiceHelper.load((String)"ococic_lot", (String)"id", (QFilter[])new QFilter[]{itemIdFilter, enableFilter, auxptyFilter})) != null && result.length > 0) {
            for (DynamicObject dynamicobject : result) {
                ids.add((Long)dynamicobject.getPkValue());
            }
        }
        return ids;
    }

    private List<Long> filterSQNIdByItemId() {
        QFilter lockstatusFilter;
        DynamicObject[] result;
        ArrayList<Long> ids = new ArrayList<Long>();
        DynamicObject rowObj = this.getCurrentRowInfo("billentry");
        if (null == rowObj) {
            return ids;
        }
        DynamicObject itemObj = (DynamicObject)rowObj.get("itemid");
        if (null == itemObj) {
            return ids;
        }
        Long itemId = (Long)itemObj.getPkValue();
        QFilter itemIdFilter = new QFilter("itemid", "=", (Object)itemId);
        QFilter auxptyFilter = null;
        DynamicObject auxpty = (DynamicObject)rowObj.get("auxptyid");
        if (null != auxpty) {
            Long auxptyId = (Long)auxpty.getPkValue();
            auxptyFilter = new QFilter("auxptyid", "=", (Object)auxptyId);
        }
        QFilter billTypeFilter = null;
        billTypeFilter = this.whetherPositiveInWay() ? new QFilter("snstatus", "=", (Object)SnStatusEnum.ONWAY.getValue()) : new QFilter("snstatus", "=", (Object)SnStatusEnum.INSTOCK.getValue());
        QFilter lotNumFilter = null;
        String lotNum = this.getStringValue("lotnumber");
        if (lotNum != null) {
            lotNumFilter = new QFilter("lotnum", "=", (Object)lotNum);
        }
        QFilter produceDateFilter = null;
        Date produceDate = rowObj.getDate("producedate");
        if (produceDate != null) {
            produceDateFilter = new QFilter("productdate", "=", (Object)produceDate);
        }
        QFilter effectiveDateFilter = null;
        Date effectiveDate = (Date)rowObj.get("expirydate");
        if (effectiveDate != null) {
            effectiveDateFilter = new QFilter("effectivedate", "=", (Object)effectiveDate);
        }
        QFilter warehouseFilter = null;
        DynamicObject warehouse = (DynamicObject)rowObj.get("warehouse");
        if (warehouse != null) {
            Long warehouseId = (Long)warehouse.getPkValue();
            warehouseFilter = new QFilter("channelstockid", "=", (Object)warehouseId);
        }
        QFilter locationFilter = null;
        DynamicObject location = (DynamicObject)rowObj.get("locationid");
        if (location != null) {
            Long locationId = (Long)location.getPkValue();
            locationFilter = new QFilter("channellocationid", "=", (Object)locationId);
        }
        QFilter stockstatusFilter = null;
        DynamicObject stockstatus = (DynamicObject)rowObj.get("stockstatus");
        if (stockstatus != null) {
            Long stockstatusId = (Long)stockstatus.getPkValue();
            stockstatusFilter = new QFilter("channelstockstatusid", "=", (Object)stockstatusId);
        }
        QFilter stocktypeFilter = null;
        DynamicObject stocktype = (DynamicObject)rowObj.get("stocktype");
        if (stocktype != null) {
            Long stocktypeId = (Long)stocktype.getPkValue();
            stocktypeFilter = new QFilter("channelstocktypeid", "=", (Object)stocktypeId);
        }
        QFilter ownerFilter = null;
        DynamicObject owner = (DynamicObject)rowObj.get("ownerid");
        if (owner != null) {
            Long ownerId = (Long)owner.getPkValue();
            ownerFilter = new QFilter("ownerid", "=", (Object)ownerId);
        }
        QFilter ownertypeFilter = null;
        String ownertype = (String)rowObj.get("ownertype");
        if (ownertype != null) {
            ownertypeFilter = new QFilter("ownertype", "=", (Object)ownertype);
        }
        QFilter keeperFilter = null;
        DynamicObject keeper = (DynamicObject)rowObj.get("keeperid");
        if (keeper != null) {
            Long keeperId = (Long)keeper.getPkValue();
            keeperFilter = new QFilter("keeperid", "=", (Object)keeperId);
        }
        QFilter keepertypeFilter = null;
        String keepertype = (String)rowObj.get("keepertype");
        if (keepertype != null) {
            keepertypeFilter = new QFilter("keepertype", "=", (Object)keepertype);
        }
        if ((result = BusinessDataServiceHelper.load((String)"ococic_snmainfile", (String)"id", (QFilter[])new QFilter[]{itemIdFilter, auxptyFilter, billTypeFilter, lotNumFilter, produceDateFilter, effectiveDateFilter, warehouseFilter, locationFilter, stockstatusFilter, stocktypeFilter, ownerFilter, ownertypeFilter, keeperFilter, keepertypeFilter, lockstatusFilter = new QFilter("lockstatus", "=", (Object)"0")})) != null && result.length > 0) {
            for (DynamicObject dynamicobject : result) {
                ids.add((Long)dynamicobject.getPkValue());
            }
        }
        return ids;
    }

    private boolean whetherWarehouseChoose() {
        boolean status = false;
        DynamicObject warehouse = (DynamicObject)this.getView().getModel().getValue("warehouse");
        if (warehouse != null) {
            status = true;
        }
        return status;
    }

    private void setStockStatusAndStockType(int rowIndex) {
        this.setDefaultStockStatus(rowIndex);
        this.setDefaultStockType(rowIndex);
    }

    private void setDefaultStockStatus(int rowIndex) {
        QFilter ispresetFilter;
        QFilter enableFilter;
        QFilter nameFilter = new QFilter("name", "=", (Object)ResManager.loadKDString((String)"\u53ef\u7528", (String)"StockInBillEdit_7", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
        DynamicObject[] result = BusinessDataServiceHelper.load((String)"ococic_stockstatus", (String)"id", (QFilter[])new QFilter[]{nameFilter, enableFilter = new QFilter("enable", "=", (Object)"1"), ispresetFilter = new QFilter("ispreset", "=", (Object)"1")});
        if (result != null && result.length > 0) {
            this.getView().getModel().setValue("stockstatus", (Object)result[0].getLong("id"), rowIndex);
        }
    }

    private void setDefaultStockType(int rowIndex) {
        QFilter ispresetFilter;
        QFilter enableFilter;
        QFilter nameFilter = new QFilter("name", "=", (Object)ResManager.loadKDString((String)"\u666e\u901a", (String)"StockInBillEdit_8", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
        DynamicObject[] result = BusinessDataServiceHelper.load((String)"ococic_stocktype", (String)"id", (QFilter[])new QFilter[]{nameFilter, enableFilter = new QFilter("enable", "=", (Object)"1"), ispresetFilter = new QFilter("ispreset", "=", (Object)"1")});
        if (result != null && result.length > 0) {
            this.getView().getModel().setValue("stocktype", (Object)result[0].getLong("id"), rowIndex);
        }
    }

    private List<Long> getIdsFromOcocicWareHouse() {
        QFilter enableFilter;
        QFilter statusFilter;
        DynamicObject[] result;
        ArrayList<Long> ids = new ArrayList<Long>();
        long channelId = this.getInChannelId();
        QFilter customerFilter = null;
        if (channelId > 0L) {
            customerFilter = new QFilter("ownerchannelid", "=", (Object)channelId);
        }
        if ((result = BusinessDataServiceHelper.load((String)"ococic_warehouse", (String)"id", (QFilter[])new QFilter[]{customerFilter, statusFilter = new QFilter("status", "=", (Object)"C"), enableFilter = new QFilter("enable", "=", (Object)"1")})) != null && result.length > 0) {
            for (DynamicObject dynamicobject : result) {
                ids.add(dynamicobject.getLong("id"));
            }
        }
        return ids;
    }

    private void setDefaultWareHouseID(int rowIndex) {
        QFilter enableFilter;
        QFilter statusFilter;
        QFilter defaultFilter;
        DynamicObject[] result;
        this.getView().getModel().setValue("warehouse", null, rowIndex);
        long channelId = this.getInChannelId();
        QFilter customerFilter = null;
        if (channelId > 0L && (result = BusinessDataServiceHelper.load((String)"ococic_warehouse", (String)"id", (QFilter[])new QFilter[]{customerFilter = new QFilter("ownerchannelid", "=", (Object)channelId), defaultFilter = new QFilter("isdefault", "=", (Object)"1"), statusFilter = new QFilter("status", "=", (Object)"C"), enableFilter = new QFilter("enable", "=", (Object)"1")})) != null && result.length > 0) {
            this.getView().getModel().setValue("warehouse", result[0].getPkValue(), rowIndex);
        }
    }

    private List<QFilter> getinChannelFilters() {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        QFilter qFilter1 = new QFilter("isinnerorg", "=", (Object)Boolean.FALSE);
        QFilter qFilter2 = new QFilter("status", "=", (Object)"C");
        QFilter qFilter3 = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter qFilter4 = new QFilter("channelfunctions.fbasedataid.number", "=", (Object)"003");
        qFilters.add(qFilter1);
        qFilters.add(qFilter2);
        qFilters.add(qFilter3);
        qFilters.add(qFilter4);
        qFilters.add(CUserHelper.getAuthorizedChannelFilter());
        qFilters.add(new QFilter("invcontrolmode", "=", (Object)"A"));
        return qFilters;
    }

    private List<Long> getSaleChannelsFromOcdbdChannelAuthorize() {
        ArrayList<Long> ids = new ArrayList<Long>();
        long channelId = this.getInChannelId();
        if (channelId <= 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5165\u5e93\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"StockInBillEdit_9", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
        }
        QFilter customerFilter = new QFilter("orderchannel", "=", (Object)channelId);
        DynamicObject[] result = BusinessDataServiceHelper.load((String)"ocdbd_channel_authorize", (String)"salechannel", (QFilter[])new QFilter[]{customerFilter});
        if (result != null && result.length > 0) {
            for (DynamicObject dynamicobject : result) {
                ids.add(dynamicobject.getLong("salechannel.id"));
            }
        }
        return ids;
    }

    private List<Long> getSaleOrgsFromOcdbdChannelAuthorize() {
        ArrayList<Long> ids = new ArrayList<Long>();
        long channelId = this.getInChannelId();
        if (channelId <= 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5165\u5e93\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"StockInBillEdit_9", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
        }
        QFilter customerFilter = new QFilter("orderchannel", "=", (Object)channelId);
        DynamicObject[] result = BusinessDataServiceHelper.load((String)"ocdbd_channel_authorize", (String)"saleorg", (QFilter[])new QFilter[]{customerFilter});
        if (result != null && result.length > 0) {
            for (DynamicObject dynamicobject : result) {
                ids.add(dynamicobject.getLong("saleorg.id"));
            }
        }
        return ids;
    }

    private void setUnitIdEntryF7Select(BeforeF7SelectEvent e, int rowIndex) {
        if (!this.verifyItem(rowIndex)) {
            e.setCancel(true);
            return;
        }
        Object materialId = this.getEntryF7PKValue("billentry", "materialid", rowIndex);
        Object baseUnitId = this.getEntryF7PKValue("billentry", "baseunitid", rowIndex);
        List fixconunitlist = QueryUtil.getAssistMUListResult((Long)(materialId == null ? Long.valueOf(0L) : Long.valueOf(materialId.toString())), (Long)(baseUnitId == null ? Long.valueOf(0L) : Long.valueOf(baseUnitId.toString())), (String)"1");
        QFilter fixconFilter = new QFilter("id", "in", (Object)fixconunitlist);
        F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)fixconFilter);
    }

    private boolean verifyItem(int rowIndex) {
        Object itemId = this.getEntryF7PKValue("billentry", "itemid", rowIndex);
        if (itemId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5546\u54c1\u3002", (String)"StockInBillEdit_10", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void setDefaultInchannelId() {
        int entryRowCount;
        QFilter qFilterIsinNerOrg = new QFilter("isinnerorg", "=", (Object)Boolean.FALSE);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter qFilterCustomerAuthorize = CUserHelper.getAuthorizedChannelFilter();
        DynamicObject[] result = BusinessDataServiceHelper.load((String)"ocdbd_channel", (String)"id", (QFilter[])new QFilter[]{qFilterCustomerAuthorize, qFilterIsinNerOrg, enableFilter, statusFilter});
        if (result != null && result.length > 0) {
            this.getView().getModel().setValue("inchannelid", (Object)result[0].getLong("id"));
        }
        if (0 < (entryRowCount = this.getModel().getEntryRowCount("billentry"))) {
            this.setOwnerAndKeeper(0);
        }
    }

    private DynamicObject getInChannelObject() {
        Object obj = this.getModel().getValue("inchannelid");
        return obj == null ? null : (DynamicObject)obj;
    }

    private long getInChannelId() {
        Object obj = this.getF7PKValue("inchannelid");
        return obj == null ? 0L : (Long)obj;
    }

    private QFilter getItemFilter() {
        QFilter itemFilter = ItemNSaleControlUtil.getMyItemFilter((long)this.getInChannelId(), (boolean)false);
        return itemFilter;
    }

    private DynamicObject getSupplyChannel() {
        Object obj = this.getModel().getValue("supplychannelid");
        return obj == null ? null : (DynamicObject)obj;
    }

    private DynamicObject getSaleOrg() {
        Object obj = this.getModel().getValue("saleorg");
        return obj == null ? null : (DynamicObject)obj;
    }

    private void setALLQTYZERO(int rowIndex) {
        this.setRowValue("baseqty", 0, rowIndex);
        this.setRowValue("assistqty", 0, rowIndex);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs ea) {
        String opKey;
        super.beforeDoOperation(ea);
        switch (opKey = ((AbstractOperate)ea.getSource()).getOperateKey()) {
            case "newentry": {
                DynamicObject billType;
                if (null == this.getInChannelObject()) {
                    ea.setCancel(true);
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5165\u5e93\u6e20\u9053", (String)"StockInBillEdit_6", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
                }
                if (null != (billType = (DynamicObject)this.getModel().getValue("billtypeid"))) {
                    String billTypeNumber = billType.getString("number");
                    if ("ococic_in_sys009".equals(billTypeNumber)) {
                        if (null != this.getSupplyChannel()) break;
                        ea.setCancel(true);
                        this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u4f9b\u8d27\u6e20\u9053\u3002", (String)"StockInBillEdit_11", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    if (null != this.getSaleOrg()) break;
                    ea.setCancel(true);
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u9500\u552e\u7ec4\u7ec7\u3002", (String)"StockInBillEdit_12", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
                    break;
                }
                ea.setCancel(true);
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u5355\u636e\u7c7b\u578b\u3002", (String)"StockInBillEdit_13", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
                break;
            }
            case "newsubentry": {
                if (this.isEmptyEntry()) {
                    ea.setCancel(true);
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u6dfb\u52a0\u5206\u5f55\uff01", (String)"StockInBillEdit_14", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.ifDisableLockSerialNumberColumn(ea);
                break;
            }
            case "deleteentry": {
                break;
            }
            case "save": {
                String errorMsg = this.checkSerialNumber();
                if (StringUtils.isEmpty((CharSequence)errorMsg)) break;
                ConfirmCallBackListener reduceCallBacks = new ConfirmCallBackListener(CALLBACK_SAVE_CHECKSERIALNUMBER, (IFormPlugin)this);
                this.getView().showConfirm(errorMsg, MessageBoxOptions.YesNo, ConfirmTypes.Default, reduceCallBacks);
                ea.setCancel(true);
                break;
            }
            case "submit": {
                String errorMsg = this.checkSerialNumber();
                if (StringUtils.isEmpty((CharSequence)errorMsg)) break;
                ConfirmCallBackListener reduceCallBacks = new ConfirmCallBackListener(CALLBACK_SUBMIT_CHECKSERIALNUMBER, (IFormPlugin)this);
                this.getView().showConfirm(errorMsg, MessageBoxOptions.YesNo, ConfirmTypes.Default, reduceCallBacks);
                ea.setCancel(true);
            }
        }
    }

    private String checkSerialNumber() {
        String errorMsg = "";
        String selectField = "billno,inchannelid,billentry.subentryentity.serialnumber";
        Object billid = this.getModel().getDataEntity(true).getPkValue();
        QFilter filter = new QFilter("id", "=", billid);
        DynamicObjectCollection inbills = QueryServiceHelper.query((String)"ococic_channelinbill", (String)selectField, (QFilter[])filter.toArray());
        if (!CollectionUtils.isEmpty((Collection)inbills)) {
            String billno = ((DynamicObject)inbills.get(0)).getString("billno");
            long inchannelid = ((DynamicObject)inbills.get(0)).getLong("inchannelid");
            HashSet<String> serialnumbers = new HashSet<String>(inbills.size());
            for (DynamicObject inbill : inbills) {
                String serialnumber = inbill.getString("billentry.subentryentity.serialnumber");
                if (inchannelid == 0L || StringUtils.isEmpty((CharSequence)serialnumber)) continue;
                serialnumbers.add(serialnumber);
            }
            StringBuilder sbSN = new StringBuilder();
            HashSet<Long> snids = new HashSet<Long>(serialnumbers.size());
            QFilter qFilter = new QFilter("channelid", "=", (Object)inchannelid);
            qFilter.and("number", "in", serialnumbers);
            qFilter.and("snstatus", "=", (Object)SnStatusEnum.ONWAY.getValue());
            DynamicObjectCollection snmainFiles = QueryServiceHelper.query((String)"ococic_snmainfile", (String)"id", (QFilter[])qFilter.toArray());
            for (DynamicObject snmainFile : snmainFiles) {
                long snid = snmainFile.getLong("id");
                snids.add(snid);
            }
            if (snids.size() > 0) {
                HashSet<String> moveSNs = new HashSet<String>(snids.size());
                QFilter snFilter = new QFilter("snmainfileid", "in", snids);
                snFilter.and("billentityid", "=", (Object)"ococic_channelinbill");
                snFilter.and("billno", "!=", (Object)billno);
                DynamicObjectCollection movetracks = QueryServiceHelper.query((String)"ococic_snmovetrack", (String)"billno,snmainfileid.number", (QFilter[])snFilter.toArray());
                if (!CollectionUtils.isEmpty((Collection)movetracks)) {
                    for (DynamicObject movetrack : movetracks) {
                        String moveSN = movetrack.getString("snmainfileid.number");
                        if (moveSNs.contains(moveSN)) continue;
                        moveSNs.add(moveSN);
                        sbSN.append(moveSN).append("\r\n");
                    }
                    if (sbSN.length() > 0) {
                        sbSN.deleteCharAt(sbSN.length() - 2);
                        errorMsg = sbSN.append(ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\uff0c\u5728\u5165\u5e93\u6e20\u9053\u662f\u5df2\u53d1\u51fa\u7684\u5728\u9014\u72b6\u6001\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u91cd\u65b0\u5165\u5e93\uff1f", (String)"StockInBillEdit_15", (String)"occ-ococic-formplugin", (Object[])new Object[0])).toString();
                    }
                }
            }
        }
        return errorMsg;
    }

    public void afterDoOperation(AfterDoOperationEventArgs ae) {
        OperationResult opResult;
        super.afterDoOperation(ae);
        if (!StringUtils.equals((CharSequence)"bar_save", (CharSequence)ae.getOperateKey()) || (opResult = ae.getOperationResult()) == null || opResult.isSuccess()) {
            // empty if block
        }
        if (StringUtils.equals((CharSequence)"unaudit", (CharSequence)ae.getOperateKey()) && (opResult = ae.getOperationResult()) != null && opResult.isSuccess()) {
            DynamicObject data;
            ArrayList<Object> needDeleteIds = new ArrayList<Object>();
            DynamicObjectCollection billEntry = this.getModel().getEntryEntity("billentry");
            if (!CommonUtils.isNull((Object)billEntry) && (data = (DynamicObject)billEntry.stream().filter(r -> "ocbsoc_delivery_record".equals(r.getString("srcbillentity"))).findFirst().orElse(null)) != null) {
                needDeleteIds.add(this.getModel().getValue("id"));
            }
            if (!CommonUtils.isNull(needDeleteIds)) {
                OperateOption option = OperateOption.create();
                option.setVariableValue("ignoreValidation", String.valueOf(true));
                OperationServiceHelper.executeOperate((String)"delete", (String)"ococic_channelinbill", (Object[])needDeleteIds.toArray(), (OperateOption)option);
                this.getView().close();
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        if ("billentry".equals(entryName)) {
            int rowIndex = e.getRowDataEntities()[0].getRowIndex();
            this.setOwnerAndKeeper(rowIndex);
            this.setDefaultWareHouseID(rowIndex);
            this.setStockStatusAndStockType(rowIndex);
        }
    }

    private void setOwnerAndKeeper(int rowIndex) {
        DynamicObject inChannel = this.getInChannelObject();
        if (null != inChannel) {
            IDataEntityType type = inChannel.getDataEntityType();
            this.getModel().setValue("ownertype", (Object)type.getName(), rowIndex);
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"ownertype"});
            this.getModel().setValue("ownerid", (Object)inChannel, rowIndex);
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"ownerid"});
            this.getModel().setValue("keepertype", (Object)type.getName(), rowIndex);
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"keepertype"});
            this.getModel().setValue("keeperid", (Object)inChannel, rowIndex);
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"keeperid"});
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setDefaultInchannelId();
        int entryRowCount = this.getModel().getEntryRowCount("billentry");
        if (0 < entryRowCount) {
            this.setOwnerAndKeeper(0);
        }
        this.clearOrgAndChannel();
        this.setOrgAndChannel();
        this.preSetSupplyChannelIdChange();
        this.setSaleOrg();
        this.changeIntypeValue();
        this.setCurrency();
        this.inStockWay();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (!CollectionUtils.isEmpty((Map)customParams) && customParams.containsKey("isfromchannelinvacc")) {
            this.updateBillValuesForStockIn(customParams);
            this.inStockWay();
        }
        this.lockData();
        this.setAssistantProperty();
        this.checkStockLocationAfterBind();
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        switch (actionId = evt.getActionId()) {
            case "snbatchinput": {
                String[] snArray = (String[])evt.getReturnData();
                if (snArray == null || snArray.length <= 0) break;
                ArrayList<String> snList = new ArrayList<String>(Arrays.asList(snArray));
                List<String> existSnList = this.checkSnExist(snList);
                this.addSnToEntry(existSnList, snList);
                break;
            }
        }
        super.closedCallBack(evt);
    }

    private void setAssistantProperty() {
        int entryRowCount = this.getModel().getEntryRowCount("billentry");
        for (int i = 0; i < entryRowCount; ++i) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("billentry", i);
            DynamicObject item = entryRowEntity.getDynamicObject("itemid");
            if (null == item) continue;
            this.setAuxpty(i, item);
        }
    }

    private void inStockWay() {
        long billTypeId = this.getModel().getDataEntity().getLong("billtypeid.id");
        DynamicObject o = (DynamicObject)SystemParamServiceHelper.getBillTypeParameter((String)"ococic_channelinbill", (String)"ococic_inbill_parm", (long)billTypeId);
        if (o != null) {
            String name = o.getString("indirection");
            this.getModel().setValue("inway", (Object)name);
        }
    }

    private boolean whetherPositiveInWay() {
        DynamicObject billType = (DynamicObject)this.getModel().getValue("billtypeid");
        if (billType != null) {
            return !billType.getString("number").equals("ococic_in_sys004");
        }
        return true;
    }

    private void lockData() {
        this.getView().setEnable(Boolean.FALSE, new String[]{"settlecurrencyid"});
        String billstatus = (String)this.getModel().getValue("billstatus");
        if (billstatus.equals("B") || billstatus.equals("C")) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"billtypeid"});
        }
        this.ifDisableLockSerialNum();
    }

    private void setDefaultValues(int i) {
        this.getModel().setValue("materialid", null, i);
        this.getModel().setValue("unitid", null, i);
        this.getModel().setValue("baseunitid", null, i);
        this.getModel().setValue("assistunitid", null, i);
        this.getModel().setValue("qty", (Object)0, i);
        this.getModel().setValue("baseqty", (Object)0, i);
        this.getModel().setValue("assistqty", (Object)0, i);
        this.getModel().setValue("serialqty", (Object)0, i);
        this.getModel().setValue("serialunit", null, i);
        this.getModel().setValue("lotnumberid", null, i);
        this.getModel().setValue("lotnumber", (Object)"", i);
        this.getModel().setValue("producedate", null, i);
        this.getModel().setValue("expirydate", null, i);
        this.getModel().setValue("serialunit", null, i);
        this.getModel().setValue("serialqty", (Object)0, i);
    }

    private void lockDataAfterReviseRowItemId(int rowNo, DynamicObject item) {
        if (item != null) {
            this.changeMaterialColumn(rowNo, item);
            this.setAuxpty(rowNo, item);
            this.setUnit(rowNo, item);
            this.getView().setEnable(Boolean.FALSE, rowNo, new String[]{"ownertype"});
            this.getView().setEnable(Boolean.FALSE, rowNo, new String[]{"keepertype"});
        }
    }

    private void setUnit(int rowNo, DynamicObject currentItem) {
        DynamicObject stockUnit;
        if (currentItem != null && null != (stockUnit = (DynamicObject)currentItem.get("stockunit"))) {
            this.getView().setEnable(Boolean.TRUE, rowNo, new String[]{"unitid"});
            Long stockunit4ItemPKValue = stockUnit.getPkValue() != null ? (Long)stockUnit.getPkValue() : 0L;
            this.getModel().setValue("unitid", (Object)stockunit4ItemPKValue, rowNo);
            DynamicObject baseunit4Item = (DynamicObject)currentItem.get("baseunit");
            if (null == baseunit4Item) {
                this.getView().setEnable(Boolean.TRUE, rowNo, new String[]{"baseunitid"});
            } else {
                Long baseunit4ItemPkValue = baseunit4Item.getPkValue() != null ? (Long)baseunit4Item.getPkValue() : 0L;
                this.getModel().setValue("baseunitid", (Object)baseunit4ItemPkValue, rowNo);
                this.getView().setEnable(Boolean.FALSE, rowNo, new String[]{"baseunitid"});
            }
            DynamicObject assistantunit4Item = (DynamicObject)currentItem.get("assistunit");
            if (null == assistantunit4Item) {
                this.getView().setEnable(Boolean.TRUE, rowNo, new String[]{"assistunitid"});
            } else {
                Long assisunit4ItemPkValue = assistantunit4Item.getPkValue() != null ? (Long)assistantunit4Item.getPkValue() : 0L;
                this.getModel().setValue("assistunitid", (Object)assisunit4ItemPkValue, rowNo);
                this.getView().setEnable(Boolean.FALSE, rowNo, new String[]{"assistunitid"});
            }
        }
    }

    private void setAuxpty(int rowNo, DynamicObject currentItem) {
        if (currentItem != null) {
            DynamicObject bdmaterial;
            boolean assistunit = false;
            DynamicObject material = currentItem.getDynamicObject("material");
            if (material != null && (bdmaterial = QueryServiceHelper.queryOne((String)"bd_material", (String)"isuseauxpty", (QFilter[])new QFilter[]{new QFilter("id", "=", material.getPkValue())})) != null) {
                assistunit = bdmaterial.getBoolean("isuseauxpty");
            }
            if (!assistunit) {
                this.getView().setEnable(Boolean.FALSE, rowNo, new String[]{"auxptyid"});
            } else {
                this.getView().setEnable(Boolean.TRUE, rowNo, new String[]{"auxptyid"});
            }
        }
    }

    private void changeMaterialColumn(int i, DynamicObject currentItem) {
        if (null != currentItem) {
            DynamicObject material4Item = (DynamicObject)currentItem.get("material");
            if (null == material4Item) {
                this.getModel().setValue("materialid", null, i);
                this.getView().setEnable(Boolean.TRUE, i, new String[]{"materialid"});
            } else {
                this.getModel().setValue("materialid", (Object)material4Item.getLong("id"), i);
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"materialid"});
            }
        }
    }

    protected void setOrgAndChannel() {
        DynamicObject inChannel = (DynamicObject)this.getModel().getValue("inchannelid");
        if (null != inChannel) {
            this.setOrgAndChannel(inChannel);
        }
    }

    private void setOrgAndChannel(DynamicObject inChannel) {
        DynamicObject saleOrg = null;
        if (null != inChannel) {
            DynamicObject[] ids;
            DynamicObject saleorg = (DynamicObject)inChannel.get("saleorg");
            if (null != saleorg && null != (ids = BusinessDataServiceHelper.load((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("bos_org.id", "=", saleorg.getPkValue())})) && ids.length > 0) {
                saleOrg = ids[0];
            }
            this.getModel().setValue("org", saleOrg);
        }
    }

    private void clearOrgAndChannel() {
        this.getModel().setValue("org", null);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        DynamicObject lot_number_id;
        if (!StringUtils.equals((CharSequence)"bar_save", (CharSequence)evt.getItemKey()) || (lot_number_id = (DynamicObject)this.getModel().getValue("lotnumberid")) == null) {
            // empty if block
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        switch (name = e.getProperty().getName()) {
            case "warehouse": {
                int rowIndex = this.getRowIndex(e);
                this.clearLocationId(rowIndex);
                this.checkStockLocation(e);
                break;
            }
            case "inchannelid": {
                this.getModel().deleteEntryData("billentry");
                this.changeAllRowOwnerAndSetter();
                this.changeAllDefaultWareHouse();
                this.preSetSupplyChannelIdChange();
                this.setSaleOrg();
                this.clearOrgAndChannel();
                this.setOrgAndChannel();
                this.setCurrency();
                break;
            }
            case "itemid": {
                DynamicObject newItem = (DynamicObject)e.getChangeSet()[0].getNewValue();
                int rowNo = this.getRowIndex(e);
                this.clearAllSubEntryRows(rowNo);
                this.setDefaultValues(rowNo);
                this.lockDataAfterReviseRowItemId(rowNo, newItem);
                this.ifDisableLockSerialNum();
                this.setOwnerAndKeeper(rowNo);
                this.setDefaultWareHouseID(rowNo);
                this.setStockStatusAndStockType(rowNo);
                this.setSerialNumberUnitAndQty(rowNo, newItem);
                break;
            }
            case "qty": {
                int i = this.getRowIndex(e);
                DynamicObject item = this.getModel().getEntryRowEntity("billentry", i).getDynamicObject("itemid");
                if (item == null) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5546\u54c1", (String)"StockInBillEdit_1", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.afterQtyChange(e);
                this.setSerialNumberUnitAndQty(i, item);
                this.recalSumQty();
                break;
            }
            case "unitid": {
                int i_unit = this.getRowIndex(e);
                DynamicObject item_unit = this.getModel().getEntryRowEntity("billentry", i_unit).getDynamicObject("itemid");
                if (item_unit != null) {
                    this.afterUnitChange(e);
                    this.setSerialNumberUnitAndQty(i_unit, item_unit);
                    break;
                }
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5546\u54c1", (String)"StockInBillEdit_1", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
                return;
            }
            case "serialid": {
                Object serialObj = this.getValue("serialid");
                if (null == serialObj) break;
                int irow = this.getRowIndex(e);
                this.getView().getModel().setValue("serialnumber", (Object)((DynamicObject)serialObj).getString("number"), irow);
                break;
            }
            case "lotnumberid": {
                Object obj = this.getValue("lotnumberid");
                if (null == obj) break;
                int ilot = this.getRowIndex(e);
                this.getView().getModel().setValue("lotnumber", (Object)((DynamicObject)obj).getString("number"), ilot);
                break;
            }
            case "lotnumber": {
                int i_row = this.getRowIndex(e);
                this.reloadLotId(i_row);
                this.relLotNumberSpace(this.getRowIndex(e));
                this.setDate(this.getRowIndex(e));
                break;
            }
            case "serialnumber": {
                this.relSnNumberSpace(this.getRowIndex(e));
                break;
            }
            case "sninput": {
                String snInput = String.valueOf(this.getModel().getValue(SNINPUT)).trim();
                if (StringUtils.isEmpty((CharSequence)snInput)) break;
                int rowIndex = this.getCurrentRowIndex("billentry");
                ArrayList<String> snList = new ArrayList<String>();
                snList.add(snInput);
                List<String> existSnList = this.checkSnExist(snList);
                this.addSnToEntry(existSnList, snList);
                this.getModel().setValue(SNINPUT, (Object)"");
                break;
            }
        }
    }

    private void addSnToEntry(List<String> existSnList, List<String> snList) {
        Object result;
        if (snList == null || snList.isEmpty()) {
            return;
        }
        JSONArray data = null;
        long channelId = (Long)this.getModel().getValue("inchannelid_id");
        long billtypeid = (Long)this.getModel().getValue("billtypeid_id");
        if (billtypeid == 1028239792493724672L) {
            String snStatus = SnStatusEnum.INSTOCK.getValue();
            result = CSerialHelper.getSerialDataByScanNumber(snList, (Long)channelId, (String)snStatus);
            data = result.getJSONArray("data");
            if (data.isEmpty()) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5e8f\u5217\u53f7:%s\u4e0d\u5b58\u5728\u6216\u8005\u975e\u5728\u5e93\u72b6\u6001\u3002", (String)"StockInBillEdit_28", (String)"occ-ococic-formplugin", (Object[])new Object[0]), Arrays.toString(snList.toArray())));
                return;
            }
        } else {
            List<String> snStatusList = Arrays.asList(SnStatusEnum.ONWAY.getValue(), SnStatusEnum.CHANNELOUTSTOCK.getValue(), SnStatusEnum.RETURNOUTSTOCK.getValue());
            result = CSerialHelper.getSerialDataByScanNumber(snList, (Long)channelId, snStatusList);
            data = result.getJSONArray("data");
            if (data.isEmpty()) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5e8f\u5217\u53f7:%s\u4e0d\u5b58\u5728\u6216\u8005\u975e\u201c\u5728\u9014\u3001\u6e20\u9053\u51fa\u5e93\u3001\u9000\u8d27\u51fa\u5e93\u201d\u72b6\u6001\u3002", (String)"StockInBillEdit_31", (String)"occ-ococic-formplugin", (Object[])new Object[0]), Arrays.toString(snList.toArray())));
                return;
            }
        }
        HashMap<String, List<JSONObject>> snKeyMap = new HashMap<String, List<JSONObject>>();
        for (JSONObject json : data.toJavaList(JSONObject.class)) {
            String serialno = json.getString("serialno");
            if (existSnList.contains(serialno)) continue;
            String key = String.join((CharSequence)"_", json.getString("itemid"), json.getString("auxptyid"), json.getString("lotid"), json.getString("channelstockid"), json.getString("channellocationid"), json.getString("channelstockstatusid"), json.getString("channelstocktypeid"), json.getString("ownerid"), json.getString("ownertype"), json.getString("keeperid"), json.getString("keepertype"), json.getString("projectid"), this.formatDate(json.getDate("productdate")), this.formatDate(json.getDate("effectivedate")));
            if (snKeyMap.containsKey(key) && snKeyMap.get(key) != null) {
                ((List)snKeyMap.get(key)).add(json);
                continue;
            }
            ArrayList<JSONObject> jsonList = new ArrayList<JSONObject>();
            jsonList.add(json);
            snKeyMap.put(key, jsonList);
        }
        this.snMatchEntry(snKeyMap);
        this.snAddEntry(snKeyMap);
        DynamicObjectCollection billEntryEntity = this.getModel().getEntryEntity("billentry");
        BusinessDataServiceHelper.loadRefence((Object[])billEntryEntity.toArray(), (IDataEntityType)billEntryEntity.getDynamicObjectType());
        this.getModel().setValue("billentry", (Object)billEntryEntity);
        this.getModel().updateEntryCache(billEntryEntity);
        this.getView().updateView();
        this.recalSumQty();
    }

    private String formatDate(Date date) {
        if (date != null) {
            return new SimpleDateFormat("yyyy-MM-dd").format(date);
        }
        return "";
    }

    private void snMatchEntry(Map<String, List<JSONObject>> snKeyMap) {
        DynamicObjectCollection billEntryEntity = this.getModel().getEntryEntity("billentry");
        if (billEntryEntity != null && !billEntryEntity.isEmpty()) {
            int rowindex = 0;
            for (DynamicObject billEntry : billEntryEntity) {
                ++rowindex;
                String key = String.join((CharSequence)"_", billEntry.getString("itemid_id"), billEntry.getString("auxptyid_id"), billEntry.getString("lotnumberid_id"), billEntry.getString("warehouse_id"), billEntry.getString("locationid_id"), billEntry.getString("stockstatus_id"), billEntry.getString("stocktype_id"), billEntry.getString("ownerid_id"), billEntry.getString("ownertype"), billEntry.getString("keeperid_id"), billEntry.getString("keepertype"), billEntry.getString("projectid_id"), this.formatDate(billEntry.getDate("producedate")), this.formatDate(billEntry.getDate("expirydate")));
                if (!snKeyMap.containsKey(key)) continue;
                String srcbillnumber = billEntry.getString("sourcecode");
                BigDecimal snQty = billEntry.getBigDecimal("serialqty");
                DynamicObjectCollection snEntry = billEntry.getDynamicObjectCollection("subentryentity");
                if (!StringUtils.isEmpty((CharSequence)srcbillnumber)) {
                    int snEntryCount = snKeyMap.get(key).size();
                    if (!CollectionUtils.isEmpty((Collection)snEntry)) {
                        snEntryCount += snEntry.size();
                    }
                    if (snEntryCount > snQty.intValue()) {
                        snKeyMap.clear();
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\uff0c\u5e8f\u5217\u53f7\u6570\u91cf\u5df2\u8d85\u5546\u54c1\u6570\u91cf\uff01", (String)"StockInBillEdit_30", (String)"occ-ococic-formplugin", (Object[])new Object[0]), rowindex));
                        return;
                    }
                } else {
                    snQty = snQty.add(new BigDecimal(snKeyMap.get(key).size()));
                    billEntry.set("serialqty", (Object)snQty);
                    long snUnitId = billEntry.getLong("serialunit_id");
                    long unitId = billEntry.getLong("unitid_id");
                    long baseUnitId = billEntry.getLong("baseunitid_id");
                    long assistUnitId = billEntry.getLong("assistunitid_id");
                    long materialId = billEntry.getLong("materialid_id");
                    BigDecimal baseQty = UnitConvertHelper.calculateDestQty((BigDecimal)snQty, (Long)materialId, (Long)snUnitId, (Long)baseUnitId);
                    billEntry.set("baseqty", (Object)baseQty);
                    BigDecimal qty = UnitConvertHelper.calculateDestQty((BigDecimal)baseQty, (Long)materialId, (Long)baseUnitId, (Long)unitId);
                    billEntry.set("qty", (Object)qty);
                    BigDecimal assistQty = UnitConvertHelper.calculateDestQty((BigDecimal)baseQty, (Long)materialId, (Long)baseUnitId, (Long)assistUnitId);
                    billEntry.set("assistqty", (Object)assistQty);
                }
                for (JSONObject json : snKeyMap.get(key)) {
                    DynamicObject sn = snEntry.addNew();
                    sn.set("serialnumber", (Object)json.getString("serialno"));
                    sn.set("serialid_id", (Object)json.getLong("serialid"));
                }
                snKeyMap.remove(key);
            }
        }
    }

    private void snAddEntry(Map<String, List<JSONObject>> snKeyMap) {
        DynamicObjectCollection billEntryEntity = this.getModel().getEntryEntity("billentry");
        if (!snKeyMap.isEmpty()) {
            DynamicObject outChannel = (DynamicObject)this.getModel().getValue("inchannelid");
            String snmanager = DynamicObjectUtils.getString((DynamicObject)outChannel, (String)"snmanager");
            for (Map.Entry<String, List<JSONObject>> snMapEntry : snKeyMap.entrySet()) {
                List<JSONObject> jsonList = snMapEntry.getValue();
                DynamicObject billEntry = billEntryEntity.addNew();
                billEntry.set("itemid_id", (Object)jsonList.get(0).getLong("itemid"));
                billEntry.set("auxptyid_id", (Object)jsonList.get(0).getLong("auxptyid"));
                billEntry.set("lotnumber", (Object)jsonList.get(0).getString("lotnum"));
                billEntry.set("lotnumberid_id", (Object)jsonList.get(0).getLong("lotid"));
                billEntry.set("warehouse_id", (Object)jsonList.get(0).getLong("channelstockid"));
                billEntry.set("locationid_id", (Object)jsonList.get(0).getLong("channellocationid"));
                billEntry.set("stockstatus_id", (Object)jsonList.get(0).getLong("channelstockstatusid"));
                billEntry.set("stocktype_id", (Object)jsonList.get(0).getLong("channelstocktypeid"));
                billEntry.set("ownerid_id", (Object)jsonList.get(0).getLong("ownerid"));
                billEntry.set("ownertype", (Object)jsonList.get(0).getString("ownertype"));
                billEntry.set("keeperid_id", (Object)jsonList.get(0).getLong("keeperid"));
                billEntry.set("keepertype", (Object)jsonList.get(0).getString("keepertype"));
                billEntry.set("projectid_id", (Object)jsonList.get(0).getLong("projectid"));
                billEntry.set("producedate", (Object)jsonList.get(0).getDate("productdate"));
                billEntry.set("expirydate", (Object)jsonList.get(0).getDate("effectivedate"));
                long materialId = jsonList.get(0).getLong("material");
                billEntry.set("materialid_id", (Object)materialId);
                BigDecimal snQty = new BigDecimal(jsonList.size());
                long snUnitId = jsonList.get(0).getLong("serialunit");
                long unitId = jsonList.get(0).getLong("stockunit");
                long baseUnitId = jsonList.get(0).getLong("baseunit");
                long assistUnitId = jsonList.get(0).getLong("assistunit");
                billEntry.set("serialunit_id", (Object)snUnitId);
                billEntry.set("unitid_id", (Object)unitId);
                billEntry.set("assistunitid_id", (Object)assistUnitId);
                billEntry.set("baseunitid_id", (Object)baseUnitId);
                BigDecimal baseQty = UnitConvertHelper.calculateDestQty((BigDecimal)snQty, (Long)materialId, (Long)snUnitId, (Long)baseUnitId);
                billEntry.set("baseqty", (Object)baseQty);
                BigDecimal qty = UnitConvertHelper.calculateDestQty((BigDecimal)baseQty, (Long)materialId, (Long)baseUnitId, (Long)unitId);
                billEntry.set("qty", (Object)qty);
                BigDecimal assistQty = UnitConvertHelper.calculateDestQty((BigDecimal)baseQty, (Long)materialId, (Long)baseUnitId, (Long)assistUnitId);
                billEntry.set("assistqty", (Object)assistQty);
                DynamicObjectCollection snEntry = billEntry.getDynamicObjectCollection("subentryentity");
                if (!snmanager.equals("A")) continue;
                billEntry.set("serialqty", (Object)snQty);
                for (JSONObject json : jsonList) {
                    DynamicObject sn = snEntry.addNew();
                    sn.set("serialnumber", (Object)json.getString("serialno"));
                    sn.set("serialid_id", (Object)json.getLong("serialid"));
                }
            }
        }
    }

    private List<String> checkSnExist(List<String> snList) {
        ArrayList<String> existSnList = new ArrayList<String>();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("billentry");
        if (!CollectionUtils.isEmpty((Collection)entryEntity)) {
            for (DynamicObject rowEntry : entryEntity) {
                DynamicObjectCollection subEntryList = rowEntry.getDynamicObjectCollection("subentryentity");
                if (subEntryList == null || subEntryList.isEmpty()) continue;
                for (DynamicObject subEntry : subEntryList) {
                    String snnum = subEntry.getString("serialnumber");
                    existSnList.add(snnum);
                    if (StringUtils.isEmpty((CharSequence)snnum) || !snList.contains(snnum)) continue;
                    snList.remove(snnum);
                }
            }
        }
        return existSnList;
    }

    private void setDate(int row) {
        DynamicObject lotnumberid = (DynamicObject)this.getValue("lotnumberid", row);
        if (lotnumberid != null) {
            long lotNumberId = (Long)lotnumberid.getPkValue();
            DynamicObject lot = BusinessDataServiceHelper.loadSingle((String)"ococic_lot", (String)"entryid,productdate,expiredate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)lotNumberId)});
            DynamicObjectCollection lotDate = (DynamicObjectCollection)lot.get("ococic_lotdate");
            if (lotDate.size() > 0) {
                this.setValue("producedate", ((DynamicObject)lotDate.get(0)).get("productdate"), row);
                this.setValue("expirydate", ((DynamicObject)lotDate.get(0)).get("expiredate"), row);
            } else {
                this.setValue("producedate", null, row);
                this.setValue("expirydate", null, row);
            }
        }
    }

    private void reloadLotId(int row) {
        String number;
        this.getView().getModel().setItemValueByID("lotnumberid", null, row);
        DynamicObject item = (DynamicObject)this.getModel().getEntryRowEntity("billentry", row).get("itemid");
        if (item == null) {
            return;
        }
        long itemId = item.getLong("id");
        DynamicObject auxpty = (DynamicObject)this.getModel().getEntryRowEntity("billentry", row).get("auxptyid");
        QFilter auxptyFilter = null;
        if (null != auxpty) {
            Long auxptyId = (Long)auxpty.getPkValue();
            auxptyFilter = new QFilter("auxptyid", "=", (Object)auxptyId);
        }
        if ((number = (String)this.getModel().getEntryRowEntity("billentry", row).get("lotnumber")) != null) {
            QFilter idFilter;
            QFilter itemidFilter = new QFilter("itemid", "=", (Object)itemId);
            DynamicObject[] result = BusinessDataServiceHelper.load((String)"ococic_lot", (String)"id,enable", (QFilter[])new QFilter[]{itemidFilter, auxptyFilter, idFilter = new QFilter("number", "=", (Object)number)});
            if (null != result && result.length > 0) {
                if (result[0].getString("enable").equals("0")) {
                    this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u5546\u54c1%1$s\u7684\u6279\u53f7%2$s\u88ab\u7981\u7528\uff0c\u8bf7\u5148\u542f\u7528\u6b64\u6279\u53f7", (String)"StockInBillEdit_27", (String)"occ-ococic-formplugin", (Object[])new Object[0]), item.getString("number"), number));
                    return;
                }
                Long rs = result[0].getLong("id");
                this.getView().getModel().setValue("lotnumberid", (Object)rs, row);
            } else {
                this.getView().getModel().setValue("lotnumberid", null, row);
            }
        }
    }

    private void relLotNumberSpace(int row) {
        DynamicObject dynamicObject = this.getModel().getEntryRowEntity("billentry", row);
        String lotNumber = dynamicObject.getString("lotnumber");
        if (lotNumber != null) {
            lotNumber = lotNumber.replaceAll("\u3000", " ").trim();
            this.setValue("lotnumber", lotNumber, row, false);
        }
    }

    private void relSnNumberSpace(int row) {
        DynamicObject dynamicObject = this.getModel().getEntryRowEntity("subentryentity", row);
        String fieldValue = dynamicObject.getString("serialnumber");
        if (fieldValue != null) {
            fieldValue = fieldValue.replaceAll("\u3000", " ").trim();
            this.setValue("serialnumber", fieldValue, row, false);
        }
    }

    private void clearAllSubEntryRows(int i) {
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("billentry", i);
        DynamicObjectCollection subEntries = entryRowEntity.getDynamicObjectCollection("subentryentity");
        int rowCount = subEntries.getRowCount();
        if (rowCount > 0) {
            int[] rows = new int[rowCount];
            for (int j = 0; j < rowCount; ++j) {
                rows[j] = j;
            }
            this.getModel().deleteEntryRows("subentryentity", rows);
        }
    }

    private void setSerialNumberUnitAndQty(int i, DynamicObject itemObject) {
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("billentry", i);
        if (itemObject == null) {
            return;
        }
        if (itemObject.getBoolean("enableserial")) {
            DynamicObject serialUnit = (DynamicObject)itemObject.get("serialunit");
            if (null != serialUnit) {
                DynamicObject baseUnit;
                Long baseUnitId;
                BigDecimal serialQty;
                this.getModel().setValue("serialunit", serialUnit.getPkValue(), i);
                Long serialUnitId = (Long)serialUnit.getPkValue();
                DynamicObject material = entryRowEntity.getDynamicObject("materialid");
                Long materialId = material != null ? (Long)material.getPkValue() : 0L;
                BigDecimal baseQty = entryRowEntity.getBigDecimal("baseqty");
                if (baseQty != null && this.MAX_QTY.compareTo(baseQty) < 0) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u6570\u91cf\u8d85\u51fa\u7cbe\u5ea6\u9650\u5236\uff0c\u8bf7\u786e\u8ba4", (String)"StockInBillEdit_20", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (null == baseQty) {
                    baseQty = BigDecimal.ZERO;
                }
                if (this.MAX_QTY.compareTo(serialQty = UnitConvertHelper.calculateDestQty((BigDecimal)baseQty, (Long)materialId, (Long)(baseUnitId = Long.valueOf((baseUnit = entryRowEntity.getDynamicObject("baseunitid")) != null ? (Long)baseUnit.getPkValue() : 0L)), (Long)serialUnitId)) < 0) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u6570\u91cf\u8d85\u51fa\u7cbe\u5ea6\u9650\u5236\uff0c\u8bf7\u786e\u8ba4", (String)"StockInBillEdit_21", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.setRowValue("serialqty", serialQty, i);
            } else {
                this.getModel().setValue("serialunit", null, i);
                this.getModel().setValue("serialqty", (Object)0, i);
                this.setUnEnable(i, new String[]{"serialunit", "serialqty"});
            }
        }
    }

    private void checkStockLocationAfterBind() {
        int entryRowCount = this.getModel().getEntryRowCount("billentry");
        for (int i = 0; i < entryRowCount; ++i) {
            DynamicObject newStock = (DynamicObject)this.getModel().getEntryRowEntity("billentry", i).get("warehouse");
            if (newStock == null) continue;
            boolean enablelocation = newStock.getBoolean("enablelocation");
            if (enablelocation) {
                this.getView().setEnable(Boolean.TRUE, i, new String[]{"locationid"});
                continue;
            }
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"locationid"});
        }
    }

    private void checkStockLocation(PropertyChangedArgs e) {
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        DynamicObject newStock = (DynamicObject)e.getChangeSet()[0].getNewValue();
        if (null != newStock) {
            DynamicObject dynamicObject;
            boolean enableLocation = newStock.getBoolean("enablelocation");
            this.getView().setEnable(Boolean.valueOf(enableLocation), rowIndex, new String[]{"locationid"});
            if (enableLocation && null != (dynamicObject = BusinessDataServiceHelper.loadSingle((String)"ococic_location", (String)"id", (QFilter[])new QFilter[]{new QFilter("warehouseid", "=", newStock.getPkValue()), new QFilter("isdefault", "=", (Object)Boolean.TRUE), new QFilter("enable", "=", (Object)"1")}))) {
                this.getModel().setValue("locationid", dynamicObject.getPkValue(), rowIndex);
            }
        }
    }

    protected void setCurrency() {
        DynamicObject inChannel = this.getInChannelObject();
        if (inChannel != null) {
            DynamicObject currency = inChannel.getDynamicObject("currency");
            this.getModel().setValue("settlecurrencyid", currency.getPkValue());
            this.getView().setEnable(Boolean.FALSE, new String[]{"settlecurrencyid"});
        } else {
            this.getModel().setValue("settlecurrencyid", null);
        }
    }

    private void clearLocationId(int rowIndex) {
        this.getModel().setValue("locationid", null, rowIndex);
    }

    private void changeIntypeValue() {
        this.getModel().setValue("intype", (Object)"1");
    }

    private void preSetSupplyChannelIdChange() {
        String billTypeNumber;
        this.getModel().setValue("supplychannelid", null);
        if (this.getInChannelObject() == null) {
            return;
        }
        DynamicObject billType = (DynamicObject)this.getModel().getValue("billtypeid");
        if (null != billType && "ococic_in_sys009".equals(billTypeNumber = billType.getString("number"))) {
            List<Long> ids = this.getSaleChannelsFromOcdbdChannelAuthorize();
            if (ids.size() == 0) {
                return;
            }
            DynamicObject[] result = BusinessDataServiceHelper.load((String)"ocdbd_channel", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", ids), new QFilter("enable", "=", (Object)"1")});
            if (null != result && 0 < result.length) {
                this.getModel().setValue("supplychannelid", (Object)result[0].getLong("id"));
            }
        }
    }

    private void setSaleOrg() {
        List<Long> ids;
        String billTypeNumber;
        this.getModel().setValue("supplychannelid", null);
        if (this.getInChannelObject() == null) {
            return;
        }
        DynamicObject billType = (DynamicObject)this.getModel().getValue("billtypeid");
        if (null != billType && !"ococic_in_sys009".equals(billTypeNumber = billType.getString("number")) && (ids = this.getSaleOrgsFromOcdbdChannelAuthorize()).size() > 0) {
            this.getModel().setValue("saleorg", (Object)ids.get(0));
        }
    }

    private void afterQtyChange(PropertyChangedArgs e) {
        DynamicObject serialUnit;
        DynamicObject auxunit;
        int rowIndex = this.getRowIndex(e);
        DynamicObject rowEntry = this.getModel().getEntryRowEntity("billentry", rowIndex);
        if (rowEntry == null) {
            return;
        }
        this.setALLQTYZERO(rowIndex);
        ChangeData[] changeDatas = e.getChangeSet();
        if (changeDatas == null || changeDatas.length <= 0) {
            return;
        }
        BigDecimal qty = (BigDecimal)changeDatas[0].getNewValue();
        DynamicObject material = rowEntry.getDynamicObject("materialid");
        long materielId = 0L;
        if (material != null && material.getPkValue() != null) {
            materielId = (Long)material.getPkValue();
        }
        long srcUnitId = 0L;
        DynamicObject unit = rowEntry.getDynamicObject("unitid");
        if (unit != null) {
            srcUnitId = (Long)unit.getPkValue();
        }
        DynamicObject baseunit = rowEntry.getDynamicObject("baseunitid");
        long baseUnitId = 0L;
        BigDecimal baseQty = BigDecimal.ZERO;
        if (null != baseunit) {
            baseUnitId = (Long)baseunit.getPkValue();
            baseQty = UnitConvertHelper.calculateDestQty((BigDecimal)qty, (Long)materielId, (Long)srcUnitId, (Long)baseUnitId);
            if (this.MAX_QTY.compareTo(baseQty) < 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6570\u91cf\u8d85\u51fa\u7cbe\u5ea6\u9650\u5236\uff0c\u8bf7\u786e\u8ba4", (String)"StockInBillEdit_20", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
                return;
            }
            this.setRowValue("baseqty", baseQty, rowIndex);
        }
        if (null != (auxunit = rowEntry.getDynamicObject("assistunitid"))) {
            long assistantUnitId = (Long)auxunit.getPkValue();
            BigDecimal assistantQty = UnitConvertHelper.calculateDestQty((BigDecimal)qty, (Long)materielId, (Long)srcUnitId, (Long)assistantUnitId);
            if (this.MAX_QTY.compareTo(assistantQty) < 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8f85\u52a9\u6570\u91cf\u8d85\u51fa\u7cbe\u5ea6\u9650\u5236\uff0c\u8bf7\u786e\u8ba4", (String)"StockInBillEdit_22", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
                return;
            }
            this.setRowValue("assistqty", assistantQty, rowIndex);
        }
        if (null != (serialUnit = rowEntry.getDynamicObject("serialunit"))) {
            long serialUnitId = (Long)serialUnit.getPkValue();
            BigDecimal serialQty = UnitConvertHelper.calculateDestQty((BigDecimal)baseQty, (Long)materielId, (Long)baseUnitId, (Long)serialUnitId);
            if (this.MAX_QTY.compareTo(serialQty) < 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u6570\u91cf\u8d85\u51fa\u7cbe\u5ea6\u9650\u5236\uff0c\u8bf7\u786e\u8ba4", (String)"StockInBillEdit_21", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
                return;
            }
            this.setRowValue("serialqty", serialQty, rowIndex);
        }
    }

    private void afterUnitChange(PropertyChangedArgs e) {
        DynamicObject serialUnit;
        DynamicObject auxunit;
        int rowIndex = this.getRowIndex(e);
        DynamicObject rowEntry = this.getModel().getEntryRowEntity("billentry", rowIndex);
        if (rowEntry == null) {
            return;
        }
        this.setALLQTYZERO(rowIndex);
        ChangeData[] changeDatas = e.getChangeSet();
        if (changeDatas == null || changeDatas.length <= 0) {
            return;
        }
        long srcUnitId = 0L;
        DynamicObject unit = (DynamicObject)changeDatas[0].getNewValue();
        if (unit != null) {
            srcUnitId = (Long)unit.getPkValue();
        }
        BigDecimal qty = rowEntry.getBigDecimal("qty");
        DynamicObject material = rowEntry.getDynamicObject("materialid");
        long materielId = 0L;
        if (material != null && material.getPkValue() != null) {
            materielId = (Long)material.getPkValue();
        }
        DynamicObject baseunit = rowEntry.getDynamicObject("baseunitid");
        long baseUnitId = 0L;
        BigDecimal baseQty = BigDecimal.ZERO;
        if (null != baseunit) {
            baseUnitId = (Long)baseunit.getPkValue();
            baseQty = UnitConvertHelper.calculateDestQty((BigDecimal)qty, (Long)materielId, (Long)srcUnitId, (Long)baseUnitId);
            if (this.MAX_QTY.compareTo(baseQty) < 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6570\u91cf\u8d85\u51fa\u7cbe\u5ea6\u9650\u5236\uff0c\u8bf7\u786e\u8ba4", (String)"StockInBillEdit_20", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
                return;
            }
            this.setRowValue("baseqty", baseQty, rowIndex);
        }
        if (null != (auxunit = rowEntry.getDynamicObject("assistunitid"))) {
            long assistantUnitId = (Long)auxunit.getPkValue();
            BigDecimal assistantQty = UnitConvertHelper.calculateDestQty((BigDecimal)qty, (Long)materielId, (Long)srcUnitId, (Long)assistantUnitId);
            if (this.MAX_QTY.compareTo(assistantQty) < 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8f85\u52a9\u6570\u91cf\u8d85\u51fa\u7cbe\u5ea6\u9650\u5236\uff0c\u8bf7\u786e\u8ba4", (String)"StockInBillEdit_22", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
                return;
            }
            this.setRowValue("assistqty", assistantQty, rowIndex);
        }
        if (null != (serialUnit = rowEntry.getDynamicObject("serialunit"))) {
            long serialUnitId = (Long)serialUnit.getPkValue();
            BigDecimal serialQty = UnitConvertHelper.calculateDestQty((BigDecimal)baseQty, (Long)materielId, (Long)baseUnitId, (Long)serialUnitId);
            if (this.MAX_QTY.compareTo(serialQty) < 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u6570\u91cf\u8d85\u51fa\u7cbe\u5ea6\u9650\u5236\uff0c\u8bf7\u786e\u8ba4", (String)"StockInBillEdit_21", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
                return;
            }
            this.setRowValue("serialqty", serialQty, rowIndex);
        }
    }

    private void ifDisableLockSerialNumberColumn(BeforeDoOperationEventArgs ea) {
        if (1 > this.getModel().getEntryRowCount("billentry")) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u6dfb\u52a0\u5546\u54c1\u4fe1\u606f\u3002", (String)"StockInBillEdit_23", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
            return;
        }
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("billentry");
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("billentry", entryCurrentRowIndex);
        DynamicObject item = entryRowEntity.getDynamicObject("itemid");
        if (null != item) {
            boolean enableserial = item.getBoolean("enableserial");
            if (!enableserial) {
                ea.setCancel(true);
                this.getView().showMessage(ResManager.loadKDString((String)"\u5546\u54c1\u672a\u542f\u7528\u5e8f\u5217\u53f7\u7ba1\u7406\uff0c\u4e0d\u5141\u8bb8\u5f55\u5165\u5e8f\u5217\u53f7\u3002", (String)"StockInBillEdit_24", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
            }
        } else {
            ea.setCancel(true);
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5546\u54c1\u3002", (String)"StockInBillEdit_10", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
        }
    }

    private boolean isEmptyEntry() {
        return 1 > this.getModel().getEntryRowCount("billentry");
    }

    private void ifDisableLockSerialNum() {
        boolean enableserial;
        DynamicObject item;
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("billentry");
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("billentry", entryCurrentRowIndex);
        if (null != entryRowEntity && null != (item = entryRowEntity.getDynamicObject("itemid")) && (enableserial = item.getBoolean("enableserial"))) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"sn_addrow"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"sn_deleterow"});
        }
    }

    private void changeAllRowOwnerAndSetter() {
        int entryRowCount = this.getModel().getEntryRowCount("billentry");
        for (int i = 0; i < entryRowCount; ++i) {
            this.setOwnerAndKeeper(i);
        }
    }

    private void changeAllDefaultWareHouse() {
        int entryRowCount = this.getModel().getEntryRowCount("billentry");
        for (int i = 0; i < entryRowCount; ++i) {
            this.setDefaultWareHouseID(i);
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        String entryName;
        super.afterDeleteRow(e);
        switch (entryName = e.getEntryProp().getName()) {
            case "billentry": {
                this.recalSumQty();
                break;
            }
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
        Map sourceDataMap = e.getSourceData();
        JSONArray billentries = (JSONArray)sourceDataMap.get("billentry");
        int size = billentries.size();
        Map<String, Long> stockMap = this.getStokMap(sourceDataMap);
        for (int i = 0; i < size; ++i) {
            JSONObject locationObject;
            String stockNumber = (String)((JSONObject)billentries.get(i)).getJSONObject("warehouse").get((Object)"number");
            if (!stockMap.containsKey(stockNumber) || (locationObject = ((JSONObject)billentries.get(i)).getJSONObject("locationid")) != null) continue;
            e.setCancel(true);
            ArrayList<String> msgList = new ArrayList<String>(1);
            msgList.add(ResManager.loadKDString((String)"\u4ed3\u5e93\u542f\u7528\u4ed3\u4f4d\uff0c\u4ed3\u4f4d\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539.", (String)"StockInBillEdit_25", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
            e.setCancelMessages(Integer.valueOf(i), Integer.valueOf(0), msgList);
            e.setFireAfterImportData(false);
        }
    }

    private Map<String, Long> getStokMap(Map<String, Object> data) {
        JSONArray billentries = (JSONArray)data.get("billentry");
        int size = billentries.size();
        HashSet<String> stockMapset = new HashSet<String>(10);
        for (int i = 0; i < size; ++i) {
            String stockNumber_each = (String)((JSONObject)billentries.get(i)).getJSONObject("warehouse").get((Object)"number");
            stockMapset.add(stockNumber_each);
        }
        QFilter allstockFilter = new QFilter("number", "in", stockMapset);
        DynamicObjectCollection stockCollection = QueryServiceHelper.query((String)"ococic_warehouse", (String)"id,number,enablelocation", (QFilter[])allstockFilter.toArray());
        HashMap<String, Long> stockMap = new HashMap<String, Long>(10);
        if (stockCollection != null && stockCollection.size() > 0) {
            for (int i = 0; i < stockCollection.size(); ++i) {
                if (!((DynamicObject)stockCollection.get(i)).getBoolean("enablelocation")) continue;
                stockMap.put(((DynamicObject)stockCollection.get(i)).getString("number"), ((DynamicObject)stockCollection.get(i)).getLong("id"));
            }
        }
        return stockMap;
    }

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        DynamicObjectCollection entriesCol = this.getModel().getEntryEntity("billentry");
        for (int i = 0; i < entriesCol.size(); ++i) {
            boolean enableLocation;
            DynamicObject warehouse = this.getF7Value("warehouse", i);
            if (null == warehouse || !(enableLocation = warehouse.getBoolean("enablelocation"))) continue;
            QFilter qFilter = new QFilter("warehouseid", "=", warehouse.getPkValue());
            qFilter = qFilter.and("isdefault", "=", (Object)Boolean.TRUE);
            List locationIdList = QueryServiceHelper.queryPrimaryKeys((String)"ococic_location", (QFilter[])(qFilter = qFilter.and("enable", "=", (Object)Enable.ENABLE.toString())).toArray(), (String)"", (int)1);
            if (CollectionUtils.isEmpty((Collection)locationIdList)) continue;
            this.setValue("locationid", locationIdList.get(0), i);
        }
        this.recalSumQty();
    }

    private void recalSumQty() {
        BigDecimal sumqty = BigDecimal.ZERO;
        DynamicObjectCollection entity = this.getModel().getEntryEntity("billentry");
        for (DynamicObject entry : entity) {
            BigDecimal qty = entry.getBigDecimal("qty");
            sumqty = sumqty.add(qty);
        }
        this.setValue("sumqty", sumqty);
    }

    private void updateBillValuesForStockIn(Map<String, Object> customParams) {
        this.getModel().setValue("inchannelid", customParams.get("inchannelid"));
        this.getModel().setValue("billtypeid", customParams.get("billtypeid"));
        this.getModel().setValue("org", customParams.get("org"));
        this.getModel().setValue("settlecurrencyid", customParams.get("settlecurrencyid"));
        this.getModel().setValue("saleorg", customParams.get("saleorg"));
        this.getModel().setValue("comment", (Object)ResManager.loadKDString((String)"\u5e93\u5b58\u5165\u5e93", (String)"StockInBillEdit_26", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
        this.getModel().setValue("sumqty", customParams.get("sumqty"));
        DynamicObjectCollection entries = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("billentry");
        entries.clear();
        DynamicObject newEntry = entries.addNew();
        newEntry.set("itemid_id", customParams.get("itemid"));
        newEntry.set("materialid_id", customParams.get("materialid"));
        newEntry.set("unitid_id", customParams.get("unitid"));
        newEntry.set("auxptyid_id", customParams.get("auxptyid"));
        newEntry.set("lotnumber", customParams.get("lotnumber"));
        newEntry.set("lotnumberid_id", customParams.get("lotnumberid"));
        newEntry.set("projectid_id", customParams.get("projectid"));
        if (customParams.get("producedate") != null) {
            newEntry.set("producedate", (Object)DateUtil.getDateFormat((String)customParams.get("producedate").toString()));
        }
        if (customParams.get("expirydate") != null) {
            newEntry.set("expirydate", (Object)DateUtil.getDateFormat((String)customParams.get("expirydate").toString()));
        }
        newEntry.set("unitid_id", customParams.get("unitid"));
        newEntry.set("qty", customParams.get("qty"));
        newEntry.set("baseunitid_id", customParams.get("baseunitid"));
        newEntry.set("baseqty", customParams.get("baseqty"));
        newEntry.set("assistunitid_id", customParams.get("assistunitid"));
        newEntry.set("assistqty", customParams.get("assistqty"));
        newEntry.set("warehouse_id", customParams.get("warehouse"));
        newEntry.set("locationid_id", customParams.get("locationid"));
        newEntry.set("stockstatus_id", customParams.get("stockstatus"));
        newEntry.set("stocktype_id", customParams.get("stocktype"));
        newEntry.set("ownertype", customParams.get("ownertype"));
        newEntry.set("ownerid_id", customParams.get("ownerid"));
        newEntry.set("keepertype", customParams.get("keepertype"));
        newEntry.set("keeperid_id", customParams.get("keeperid"));
        newEntry.set("unitid_id", customParams.get("unitid"));
        newEntry.set("qty", customParams.get("qty"));
        BusinessDataServiceHelper.loadRefence((Object[])entries.toArray(), (IDataEntityType)entries.getDynamicObjectType());
        this.getView().updateView("billentry");
    }
}

