/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ococic.formplugin.stockinPlugins;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.occ.ococic.enums.SnStatusEnum;

public class StockInBillList
extends AbstractListPlugin {
    private static final String OP_BATCHQUERYSN = "batchquerysn";
    private static final String FORM_OCOCIC_BATCHQUERYSN = "ococic_batchquerysn";
    private static final String CALLBACK_BATCHQUERYSN = "batchquerysn";
    private static final String CALLBACK_SUBMIT_CHECKSERIALNUMBER = "submit_checkserialnumber";

    public void setFilter(SetFilterEvent e) {
        Object isfromb2bbillclose;
        super.setFilter(e);
        String numbers = "";
        Object numbersObject = this.getView().getFormShowParameter().getCustomParam("batchquerynumber");
        if (numbersObject != null) {
            numbers = numbersObject.toString();
        }
        if ((isfromb2bbillclose = this.getView().getFormShowParameter().getCustomParam("isfromb2bbillclose")) != null && ((Boolean)isfromb2bbillclose).booleanValue()) {
            numbers = this.getPageCache().get("batchquerynumber");
        } else if (StringUtils.isEmpty((CharSequence)numbers)) {
            this.getPageCache().put("batchquerynumber", "");
        }
        if (!ObjectUtils.isEmpty((Object)numbers)) {
            List<String> list = Arrays.asList(numbers.split(","));
            QFilter qFilter = new QFilter("billentry.serialqty", ">", (Object)BigDecimal.ZERO);
            qFilter.and("billentry.subentryentity.serialnumber", "in", list);
            e.getQFilters().clear();
            e.getQFilters().add(qFilter);
            this.getPageCache().put("batchquerynumber", numbers);
        }
        e.setOrderBy("modifytime desc, billno desc");
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (StringUtils.equals((CharSequence)"batchquerysn", (CharSequence)itemKey)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId(FORM_OCOCIC_BATCHQUERYSN);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "batchquerysn"));
            showParameter.getOpenStyle().setShowType(ShowType.Floating);
            showParameter.setParentPageId(this.getView().getPageId());
            this.getView().showForm(showParameter);
        }
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        this.getView().invokeOperation("modify");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String key;
        super.beforeDoOperation(e);
        switch (key = ((AbstractOperate)e.getSource()).getOperateKey()) {
            case "submit": {
                ListSelectedRowCollection selectList = this.getSelectedRows();
                if (CollectionUtils.isEmpty((Collection)selectList)) break;
                ArrayList<Object> idList = new ArrayList<Object>(selectList.size());
                for (ListSelectedRow row : selectList) {
                    idList.add(row.getPrimaryKeyValue());
                }
                String errorMsg = this.checkSerialNumber(idList);
                if (StringUtils.isEmpty((CharSequence)errorMsg)) break;
                ConfirmCallBackListener reduceCallBacks = new ConfirmCallBackListener(CALLBACK_SUBMIT_CHECKSERIALNUMBER, (IFormPlugin)this);
                this.getView().showConfirm(errorMsg, MessageBoxOptions.YesNo, ConfirmTypes.Default, reduceCallBacks);
                e.setCancel(true);
                break;
            }
        }
    }

    private String checkSerialNumber(List<Object> idList) {
        String errorMsg = "";
        String selectField = "billno,inchannelid,billentry.subentryentity.serialnumber";
        QFilter filter = new QFilter("id", "in", idList);
        DynamicObjectCollection inbills = QueryServiceHelper.query((String)"ococic_channelinbill", (String)selectField, (QFilter[])filter.toArray());
        if (!CollectionUtils.isEmpty((Collection)inbills)) {
            int billsize = idList.size();
            HashSet<String> billnos = new HashSet<String>(billsize);
            HashSet<Long> inchannelids = new HashSet<Long>(billsize);
            HashSet<String> serialnumbers = new HashSet<String>(billsize);
            for (DynamicObject inbill : inbills) {
                String billno = inbill.getString("billno");
                long inchannelid = inbill.getLong("inchannelid");
                String serialnumber = inbill.getString("billentry.subentryentity.serialnumber");
                if (inchannelid == 0L || StringUtils.isEmpty((CharSequence)serialnumber)) continue;
                billnos.add(billno);
                inchannelids.add(inchannelid);
                serialnumbers.add(serialnumber);
            }
            StringBuilder sbSN = new StringBuilder();
            HashSet<Long> snids = new HashSet<Long>(billsize);
            QFilter qFilter = new QFilter("channelid", "in", inchannelids);
            qFilter.and("number", "in", serialnumbers);
            qFilter.and("snstatus", "=", (Object)SnStatusEnum.ONWAY.getValue());
            DynamicObjectCollection snmainFiles = QueryServiceHelper.query((String)"ococic_snmainfile", (String)"id", (QFilter[])qFilter.toArray());
            for (DynamicObject snmainFile : snmainFiles) {
                long snid = snmainFile.getLong("id");
                snids.add(snid);
            }
            if (snids.size() > 0) {
                HashSet<String> moveSNs = new HashSet<String>(snids.size());
                QFilter snFilter = new QFilter("snmainfileid", "in", snids);
                snFilter.and("billentityid", "=", (Object)"ococic_channelinbill");
                snFilter.and("billno", "not in", billnos);
                DynamicObjectCollection movetracks = QueryServiceHelper.query((String)"ococic_snmovetrack", (String)"billno,snmainfileid.number", (QFilter[])snFilter.toArray());
                if (!CollectionUtils.isEmpty((Collection)movetracks)) {
                    for (DynamicObject movetrack : movetracks) {
                        String moveSN = movetrack.getString("snmainfileid.number");
                        if (moveSNs.contains(moveSN)) continue;
                        moveSNs.add(moveSN);
                        sbSN.append(moveSN).append("\r\n");
                    }
                    if (sbSN.length() > 0) {
                        sbSN.deleteCharAt(sbSN.length() - 2);
                        errorMsg = sbSN.append(ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\uff0c\u5728\u5165\u5e93\u6e20\u9053\u662f\u5df2\u53d1\u51fa\u7684\u5728\u9014\u72b6\u6001\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u91cd\u65b0\u5165\u5e93\uff1f", (String)"StockInBillList_0", (String)"occ-ococic-formplugin", (Object[])new Object[0])).toString();
                    }
                }
            }
        }
        return errorMsg;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String key;
        switch (key = afterDoOperationEventArgs.getOperateKey()) {
            case "unaudit": {
                QFilter filter;
                String selectField;
                DynamicObjectCollection data;
                ArrayList needDeleteIds = new ArrayList();
                List successIds = afterDoOperationEventArgs.getOperationResult().getSuccessPkIds();
                if (successIds != null && successIds.size() > 0 && (data = QueryServiceHelper.query((String)"ococic_channelinbill", (String)(selectField = "id,billentry.srcbillentity"), (QFilter[])(filter = new QFilter("id", "in", (Object)successIds)).toArray())) != null && data.size() > 0) {
                    Set needDelectSetIds = data.stream().filter(r -> "ocbsoc_delivery_record".equals(r.getString("billentry.srcbillentity"))).map(r -> r.get("id")).collect(Collectors.toSet());
                    needDeleteIds.addAll(needDelectSetIds);
                }
                if (needDeleteIds == null || needDeleteIds.size() <= 0) break;
                OperationServiceHelper.executeOperate((String)"delete", (String)"ococic_channelinbill", (Object[])needDeleteIds.toArray(), (OperateOption)OperateOption.create());
                break;
            }
        }
        super.afterDoOperation(afterDoOperationEventArgs);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        ListSelectedRowCollection selectList;
        String callBackId;
        super.confirmCallBack(event);
        if (event.getResult() == MessageBoxResult.Yes && CALLBACK_SUBMIT_CHECKSERIALNUMBER.equalsIgnoreCase(callBackId = event.getCallBackId()) && !CollectionUtils.isEmpty((Collection)(selectList = this.getSelectedRows()))) {
            ArrayList<Object> idList = new ArrayList<Object>(selectList.size());
            for (ListSelectedRow selectedRow : selectList) {
                idList.add(selectedRow.getPrimaryKeyValue());
            }
            OperationResult result = OperationServiceHelper.executeOperate((String)"submit", (String)"ococic_channelinbill", (Object[])idList.toArray(), (OperateOption)OperateOption.create());
            if (result != null && !result.isSuccess()) {
                this.getView().showOperationResult(result);
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f\u3002", (String)"StockInBillList_1", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if ("batchquerysn".equals(actionId)) {
            IListView listview = (IListView)this.getView();
            listview.refresh();
        }
    }
}

