/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ococic.formplugin.stockoutPlugins;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.occ.ocbase.business.helper.SaleOrderMatchInventoryHelper;
import kd.occ.ocbase.business.helper.UnitConvertHelper;
import kd.occ.ocbase.common.enums.Enable;
import kd.occ.ocbase.common.enums.GoodsTypeEnum;
import kd.occ.ocbase.common.enums.SnStatusEnum;
import kd.occ.ocbase.common.helper.CSerialHelper;
import kd.occ.ocbase.common.helper.CUserHelper;
import kd.occ.ocbase.common.pojo.ocic.AvailableChannelStockParamVO;
import kd.occ.ocbase.common.pojo.ocic.AvailableChannelStockResultVO;
import kd.occ.ocbase.common.status.Status;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.ItemNSaleControlUtil;
import kd.occ.ocbase.common.util.QueryUtil;
import kd.occ.ocbase.common.util.StringUtils;
import kd.occ.ocbase.formplugin.base.OcbaseBasePlugin;

public class StockOutBillEdit
extends OcbaseBasePlugin
implements BeforeF7SelectListener {
    private BigDecimal MAX_QTY = new BigDecimal("999999999999.999999999");
    private static final String BAR_SAVE = "bar_save";
    private static final String BAR_AUDIT = "bar_audit";
    private static final String SNBATCHINPUT = "snbatchinput";
    private static final String SNINPUT = "sninput";
    private static final String SN_ADDROW = "sn_addrow";
    private static final String SN_DELETEROW = "sn_deleterow";
    private static final String SNREINSERT = "snreinsert";

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        IFormView formView = this.getView().getParentView();
        if (formView instanceof ListView) {
            ListView lstFormView = (ListView)this.getView().getParentView();
            lstFormView.getFormShowParameter().setCustomParam("isfromb2bbillclose", (Object)true);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"lotnumber"});
        this.addClickListeners(new String[]{"serialnumber"});
        this.addClickListeners(new String[]{SNBATCHINPUT});
        this.addF7Listener(this, new String[]{"outchannelid", "orderchannelid", "stockid", "stockaddrid", "unitid", "serialid", "itemid", "materielid", "lotid"});
    }

    public void afterLoadData(EventObject e) {
        if (Status.SUBMITED.toString().equals((String)this.getModel().getValue("billstatus"))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BAR_SAVE});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{BAR_SAVE, SNINPUT, SNBATCHINPUT, SN_ADDROW, SN_DELETEROW});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"chnloutbill_sn"});
        }
        super.afterLoadData(e);
    }

    public void afterBindData(EventObject e) {
        DynamicObject billtype;
        long billtypeid;
        DynamicObjectCollection entry;
        super.afterBindData(e);
        if (this.isAddNew() && (entry = this.getModel().getEntryEntity("billentry")) != null && !entry.isEmpty() && "ocbsoc_saleorder".equals(((DynamicObject)entry.get(0)).getString("srcbillentity"))) {
            this.getView().getPageCache().put("ispush", "true");
        }
        this.getView().setEnable(Boolean.FALSE, new String[]{"org"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"currencyid"});
        this.setRowLockProperties();
        DynamicObjectCollection billEntry = this.getModel().getEntryEntity("billentry");
        if (billEntry != null && !billEntry.isEmpty() && "ocbsoc_saleorder".equals(((DynamicObject)billEntry.get(0)).getString("srcbillentity"))) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"outchannelid", "orderchannelid", "billtypeid", "outdate"});
        }
        if ((billtypeid = DynamicObjectUtils.getPkValue((DynamicObject)(billtype = this.getModel().getDataEntity(true).getDynamicObject("billtypeid")))) == 1028196345158206464L) {
            this.setMustInput("orderchannelid", true);
        } else {
            this.setMustInput("orderchannelid", false);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        if (this.getView().getPageCache().get("ispush") != null) {
            this.getView().getPageCache().put("hasRight", "true");
            this.getView().invokeOperation(evt.getOperationKey(), CommonUtils.getOperateOption());
            evt.setCancel(true);
        }
        super.beforeItemClick(evt);
    }

    private void setRowLockProperties() {
        int entryRowCount = this.getModel().getEntryRowCount("billentry");
        for (int i = 0; i < entryRowCount; ++i) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("billentry", i);
            DynamicObject item = entryRowEntity.getDynamicObject("itemid");
            if (null == item) continue;
            this.setAssistantProperty(i, item);
            this.setStockLocationLockStatus(i, entryRowEntity);
        }
    }

    private void setStockLocationLockStatus(int i, DynamicObject entryRowEntity) {
        Object stock;
        if (null != entryRowEntity && null != (stock = entryRowEntity.get("stockid"))) {
            boolean enablelocation = ((DynamicObject)stock).getBoolean("enablelocation");
            this.getView().setEnable(Boolean.valueOf(enablelocation), i, new String[]{"stockaddrid"});
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (!CollectionUtils.isEmpty((Map)customParams) && customParams.containsKey("isfromchannelinvacc")) {
            this.updateBillValuesForStockOut(customParams);
        } else {
            this.setDefaultOutChannel();
        }
        this.outStockWay();
        DynamicObjectCollection entry = this.getModel().getEntryEntity("billentry");
        if (entry != null && !entry.isEmpty() && "ocbsoc_saleorder".equals(((DynamicObject)entry.get(0)).getString("srcbillentity"))) {
            this.getView().getPageCache().put("hasRight", "true");
        }
    }

    private void outStockWay() {
        long billTypeId = this.getModel().getDataEntity().getLong("billtypeid.id");
        DynamicObject o = (DynamicObject)SystemParamServiceHelper.getBillTypeParameter((String)"ococic_channeloutbill", (String)"ococic_outbill_parm", (long)billTypeId);
        if (o != null) {
            String name = o.getString("outdirection");
            this.getModel().setValue("outdirection", (Object)name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<QFilter> getFilters4LotByItemId() {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        DynamicObject rowObj = this.getCurrentRowInfo("billentry");
        if (null == rowObj) {
            return filters;
        }
        Object itemObj = rowObj.get("itemid");
        if (null == itemObj) {
            return filters;
        }
        Long itemId = (Long)((DynamicObject)itemObj).getPkValue();
        filters.add(new QFilter("itemid", "=", (Object)itemId));
        filters.add(new QFilter("enable", "=", (Object)"1"));
        DynamicObject outChannel = (DynamicObject)this.getModel().getValue("outchannelid");
        QFilter invFilter = new QFilter("channelid", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)outChannel));
        invFilter.and("itemid", "=", (Object)itemId);
        invFilter.and("baseqty", ">", (Object)BigDecimal.ZERO);
        HashSet<Long> lotIds = new HashSet<Long>();
        try (DataSet lotSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ococic_channelinvacc", (String)"lotid", (QFilter[])invFilter.toArray(), (String)"");){
            while (lotSet.hasNext()) {
                Row row = lotSet.next();
                lotIds.add(row.getLong("lotid"));
            }
        }
        filters.add(new QFilter("id", "in", lotIds));
        Object auxpty = rowObj.get("auxptyid");
        if (auxpty instanceof DynamicObject) {
            Long auxptyId = (Long)((DynamicObject)auxpty).getPkValue();
            filters.add(new QFilter("auxptyid", "=", (Object)auxptyId));
        }
        return filters;
    }

    private List<QFilter> getFilters4SNByItemId() {
        Object keeperType;
        Object keeperId;
        Object ownerType;
        Object ownerId;
        Object stockType;
        Object stockStatus;
        Object locationId;
        Object stockId;
        Object productionDate;
        int currentRowIndex;
        Object lotId;
        Long auxptyId;
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        DynamicObject rowObj = this.getCurrentRowInfo("billentry");
        if (null == rowObj) {
            return filters;
        }
        Object itemObj = rowObj.get("itemid");
        if (null == itemObj) {
            return filters;
        }
        Long itemId = (Long)((DynamicObject)itemObj).getPkValue();
        filters.add(new QFilter("itemid", "=", (Object)itemId));
        QFilter auxptyFilter = null;
        DynamicObject auxpty = (DynamicObject)rowObj.get("auxptyid");
        if (null != auxpty && 0L < (auxptyId = Long.valueOf(auxpty.getLong("id")))) {
            auxptyFilter = new QFilter("auxptyid", "=", (Object)auxptyId);
            filters.add(auxptyFilter);
        }
        if (!this.isOppositeDirection()) {
            QFilter snStatusInStock = new QFilter("snstatus", "=", (Object)SnStatusEnum.INSTOCK.getValue());
            filters.add(snStatusInStock);
        }
        if (this.isOppositeDirection()) {
            QFilter snStatusOnWay = new QFilter("snstatus", "=", (Object)SnStatusEnum.RETURNOUTSTOCK.getValue());
            filters.add(snStatusOnWay);
        }
        filters.add(new QFilter("lockstatus", "=", (Object)Character.valueOf('0')));
        Object outChannelId = this.getF7PKValue("outchannelid");
        if (null != outChannelId) {
            filters.add(new QFilter("channelid", "=", outChannelId));
        }
        if (null != (lotId = this.getValue("lotid", currentRowIndex = this.getCurrentRowIndex("billentry"))) && lotId instanceof DynamicObject) {
            QFilter lotIdFilter = new QFilter("lotid", "=", ((DynamicObject)lotId).getPkValue());
            filters.add(lotIdFilter);
        }
        if (null != (productionDate = this.getValue("productdate", currentRowIndex))) {
            filters.add(new QFilter("productdate", "=", productionDate));
        }
        Date validToDate = (Date)this.getValue("expiredate", currentRowIndex);
        if (null != productionDate) {
            filters.add(new QFilter("effectivedate", "=", (Object)validToDate));
        }
        if (null != (stockId = this.getEntryF7PKValue("billentry", "stockid", currentRowIndex))) {
            filters.add(new QFilter("channelstockid", "=", stockId));
        }
        if (null != (locationId = this.getEntryF7PKValue("billentry", "stockaddrid", currentRowIndex))) {
            filters.add(new QFilter("channellocationid", "=", locationId));
        }
        if (null != (stockStatus = this.getEntryF7PKValue("billentry", "stockstatusid", currentRowIndex))) {
            filters.add(new QFilter("channelstockstatusid", "=", stockStatus));
        }
        if (null != (stockType = this.getEntryF7PKValue("billentry", "stocktypeid", currentRowIndex))) {
            filters.add(new QFilter("channelstocktypeid", "=", stockType));
        }
        if (null != (ownerId = this.getEntryF7PKValue("billentry", "ownerid", currentRowIndex))) {
            filters.add(new QFilter("ownerid", "=", ownerId));
        }
        if (null != (ownerType = this.getValue("ownertype", currentRowIndex))) {
            filters.add(new QFilter("ownertype", "=", ownerType));
        }
        if (null != (keeperId = this.getEntryF7PKValue("billentry", "keeperid", currentRowIndex))) {
            filters.add(new QFilter("keeperid", "=", keeperId));
        }
        if (null != (keeperType = this.getValue("keepertype", currentRowIndex))) {
            filters.add(new QFilter("keepertype", "=", keeperType));
        }
        return filters;
    }

    public void click(EventObject e) {
        String key;
        super.click(e);
        switch (key = ((Control)e.getSource()).getKey()) {
            case "lotnumber": {
                BasedataEdit lotIdBaseEdit = (BasedataEdit)this.getControl("lotid");
                lotIdBaseEdit.setQFilters(this.getFilters4LotByItemId());
                lotIdBaseEdit.setF7MultipleSelect(false);
                lotIdBaseEdit.click();
                break;
            }
            case "serialnumber": {
                BasedataEdit snIdBaseEdit = (BasedataEdit)this.getControl("serialid");
                snIdBaseEdit.setQFilters(this.getFilters4SNByItemId());
                snIdBaseEdit.setF7MultipleSelect(true);
                snIdBaseEdit.click();
                break;
            }
            case "snbatchinput": {
                FormShowParameter parameter = new FormShowParameter();
                parameter.setFormId("ococic_batchinputserial");
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SNBATCHINPUT));
                this.getView().showForm(parameter);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        switch (actionId = evt.getActionId()) {
            case "snbatchinput": {
                String[] snArray = (String[])evt.getReturnData();
                if (snArray == null || snArray.length <= 0) break;
                ArrayList<String> snList = new ArrayList<String>(Arrays.asList(snArray));
                List<String> existSnList = this.checkSnExist(snList);
                this.addSnToEntry(existSnList, snList);
                break;
            }
        }
        super.closedCallBack(evt);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String propName = e.getProperty().getName();
        int currentRowIndex = e.getRow();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        switch (propName) {
            case "outchannelid": {
                showParameter.getListFilterParameter().setQFilters(this.getOutChannelFilters());
                break;
            }
            case "orderchannelid": {
                Object outchannel = this.getModel().getValue("outchannelid");
                if (null == outchannel) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u51fa\u5e93\u6e20\u9053\u3002", (String)"StockOutBillEdit_0", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                showParameter.getListFilterParameter().setQFilters(this.getOrderChannelFilters());
                break;
            }
            case "itemid": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, this.getItemFilter());
                break;
            }
            case "unitid": {
                this.setUnitIdEntryF7Select(e, currentRowIndex);
                break;
            }
            case "stockid": {
                Long channelId = this.getOutStockChannelPKValue();
                ArrayList<QFilter> filters = new ArrayList<QFilter>();
                QFilter qf1 = new QFilter("ownerchannelid", "=", (Object)channelId);
                QFilter status = new QFilter("status", "=", (Object)"C");
                QFilter enable = new QFilter("enable", "=", (Object)Boolean.TRUE);
                filters.add(qf1);
                filters.add(status);
                filters.add(enable);
                showParameter.getListFilterParameter().setQFilters(filters);
                showParameter.setMultiSelect(false);
                break;
            }
            case "stockaddrid": {
                if (null == this.getModel().getValue("stockid", currentRowIndex)) {
                    e.setCancel(true);
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4ed3\u5e93\u3002", (String)"StockOutBillEdit_1", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
                    break;
                }
                long wid = ((DynamicObject)this.getModel().getEntryRowEntity("billentry", currentRowIndex).get("stockid")).getLong("id");
                QFilter qf2 = new QFilter("warehouseid", "=", (Object)wid);
                showParameter.getListFilterParameter().setFilter(qf2);
                showParameter.setMultiSelect(false);
                break;
            }
            case "materielid": {
                this.checkItemExistsWhenChooseMaterial(e);
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        int rowIndex = e.getRowDataEntities()[0].getRowIndex();
        switch (entryName) {
            case "billentry": {
                this.setOwnerAndKeeper(rowIndex);
                this.setDefaultStock(rowIndex);
                this.checkStockStatusDefaultValueIsEnable(rowIndex);
                this.checkStockTypeDefaultValueIsEnable(rowIndex);
            }
        }
    }

    private void checkStockTypeDefaultValueIsEnable(int i) {
        boolean enable;
        Object stockStatus = this.getValue("stocktypeid", i);
        if (stockStatus instanceof DynamicObject && !(enable = ((DynamicObject)stockStatus).getBoolean("enable"))) {
            this.setValue("stocktypeid", null, i, false);
        }
    }

    private void checkStockStatusDefaultValueIsEnable(int i) {
        boolean enable;
        Object stockStatus = this.getValue("stockstatusid", i);
        if (stockStatus instanceof DynamicObject && !(enable = ((DynamicObject)stockStatus).getBoolean("enable"))) {
            this.setValue("stockstatusid", null, i, false);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        if (!this.triggerChangeEvent) {
            return;
        }
        switch (propName = e.getProperty().getName()) {
            case "outchannelid": {
                this.getModel().deleteEntryData("billentry");
                this.setSaleOrgAndChannel(e);
                this.setCurrencyByOutChannel(e);
                this.setValue("orderchannelid", null, false);
                break;
            }
            case "orderchannelid": {
                this.getModel().deleteEntryData("billentry");
                break;
            }
            case "billtypeid": {
                this.setOutDirectionByBillType(e);
                break;
            }
            case "itemid": {
                this.initEntryRowEntity(e);
                break;
            }
            case "quantity": {
                this.afterQtyChange(e);
                break;
            }
            case "unitid": {
                this.afterUnitChange(e);
                break;
            }
            case "stockid": {
                this.checkStockLocation(e);
                break;
            }
            case "lotid": {
                this.setLotNumberByLotId(e);
                break;
            }
            case "lotnumber": {
                int i_row = this.getRowIndex(e);
                this.reloadLotId(i_row);
                this.relLotNumberSpace(this.getRowIndex(e));
                this.setDate(this.getRowIndex(e));
                break;
            }
            case "serialid": {
                this.setSerialNumberBySerialId(e);
                break;
            }
            case "serialnumber": {
                this.relSnNumberSpace(this.getRowIndex(e));
                break;
            }
            case "sninput": {
                String snInput = (String)this.getModel().getValue(SNINPUT);
                if (StringUtils.isNotNull((String)snInput)) {
                    ArrayList<String> snList = new ArrayList<String>();
                    snList.add(snInput);
                    List<String> existSnList = this.checkSnExist(snList);
                    this.addSnToEntry(existSnList, snList);
                }
                this.getModel().setValue(SNINPUT, (Object)"");
                break;
            }
        }
    }

    private void addSnToEntry(List<String> existSnList, List<String> snList) {
        long channelId;
        JSONObject result;
        JSONArray data;
        if (snList == null || snList.isEmpty()) {
            return;
        }
        String snStatus = SnStatusEnum.INSTOCK.getValue();
        String outDirecition = (String)this.getModel().getValue("outdirection");
        if ("2".equals(outDirecition)) {
            snStatus = SnStatusEnum.RETURNOUTSTOCK.getValue();
        }
        if (!(data = (result = CSerialHelper.getSerialDataByScanNumber(snList, (Long)(channelId = ((Long)this.getModel().getValue("outchannelid_id")).longValue()), (String)snStatus)).getJSONArray("data")).isEmpty()) {
            HashMap<String, List<JSONObject>> snKeyMap = new HashMap<String, List<JSONObject>>();
            for (JSONObject json : data.toJavaList(JSONObject.class)) {
                String serialno = json.getString("serialno");
                if (existSnList.contains(serialno)) continue;
                String key = String.join((CharSequence)"_", json.getString("itemid"), json.getString("auxptyid"), json.getString("lotid"), json.getString("channelstockid"), json.getString("channellocationid"), json.getString("channelstockstatusid"), json.getString("channelstocktypeid"), json.getString("ownerid"), json.getString("ownertype"), json.getString("keeperid"), json.getString("keepertype"), json.getString("projectid"), this.formatDate(json.getDate("productdate")), this.formatDate(json.getDate("effectivedate")));
                if (snKeyMap.containsKey(key) && snKeyMap.get(key) != null) {
                    ((List)snKeyMap.get(key)).add(json);
                    continue;
                }
                ArrayList<JSONObject> jsonList = new ArrayList<JSONObject>();
                jsonList.add(json);
                snKeyMap.put(key, jsonList);
            }
            this.snMatchEntry(snKeyMap);
            if (Status.SUBMITED.toString().equals((String)this.getModel().getValue("billstatus")) && snKeyMap.size() > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u672a\u5339\u914d\u5230\u5546\u54c1\u884c", (String)"StockOutBillEdit_17", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
            } else {
                this.snAddEntry(snKeyMap);
            }
            DynamicObjectCollection billEntryEntity = this.getModel().getEntryEntity("billentry");
            BusinessDataServiceHelper.loadRefence((Object[])billEntryEntity.toArray(), (IDataEntityType)billEntryEntity.getDynamicObjectType());
            this.getModel().setValue("billentry", (Object)billEntryEntity);
            this.getModel().updateEntryCache(billEntryEntity);
            this.getView().updateView();
            this.recalSumQty();
        } else {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5e8f\u5217\u53f7:%s", (String)"StockOutBillEdit_14", (String)"occ-ococic-formplugin", (Object[])new Object[0]), Arrays.toString(snList.toArray())));
        }
    }

    private String formatDate(Date date) {
        if (date != null) {
            return new SimpleDateFormat("yyyy-MM-dd").format(date);
        }
        return "";
    }

    private void snAddEntry(Map<String, List<JSONObject>> snKeyMap) {
        DynamicObjectCollection billEntryEntity = this.getModel().getEntryEntity("billentry");
        if (!snKeyMap.isEmpty()) {
            DynamicObject outChannel = (DynamicObject)this.getModel().getValue("outchannelid");
            String snmanager = DynamicObjectUtils.getString((DynamicObject)outChannel, (String)"snmanager");
            for (Map.Entry<String, List<JSONObject>> snMapEntry : snKeyMap.entrySet()) {
                List<JSONObject> jsonList = snMapEntry.getValue();
                DynamicObject billEntry = billEntryEntity.addNew();
                billEntry.set("itemid_id", (Object)jsonList.get(0).getLong("itemid"));
                billEntry.set("auxptyid_id", (Object)jsonList.get(0).getLong("auxptyid"));
                billEntry.set("lotnumber", (Object)jsonList.get(0).getString("lotnum"));
                billEntry.set("lotid_id", (Object)jsonList.get(0).getLong("lotid"));
                billEntry.set("stockid_id", (Object)jsonList.get(0).getLong("channelstockid"));
                billEntry.set("stockaddrid_id", (Object)jsonList.get(0).getLong("channellocationid"));
                billEntry.set("stockstatusid_id", (Object)jsonList.get(0).getLong("channelstockstatusid"));
                billEntry.set("stocktypeid_id", (Object)jsonList.get(0).getLong("channelstocktypeid"));
                billEntry.set("ownerid_id", (Object)jsonList.get(0).getLong("ownerid"));
                billEntry.set("ownertype", (Object)jsonList.get(0).getString("ownertype"));
                billEntry.set("keeperid_id", (Object)jsonList.get(0).getLong("keeperid"));
                billEntry.set("keepertype", (Object)jsonList.get(0).getString("keepertype"));
                billEntry.set("projectid_id", (Object)jsonList.get(0).getLong("projectid"));
                billEntry.set("productdate", (Object)jsonList.get(0).getDate("productdate"));
                billEntry.set("expiredate", (Object)jsonList.get(0).getDate("effectivedate"));
                long materialId = jsonList.get(0).getLong("material");
                billEntry.set("materielid_id", (Object)materialId);
                BigDecimal snQty = new BigDecimal(jsonList.size());
                long snUnitId = jsonList.get(0).getLong("serialunit");
                long unitId = jsonList.get(0).getLong("stockunit");
                long baseUnitId = jsonList.get(0).getLong("baseunit");
                long assistUnitId = jsonList.get(0).getLong("assistunit");
                billEntry.set("snunit_id", (Object)snUnitId);
                billEntry.set("unitid_id", (Object)unitId);
                billEntry.set("auxptyunitid_id", (Object)assistUnitId);
                billEntry.set("baseunitid_id", (Object)baseUnitId);
                BigDecimal baseQty = UnitConvertHelper.calculateDestQty((BigDecimal)snQty, (Long)materialId, (Long)snUnitId, (Long)baseUnitId);
                billEntry.set("basequantity", (Object)baseQty);
                BigDecimal qty = UnitConvertHelper.calculateDestQty((BigDecimal)baseQty, (Long)materialId, (Long)baseUnitId, (Long)unitId);
                billEntry.set("quantity", (Object)qty);
                BigDecimal assistQty = UnitConvertHelper.calculateDestQty((BigDecimal)baseQty, (Long)materialId, (Long)baseUnitId, (Long)assistUnitId);
                billEntry.set("auxquantity", (Object)assistQty);
                DynamicObjectCollection snEntry = billEntry.getDynamicObjectCollection("chnloutbill_sn");
                if (!snmanager.equals("A")) continue;
                billEntry.set("snquantity", (Object)snQty);
                for (JSONObject json : jsonList) {
                    DynamicObject sn = snEntry.addNew();
                    sn.set("serialnumber", (Object)json.getString("serialno"));
                    sn.set("serialid_id", (Object)json.getLong("serialid"));
                }
            }
        }
    }

    private void snMatchEntry(Map<String, List<JSONObject>> snKeyMap) {
        DynamicObjectCollection billEntryEntity = this.getModel().getEntryEntity("billentry");
        if (billEntryEntity != null && !billEntryEntity.isEmpty()) {
            int rowindex = 0;
            for (DynamicObject billEntry : billEntryEntity) {
                ++rowindex;
                String key = String.join((CharSequence)"_", billEntry.getString("itemid_id"), billEntry.getString("auxptyid_id"), billEntry.getString("lotid_id"), billEntry.getString("stockid_id"), billEntry.getString("stockaddrid_id"), billEntry.getString("stockstatusid_id"), billEntry.getString("stocktypeid_id"), billEntry.getString("ownerid_id"), billEntry.getString("ownertype"), billEntry.getString("keeperid_id"), billEntry.getString("keepertype"), billEntry.getString("projectid_id"), this.formatDate(billEntry.getDate("productdate")), this.formatDate(billEntry.getDate("expiredate")));
                if (!snKeyMap.containsKey(key)) continue;
                boolean isSubmit = Status.SUBMITED.toString().equals((String)this.getModel().getValue("billstatus"));
                boolean isHasSrcBill = StringUtils.isNotEmpty((String)billEntry.getString("srcbillnumber"));
                BigDecimal snQty = billEntry.getBigDecimal("snquantity");
                DynamicObjectCollection snEntry = billEntry.getDynamicObjectCollection("chnloutbill_sn");
                if (isSubmit || isHasSrcBill) {
                    int snEntryCount = snKeyMap.get(key).size();
                    if (!CollectionUtils.isEmpty((Collection)snEntry)) {
                        snEntryCount += snEntry.size();
                    }
                    if (snEntryCount > snQty.intValue()) {
                        snKeyMap.clear();
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\uff0c\u5e8f\u5217\u53f7\u6570\u91cf\u5df2\u8d85\u5546\u54c1\u6570\u91cf\uff01", (String)"StockOutBillEdit_15", (String)"occ-ococic-formplugin", (Object[])new Object[0]), rowindex));
                        return;
                    }
                } else {
                    snQty = snQty.add(new BigDecimal(snKeyMap.get(key).size()));
                    billEntry.set("snquantity", (Object)snQty);
                    long snUnitId = billEntry.getLong("snunit_id");
                    long unitId = billEntry.getLong("unitid_id");
                    long baseUnitId = billEntry.getLong("baseunitid_id");
                    long assistUnitId = billEntry.getLong("auxptyunitid_id");
                    long materialId = billEntry.getLong("materielid_id");
                    BigDecimal baseQty = UnitConvertHelper.calculateDestQty((BigDecimal)snQty, (Long)materialId, (Long)snUnitId, (Long)baseUnitId);
                    billEntry.set("basequantity", (Object)baseQty);
                    BigDecimal qty = UnitConvertHelper.calculateDestQty((BigDecimal)baseQty, (Long)materialId, (Long)baseUnitId, (Long)unitId);
                    billEntry.set("quantity", (Object)qty);
                    BigDecimal assistQty = UnitConvertHelper.calculateDestQty((BigDecimal)baseQty, (Long)materialId, (Long)baseUnitId, (Long)assistUnitId);
                    billEntry.set("auxquantity", (Object)assistQty);
                }
                for (JSONObject json : snKeyMap.get(key)) {
                    DynamicObject sn = snEntry.addNew();
                    sn.set("serialnumber", (Object)json.getString("serialno"));
                    sn.set("serialid_id", (Object)json.getLong("serialid"));
                }
                snKeyMap.remove(key);
            }
        }
    }

    private List<String> checkSnExist(List<String> snList) {
        ArrayList<String> existSnList = new ArrayList<String>();
        DynamicObjectCollection billEntryEntity = this.getModel().getEntryEntity("billentry");
        if (billEntryEntity != null && !billEntryEntity.isEmpty()) {
            for (DynamicObject billEntry : billEntryEntity) {
                DynamicObjectCollection subEntryList = billEntry.getDynamicObjectCollection("chnloutbill_sn");
                if (subEntryList == null || subEntryList.isEmpty()) continue;
                for (DynamicObject subEntry : subEntryList) {
                    String snnum = subEntry.getString("serialnumber");
                    existSnList.add(snnum);
                    if (!StringUtils.isNotNull((String)snnum) || !snList.contains(snnum)) continue;
                    snList.remove(snnum);
                }
            }
        }
        return existSnList;
    }

    private void setDate(int row) {
        DynamicObject lotnumberid = (DynamicObject)this.getValue("lotid", row);
        if (lotnumberid != null) {
            long lotNumberId = (Long)lotnumberid.getPkValue();
            DynamicObject lot = BusinessDataServiceHelper.loadSingle((String)"ococic_lot", (String)"productdate,expiredate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)lotNumberId)});
            DynamicObjectCollection lotDate = (DynamicObjectCollection)lot.get("ococic_lotdate");
            if (lotDate.size() > 0) {
                this.setValue("productdate", ((DynamicObject)lotDate.get(0)).get("productdate"), row);
                this.setValue("expiredate", ((DynamicObject)lotDate.get(0)).get("expiredate"), row);
            } else {
                this.setValue("productdate", null, row);
                this.setValue("expiredate", null, row);
            }
        }
    }

    private void reloadLotId(int row) {
        this.getView().getModel().setItemValueByID("lotid", null, row);
        DynamicObject item = (DynamicObject)this.getModel().getEntryRowEntity("billentry", row).get("itemid");
        if (item == null) {
            return;
        }
        long itemId = item.getLong("id");
        String number = (String)this.getModel().getEntryRowEntity("billentry", row).get("lotnumber");
        if (number != null) {
            DynamicObject[] result;
            QFilter itemidFilter = new QFilter("itemid", "=", (Object)itemId);
            QFilter idFilter = new QFilter("number", "=", (Object)number);
            DynamicObject auxpty = (DynamicObject)this.getView().getModel().getEntryRowEntity("billentry", row).get("auxptyid");
            QFilter auxptyFilter = null;
            if (null != auxpty) {
                Long auxptyId = (Long)auxpty.getPkValue();
                auxptyFilter = new QFilter("auxptyid", "=", (Object)auxptyId);
            }
            if (null != (result = BusinessDataServiceHelper.load((String)"ococic_lot", (String)"id", (QFilter[])new QFilter[]{itemidFilter, idFilter, auxptyFilter})) && result.length > 0) {
                Long rs = result[0].getLong("id");
                this.getView().getModel().setValue("lotid", (Object)rs, row);
            } else {
                this.getView().getModel().setValue("lotid", null, row);
            }
        }
    }

    private void relLotNumberSpace(int row) {
        DynamicObject dynamicObject = this.getModel().getEntryRowEntity("billentry", row);
        String lotNumber = dynamicObject.getString("lotnumber");
        if (lotNumber != null) {
            lotNumber = lotNumber.replaceAll("\u3000", " ").trim();
            this.setValue("lotnumber", lotNumber, row, false);
        }
    }

    private void relSnNumberSpace(int row) {
        DynamicObject dynamicObject = this.getModel().getEntryRowEntity("chnloutbill_sn", row);
        String fieldValue = dynamicObject.getString("serialnumber");
        if (fieldValue != null) {
            fieldValue = fieldValue.replaceAll("\u3000", " ").trim();
            this.setValue("serialnumber", fieldValue, row);
        }
    }

    private void setSerialNumberBySerialId(PropertyChangedArgs e) {
        int i = e.getChangeSet()[0].getRowIndex();
        this.getModel().setValue("serialnumber", (Object)"", i);
        DynamicObject snId = (DynamicObject)e.getChangeSet()[0].getNewValue();
        if (null != snId) {
            this.setValue("serialnumber", snId.get("number"), i);
        }
    }

    private void checkItemExistsWhenChooseMaterial(BeforeF7SelectEvent e) {
        int rowIndex = e.getRow();
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("billentry", rowIndex);
        if (null == entryRowEntity.getDynamicObject("itemid")) {
            e.setCancel(true);
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5546\u54c1\u3002", (String)"StockOutBillEdit_4", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs ea) {
        String opKey;
        super.beforeDoOperation(ea);
        switch (opKey = ((AbstractOperate)ea.getSource()).getOperateKey()) {
            case "confirmdelivery": {
                String status = (String)this.getModel().getValue("billstatus");
                if (Status.AUDITED.toString().equals(status)) break;
                this.getView().showMessage(ResManager.loadKDString((String)"\u5ba1\u6838\u72b6\u6001\u624d\u80fd\u786e\u8ba4\u51fa\u5e93", (String)"StockOutBillEdit_5", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
                ea.setCancel(true);
                break;
            }
            case "newentry": {
                if (this.getOutStockChannelPKValue() != 0L) break;
                ea.setCancel(true);
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u51fa\u5e93\u6e20\u9053\u3002", (String)"StockOutBillEdit_0", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
                break;
            }
            case "newsubentry": {
                if (this.isEmptyEntry()) {
                    ea.setCancel(true);
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u6dfb\u52a0\u5206\u5f55\u3002", (String)"StockOutBillEdit_6", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
                }
                this.ifDisableLockSerialNumberColumn(ea);
                break;
            }
            case "save": 
            case "submit": {
                if (!this.isEmptyEntry()) break;
                ea.setCancel(true);
                this.getView().showMessage(ResManager.loadKDString((String)"\u81f3\u5c11\u8981\u6709\u4e00\u6761\u5206\u5f55\u3002", (String)"StockOutBillEdit_7", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
                break;
            }
            case "audit": {
                String billStatus = (String)this.getModel().getValue("billstatus");
                if ("B".equals(billStatus)) break;
                ea.setCancel(true);
                this.getView().showMessage(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u5bf9\u63d0\u4ea4\u72b6\u6001\u7684\u5355\u636e\u8fdb\u884c\u5ba1\u6838\u3002", (String)"StockOutBillEdit_8", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String key;
        super.afterDoOperation(e);
        switch (key = e.getOperateKey()) {
            case "queryavailableqty": {
                int rowCount = this.getModel().getEntryRowCount("billentry");
                int[] selectRows = new int[rowCount];
                for (int i = 0; i < rowCount; ++i) {
                    selectRows[i] = i;
                }
                this.showAvailableChannelStock(selectRows);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u663e\u793a\u53ef\u7528\u5e93\u5b58\u5b8c\u6210\u3002", (String)"StockOutBillEdit_16", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
                break;
            }
            case "snreinsert": {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{BAR_SAVE});
                this.getView().setEnable(Boolean.valueOf(true), new String[]{BAR_SAVE, SNINPUT, SNBATCHINPUT, SN_ADDROW, SN_DELETEROW});
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"chnloutbill_sn"});
                this.getView().setEnable(Boolean.valueOf(false), new String[]{BAR_AUDIT});
                break;
            }
            case "submit": {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{SNINPUT, SNBATCHINPUT, SN_ADDROW, SN_DELETEROW});
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"chnloutbill_sn"});
                break;
            }
            case "save": {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{BAR_AUDIT});
                if (!Status.SUBMITED.toString().equals((String)this.getModel().getValue("billstatus"))) break;
                this.getView().setVisible(Boolean.valueOf(false), new String[]{BAR_SAVE});
                this.getView().setEnable(Boolean.valueOf(false), new String[]{BAR_SAVE, SNINPUT, SNBATCHINPUT, SN_ADDROW, SN_DELETEROW});
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"chnloutbill_sn"});
                break;
            }
        }
    }

    private AvailableChannelStockParamVO getAvailableChannelStockParamVO(int rowIndex) {
        DynamicObject entryDynObj = this.getModel().getEntryRowEntity("billentry", rowIndex);
        long channelId = DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("outchannelid"));
        long itemId = DynamicObjectUtils.getPkValue((DynamicObject)entryDynObj, (String)"itemid");
        long materialId = DynamicObjectUtils.getPkValue((DynamicObject)entryDynObj, (String)"materielid");
        long auxPtyId = DynamicObjectUtils.getPkValue((DynamicObject)entryDynObj, (String)"auxptyid");
        long baseUnitId = DynamicObjectUtils.getPkValue((DynamicObject)entryDynObj, (String)"baseunitid");
        long unitId = DynamicObjectUtils.getPkValue((DynamicObject)entryDynObj, (String)"unitid");
        long stockId = DynamicObjectUtils.getPkValue((DynamicObject)entryDynObj, (String)"stockid");
        long stockAddrId = DynamicObjectUtils.getPkValue((DynamicObject)entryDynObj, (String)"stockaddrid");
        long stockStatusId = DynamicObjectUtils.getPkValue((DynamicObject)entryDynObj, (String)"stockstatusid");
        long stockTypeId = DynamicObjectUtils.getPkValue((DynamicObject)entryDynObj, (String)"stocktypeid");
        String ownerType = DynamicObjectUtils.getString((DynamicObject)entryDynObj, (String)"ownertype");
        long ownerId = DynamicObjectUtils.getPkValue((DynamicObject)entryDynObj, (String)"ownerid");
        String keeperType = DynamicObjectUtils.getString((DynamicObject)entryDynObj, (String)"keepertype");
        long keeperId = DynamicObjectUtils.getPkValue((DynamicObject)entryDynObj, (String)"keeperid");
        Date productDate = DynamicObjectUtils.getDate((DynamicObject)entryDynObj, (String)"productdate");
        Date expireDate = DynamicObjectUtils.getDate((DynamicObject)entryDynObj, (String)"expiredate");
        String lotNum = DynamicObjectUtils.getString((DynamicObject)entryDynObj, (String)"lotnumber");
        long projectId = DynamicObjectUtils.getPkValue((DynamicObject)entryDynObj, (String)"projectid");
        return new AvailableChannelStockParamVO(channelId, itemId, materialId, auxPtyId, baseUnitId, unitId, stockId, stockAddrId, stockStatusId, stockTypeId, ownerType, ownerId, keeperType, keeperId, productDate, expireDate, lotNum, projectId);
    }

    private void showAvailableChannelStock(int[] selectRows) {
        int size = selectRows.length;
        ArrayList<AvailableChannelStockParamVO> availableParamList = new ArrayList<AvailableChannelStockParamVO>(size);
        for (int i = 0; i < size; ++i) {
            int rowIndex = selectRows[i];
            AvailableChannelStockParamVO paramVO = this.getAvailableChannelStockParamVO(rowIndex);
            availableParamList.add(paramVO);
        }
        Map availableStockMap = SaleOrderMatchInventoryHelper.newQueryAvailableChannelStock(availableParamList);
        for (int i = 0; i < size; ++i) {
            int rowIndex = selectRows[i];
            AvailableChannelStockParamVO paramVO = this.getAvailableChannelStockParamVO(rowIndex);
            BigDecimal availableQty = BigDecimal.ZERO;
            if (availableStockMap.containsKey(paramVO.getCustomerNewKey())) {
                availableQty = ((AvailableChannelStockResultVO)availableStockMap.get(paramVO.getCustomerNewKey())).getAvailableQty();
            }
            this.setValue("availableqty", availableQty.stripTrailingZeros().toPlainString(), rowIndex);
        }
    }

    private boolean isEmptyEntry() {
        return 1 > this.getModel().getEntryRowCount("billentry");
    }

    private void setOutDirectionByBillType(PropertyChangedArgs e) {
        String billTypeNumber;
        DynamicObject billType = (DynamicObject)e.getChangeSet()[0].getNewValue();
        if (null != billType && (billTypeNumber = billType.getString("number")).equals("ococic_out_sys004")) {
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"chnloutbill_sn"});
        }
    }

    private List<QFilter> getOrderChannelFilters() {
        DynamicObject outChannel = (DynamicObject)this.getModel().getValue("outchannelid");
        if (null == outChannel) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u51fa\u5e93\u6e20\u9053\u3002", (String)"StockOutBillEdit_0", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
            return null;
        }
        Long outChannelId = (Long)outChannel.getPkValue();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        DynamicObject[] relations = BusinessDataServiceHelper.load((String)"ocdbd_channel_authorize", (String)"orderchannel", (QFilter[])new QFilter[]{new QFilter("salechannel", "=", (Object)outChannelId).and(new QFilter("enable", "=", (Object)Boolean.TRUE))});
        ArrayList<Long> ids = new ArrayList<Long>(16);
        for (DynamicObject relation : relations) {
            DynamicObject customer = relation.getDynamicObject("orderchannel");
            if (customer == null) continue;
            ids.add((Long)customer.getPkValue());
        }
        QFilter qFilter1 = new QFilter("id", "in", ids);
        qFilters.add(qFilter1);
        return qFilters;
    }

    private List<QFilter> getOutChannelFilters() {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        QFilter qFilter1 = new QFilter("isinnerorg", "=", (Object)Boolean.FALSE);
        QFilter qFilter2 = new QFilter("status", "=", (Object)"C");
        QFilter qFilter3 = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter qFilter4 = new QFilter("channeltype.isinsideorg", "=", (Object)Boolean.FALSE);
        QFilter qFilter5 = new QFilter("channelfunctions.fbasedataid.number", "=", (Object)"003");
        qFilters.add(qFilter1);
        qFilters.add(qFilter2);
        qFilters.add(qFilter3);
        qFilters.add(qFilter4);
        qFilters.add(qFilter5);
        qFilters.add(CUserHelper.getAuthorizedChannelFilter());
        qFilters.add(new QFilter("invcontrolmode", "=", (Object)"A"));
        return qFilters;
    }

    private void setDefaultOutChannel() {
        List<QFilter> outChannelFilters = this.getOutChannelFilters();
        int size = outChannelFilters.size();
        QFilter[] qFilters = new QFilter[size];
        for (int i = 0; i < size; ++i) {
            qFilters[i] = outChannelFilters.get(i);
        }
        DynamicObject[] outChannels = BusinessDataServiceHelper.load((String)"ocdbd_channel", (String)"id", (QFilter[])qFilters);
        if (null != outChannels && outChannels.length > 0) {
            this.getModel().setValue("outchannelid", outChannels[0].getPkValue());
            this.setCurrencyByOutChannel();
            this.setSaleOrgAndChannel();
        }
    }

    private List<QFilter> getItemFilter() {
        List<QFilter> itemFilter = null;
        long saleOrgId = (Long)this.getModel().getValue("saleorg_id");
        long outChannelId = (Long)this.getModel().getValue("outchannelid_id");
        long orderChannelId = (Long)this.getModel().getValue("orderchannelid_id");
        if (orderChannelId > 0L) {
            itemFilter = ItemNSaleControlUtil.getItemFilterBySaleChannel((long)saleOrgId, (long)outChannelId, (long)orderChannelId);
            if (itemFilter == null) {
                return new ArrayList<QFilter>(0);
            }
            itemFilter.add(new QFilter("itemtypeid", "!=", (Object)Long.parseLong(GoodsTypeEnum.COMBINEGOODS.getValue())));
        } else {
            itemFilter = new ArrayList();
            QFilter myItemFilter = ItemNSaleControlUtil.getMyItemFilter((long)outChannelId, (boolean)false);
            itemFilter.add(myItemFilter);
            itemFilter.add(new QFilter("itemtypeid", "!=", (Object)Long.parseLong(GoodsTypeEnum.COMBINEGOODS.getValue())));
        }
        return itemFilter;
    }

    private void setUnitIdEntryF7Select(BeforeF7SelectEvent e, int rowIndex) {
        if (!this.verifyItem(rowIndex)) {
            e.setCancel(true);
            return;
        }
        Object materialId = this.getEntryF7PKValue("billentry", "materielid", rowIndex);
        Object baseUnitId = this.getEntryF7PKValue("billentry", "baseunitid", rowIndex);
        List fixconunitlist = QueryUtil.getAssistMUListResult((Long)(materialId == null ? Long.valueOf(0L) : Long.valueOf(materialId.toString())), (Long)(baseUnitId == null ? Long.valueOf(0L) : Long.valueOf(baseUnitId.toString())), (String)"1");
        QFilter fixconFilter = new QFilter("id", "in", (Object)fixconunitlist);
        F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)fixconFilter);
    }

    private boolean verifyItem(int rowIndex) {
        Object itemId = this.getEntryF7PKValue("billentry", "itemid", rowIndex);
        if (itemId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5546\u54c1\u3002", (String)"StockOutBillEdit_4", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void setLotNumberByLotId(PropertyChangedArgs e) {
        int i = e.getChangeSet()[0].getRowIndex();
        DynamicObject lotId = (DynamicObject)e.getChangeSet()[0].getNewValue();
        if (null != lotId) {
            this.setValue("lotnumber", lotId.get("number"), i);
        }
    }

    private void checkStockLocation(PropertyChangedArgs e) {
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        DynamicObject newStock = (DynamicObject)e.getChangeSet()[0].getNewValue();
        this.setStockLocationByStock(rowIndex, newStock);
    }

    private void setStockLocationByStock(int rowIndex, DynamicObject newStock) {
        this.getModel().setValue("stockaddrid", null, rowIndex);
        if (null != newStock) {
            DynamicObject[] dynamicObjects;
            boolean enablelocation = newStock.getBoolean("enablelocation");
            this.getView().setEnable(Boolean.valueOf(enablelocation), rowIndex, new String[]{"stockaddrid"});
            if (enablelocation && null != (dynamicObjects = BusinessDataServiceHelper.load((String)"ococic_location", (String)"id", (QFilter[])new QFilter[]{new QFilter("warehouseid", "=", newStock.getPkValue()), new QFilter("isdefault", "=", (Object)Boolean.TRUE), new QFilter("enable", "=", (Object)"1")})) && dynamicObjects.length > 0) {
                this.getModel().setValue("stockaddrid", (Object)dynamicObjects[0], rowIndex);
            }
        }
    }

    private void ifDisableLockSerialNumberColumn(BeforeDoOperationEventArgs ea) {
        if (1 > this.getModel().getEntryRowCount("billentry")) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u6dfb\u52a0\u5546\u54c1\u4fe1\u606f\u3002", (String)"StockOutBillEdit_9", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
            return;
        }
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("billentry");
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("billentry", entryCurrentRowIndex);
        DynamicObject item = entryRowEntity.getDynamicObject("itemid");
        if (null != item) {
            boolean enableserial = item.getBoolean("enableserial");
            if (!enableserial) {
                ea.setCancel(true);
                this.getView().showMessage(ResManager.loadKDString((String)"\u5546\u54c1\u672a\u542f\u7528\u5e8f\u5217\u53f7\u7ba1\u7406\uff0c\u4e0d\u5141\u8bb8\u5f55\u5165\u5e8f\u5217\u53f7\u3002", (String)"StockOutBillEdit_10", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
            }
        } else {
            ea.setCancel(true);
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5546\u54c1\u3002", (String)"StockOutBillEdit_4", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
        }
    }

    private void initEntryRowEntity(PropertyChangedArgs e) {
        Object newValue = e.getChangeSet()[0].getNewValue();
        int i = e.getChangeSet()[0].getRowIndex();
        if (null == newValue) {
            this.setDefaultValues(i);
            return;
        }
        this.setOwnerAndKeeper(i);
        this.setDefaultStock(i);
        DynamicObject newItem = (DynamicObject)e.getChangeSet()[0].getNewValue();
        if (null != newItem) {
            this.setDefaultValues(i);
            this.setDefaultStock(i);
            this.initLotNumberColumn(i, newItem);
            this.initMaterialColumn(i, newItem);
            this.initItemUnit(i, newItem);
            this.setAssistantProperty(i, newItem);
            this.setSerialNumberUnitAndQty(i, newItem);
            this.clearAllSubEntryRows(i);
        }
    }

    private void clearAllSubEntryRows(int i) {
        int rowCount;
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("billentry", i);
        DynamicObjectCollection subEntries = entryRowEntity.getDynamicObjectCollection("chnloutbill_sn");
        if (!CollectionUtils.isEmpty((Collection)subEntries) && (rowCount = subEntries.getRowCount()) > 0) {
            int[] rows = new int[rowCount];
            for (int j = 0; j < rowCount; ++j) {
                rows[j] = j;
            }
            this.getModel().deleteEntryRows("chnloutbill_sn", rows);
        }
    }

    private void initLotNumberColumn(int i, DynamicObject item) {
        boolean enablelot = item.getBoolean("enablelot");
        this.getView().setEnable(Boolean.valueOf(enablelot), i, new String[]{"lotnumber"});
        this.setRowValue("lotid", 0, i);
        this.setRowValue("lotnumber", null, i);
    }

    private void setDefaultValues(int i) {
        this.getModel().setValue("auxptyid", null, i);
        this.getModel().setValue("materielid", null, i);
        this.getModel().setValue("unitid", null, i);
        this.getModel().setValue("baseunitid", null, i);
        this.getModel().setValue("auxptyunitid", null, i);
        this.getModel().setValue("quantity", (Object)0, i);
        this.getModel().setValue("basequantity", (Object)0, i);
        this.getModel().setValue("auxquantity", (Object)0, i);
        this.getModel().setValue("snquantity", (Object)0, i);
        this.getModel().setValue("snunit", null, i);
        this.getModel().setValue("lotid", null, i);
        this.getModel().setValue("lotnumber", (Object)"", i);
        this.getModel().setValue("productdate", null, i);
        this.getModel().setValue("expiredate", null, i);
        this.getModel().setValue("snunit", null, i);
        this.getModel().setValue("snquantity", (Object)0, i);
    }

    private void setSerialNumberUnitAndQty(int i, DynamicObject item) {
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("billentry", i);
        if (item.getBoolean("enableserial")) {
            DynamicObject serialUnit = (DynamicObject)item.get("serialunit");
            if (null != serialUnit) {
                BigDecimal baseQty;
                this.getModel().setValue("snunit", serialUnit.getPkValue(), i);
                Long serialUnitId = (Long)serialUnit.getPkValue();
                DynamicObject material = entryRowEntity.getDynamicObject("materielid");
                Long materialId = 0L;
                if (null != material) {
                    materialId = (Long)material.getPkValue();
                }
                if (null == (baseQty = entryRowEntity.getBigDecimal("basequantity"))) {
                    baseQty = BigDecimal.ZERO;
                }
                DynamicObject baseUnit = entryRowEntity.getDynamicObject("baseunitid");
                Long baseUnitId = 0L;
                if (null != baseUnit) {
                    baseUnitId = (Long)baseUnit.getPkValue();
                }
                BigDecimal serialQty = UnitConvertHelper.calculateDestQty((BigDecimal)baseQty, (Long)materialId, (Long)baseUnitId, (Long)serialUnitId);
                this.setRowValue("snquantity", serialQty, i);
            } else {
                this.getModel().setValue("snunit", null, i);
                this.getModel().setValue("snquantity", (Object)0, i);
                this.setUnEnable(i, new String[]{"snunit", "snquantity"});
            }
        }
    }

    private void setAssistantProperty(int i, DynamicObject item) {
        if (null != item) {
            long materialId = item.getLong("material.id");
            boolean assistunit = false;
            if (materialId > 0L) {
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bd_material", (String)"isuseauxpty", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)materialId)});
                assistunit = dynamicObject.getBoolean("isuseauxpty");
            }
            if (!assistunit) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"auxptyid"});
            } else {
                this.getView().setEnable(Boolean.TRUE, i, new String[]{"auxptyid"});
            }
        }
    }

    private void initItemUnit(int rowIndex, DynamicObject currentItem) {
        if (null != currentItem) {
            DynamicObject stockUnit = currentItem.getDynamicObject("stockunit");
            this.setItemUnits(currentItem, rowIndex, stockUnit);
        }
    }

    private void setItemUnits(DynamicObject currentItem, int rowIndex, DynamicObject stockUnit) {
        if (null != stockUnit && null != currentItem) {
            DynamicObject stockunit4Item = stockUnit;
            DynamicObject baseunit4Item = currentItem.getDynamicObject("baseunit");
            DynamicObject assistantunit4Item = currentItem.getDynamicObject("assistunit");
            this.getModel().setValue("unitid", (Object)stockunit4Item, rowIndex);
            if (null == baseunit4Item) {
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"baseunitid"});
            } else {
                this.getModel().setValue("baseunitid", (Object)baseunit4Item, rowIndex);
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"baseunitid"});
            }
            if (null == assistantunit4Item) {
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"auxptyunitid"});
            } else {
                this.getModel().setValue("auxptyunitid", (Object)assistantunit4Item, rowIndex);
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"auxptyunitid"});
            }
        }
    }

    private void initMaterialColumn(int i, DynamicObject currentItem) {
        if (null != currentItem) {
            DynamicObject material4Item = currentItem.getDynamicObject("material");
            if (null == material4Item) {
                this.getModel().setValue("materielid", null, i);
                this.getView().setEnable(Boolean.TRUE, i, new String[]{"materielid"});
            } else {
                this.getModel().setValue("materielid", (Object)material4Item, i);
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"materielid"});
            }
        }
    }

    private void afterQtyChange(PropertyChangedArgs e) {
        DynamicObject serialUnit;
        DynamicObject auxunitIdObj;
        DynamicObject srcUnit;
        int rowIndex = this.getRowIndex(e);
        DynamicObject currentRowInfo = this.getModel().getEntryRowEntity("billentry", rowIndex);
        ChangeData[] changeDatas = e.getChangeSet();
        if (changeDatas == null || changeDatas.length <= 0) {
            return;
        }
        BigDecimal qty = (BigDecimal)changeDatas[0].getNewValue();
        DynamicObject materielObj = currentRowInfo.getDynamicObject("materielid");
        Long materielId = 0L;
        if (null != materielObj) {
            materielId = (Long)materielObj.getPkValue();
        }
        if (null == (srcUnit = currentRowInfo.getDynamicObject("unitid"))) {
            return;
        }
        Long srcUnitId = (Long)srcUnit.getPkValue();
        DynamicObject baseUnit = currentRowInfo.getDynamicObject("baseunitid");
        this.setRowValue("sendqty", qty, rowIndex);
        if (null == baseUnit) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u57fa\u672c\u5355\u4f4d\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u5546\u54c1\u662f\u5426\u6b63\u786e\u3002", (String)"StockOutBillEdit_11", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
            return;
        }
        Long baseUnitId = (Long)baseUnit.getPkValue();
        BigDecimal baseQty = BigDecimal.ZERO;
        if (null != baseUnit) {
            baseQty = UnitConvertHelper.calculateDestQty((BigDecimal)qty, (Long)materielId, (Long)srcUnitId, (Long)baseUnitId);
            if (this.MAX_QTY.compareTo(baseQty) < 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6570\u91cf\u8d85\u51fa\u7cbe\u5ea6\u9650\u5236\uff0c\u8bf7\u786e\u8ba4\u6570\u91cf", (String)"StockOutBillEdit_12", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
                return;
            }
            this.setRowValue("basequantity", baseQty, rowIndex);
        }
        if (null != (auxunitIdObj = currentRowInfo.getDynamicObject("auxptyunitid"))) {
            Long assistantUnitId = (Long)auxunitIdObj.getPkValue();
            BigDecimal assistantQty = UnitConvertHelper.calculateDestQty((BigDecimal)baseQty, (Long)materielId, (Long)baseUnitId, (Long)assistantUnitId);
            if (this.MAX_QTY.compareTo(baseQty) < 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6570\u91cf\u8d85\u51fa\u7cbe\u5ea6\u9650\u5236\uff0c\u8bf7\u786e\u8ba4\u6570\u91cf", (String)"StockOutBillEdit_12", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
                return;
            }
            this.setRowValue("auxquantity", assistantQty, rowIndex);
        }
        if (null != (serialUnit = currentRowInfo.getDynamicObject("snunit"))) {
            Long serialUnitId = (Long)serialUnit.getPkValue();
            BigDecimal serialQty = UnitConvertHelper.calculateDestQty((BigDecimal)baseQty, (Long)materielId, (Long)baseUnitId, (Long)serialUnitId);
            if (this.MAX_QTY.compareTo(baseQty) < 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6570\u91cf\u8d85\u51fa\u7cbe\u5ea6\u9650\u5236\uff0c\u8bf7\u786e\u8ba4\u6570\u91cf", (String)"StockOutBillEdit_12", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
                return;
            }
            this.setRowValue("snquantity", serialQty, rowIndex);
        }
        this.recalSumQty();
    }

    private void afterUnitChange(PropertyChangedArgs e) {
        DynamicObject serialUnit;
        DynamicObject auxunitIdObj;
        int rowIndex = this.getRowIndex(e);
        DynamicObject currentRowInfo = this.getModel().getEntryRowEntity("billentry", rowIndex);
        ChangeData[] changeDatas = e.getChangeSet();
        if (changeDatas == null || changeDatas.length <= 0) {
            return;
        }
        long srcUnitId = 0L;
        DynamicObject unit = (DynamicObject)changeDatas[0].getNewValue();
        if (unit != null) {
            srcUnitId = (Long)unit.getPkValue();
        }
        BigDecimal qty = currentRowInfo.getBigDecimal("quantity");
        this.setRowValue("sendqty", qty, rowIndex);
        DynamicObject materielObj = currentRowInfo.getDynamicObject("materielid");
        Long materielId = 0L;
        if (null != materielObj) {
            materielId = (Long)materielObj.getPkValue();
        }
        long baseUnitId = 0L;
        DynamicObject baseUnit = currentRowInfo.getDynamicObject("baseunitid");
        if (null != baseUnit) {
            baseUnitId = (Long)baseUnit.getPkValue();
        }
        BigDecimal baseQty = BigDecimal.ZERO;
        if (null != baseUnit) {
            baseQty = UnitConvertHelper.calculateDestQty((BigDecimal)qty, (Long)materielId, (Long)srcUnitId, (Long)baseUnitId);
            if (this.MAX_QTY.compareTo(baseQty) < 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6570\u91cf\u8d85\u51fa\u7cbe\u5ea6\u9650\u5236\uff0c\u8bf7\u786e\u8ba4\u6570\u91cf", (String)"StockOutBillEdit_12", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
                return;
            }
            this.setRowValue("basequantity", baseQty, rowIndex);
        }
        if (null != (auxunitIdObj = currentRowInfo.getDynamicObject("auxptyunitid"))) {
            Long assistantUnitId = (Long)auxunitIdObj.getPkValue();
            BigDecimal assistantQty = UnitConvertHelper.calculateDestQty((BigDecimal)baseQty, (Long)materielId, (Long)baseUnitId, (Long)assistantUnitId);
            if (this.MAX_QTY.compareTo(baseQty) < 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6570\u91cf\u8d85\u51fa\u7cbe\u5ea6\u9650\u5236\uff0c\u8bf7\u786e\u8ba4\u6570\u91cf", (String)"StockOutBillEdit_12", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
                return;
            }
            this.setRowValue("auxquantity", assistantQty, rowIndex);
        }
        if (null != (serialUnit = currentRowInfo.getDynamicObject("snunit"))) {
            Long serialUnitId = (Long)serialUnit.getPkValue();
            BigDecimal serialQty = UnitConvertHelper.calculateDestQty((BigDecimal)baseQty, (Long)materielId, (Long)baseUnitId, (Long)serialUnitId);
            if (this.MAX_QTY.compareTo(baseQty) < 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6570\u91cf\u8d85\u51fa\u7cbe\u5ea6\u9650\u5236\uff0c\u8bf7\u786e\u8ba4\u6570\u91cf", (String)"StockOutBillEdit_12", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
                return;
            }
            this.setRowValue("snquantity", serialQty, rowIndex);
        }
        this.recalSumQty();
    }

    private Object getOutChannel() {
        return this.getModel().getValue("outchannelid");
    }

    private void setOwnerAndKeeper(int rowIndex) {
        Object outChannel = this.getOutChannel();
        if (null != outChannel) {
            IDataEntityType type = ((DynamicObject)outChannel).getDataEntityType();
            this.getModel().setValue("ownertype", (Object)type.getName(), rowIndex);
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"ownertype"});
            this.getModel().setValue("ownerid", outChannel, rowIndex);
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"ownerid"});
            this.getModel().setValue("keepertype", (Object)type.getName(), rowIndex);
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"keepertype"});
            this.getModel().setValue("keeperid", outChannel, rowIndex);
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"keeperid"});
        }
    }

    private void setDefaultStock(int rowIndx) {
        Object outChannel = this.getOutChannel();
        if (null == outChannel) {
            return;
        }
        QFilter ownerchannelid = new QFilter("ownerchannelid", "=", ((DynamicObject)outChannel).getPkValue());
        QFilter isdelivery = new QFilter("isdelivery", "=", (Object)Boolean.TRUE);
        QFilter isreturn = new QFilter("isreturn", "=", (Object)Boolean.TRUE);
        QFilter status = new QFilter("status", "=", (Object)"C");
        QFilter enable = new QFilter("enable", "=", (Object)Boolean.TRUE);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(ownerchannelid);
        filters.add(status);
        filters.add(enable);
        if (this.isOppositeDirection()) {
            filters.add(isreturn);
        } else {
            filters.add(isdelivery);
        }
        DynamicObject[] stocks = BusinessDataServiceHelper.load((String)"ococic_warehouse", (String)"id, enablelocation", (QFilter[])filters.toArray(new QFilter[0]));
        if (null != stocks && stocks.length > 0) {
            this.getModel().setValue("stockid", (Object)stocks[0], rowIndx);
            this.setStockLocationByStock(rowIndx, stocks[0]);
        }
    }

    private void setSaleOrgAndChannel(PropertyChangedArgs e) {
        DynamicObject outChannel = (DynamicObject)e.getChangeSet()[0].getNewValue();
        this.setSaleOrgAndChannel(outChannel);
    }

    protected void setSaleOrgAndChannel() {
        Object outChannel = this.getModel().getValue("outchannelid");
        if (null != outChannel) {
            this.setSaleOrgAndChannel((DynamicObject)outChannel);
        } else {
            this.getModel().setValue("org", null);
        }
    }

    private void setSaleOrgAndChannel(DynamicObject outChannel) {
        DynamicObject saleOrg = null;
        if (null == outChannel) {
            this.getModel().setValue("org", null);
        }
        if (null != outChannel) {
            DynamicObject[] ids;
            DynamicObject bizgroup = outChannel.getDynamicObject("saleorg");
            if (null != bizgroup && null != (ids = BusinessDataServiceHelper.load((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("bos_org.id", "=", bizgroup.getPkValue())})) && ids.length > 0) {
                saleOrg = ids[0];
            }
            this.getModel().setValue("org", saleOrg);
        }
    }

    private void setCurrencyByOutChannel(PropertyChangedArgs e) {
        DynamicObject outChannel = (DynamicObject)e.getChangeSet()[0].getNewValue();
        this.setCurrencyByOutChannel(outChannel);
    }

    protected void setCurrencyByOutChannel() {
        Object value = this.getModel().getValue("outchannelid");
        if (null != value) {
            this.setCurrencyByOutChannel((DynamicObject)value);
        }
    }

    private void setCurrencyByOutChannel(DynamicObject outChannel) {
        DynamicObject currency;
        if (null != outChannel && null != (currency = outChannel.getDynamicObject("currency"))) {
            this.getModel().setValue("currencyid", currency.getPkValue());
        }
    }

    private boolean isOppositeDirection() {
        String outDirection = (String)this.getModel().getValue("outdirection");
        return null != outDirection && "2".equals(outDirection);
    }

    private long getOutStockChannelPKValue() {
        Object obj = this.getF7PKValue("outchannelid");
        return obj == null ? 0L : (Long)obj;
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        String entryName;
        super.afterDeleteRow(e);
        switch (entryName = e.getEntryProp().getName()) {
            case "billentry": {
                this.recalSumQty();
                break;
            }
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        DynamicObjectCollection entriesCol = this.getModel().getEntryEntity("billentry");
        for (int i = 0; i < entriesCol.size(); ++i) {
            boolean enableLocation;
            DynamicObject warehouse = this.getF7Value("stockid", i);
            if (null == warehouse || !(enableLocation = warehouse.getBoolean("enablelocation"))) continue;
            QFilter qFilter = new QFilter("warehouseid", "=", warehouse.getPkValue());
            qFilter = qFilter.and("isdefault", "=", (Object)Boolean.TRUE);
            List locationIdList = QueryServiceHelper.queryPrimaryKeys((String)"ococic_location", (QFilter[])(qFilter = qFilter.and("enable", "=", (Object)Enable.ENABLE.toString())).toArray(), (String)"", (int)1);
            if (CollectionUtils.isEmpty((Collection)locationIdList)) continue;
            this.setValue("stockaddrid", locationIdList.get(0), i);
        }
        this.recalSumQty();
    }

    private void recalSumQty() {
        BigDecimal sumqty = BigDecimal.ZERO;
        DynamicObjectCollection entity = this.getModel().getEntryEntity("billentry");
        for (DynamicObject entry : entity) {
            BigDecimal qty = entry.getBigDecimal("quantity");
            sumqty = sumqty.add(qty);
        }
        this.setValue("sumqty", sumqty);
    }

    private void updateBillValuesForStockOut(Map<String, Object> customParams) {
        this.getModel().setValue("outchannelid", customParams.get("outchannelid"));
        this.getModel().setValue("billtypeid", customParams.get("billtypeid"));
        this.getModel().setValue("org", customParams.get("org"));
        this.getModel().setValue("currencyid", customParams.get("currencyid"));
        this.getModel().setValue("sumqty", customParams.get("sumqty"));
        this.getModel().setValue("remark", (Object)ResManager.loadKDString((String)"\u5e93\u5b58\u8c03\u51cf", (String)"StockOutBillEdit_13", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
        DynamicObjectCollection entry = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("billentry");
        DynamicObject newEntry = entry.addNew();
        newEntry.set("itemid_id", customParams.get("itemid"));
        newEntry.set("materielid_id", customParams.get("materielid"));
        newEntry.set("unitid_id", customParams.get("unitid"));
        newEntry.set("auxptyid_id", customParams.get("auxptyid"));
        newEntry.set("lotnumber", customParams.get("lotnumber"));
        newEntry.set("lotid_id", customParams.get("lotid"));
        newEntry.set("projectid_id", customParams.get("projectid"));
        if (customParams.get("productdate") != null) {
            newEntry.set("productdate", (Object)DateUtil.getDateFormat((String)customParams.get("productdate").toString()));
        }
        if (customParams.get("expiredate") != null) {
            newEntry.set("expiredate", (Object)DateUtil.getDateFormat((String)customParams.get("expiredate").toString()));
        }
        newEntry.set("unitid_id", customParams.get("unitid"));
        newEntry.set("quantity", customParams.get("quantity"));
        newEntry.set("baseunitid_id", customParams.get("baseunitid"));
        newEntry.set("basequantity", customParams.get("basequantity"));
        newEntry.set("auxptyunitid_id", customParams.get("auxptyunitid"));
        newEntry.set("auxquantity", customParams.get("auxquantity"));
        newEntry.set("stockid_id", customParams.get("stockid"));
        newEntry.set("stockaddrid_id", customParams.get("stockaddrid"));
        newEntry.set("stockstatusid_id", customParams.get("stockstatusid"));
        newEntry.set("stocktypeid_id", customParams.get("stocktypeid"));
        newEntry.set("ownertype", customParams.get("ownertype"));
        newEntry.set("ownerid_id", customParams.get("ownerid"));
        newEntry.set("keepertype", customParams.get("keepertype"));
        newEntry.set("keeperid_id", customParams.get("keeperid"));
        newEntry.set("snunit_id", customParams.get("snunit"));
        newEntry.set("snquantity", customParams.get("snquantity"));
        BusinessDataServiceHelper.loadRefence((Object[])entry.toArray(), (IDataEntityType)entry.getDynamicObjectType());
    }
}

