/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ococic.formplugin.transbill;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.util.StringUtils;
import kd.occ.ocbase.formplugin.base.OcbaseFormPlugin;
import kd.occ.ococic.business.transbill.TransBillSelectItemReturnData;
import kd.occ.ococic.business.transbill.TransBillSelectItemReturnDataEntry;

public class SelectTransGoods
extends OcbaseFormPlugin
implements BeforeF7SelectListener {
    private static final String SM_SALORDER = "sm_salorder";
    private static final String SEARCH = "search";
    private static final String BILLENTITY = "billentity";
    private static final String ENTRYENTITY = "entryentity";
    private static final String SELECTITEMID = "selectitemid";
    private static final String SELECTLOTNUMBER = "selectlotnumber";
    private static final String SRCBILLDATE = "srcbilldate";
    private static final String SETTLECURRENCYID = "settlecurrencyid";
    private static final String DELIVERYQTY = "deliveryqty";
    private static final String BASEUNIT = "baseunit";
    private static final String CANTRANSBASEQTY = "cantransbaseqty";
    private static final String JOINBASEQTY = "joinbaseqty";
    private static final String TOTALRETURNQTY = "totalreturnqty";
    private static final String SRCSUBENTRYID = "srcsubentryid";

    public void afterCreateNewData(EventObject e) {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null || !"ococic_transbill".equals(parentView.getEntityId())) {
            return;
        }
        long outChannelId = (Long)parentView.getModel().getValue("outchannelid_id");
        long saleOrgId = (Long)parentView.getModel().getValue("saleorgid_id");
        this.getModel().setValue("outchannelid", (Object)outChannelId);
        this.getModel().setValue("saleorgid", (Object)saleOrgId);
        this.getModel().setValue(BILLENTITY, parentView.getModel().getValue("datasources"));
        super.afterCreateNewData(e);
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        switch (evt.getOperateKey()) {
            case "search": {
                DynamicObject srcBillEntity = (DynamicObject)this.getModel().getValue(BILLENTITY);
                if (srcBillEntity != null && "ocbsoc_saleorder".equals(srcBillEntity.getString("number"))) {
                    this.searchSaleOrder();
                }
                if (srcBillEntity == null || !SM_SALORDER.equals(srcBillEntity.getString("number"))) break;
                this.searchSalOutBill();
                break;
            }
            case "submit": {
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
                if (entryEntity == null || entryEntity.isEmpty()) break;
                this.checkData();
                DynamicObject srcBillEntity = (DynamicObject)this.getModel().getValue(BILLENTITY);
                if ("ocbsoc_saleorder".equals(srcBillEntity.getString("number"))) {
                    this.addItemToParentPage4SaleOrder();
                    break;
                }
                if (!SM_SALORDER.equals(srcBillEntity.getString("number"))) break;
                this.addItemToParentPage();
                break;
            }
        }
        super.afterDoOperation(evt);
    }

    private void checkData() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] selectIndex = entryGrid.getSelectRows();
        DynamicObjectCollection pageEntryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        if (selectIndex.length <= 0) {
            return;
        }
        for (int index : selectIndex) {
            DynamicObject entry = (DynamicObject)pageEntryEntity.get(index);
            if (entry.getBigDecimal(JOINBASEQTY) == null || entry.getBigDecimal(DELIVERYQTY) == null || entry.getBigDecimal(JOINBASEQTY).compareTo(entry.getBigDecimal(DELIVERYQTY)) < 0) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5546\u54c1,\u5df2\u5173\u8054\u8c03\u8d27\u9000\u8d27\u57fa\u672c\u6570\u91cf\u5927\u4e8e\u7b49\u4e8e\u5df2\u53d1\u8d27\u57fa\u672c\u6570\u91cf,\u4e0d\u5141\u8bb8\u8c03\u8d27.", (String)"SelectTransGoods_2", (String)"occ-ococic-formplugin", (Object[])new Object[0]), index + 1));
        }
    }

    private void addItemToParentPage4SaleOrder() {
        TransBillSelectItemReturnData returnData = new TransBillSelectItemReturnData();
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] selectIndex = entryGrid.getSelectRows();
        DynamicObjectCollection pageEntryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        if (selectIndex.length <= 0) {
            return;
        }
        ArrayList<TransBillSelectItemReturnDataEntry> entries = new ArrayList<TransBillSelectItemReturnDataEntry>(selectIndex.length);
        for (int index : selectIndex) {
            DynamicObject entry = (DynamicObject)pageEntryEntity.get(index);
            TransBillSelectItemReturnDataEntry dataEntry = new TransBillSelectItemReturnDataEntry();
            dataEntry.setPrimaryKeyValue(entry.getLong("srcbillid"));
            dataEntry.setEntryPrimaryKeyValue(entry.getLong("srcbillentryid"));
            dataEntry.setSubEntryPrimaryKeyValue(entry.getLong(SRCSUBENTRYID));
            entries.add(dataEntry);
        }
        returnData.setEntries(entries);
        this.getView().returnDataToParent((Object)returnData);
        this.getView().close();
    }

    private void searchSaleOrder() {
        long outChannelId = (Long)this.getModel().getValue("outchannelid_id");
        long itemId = (Long)this.getModel().getValue("selectitemid_id");
        String selectLotNumber = (String)this.getModel().getValue(SELECTLOTNUMBER);
        DynamicObjectCollection pageEntryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        pageEntryEntity.clear();
        if (outChannelId == 0L) {
            return;
        }
        QFilter filter = new QFilter("itementry.deliverysubentity.deliveryorderchannel", "=", (Object)outChannelId);
        filter.and(QFilter.of((String)"itementry.deliverysubentity.deliverbaseqty>itementry.deliverysubentity.deliverytotalretbaseqty", (Object[])new Object[0]));
        if (itemId != 0L) {
            filter.and("itementry.deliverysubentity.deliveryitem", "in", (Object)itemId);
        }
        if (StringUtils.isNotNull((String)selectLotNumber)) {
            filter.and("itementry.deliverysubentity.deliverylotnumber", "=", (Object)selectLotNumber);
        }
        String selectFields = String.join((CharSequence)",", "id", "billno", "orderdate", SETTLECURRENCYID, "itementry.id", "itementry.seq", "itementry.materialid", "itementry.approveqty", "itementry.price", "itementry.taxprice", "itementry.taxrate", "itementry.taxrateid", "itementry.pricediscount", "itementry.unitdiscount", "itementry.promotiondiscount", "itementry.recdiscount", "itementry.discountamount", "itementry.unit", "itementry.baseunit", "itementry.deliverysubentity.id", "itementry.deliverysubentity.deliveryitem", "itementry.deliverysubentity.deliverybaseunit", "itementry.deliverysubentity.deliverbaseqty", "itementry.deliverysubentity.deliveryunit", "itementry.deliverysubentity.deliveryqty", "itementry.deliverysubentity.deliveryociclot", "itementry.deliverysubentity.deliveryscmlot", "itementry.deliverysubentity.deliverylotnumber", "itementry.deliverysubentity.deliveryproducedate", "itementry.deliverysubentity.deliveryexpirydate", "itementry.deliverysubentity.deliveryorderchannel", "itementry.deliverysubentity.deliverycurretbaseqty", "itementry.deliverysubentity.deliveryjoinretbaseqty", "itementry.deliverysubentity.deliverytotalretbaseqty");
        DynamicObjectCollection datas = QueryServiceHelper.query((String)"ocbsoc_saleorder", (String)selectFields, (QFilter[])filter.toArray(), (String)"billno desc", (int)999);
        for (DynamicObject data : datas) {
            DynamicObject pageEntry = pageEntryEntity.addNew();
            pageEntry.set("srcbillentity_id", (Object)"ocbsoc_saleorder");
            pageEntry.set("srcbillid", (Object)data.getLong("id"));
            pageEntry.set("srcbillnumber", (Object)data.getString("billno"));
            pageEntry.set("srcbillentryid", (Object)data.getLong("itementry.id"));
            pageEntry.set("srcbillentryseq", (Object)data.getInt("itementry.seq"));
            pageEntry.set(SRCSUBENTRYID, (Object)data.getLong("itementry.deliverysubentity.id"));
            pageEntry.set(SRCBILLDATE, (Object)data.getDate("orderdate"));
            pageEntry.set("settlecurrencyid_id", (Object)data.getLong(SETTLECURRENCYID));
            pageEntry.set("itemid_id", (Object)data.getLong("itementry.deliverysubentity.deliveryitem"));
            pageEntry.set("materialid_id", (Object)data.getLong("itementry.materialid"));
            pageEntry.set("unit_id", (Object)data.getLong("itementry.unit"));
            pageEntry.set("baseunit_id", (Object)data.getDate("itementry.baseunit"));
            pageEntry.set("srcqty", (Object)data.getBigDecimal("itementry.approveqty"));
            pageEntry.set("srcprice", (Object)data.getBigDecimal("itementry.price"));
            pageEntry.set("srctaxprice", (Object)data.getBigDecimal("itementry.taxprice"));
            pageEntry.set("taxrate", (Object)data.getBigDecimal("itementry.taxrate"));
            pageEntry.set("taxrateid_id", (Object)data.getLong("itementry.taxrateid"));
            pageEntry.set("srcpricediscount", (Object)data.getBigDecimal("itementry.pricediscount"));
            pageEntry.set("srcunitdiscount", (Object)data.getBigDecimal("itementry.unitdiscount"));
            pageEntry.set("srcpmtdiscount", (Object)data.getBigDecimal("itementry.promotiondiscount"));
            pageEntry.set("srcrecdiscount", (Object)data.getBigDecimal("itementry.recdiscount"));
            pageEntry.set("srcdiscountamount", (Object)data.getBigDecimal("itementry.discountamount"));
            pageEntry.set("scmlotid_id", (Object)data.getLong("itementry.deliverysubentity.deliveryscmlot"));
            pageEntry.set("lotid_id", (Object)data.getLong("itementry.deliverysubentity.deliveryociclot"));
            pageEntry.set("lotnumber", (Object)data.getString("itementry.deliverysubentity.deliverylotnumber"));
            pageEntry.set("productdate", (Object)data.getDate("itementry.deliverysubentity.deliveryproducedate"));
            pageEntry.set("expiredate", (Object)data.getDate("itementry.deliverysubentity.deliveryexpirydate"));
            pageEntry.set(DELIVERYQTY, (Object)data.getBigDecimal("itementry.deliverysubentity.deliverbaseqty"));
            pageEntry.set(JOINBASEQTY, (Object)data.getBigDecimal("itementry.deliverysubentity.deliveryjoinretbaseqty"));
            pageEntry.set(TOTALRETURNQTY, (Object)data.getBigDecimal("itementry.deliverysubentity.deliverytotalretbaseqty"));
            pageEntry.set(CANTRANSBASEQTY, (Object)pageEntry.getBigDecimal(DELIVERYQTY).subtract(pageEntry.getBigDecimal(JOINBASEQTY)));
        }
        if (!pageEntryEntity.isEmpty()) {
            BusinessDataServiceHelper.loadRefence((Object[])pageEntryEntity.toArray(), (IDataEntityType)((DynamicObject)pageEntryEntity.get(0)).getDataEntityType());
        }
        this.getView().updateView(ENTRYENTITY);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u5b8c\u6210", (String)"SelectTransGoods_1", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
    }

    private void addItemToParentPage() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        if (entryGrid != null) {
            int[] selectIndex = entryGrid.getSelectRows();
            DynamicObjectCollection pageEntryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
            if (selectIndex.length <= 0) {
                return;
            }
            JSONArray returnDataArray = new JSONArray();
            for (int index : selectIndex) {
                JSONObject returnData = new JSONObject();
                DynamicObject pageEntry = (DynamicObject)pageEntryEntity.get(index);
                returnData.put("srcbillentity", (Object)"ocbsoc_saleorder");
                returnData.put("srcbillid", (Object)pageEntry.getLong("srcbillid"));
                returnData.put("srcbillnumber", (Object)pageEntry.getString("srcbillnumber"));
                returnData.put("srcbillentryid", (Object)pageEntry.getLong("srcbillentryid"));
                returnData.put("srcbillentryseq", (Object)pageEntry.getInt("srcbillentryseq"));
                returnData.put("itemid", (Object)pageEntry.getLong("itemid_id"));
                returnData.put("unit", (Object)pageEntry.getLong("unit_id"));
                returnData.put("srcqty", (Object)pageEntry.getBigDecimal("srcqty"));
                returnData.put("srcprice", (Object)pageEntry.getBigDecimal("srcprice"));
                returnData.put("srctaxprice", (Object)pageEntry.getBigDecimal("srctaxprice"));
                returnData.put("taxrate", (Object)pageEntry.getBigDecimal("taxrate"));
                returnData.put("taxrateid", (Object)pageEntry.getLong("taxrateid_id"));
                returnData.put("srcpricediscount", (Object)pageEntry.getBigDecimal("srcpricediscount"));
                returnData.put("srcunitdiscount", (Object)pageEntry.getBigDecimal("srcunitdiscount"));
                returnData.put("srcpmtdiscount", (Object)pageEntry.getBigDecimal("srcpmtdiscount"));
                returnData.put("srcrecdiscount", (Object)pageEntry.getBigDecimal("srcrecdiscount"));
                returnData.put("srcdiscountamount", (Object)pageEntry.getBigDecimal("srcdiscountamount"));
                returnData.put("scmlotid", (Object)pageEntry.getLong("scmlotid_id"));
                returnData.put("lotid", (Object)pageEntry.getLong("lotid_id"));
                returnData.put("lotnumber", (Object)pageEntry.getString("lotnumber"));
                returnData.put("productdate", (Object)pageEntry.getDate("productdate"));
                returnData.put("expiredate", (Object)pageEntry.getDate("expiredate"));
                returnDataArray.add((Object)returnData);
            }
            this.getView().returnDataToParent((Object)returnDataArray);
            this.getView().close();
        }
    }

    private void searchSalOutBill() {
        DynamicObjectCollection parentEntry;
        List srcBillEntryId;
        String selectFields;
        DynamicObjectCollection datas;
        DynamicObjectCollection pageEntryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        pageEntryEntity.clear();
        long customerId = 0L;
        DynamicObject outChannel = (DynamicObject)this.getModel().getValue("outchannelid");
        if (outChannel != null) {
            customerId = outChannel.getLong("customer_id");
        }
        if (customerId == 0L) {
            return;
        }
        long itemId = (Long)this.getModel().getValue("selectitemid_id");
        String selectLotNumber = (String)this.getModel().getValue(SELECTLOTNUMBER);
        QFilter filter = new QFilter("billentry.reccustomer", "=", (Object)customerId);
        filter.and("billentry.mainbillentity", "=", (Object)SM_SALORDER);
        if (StringUtils.isNotNull((String)selectLotNumber)) {
            filter.and("billentry.lotnumber", "=", (Object)selectLotNumber);
        }
        if ((datas = QueryServiceHelper.query((String)"im_saloutbill", (String)(selectFields = String.join((CharSequence)",", "id", "billno", "billentry.mainbillid", "billentry.mainbillentryid", "billentry.lot", "billentry.lotnumber", "billentry.producedate", "billentry.expirydate")), (QFilter[])filter.toArray(), (String)"billno", (int)999)) == null || datas.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u67e5\u5230\u8bb0\u5f55", (String)"SelectTransGoods_0", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
        }
        List saleOrderIds = datas.stream().map(r -> r.getLong("billentry.mainbillid")).collect(Collectors.toList());
        List saleOrderEntryIds = datas.stream().map(r -> r.getLong("billentry.mainbillentryid")).collect(Collectors.toList());
        Map billEntryMap = datas.stream().collect(Collectors.toMap(k -> k.getLong("billentry.mainbillentryid"), Function.identity(), (r1, r2) -> r1));
        filter = new QFilter("id", "in", saleOrderIds);
        filter.and("billentry.id", "in", saleOrderEntryIds);
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && "ococic_transbill".equals(parentView.getEntityId()) && !(srcBillEntryId = (parentEntry = parentView.getModel().getEntryEntity("itementry")).stream().map(r -> r.getLong("srcbillentryid")).filter(r -> r != 0L).collect(Collectors.toList())).isEmpty()) {
            filter.and("billentry.id", "not in", srcBillEntryId);
        }
        if ((datas = QueryServiceHelper.query((String)SM_SALORDER, (String)(selectFields = String.join((CharSequence)",", "id", "billno", "bizdate", "settlecurrency", "billentry.id", "billentry.seq", "billentry.materialmasterid", "billentry.unit", "billentry.qty", "billentry.price", "billentry.priceandtax", "billentry.taxrateid", "billentry.taxrate", "billentry.discountamount", "billentry.lot", "billentry.lotnumber")), (QFilter[])filter.toArray(), (String)"billno desc", (int)999)) == null || datas.isEmpty()) {
            return;
        }
        List materialList = datas.stream().map(r -> r.getLong("billentry.materialmasterid")).collect(Collectors.toList());
        filter = new QFilter("material", "in", materialList);
        DynamicObjectCollection itemInfoList = QueryServiceHelper.query((String)"ocdbd_iteminfo", (String)String.join((CharSequence)",", "id", "material"), (QFilter[])filter.toArray());
        Map<Object, Object> materialMap = new HashMap();
        if (itemInfoList != null && !itemInfoList.isEmpty()) {
            materialMap = itemInfoList.stream().collect(Collectors.toMap(k -> k.getLong("material"), v -> v.getLong("id"), (r1, r2) -> r1));
        }
        for (DynamicObject data : datas) {
            long material = data.getLong("billentry.materialmasterid");
            if (itemId != 0L && (Long)materialMap.get(material) != itemId) continue;
            DynamicObject pageEntry = pageEntryEntity.addNew();
            pageEntry.set("srcbillentity_id", (Object)SM_SALORDER);
            pageEntry.set("srcbillid", (Object)data.getLong("id"));
            pageEntry.set("srcbillnumber", (Object)data.getString("billno"));
            pageEntry.set("srcbillentryid", (Object)data.getLong("billentry.id"));
            pageEntry.set("srcbillentryseq", (Object)data.getInt("billentry.seq"));
            pageEntry.set(SRCBILLDATE, (Object)data.getDate("bizdate"));
            pageEntry.set("settlecurrencyid_id", (Object)data.getLong("settlecurrency"));
            pageEntry.set("materialid_id", (Object)data.getLong("billentry.materialmasterid"));
            if (materialMap.containsKey(material)) {
                pageEntry.set("itemid_id", materialMap.get(material));
            }
            pageEntry.set("unit_id", (Object)data.getLong("billentry.unit"));
            BigDecimal qty = data.getBigDecimal("billentry.qty");
            pageEntry.set("srcqty", (Object)qty);
            pageEntry.set("srcprice", (Object)data.getBigDecimal("billentry.price"));
            pageEntry.set("srctaxprice", (Object)data.getBigDecimal("billentry.priceandtax"));
            pageEntry.set("taxrate", (Object)data.getBigDecimal("billentry.taxrate"));
            pageEntry.set("taxrateid_id", (Object)data.getLong("billentry.taxrateid"));
            BigDecimal discountamount = data.getBigDecimal("billentry.discountamount");
            pageEntry.set("srcdiscountamount", (Object)discountamount);
            if (discountamount != null && qty != null && qty.compareTo(BigDecimal.ZERO) != 0) {
                pageEntry.set("srcunitdiscount", (Object)discountamount.divide(qty, 10, RoundingMode.HALF_UP));
            }
            if (billEntryMap.get(data.getLong("billentry.id")) == null) continue;
            pageEntry.set("scmlotid_id", (Object)((DynamicObject)billEntryMap.get(data.getLong("billentry.id"))).getLong("billentry.lot"));
            pageEntry.set("lotnumber", (Object)((DynamicObject)billEntryMap.get(data.getLong("billentry.id"))).getString("billentry.lotnumber"));
            pageEntry.set("productdate", (Object)((DynamicObject)billEntryMap.get(data.getLong("billentry.id"))).getDate("billentry.producedate"));
            pageEntry.set("expiredate", (Object)((DynamicObject)billEntryMap.get(data.getLong("billentry.id"))).getDate("billentry.expirydate"));
        }
        if (!pageEntryEntity.isEmpty()) {
            BusinessDataServiceHelper.loadRefence((Object[])pageEntryEntity.toArray(), (IDataEntityType)((DynamicObject)pageEntryEntity.get(0)).getDataEntityType());
        }
        this.getView().updateView(ENTRYENTITY);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u5b8c\u6210", (String)"SelectTransGoods_1", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
    }
}

