/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ococic.formplugin.transbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.botp.runtime.BeforeDrawArgs;
import kd.bos.entity.botp.runtime.BeforeDrawOpResult;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.occ.ocbase.common.enums.Enable;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.StringUtils;
import kd.occ.ocbase.common.util.pos.DbUtil;
import kd.occ.ocbase.formplugin.base.OcbaseFormPlugin;
import kd.occ.ococic.business.transbill.TransBillSelectItemQueryData;
import kd.occ.ococic.business.transbill.TransBillSelectItemReturnData;
import kd.occ.ococic.business.transbill.TransBillSelectItemReturnDataEntry;
import kd.sdk.occ.ococic.extpoint.ISelectTransItemExt;
import kd.sdk.occ.ococic.extpoint.SelectTransItemExt;

public class SelectTransItem
extends OcbaseFormPlugin
implements BeforeF7SelectListener {
    PluginProxy<ISelectTransItemExt> pluginProxy = PluginProxy.create((Object)new SelectTransItemExt(), ISelectTransItemExt.class, (String)"occ.ococic.ococic_selecttransitem.ext", null);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, new String[]{"outchannelid", "itemid", "unit"});
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject transBill;
        super.afterCreateNewData(e);
        if (this.getView().getParentView() != null && (transBill = this.getView().getParentView().getModel().getDataEntity(true)) != null && "ococic_transbill".equals(transBill.getDataEntityType().getName())) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            DynamicObjectUtils.copyProperties((DynamicObject)dataEntity, (DynamicObject)transBill, (String[])new String[]{"outchannelid", "saleorgid", "settlecurrencyid"});
            DynamicObjectCollection transBillItemEntryCol = transBill.getDynamicObjectCollection("itementry");
            Map<String, List<DynamicObject>> map = transBillItemEntryCol.stream().filter(r -> DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)r, (String)"itemid") > 0L).collect(Collectors.groupingBy(r -> StringUtils.join((CharSequence)"#", (Object[])new Object[]{DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)r, (String)"itemid"), DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)r, (String)"materialid"), DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)r, (String)"unit"), DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)r, (String)"baseunit"), r.getString("lotnumber")})));
            if (!CollectionUtils.isEmpty(map)) {
                int itemSize = dataEntity.getDynamicObjectCollection("itementry").size();
                int i = 0;
                for (Map.Entry<String, List<DynamicObject>> entry : map.entrySet()) {
                    DynamicObject itemEntry = i < itemSize ? (DynamicObject)dataEntity.getDynamicObjectCollection("itementry").get(i) : dataEntity.getDynamicObjectCollection("itementry").addNew();
                    BigDecimal qty = BigDecimal.ZERO;
                    BigDecimal baseQty = BigDecimal.ZERO;
                    for (DynamicObject transBillItemEntry : entry.getValue()) {
                        qty = qty.add(transBillItemEntry.getBigDecimal("approveqty"));
                        baseQty = baseQty.add(transBillItemEntry.getBigDecimal("approvebaseqty"));
                    }
                    itemEntry.set("approveqty", (Object)qty);
                    itemEntry.set("approvebaseqty", (Object)baseQty);
                    DynamicObjectUtils.copyProperties((DynamicObject)itemEntry, (DynamicObject)entry.getValue().get(0), (String[])new String[]{"itemid", "materialid", "unit", "baseunit", "lotnumber"});
                    ++i;
                }
            }
            BusinessDataServiceHelper.loadRefence((Object[])new DynamicObject[]{dataEntity}, (IDataEntityType)dataEntity.getDynamicObjectType());
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key;
        super.afterDoOperation(args);
        switch (key = args.getOperateKey()) {
            case "dook": {
                this.returnBackInfo();
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        int index = this.getRowIndex(e);
        switch (key) {
            case "itemid": {
                DynamicObject itemDynObj = this.getEntryF7Value("itementry", "itemid", index);
                Object materialId = null;
                Object unitId = null;
                Object baseUnitId = null;
                if (itemDynObj != null) {
                    materialId = itemDynObj.getDynamicObject("material") != null ? itemDynObj.getDynamicObject("material").getPkValue() : null;
                    unitId = itemDynObj.getDynamicObject("orderunit") != null ? itemDynObj.getDynamicObject("orderunit").getPkValue() : null;
                    baseUnitId = itemDynObj.getDynamicObject("baseunit") != null ? itemDynObj.getDynamicObject("baseunit").getPkValue() : null;
                }
                this.setValue("materialid", materialId, index);
                this.setValue("unit", unitId, index);
                this.setValue("baseunit", baseUnitId, index);
                break;
            }
        }
    }

    private void returnBackInfo() {
        DynamicObject data = this.getModel().getDataEntity(true);
        long outChannelId = DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)data, (String)"outchannelid");
        long saleOrgId = DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)data, (String)"saleorgid");
        long settleCurrencyId = DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)data, (String)"settlecurrencyid");
        long botpRuleId = DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)data, (String)"botprule");
        DynamicObjectCollection itemEntryCol = data.getDynamicObjectCollection("itementry");
        int batchSize = itemEntryCol.size();
        HashSet<Long> itemIdSet = new HashSet<Long>(batchSize);
        HashSet<Long> baseUnitIdSet = new HashSet<Long>(batchSize);
        for (DynamicObject itemEntry : itemEntryCol) {
            if (!SelectTransItem.isValideItemEntry(itemEntry)) continue;
            itemIdSet.add(DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)itemEntry, (String)"itemid"));
            baseUnitIdSet.add(DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)itemEntry, (String)"baseunit"));
        }
        if (CollectionUtils.isEmpty(itemIdSet)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u8c03\u8d27\u5546\u54c1\u6570\u636e.", (String)"SelectTransItem_0", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject botpRule = BusinessDataServiceHelper.loadSingle((Object)String.valueOf(botpRuleId), (String)"botp_crlist", (String)"enabled");
        if (botpRule == null) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6807\u8bc6[%1$s]\u7684\u8f6c\u6362\u89c4\u5219\u5df2\u5220\u9664,\u8bf7\u66f4\u6362\u8f6c\u6362\u89c4\u5219.", (String)"SelectTransItem_1", (String)"occ-ococic-formplugin", (Object[])new Object[0]), String.valueOf(botpRuleId)));
            return;
        }
        if (!Enable.ENABLE.toString().equals(botpRule.getString("enabled"))) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6807\u8bc6[%1$s]\u7684\u8f6c\u6362\u89c4\u5219\u7684\u542f\u7528\u72b6\u6001\u4e0d\u4e3a\u542f\u7528,\u8bf7\u542f\u7528\u8be5\u8f6c\u6362\u89c4\u5219.", (String)"SelectTransItem_2", (String)"occ-ococic-formplugin", (Object[])new Object[0]), String.valueOf(botpRuleId)));
            return;
        }
        HashMap<Long, TransBillSelectItemReturnDataEntry> entryMap = new HashMap<Long, TransBillSelectItemReturnDataEntry>(batchSize);
        BeforeDrawArgs args = new BeforeDrawArgs("ocbsoc_saleorder", "ococic_transbill", String.valueOf(botpRuleId), this.getView().getParentView().getPageId());
        BeforeDrawOpResult beforeDrawOpResult = (BeforeDrawOpResult)ConvertServiceHelper.beforeDraw((BeforeDrawArgs)args);
        if (beforeDrawOpResult.isSuccess()) {
            QFilter qFilter = QFilter.fromSerializedString((String)beforeDrawOpResult.getDrawFilter());
            qFilter.and("orderchannelid", "=", (Object)outChannelId);
            qFilter.and("saleorgid", "=", (Object)saleOrgId);
            qFilter.and("settlecurrencyid", "=", (Object)settleCurrencyId);
            qFilter.and(String.join((CharSequence)".", "itementry", "deliverysubentity", "deliveryorderchannel"), "=", (Object)outChannelId);
            qFilter.and(String.join((CharSequence)".", "itementry", "deliverysubentity", "deliverybaseunit"), "in", baseUnitIdSet);
            qFilter.and(String.join((CharSequence)".", "itementry", "deliverysubentity", "deliveryitem"), "in", itemIdSet);
            this.pluginProxy.callAfter(p -> {
                p.beforeQuerySaleOrderData(this.getModel(), this.getView(), qFilter);
                return null;
            });
            List<TransBillSelectItemQueryData> resultList = SelectTransItem.querySaleOrder(qFilter);
            Map<String, List<TransBillSelectItemQueryData>> groupByLotNumberResult = resultList.stream().collect(Collectors.groupingBy(r -> SelectTransItem.buildGroupKeyByLotNumberResult(r)));
            Map<String, List<TransBillSelectItemQueryData>> groupNoLotNumberResult = resultList.stream().collect(Collectors.groupingBy(r -> SelectTransItem.buildGroupKeyNoLotNumberResult(r)));
            ArrayList<Integer> errorSeqList1 = new ArrayList<Integer>(batchSize);
            ArrayList<Integer> errorSeqList2 = new ArrayList<Integer>(batchSize);
            List itemEntryList = itemEntryCol.stream().filter(r -> SelectTransItem.isValideItemEntry(r)).sorted(Comparator.comparing(r -> SelectTransItem.buildGroupKeyByLotNumberResult(r), Comparator.reverseOrder())).collect(Collectors.toList());
            for (DynamicObject itemEntry : itemEntryList) {
                String lotNumber = itemEntry.getString("lotnumber");
                List<Object> groupedResultList = null;
                groupedResultList = StringUtils.isEmpty((String)lotNumber) ? groupNoLotNumberResult.get(SelectTransItem.buildGroupKeyNoLotNumberResult(itemEntry)) : groupByLotNumberResult.get(SelectTransItem.buildGroupKeyByLotNumberResult(itemEntry));
                if (CollectionUtils.isEmpty(groupedResultList)) {
                    errorSeqList1.add(itemEntry.getInt("seq"));
                    continue;
                }
                groupedResultList = groupedResultList.stream().sorted(Comparator.comparing(r -> r.getDeliveryDate(), Comparator.reverseOrder())).collect(Collectors.toList());
                BigDecimal baseQty = itemEntry.getBigDecimal("approvebaseqty");
                for (TransBillSelectItemQueryData transBillSelectItemQueryData : groupedResultList) {
                    if (BigDecimal.ZERO.compareTo(baseQty) >= 0) break;
                    BigDecimal fcurretbaseqty = transBillSelectItemQueryData.getCurretBaseQty();
                    TransBillSelectItemReturnDataEntry selectReturnItemReturnDataEntry = (TransBillSelectItemReturnDataEntry)entryMap.get(transBillSelectItemQueryData.getDetailId());
                    if (selectReturnItemReturnDataEntry == null) {
                        if (baseQty.compareTo(fcurretbaseqty) <= 0) {
                            fcurretbaseqty = baseQty;
                        }
                        entryMap.put(transBillSelectItemQueryData.getDetailId(), new TransBillSelectItemReturnDataEntry(transBillSelectItemQueryData.getId(), transBillSelectItemQueryData.getEntryId(), transBillSelectItemQueryData.getDetailId(), fcurretbaseqty));
                        baseQty = baseQty.subtract(fcurretbaseqty);
                        continue;
                    }
                    if (selectReturnItemReturnDataEntry.getCurretBaseQty().compareTo(fcurretbaseqty) >= 0) continue;
                    if (baseQty.compareTo(fcurretbaseqty = fcurretbaseqty.subtract(selectReturnItemReturnDataEntry.getCurretBaseQty())) <= 0) {
                        fcurretbaseqty = baseQty;
                    }
                    selectReturnItemReturnDataEntry.setCurretBaseQty(selectReturnItemReturnDataEntry.getCurretBaseQty().add(fcurretbaseqty));
                    entryMap.put(transBillSelectItemQueryData.getDetailId(), selectReturnItemReturnDataEntry);
                    baseQty = baseQty.subtract(fcurretbaseqty);
                }
                if (BigDecimal.ZERO.compareTo(baseQty) >= 0) continue;
                errorSeqList2.add(itemEntry.getInt("seq"));
            }
            if (!CollectionUtils.isEmpty(errorSeqList1) || !CollectionUtils.isEmpty(errorSeqList2)) {
                if (!CollectionUtils.isEmpty(errorSeqList1) && !CollectionUtils.isEmpty(errorSeqList2)) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u672a\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u8981\u8d27\u8ba2\u5355\u53d1\u8d27\u660e\u7ec6\u8bb0\u5f55\uff0c\u7b2c%2$s\u884c\u627e\u5230\u7684\u8981\u8d27\u8ba2\u5355\u53d1\u8d27\u660e\u7ec6\u53ef\u8c03\u8d27\u6570\u91cf\u4e0d\u6ee1\u8db3\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"SelectTransItem_3", (String)"occ-ococic-formplugin", (Object[])new Object[0]), StringUtils.join((CharSequence)",", (Object[])new Object[]{errorSeqList1}), StringUtils.join((CharSequence)",", (Object[])new Object[]{errorSeqList2})));
                } else if (!CollectionUtils.isEmpty(errorSeqList1)) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u672a\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u8981\u8d27\u8ba2\u5355\u53d1\u8d27\u660e\u7ec6\u8bb0\u5f55\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"SelectTransItem_4", (String)"occ-ococic-formplugin", (Object[])new Object[0]), StringUtils.join((CharSequence)",", (Object[])new Object[]{errorSeqList1})));
                } else if (!CollectionUtils.isEmpty(errorSeqList2)) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u627e\u5230\u7684\u8981\u8d27\u8ba2\u5355\u53d1\u8d27\u660e\u7ec6\u53ef\u8c03\u8d27\u6570\u91cf\u4e0d\u6ee1\u8db3\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"SelectTransItem_5", (String)"occ-ococic-formplugin", (Object[])new Object[0]), StringUtils.join((CharSequence)",", (Object[])new Object[]{errorSeqList2})));
                }
            } else if (!CollectionUtils.isEmpty(entryMap)) {
                List<TransBillSelectItemReturnDataEntry> entries = entryMap.values().stream().collect(Collectors.toList());
                SelectTransItem.updateSaleOrderDeliveryCurretBaseQty(entries);
                this.getView().returnDataToParent((Object)new TransBillSelectItemReturnData(botpRuleId, entries));
                this.getView().close();
            }
        } else {
            this.getView().showErrorNotification(beforeDrawOpResult.getMessage());
        }
    }

    private static void updateSaleOrderDeliveryCurretBaseQty(List<TransBillSelectItemReturnDataEntry> entries) {
        if (!CollectionUtils.isEmpty(entries)) {
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>(entries.size());
            for (TransBillSelectItemReturnDataEntry entry : entries) {
                paramsList.add(new Object[]{entry.getCurretBaseQty(), entry.getSubEntryPrimaryKeyValue()});
            }
            DB.executeBatch((DBRoute)DbUtil.OCC_DB, (String)"update t_ocbsoc_delyrecentry set fcurretbaseqty = ? where fdetailid = ? ", paramsList);
        }
    }

    private static boolean isValideItemEntry(DynamicObject itemEntry) {
        BigDecimal qty = itemEntry.getBigDecimal("approveqty");
        long itemId = DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)itemEntry, (String)"itemid");
        long baseUnitId = DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)itemEntry, (String)"baseunit");
        return BigDecimal.ZERO.compareTo(qty) < 0 && itemId > 0L && baseUnitId > 0L;
    }

    private static String buildGroupKeyByLotNumberResult(DynamicObject itemEntry) {
        return SelectTransItem.buildGroupKey(DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)itemEntry, (String)"itemid"), DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)itemEntry, (String)"baseunit"), itemEntry.getString("lotnumber"));
    }

    private static String buildGroupKeyNoLotNumberResult(DynamicObject itemEntry) {
        return SelectTransItem.buildGroupKey(DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)itemEntry, (String)"itemid"), DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)itemEntry, (String)"baseunit"));
    }

    private static String buildGroupKeyByLotNumberResult(TransBillSelectItemQueryData data) {
        return SelectTransItem.buildGroupKey(data.getItemId(), data.getBaseUnitId(), data.getLotNumber());
    }

    private static String buildGroupKeyNoLotNumberResult(TransBillSelectItemQueryData data) {
        return SelectTransItem.buildGroupKey(data.getItemId(), data.getBaseUnitId());
    }

    private static String buildGroupKey(long itemId, long baseUnitId) {
        return SelectTransItem.buildGroupKey(itemId, baseUnitId, null);
    }

    private static String buildGroupKey(long itemId, long baseUnitId, String lotNumber) {
        return lotNumber == null ? String.join((CharSequence)"#", String.valueOf(itemId), String.valueOf(baseUnitId)) : String.join((CharSequence)"#", String.valueOf(itemId), String.valueOf(baseUnitId), lotNumber);
    }

    private static List<TransBillSelectItemQueryData> querySaleOrder(QFilter qFilter) {
        String idField = "id";
        String itemEntityIdField = String.join((CharSequence)".", "itementry", "id");
        String deliverySubEntityIdField = String.join((CharSequence)".", "itementry", "deliverysubentity", "id");
        String deliveryDateField = String.join((CharSequence)".", "itementry", "deliverysubentity", "deliverydate");
        String deliverBaseQtyField = String.join((CharSequence)".", "itementry", "deliverysubentity", "deliverbaseqty");
        String deliveryJoinRetBaseQtyField = String.join((CharSequence)".", "itementry", "deliverysubentity", "deliveryjoinretbaseqty");
        String lotNumberField = String.join((CharSequence)".", "itementry", "deliverysubentity", "deliverylotnumber");
        String itemField = String.join((CharSequence)".", "itementry", "deliverysubentity", "deliveryitem");
        String baseUnitField = String.join((CharSequence)".", "itementry", "deliverysubentity", "deliverybaseunit");
        String selectFields = F7Utils.getSelectCols((String[])new String[]{idField, itemEntityIdField, deliverySubEntityIdField, deliveryDateField, deliverBaseQtyField, deliveryJoinRetBaseQtyField, lotNumberField, itemField, baseUnitField});
        DynamicObjectCollection saleOrderCol = QueryServiceHelper.query((String)"ocbsoc_saleorder", (String)selectFields, (QFilter[])qFilter.toArray());
        ArrayList<TransBillSelectItemQueryData> dataList = new ArrayList<TransBillSelectItemQueryData>(saleOrderCol.size());
        for (DynamicObject saleOrder : saleOrderCol) {
            BigDecimal curretBaseQty;
            long id = saleOrder.getLong(idField);
            long entryId = saleOrder.getLong(itemEntityIdField);
            long detailId = saleOrder.getLong(deliverySubEntityIdField);
            long itemId = saleOrder.getLong(itemField);
            long baseUnitId = saleOrder.getLong(baseUnitField);
            Date deliveryDate = saleOrder.getDate(deliveryDateField);
            if (deliveryDate == null) {
                deliveryDate = DateUtil.formatDate((String)"1000-1-1 00:00:00", (String)"yyyy-MM-dd HH:mm:ss");
            }
            if ((curretBaseQty = saleOrder.getBigDecimal(deliverBaseQtyField).subtract(saleOrder.getBigDecimal(deliveryJoinRetBaseQtyField))).compareTo(BigDecimal.ZERO) <= 0) continue;
            String lotNumber = saleOrder.getString(lotNumberField);
            dataList.add(new TransBillSelectItemQueryData(id, entryId, detailId, itemId, baseUnitId, deliveryDate, curretBaseQty, lotNumber));
        }
        return dataList;
    }
}

