/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ococic.formplugin.transbill;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.occ.ocbase.business.b2b.B2BUserHelper;
import kd.occ.ocbase.business.b2b.ChannelHelper;
import kd.occ.ocbase.business.b2b.ItemBusinessHelper;
import kd.occ.ocbase.common.helper.CUserHelper;
import kd.occ.ocbase.common.status.Status;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.SysParamsUtil;
import kd.occ.ococic.formplugin.transbill.TransBillEdit;

public class TransBillB2bEdit
extends TransBillEdit {
    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (this.getView().getPageCache().get("isfrombotp") == null) {
            long orderChannelId = B2BUserHelper.getLoginChannelId();
            String transbillDriver = (String)this.getModel().getValue("transbilldriver");
            if ("B".equals(transbillDriver)) {
                this.setValue("outchannelid", null);
                this.setValue("inchannelid", orderChannelId);
            } else {
                this.setValue("outchannelid", orderChannelId);
                String transbillType = (String)this.getModel().getValue("transbilltype");
                this.setValue("inchannelid", "0".equals(transbillType) ? Long.valueOf(orderChannelId) : null);
            }
        }
        DynamicObject channelDynObj = this.getF7Value("outchannelid");
        DynamicObjectCollection entryColl = this.getModel().getEntryEntity("itementry");
        long settleCurrencyId = 0L;
        long saleOrgId = 0L;
        long stockId = 0L;
        if (channelDynObj != null) {
            settleCurrencyId = channelDynObj.getLong("currency_id");
            saleOrgId = channelDynObj.getLong("saleorg_id");
            stockId = ChannelHelper.getChannelDefaultDeliveryStockId((long)channelDynObj.getLong("id"), (boolean)false, (boolean)true, (boolean)false);
        }
        this.setValue("settlecurrencyid", settleCurrencyId);
        this.setValue("outwarehouseid_h", stockId);
        this.setValue("saleorgid", saleOrgId);
        int size = entryColl.size();
        for (int i = 0; i < size; ++i) {
            this.setValue("outownerid", channelDynObj, i);
            this.setValue("outkeeperid", channelDynObj, i);
            this.setValue("outwarehouseid", stockId, i);
            this.setValue("inownerid", channelDynObj, i);
            this.setValue("inkeeperid", channelDynObj, i);
            this.setValue("inwarehouseid", null, i);
        }
        super.setTransBillChannel();
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (SysParamsUtil.isEnablePreSubmit((String)"ococic_transbill")) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_presubmit", "bar_cancelpresubmit"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_submit", "bar_unsubmit"});
            if (!Status.SAVED.toString().equalsIgnoreCase((String)this.getModel().getValue("billstatus"))) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"bar_presubmit"});
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_presubmit", "bar_cancelpresubmit"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_submit", "bar_unsubmit"});
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String key;
        AbstractOperate operate = (AbstractOperate)e.getSource();
        switch (key = operate.getOperateKey()) {
            case "presubmit": {
                OperationResult result;
                if (!Status.SAVED.toString().equalsIgnoreCase((String)this.getModel().getValue("billstatus")) || (result = this.getView().invokeOperation("cp_save")).isSuccess()) break;
                e.setCancel(true);
                break;
            }
        }
        super.beforeDoOperation(e);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "outchannelid": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)new QFilter("id", "in", (Object)CUserHelper.getAuthorizedChannelIdList()));
                break;
            }
            case "itemid": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)ItemBusinessHelper.getDpItemFilter());
                break;
            }
            default: {
                super.beforeF7Select(e);
            }
        }
    }
}

