/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ococic.formplugin.transbill;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.DrawArgs;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.occ.ocbase.business.b2b.ChannelHelper;
import kd.occ.ocbase.business.billalgorithm.TransBillAlgorithmForForm;
import kd.occ.ocbase.business.helper.UnitConvertHelper;
import kd.occ.ocbase.business.helper.saleorder.SaleOrderBusinessHelper;
import kd.occ.ocbase.common.constants.BigDecimalConstants;
import kd.occ.ocbase.common.constants.OcocicLotConst;
import kd.occ.ocbase.common.constants.PriceFetchParam;
import kd.occ.ocbase.common.constants.PriceFetchResult;
import kd.occ.ocbase.common.enums.DiscountTypeEnum;
import kd.occ.ocbase.common.enums.EnableStatusEnum;
import kd.occ.ocbase.common.enums.channel.ChannelSupplyRelation;
import kd.occ.ocbase.common.helper.CSerialHelper;
import kd.occ.ocbase.common.helper.CUserHelper;
import kd.occ.ocbase.common.helper.LspWapper;
import kd.occ.ocbase.common.util.BigDecimalUtil;
import kd.occ.ocbase.common.util.BillTypeParameterHelper;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.ItemNSaleControlUtil;
import kd.occ.ocbase.common.util.PriceServiceUtil;
import kd.occ.ocbase.common.util.QueryUtil;
import kd.occ.ocbase.common.util.StringUtils;
import kd.occ.ocbase.formplugin.base.OcbaseBillPlugin;
import kd.occ.ococic.business.transbill.TransBillSelectItemReturnData;
import kd.occ.ococic.business.transbill.TransBillSelectItemReturnDataEntry;
import kd.occ.ococic.enums.SnStatusEnum;

public class TransBillEdit
extends OcbaseBillPlugin
implements BeforeF7SelectListener {
    private TransBillAlgorithmForForm billAlgo = null;
    private static final String SELECTTRANSGOODS = "selecttransgoods";
    private static final String SELECTTRANSITEM = "selecttransitem";
    protected static final String ISFROMBOTP = "isfrombotp";
    private static final String SNBATCHINPUT = "snbatchinput";
    private static final String SNINPUT = "sninput";

    private TransBillAlgorithmForForm getAlgorithm() {
        if (this.billAlgo == null) {
            this.billAlgo = new TransBillAlgorithmForForm(this.getModel());
        }
        return this.billAlgo;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, new String[]{"outchannelid", "outwarehouseid_h", "inchannelid", "inwarehouseid_h", "itemid", "unit", "outwarehouseid", "inwarehouseid", "outlocationid", "inlocationid", "serialid", "deliveryaddressid"});
        this.addClickListeners(new String[]{SNBATCHINPUT});
        this.addClickListeners(new String[]{"lotnumber"});
        this.addClickListeners(new String[]{"serialnumber"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (!this.isFromImport()) {
            this.setBillTransBillType();
            this.setValue("billtypedata", this.getF7Value("billtypeid"));
            long saleOrgId = (Long)this.getModel().getValue("saleorgid_id");
            this.setSettleOrg(saleOrgId);
            this.setValue("exratedate", DateUtil.getNowDate());
            if (this.getView().getPageCache().get(ISFROMBOTP) != null) {
                long inChannelId = Long.parseLong(this.getView().getPageCache().get("inchannelid"));
                long outChannelId = Long.parseLong(this.getView().getPageCache().get("outchannelid"));
                this.setValue("inchannelid", inChannelId);
                this.setValue("outchannelid", outChannelId);
                DynamicObjectCollection itemList = this.getModel().getEntryEntity("itementry");
                if (itemList != null && itemList.size() > 0) {
                    for (int i = 0; i < itemList.size(); ++i) {
                        this.getAlgorithm().calQtysByItemApproveBaseQty(i);
                    }
                }
            }
        }
    }

    public void afterBindData(EventObject e) {
        this.setValue("billtypedata", this.getF7Value("billtypeid"), false);
        this.getModel().getDataEntity().getDataEntityState().setBizChanged(false);
        super.afterBindData(e);
    }

    public void click(EventObject e) {
        String key;
        super.click(e);
        switch (key = ((Control)e.getSource()).getKey()) {
            case "lotnumber": {
                int rowIndex = this.getCurrentRowIndex("itementry");
                if (this.isNullItemId(rowIndex)) {
                    return;
                }
                this.showLotInfoF7(rowIndex);
                break;
            }
            case "serialnumber": {
                int parentRowIndex = this.getCurrentRowIndex("itementry");
                if (this.isNullItemId(parentRowIndex)) {
                    return;
                }
                BasedataEdit snIdBaseEdit = (BasedataEdit)this.getControl("serialid");
                int subRowIndex = this.getCurrentRowIndex("itementry");
                snIdBaseEdit.setQFilters(this.getSNFilterByItemId(subRowIndex));
                snIdBaseEdit.click();
                break;
            }
            case "snbatchinput": {
                FormShowParameter parameter = new FormShowParameter();
                parameter.setFormId("ococic_batchinputserial");
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SNBATCHINPUT));
                this.getView().showForm(parameter);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        AbstractOperate operate = (AbstractOperate)args.getSource();
        switch (key = operate.getOperateKey()) {
            case "selecttransgoods": {
                FormShowParameter parameter = new FormShowParameter();
                parameter.setFormId("ococic_selecttransgoods");
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SELECTTRANSGOODS));
                this.getView().showForm(parameter);
                break;
            }
        }
        super.beforeDoOperation(args);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key;
        switch (key = args.getOperateKey()) {
            case "selecttransitem": {
                if (!args.getOperationResult().isSuccess()) break;
                FormShowParameter parameter = new FormShowParameter();
                parameter.setFormId("ococic_selecttransitem");
                parameter.setStatus(OperationStatus.EDIT);
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SELECTTRANSITEM));
                this.getView().showForm(parameter);
                break;
            }
        }
        super.afterDoOperation(args);
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        String entryName;
        switch (entryName = e.getEntryProp().getName()) {
            case "itementry": {
                this.resetRecEntry();
                this.recalSumQty();
                break;
            }
        }
        super.afterDeleteRow(e);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        super.closedCallBack(evt);
        switch (actionId = evt.getActionId()) {
            case "snbatchinput": {
                String[] snArray = (String[])evt.getReturnData();
                if (snArray == null || snArray.length <= 0) break;
                ArrayList<String> snList = new ArrayList<String>(Arrays.asList(snArray));
                this.checkSnExist(snList);
                this.addSnToEntry(snList);
                break;
            }
            case "lotnumber": {
                Object returnData = evt.getReturnData();
                if (returnData == null) {
                    return;
                }
                ListSelectedRowCollection rowInfo = (ListSelectedRowCollection)returnData;
                Object entryPk = rowInfo.getEntryPrimaryKeyValues()[0];
                Object pk = rowInfo.getPrimaryKeyValues()[0];
                int rowIndex = this.getCurrentRowIndex("itementry");
                this.setLotInfoByLot(Long.parseLong(pk.toString()), Long.parseLong(entryPk.toString()), null, rowIndex);
                break;
            }
            case "selecttransgoods": {
                Object returnData = evt.getReturnData();
                if (returnData instanceof TransBillSelectItemReturnData) {
                    this.selectItemReturnDataToPage4SaleOrder(evt);
                    break;
                }
                this.selectItemReturnDataToPage(evt);
                break;
            }
            case "selecttransitem": {
                Object returnData = evt.getReturnData();
                if (!(returnData instanceof TransBillSelectItemReturnData)) break;
                this.selectItemReturnDataToPage4SaleOrder(evt);
                break;
            }
        }
    }

    private void selectItemReturnDataToPage4SaleOrder(ClosedCallBackEvent evt) {
        TransBillSelectItemReturnData selectReturnItemReturnData = (TransBillSelectItemReturnData)evt.getReturnData();
        String sourceEntityNumber = "ocbsoc_saleorder";
        String targetEntityNumber = "ococic_transbill";
        String ruleId = "1809351124923683840";
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>(selectReturnItemReturnData.getEntries().size());
        for (TransBillSelectItemReturnDataEntry selectReturnItemReturnDataEntry : selectReturnItemReturnData.getEntries()) {
            ListSelectedRow listSelectedRow = new ListSelectedRow();
            listSelectedRow.setPrimaryKeyValue((Object)selectReturnItemReturnDataEntry.getPrimaryKeyValue());
            listSelectedRow.setPkLongType(true);
            listSelectedRow.setEntryEntityKey("itementry");
            listSelectedRow.setEntryPrimaryKeyValue((Object)selectReturnItemReturnDataEntry.getEntryPrimaryKeyValue());
            listSelectedRow.setEntryPkLongType(true);
            listSelectedRow.setSubEntryEntityKey("deliverysubentity");
            listSelectedRow.setSubEntryPrimaryKeyValue((Object)selectReturnItemReturnDataEntry.getSubEntryPrimaryKeyValue());
            listSelectedRow.setSubEntryPkLongType(true);
            selectedRows.add(listSelectedRow);
        }
        String targetPageId = this.getView().getPageId();
        DrawArgs args = new DrawArgs(sourceEntityNumber, targetEntityNumber, ruleId, selectedRows, targetPageId);
        ArrayList<String> clearEntrys = new ArrayList<String>(3);
        clearEntrys.add("itementry");
        clearEntrys.add("recentryentity");
        clearEntrys.add("subentryentity");
        args.setClearEntrys(clearEntrys);
        ConvertOperationResult drawResult = ConvertServiceHelper.draw((DrawArgs)args);
        if (drawResult.isSuccess()) {
            MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)targetEntityNumber);
            List targetBillObjs = drawResult.loadTargetDataObjects(new IRefrencedataProvider(){

                public void fillReferenceData(Object[] objs, IDataEntityType dType) {
                    BusinessDataReader.loadRefence((Object[])objs, (IDataEntityType)dType);
                }
            }, targetMainType);
            DynamicObject targetBill = (DynamicObject)targetBillObjs.get(0);
            this.getView().getPageCache().put(ISFROMBOTP, "1");
            this.getView().getPageCache().put("inchannelid", this.getModel().getValue("inchannelid_id").toString());
            this.getView().getPageCache().put("outchannelid", this.getModel().getValue("outchannelid_id").toString());
            this.getView().getModel().createNewData((Object)targetBill);
            this.getView().updateView();
            DynamicObjectCollection itemEntry = this.getModel().getEntryEntity("itementry");
            for (DynamicObject item : itemEntry) {
                int rowIndex = item.getInt("seq") - 1;
                this.fetchTaxPrice(rowIndex);
            }
        } else {
            this.getView().showErrorNotification(drawResult.getMessage());
        }
        this.resetRecEntry();
        DynamicObjectCollection itemEntry = this.getModel().getEntryEntity("itementry");
        for (DynamicObject item : itemEntry) {
            int rowIndex = item.getInt("seq") - 1;
            this.setRollBackAmountInfo(rowIndex);
        }
    }

    private void getPageSelectItem(TransBillSelectItemReturnData selectReturnItemReturnData) {
        DynamicObjectCollection itemEntry = this.getModel().getEntryEntity("itementry");
        if (itemEntry != null && !itemEntry.isEmpty()) {
            List returnDataEntries = selectReturnItemReturnData.getEntries();
            for (DynamicObject item : itemEntry) {
                long primaryKeyValue = item.getLong("srcbillid");
                long entryPrimaryKeyValue = item.getLong("srcbillentryid");
                long subEntryPrimaryKeyValue = item.getLong("srcdeliveryid");
                boolean isExist = returnDataEntries.stream().anyMatch(r -> r.getEntryPrimaryKeyValue() == primaryKeyValue && r.getEntryPrimaryKeyValue() == entryPrimaryKeyValue && r.getSubEntryPrimaryKeyValue() == subEntryPrimaryKeyValue);
                if (primaryKeyValue == 0L || entryPrimaryKeyValue == 0L || subEntryPrimaryKeyValue == 0L || isExist) continue;
                TransBillSelectItemReturnDataEntry dataEntry = new TransBillSelectItemReturnDataEntry();
                dataEntry.setPrimaryKeyValue(primaryKeyValue);
                dataEntry.setEntryPrimaryKeyValue(entryPrimaryKeyValue);
                dataEntry.setSubEntryPrimaryKeyValue(subEntryPrimaryKeyValue);
                returnDataEntries.add(dataEntry);
            }
        }
    }

    private void selectItemReturnDataToPage(ClosedCallBackEvent evt) {
        JSONArray returnDataArray = (JSONArray)evt.getReturnData();
        if (returnDataArray == null || returnDataArray.isEmpty()) {
            return;
        }
        int[] newRows = this.getModel().batchCreateNewEntryRow("itementry", returnDataArray.size());
        for (int i = 0; i < returnDataArray.size(); ++i) {
            JSONObject jsonData = returnDataArray.getJSONObject(i);
            int index = newRows[i];
            this.triggerChangeEvent = false;
            this.setValue("srcbillentity", jsonData.getString("srcbillentity"), index);
            this.setValue("srcbillid", jsonData.getLong("srcbillid"), index);
            this.setValue("srcbillnumber", jsonData.getString("srcbillnumber"), index);
            this.setValue("srcbillentryid", jsonData.getLong("srcbillentryid"), index);
            this.setValue("srcbillentryseq", jsonData.getInteger("srcbillentryseq"), index);
            this.setValue("itemid", jsonData.getLong("itemid"), index);
            this.setValue("unit", jsonData.getLong("unit"), index);
            this.setValue("srcqty", jsonData.getBigDecimal("srcqty"), index);
            this.setValue("srcprice", jsonData.getBigDecimal("srcprice"), index);
            this.setValue("srctaxprice", jsonData.getBigDecimal("srctaxprice"), index);
            this.setValue("taxrate", jsonData.getBigDecimal("taxrate"), index);
            this.setValue("taxrateid", jsonData.getLong("taxrateid"), index);
            this.setValue("srcpricediscount", jsonData.getBigDecimal("srcpricediscount"), index);
            this.setValue("srcunitdiscount", jsonData.getBigDecimal("srcunitdiscount"), index);
            this.setValue("srcpmtdiscount", jsonData.getBigDecimal("srcpmtdiscount"), index);
            this.setValue("srcrecdiscount", jsonData.getBigDecimal("srcrecdiscount"), index);
            this.setValue("srcdiscountamount", jsonData.getBigDecimal("srcdiscountamount"), index);
            this.setValue("scmlotid", jsonData.getLong("scmlotid"), index);
            this.setValue("lotid", jsonData.getLong("lotid"), index);
            this.setValue("lotnumber", jsonData.getString("lotnumber"), index);
            this.setValue("productdate", jsonData.getDate("productdate"), index);
            this.setValue("expiredate", jsonData.getDate("expiredate"), index);
            this.triggerChangeEvent = true;
            this.fetchTaxPrice(index);
        }
        this.resetRecEntry();
    }

    private void resetRecEntry() {
        this.getModel().deleteEntryData("recentryentity");
        DynamicObjectCollection itemEntry = this.getModel().getEntryEntity("itementry");
        if (itemEntry == null || itemEntry.isEmpty()) {
            return;
        }
        List srcBillIds = itemEntry.stream().map(r -> r.getLong("srcbillid")).collect(Collectors.toList());
        List srcBillEntryIds = itemEntry.stream().map(r -> r.getLong("srcbillentryid")).collect(Collectors.toList());
        srcBillIds.remove(0L);
        srcBillEntryIds.remove(0L);
        if (srcBillIds.isEmpty() || srcBillEntryIds.isEmpty()) {
            return;
        }
        QFilter filter = new QFilter("id", "in", srcBillIds);
        String selectFields = String.join((CharSequence)",", "id", "recentryentity.id", "recentryentity.cashpoolid", "recentryentity.cashpoolsrcid", "recentryentity.cashpoolsrcentryid", "recentryentity.cashpoolsrcentity", "recentryentity.cashpoolsrcnumber", "recentryentity.receiptoffsetid", "recentryentity.accounttypeid");
        DynamicObjectCollection recEntryEntity = QueryServiceHelper.query((String)"ocbsoc_saleorder", (String)selectFields, (QFilter[])filter.toArray());
        if (recEntryEntity == null || recEntryEntity.isEmpty()) {
            return;
        }
        filter = new QFilter("id", "in", srcBillIds);
        filter.and("recdiscountentry.itementryid", "in", srcBillEntryIds);
        selectFields = String.join((CharSequence)",", "id", "recdiscountentry.id", "recdiscountentry.itementryid", "recdiscountentry.recentryid", "recdiscountentry.recdiscountamount", "recdiscountentry.unitrecdiscount");
        DynamicObjectCollection recDiscountEntryEntity = QueryServiceHelper.query((String)"ocbsoc_saleorder", (String)selectFields, (QFilter[])filter.toArray());
        if (recDiscountEntryEntity == null || recDiscountEntryEntity.isEmpty()) {
            return;
        }
        Map recEntryMap = recEntryEntity.stream().collect(Collectors.toMap(k -> k.getLong("recentryentity.id"), Function.identity(), (r1, r2) -> r1));
        int[] rowIndexs = this.getModel().batchCreateNewEntryRow("recentryentity", recDiscountEntryEntity.size());
        for (int i = 0; i < recDiscountEntryEntity.size(); ++i) {
            DynamicObject recDiscountEntry = (DynamicObject)recDiscountEntryEntity.get(i);
            DynamicObject recEntry = (DynamicObject)recEntryMap.get(recDiscountEntry.getLong("recdiscountentry.recentryid"));
            int rowIndex = rowIndexs[i];
            this.setValue("cashpoolid", recEntry.getLong("recentryentity.cashpoolid"), rowIndex);
            this.setValue("cashpoolsrcentity", recEntry.getString("recentryentity.cashpoolsrcentity"), rowIndex);
            this.setValue("cashpoolsrcid", recEntry.getLong("recentryentity.cashpoolsrcid"), rowIndex);
            this.setValue("cashpoolsrcnumber", recEntry.getString("recentryentity.cashpoolsrcnumber"), rowIndex);
            this.setValue("cashpoolsrcentryid", recEntry.getLong("recentryentity.cashpoolsrcentryid"), rowIndex);
            this.setValue("receiptoffsetid", recEntry.getLong("recentryentity.receiptoffsetid"), rowIndex);
            this.setValue("accounttypeid", recEntry.getLong("recentryentity.accounttypeid"), rowIndex);
            this.setValue("recdiscountamount", recDiscountEntry.getBigDecimal("recdiscountentry.recdiscountamount"), rowIndex);
            this.setValue("unitrecdiscount", recDiscountEntry.getBigDecimal("recdiscountentry.unitrecdiscount"), rowIndex);
            this.setValue("recsrcbillentryid", recDiscountEntry.getLong("recdiscountentry.itementryid"), rowIndex);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (!this.triggerChangeEvent) {
            return;
        }
        String key = e.getProperty().getName();
        int rowIndex = this.getRowIndex(e);
        Object oldValue = e.getChangeSet()[0].getOldValue();
        switch (key) {
            case "saleorgid": {
                this.setSettleOrg((Long)this.getModel().getValue("saleorgid_id"));
                break;
            }
            case "settlecurrencyid": {
                this.setExRateTable();
                break;
            }
            case "sumtaxamount": {
                this.setValue("ordertaxamount", this.getModel().getValue("sumtaxamount"));
                break;
            }
            case "billtypedata": {
                this.setValue("billtypeid", this.getF7Value("billtypedata"));
                break;
            }
            case "billtypeid": {
                this.setBillTransBillType();
                break;
            }
            case "transbilldriver": {
                this.setTransBillChannel();
                break;
            }
            case "transbillchannelid": {
                long transbillchannelId = (Long)this.getModel().getValue("transbillchannelid_id");
                DynamicObject deliveryAddress = ChannelHelper.getDefaultDeliveryAddressByChannelId((long)transbillchannelId);
                this.getModel().setValue("deliveryaddressid", deliveryAddress != null ? deliveryAddress.get("id") : null);
                break;
            }
            case "itemid": {
                this.getModel().deleteEntryData("subentryentity");
                this.setValue("lotnumber", null, rowIndex);
                this.setValue("lotid", null, rowIndex);
                break;
            }
            case "auxptyid": {
                this.setValue("lotnumber", null, rowIndex);
                this.setValue("lotid", null, rowIndex);
                break;
            }
            case "lotnumber": {
                this.setValue("lotid", null, rowIndex);
                this.setValue("productdate", null, rowIndex);
                this.setValue("expiredate", null, rowIndex);
                this.setLotInfoByLot(0L, 0L, this.getStringValue("lotnumber", rowIndex), rowIndex);
                break;
            }
            case "approveqty": 
            case "unit": {
                this.getAlgorithm().calQtysByItemApproveQty(rowIndex);
                this.setRollBackAmountInfo(rowIndex);
                this.recalSumQty();
                break;
            }
            case "approveassistqty": {
                this.getAlgorithm().calQtysByItemAssistApproveQty(rowIndex);
                this.recalSumQty();
                break;
            }
            case "outchannelid": {
                DynamicObject channelDynObj = this.getF7Value("outchannelid");
                DynamicObjectCollection entryColl = this.getModel().getEntryEntity("itementry");
                int size = entryColl.size();
                for (int i = 0; i < size; ++i) {
                    this.setValue("outownerid", channelDynObj, i);
                    this.setValue("outkeeperid", channelDynObj, i);
                    this.setValue("outwarehouseid", null, i);
                }
                long settleCurrencyId = 0L;
                long saleOrgId = 0L;
                long stockId = 0L;
                long outChannelId = 0L;
                if (channelDynObj != null) {
                    outChannelId = channelDynObj.getLong("id");
                    settleCurrencyId = channelDynObj.getLong("currency_id");
                    saleOrgId = channelDynObj.getLong("saleorg_id");
                    stockId = ChannelHelper.getChannelDefaultDeliveryStockId((long)outChannelId, (boolean)false, (boolean)true, (boolean)false);
                }
                this.setValue("settlecurrencyid", settleCurrencyId);
                this.setValue("outwarehouseid_h", stockId == 0L ? null : Long.valueOf(stockId));
                this.setValue("saleorgid", saleOrgId);
                this.setTransBillChannel();
                break;
            }
            case "inchannelid": {
                DynamicObject inChannelDynObj = this.getF7Value("inchannelid");
                long inStockId = 0L;
                if (inChannelDynObj != null) {
                    inStockId = ChannelHelper.getChannelDefaultDeliveryStockId((long)inChannelDynObj.getLong("id"), (boolean)true, (boolean)false, (boolean)false);
                }
                this.setValue("inwarehouseid_h", inStockId == 0L ? null : Long.valueOf(inStockId));
                DynamicObjectCollection entryColl = this.getModel().getEntryEntity("itementry");
                int size = entryColl.size();
                for (int i = 0; i < size; ++i) {
                    this.setValue("inownerid", inChannelDynObj, i);
                    this.setValue("inkeeperid", inChannelDynObj, i);
                    this.setValue("inwarehouseid", inStockId == 0L ? null : Long.valueOf(inStockId), i);
                }
                this.setTransBillChannel();
                break;
            }
            case "outwarehouseid_h": 
            case "inwarehouseid_h": {
                this.batchSetEntryWarehouseId();
                break;
            }
            case "outwarehouseid": {
                this.setValue("outlocationid", null, rowIndex);
                break;
            }
            case "inwarehouseid": {
                this.setValue("inlocationid", null, rowIndex);
                break;
            }
            case "serialid": {
                String serialNumber = null;
                DynamicObject serialDynObj = this.getF7Value("serialid", rowIndex);
                if (serialDynObj != null) {
                    serialNumber = serialDynObj.getString("number");
                }
                this.setValue("serialnumber", serialNumber, rowIndex);
                break;
            }
            case "materialid": {
                DynamicObject materialDynObj = this.getF7Value("materialid", rowIndex);
                Long taxrateId = null;
                if (materialDynObj != null) {
                    taxrateId = DynamicObjectUtils.getPkValue((DynamicObject)materialDynObj, (String)"taxrate");
                }
                this.setValue("taxrateid", taxrateId, rowIndex);
                break;
            }
            case "taxrateid": {
                DynamicObject taxrateDynObj = this.getF7Value("taxrateid", rowIndex);
                BigDecimal taxrate = BigDecimal.ZERO;
                if (taxrateDynObj != null) {
                    taxrate = taxrateDynObj.getBigDecimal("taxrate");
                }
                this.setValue("taxrate", taxrate, rowIndex);
                break;
            }
            case "discounttype": 
            case "discount": {
                this.changeDiscountType(key, oldValue, rowIndex);
                break;
            }
            case "sninput": {
                String snInput = (String)this.getModel().getValue(SNINPUT);
                if (StringUtils.isNotNull((String)snInput)) {
                    ArrayList<String> snList = new ArrayList<String>();
                    snList.add(snInput);
                    this.checkSnExist(snList);
                    this.addSnToEntry(snList);
                }
                this.getModel().setValue(SNINPUT, (Object)"");
                break;
            }
        }
        this.fetchTaxPrice(key, rowIndex);
        this.getAlgorithm().calByChange(key, rowIndex);
    }

    protected void fetchTaxPrice(String key, int rowIndex) {
        switch (key) {
            case "inchannelid": 
            case "settlecurrencyid": {
                DynamicObjectCollection itemEntryColl = this.getModel().getEntryEntity("itementry");
                int entryCount = itemEntryColl.size();
                for (int index = 0; index < entryCount; ++index) {
                    this.fetchTaxPrice(index);
                }
                break;
            }
            case "approveqty": 
            case "unit": 
            case "ispresent": {
                this.fetchTaxPrice(rowIndex);
                break;
            }
        }
    }

    private void fetchTaxPrice(int rowIndex) {
        DynamicObject itemEntryDynObj = this.getModel().getEntryRowEntity("itementry", rowIndex);
        if (itemEntryDynObj == null) {
            return;
        }
        PriceFetchParam params = new PriceFetchParam();
        params.setSaleorgId(((Long)this.getModel().getValue("saleorgid_id")).longValue());
        params.setCustomerId(((Long)this.getModel().getValue("inchannelid_id")).longValue());
        params.setPolicyPriceId(0L);
        params.setCurrencyId(((Long)this.getModel().getValue("settlecurrencyid_id")).longValue());
        params.setOrderDate(DateUtil.getNowDate());
        params.setQty(DynamicObjectUtils.getBigDecimal((DynamicObject)itemEntryDynObj, (String)"approveqty"));
        params.setItemId(DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)itemEntryDynObj, (String)"itemid"));
        params.setUnitId(DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)itemEntryDynObj, (String)"unit"));
        params.setItemAssistattrId(0L);
        params.setMaterialAssistattrId(DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)itemEntryDynObj, (String)"auxptyid"));
        params.setChannelSupplyRelation(ChannelSupplyRelation.SUPPLY_ORG);
        PriceFetchResult result = PriceServiceUtil.getItemPrice((PriceFetchParam)params);
        this.setTaxPriceByPriceFetchResult(result, rowIndex);
    }

    private void setTaxPriceByPriceFetchResult(PriceFetchResult result, int rowIndex) {
        BigDecimal discountAmount = result.getDiscount();
        if (DiscountTypeEnum.DISRATE.getValue().equals(result.getDiscountType())) {
            discountAmount = result.getPolicyPrice().compareTo(BigDecimal.ZERO) == 0 ? result.getItemPrice().multiply(result.getDiscount().divide(BigDecimalConstants.ONEHUNDRED, result.getDiscount().scale() + 2, 4)).setScale(10, 4) : result.getPolicyPrice().multiply(result.getDiscount().divide(BigDecimalConstants.ONEHUNDRED, result.getDiscount().scale() + 2, 4)).setScale(10, 4);
        }
        boolean isPresent = this.getBooleanValue("ispresent", rowIndex);
        BigDecimal policyPrice = result.getPolicyPrice().compareTo(BigDecimal.ZERO) == 0 ? result.getItemPrice() : result.getPolicyPrice();
        this.setValue("taxprice", isPresent ? BigDecimal.ZERO : policyPrice, rowIndex, true);
        this.setValue("discounttype", result.getDiscountType(), rowIndex);
        discountAmount = isPresent ? BigDecimal.ZERO : discountAmount;
        this.setValue("discount", result.getDiscount(), rowIndex);
        this.setValue("discountamount", discountAmount, rowIndex);
    }

    private void setRollBackAmountInfo(int rowIndex) {
        DynamicObjectCollection recEntryEntity;
        long srcBillEntryId;
        BigDecimal qty = (BigDecimal)this.getModel().getValue("approveqty", rowIndex);
        BigDecimal baseQty = (BigDecimal)this.getModel().getValue("approvebaseqty", rowIndex);
        BigDecimal srcQty = (BigDecimal)this.getModel().getValue("srcqty", rowIndex);
        BigDecimal srcRecDiscount = (BigDecimal)this.getModel().getValue("srcrecdiscount", rowIndex);
        BigDecimal rollbackAmount = BigDecimal.ZERO;
        if (BigDecimal.ZERO.compareTo(srcQty) != 0 && BigDecimal.ZERO.compareTo(srcRecDiscount) != 0) {
            rollbackAmount = qty.multiply(srcRecDiscount.divide(srcQty, 10, RoundingMode.HALF_UP));
        }
        this.getModel().setValue("transrollbackamount", (Object)rollbackAmount, rowIndex);
        BigDecimal srcTaxPrice = (BigDecimal)this.getModel().getValue("srctaxprice", rowIndex);
        BigDecimal srcUnitDiscount = (BigDecimal)this.getModel().getValue("srcunitdiscount", rowIndex);
        BigDecimal credittaxamount = BigDecimal.ZERO;
        if (srcTaxPrice != null && srcUnitDiscount != null) {
            credittaxamount = qty.multiply(srcTaxPrice.subtract(srcUnitDiscount));
        }
        this.getModel().setValue("credittaxamount", (Object)credittaxamount, rowIndex);
        BigDecimal taxRate = (BigDecimal)this.getModel().getValue("taxrate", rowIndex);
        BigDecimal credittax = BigDecimal.ZERO;
        if (taxRate != null && taxRate.compareTo(BigDecimal.ZERO) > 0) {
            taxRate = taxRate.divide(BigDecimal.TEN.multiply(BigDecimal.TEN));
            credittax = credittaxamount.divide(taxRate.add(BigDecimal.ONE), 10, RoundingMode.HALF_UP).multiply(taxRate);
        }
        this.getModel().setValue("credittax", (Object)credittax, rowIndex);
        this.getModel().setValue("creditamount", (Object)credittaxamount.subtract(credittax), rowIndex);
        DynamicObjectCollection itemEntryList = this.getModel().getEntryEntity("itementry");
        if (itemEntryList != null && !itemEntryList.isEmpty()) {
            BigDecimal returnTaxAmount = BigDecimal.ZERO;
            for (DynamicObject itemEntry : itemEntryList) {
                returnTaxAmount = returnTaxAmount.add(itemEntry.getBigDecimal("credittaxamount"));
            }
            this.getModel().setValue("returntaxamount", (Object)returnTaxAmount);
        }
        if ((srcBillEntryId = ((Long)this.getModel().getValue("srcbillentryid", rowIndex)).longValue()) != 0L && (recEntryEntity = this.getModel().getEntryEntity("recentryentity")) != null && !recEntryEntity.isEmpty()) {
            AtomicInteger index = new AtomicInteger();
            for (DynamicObject recEntry : recEntryEntity) {
                int recRowIndex = index.getAndIncrement();
                if (recEntry.getLong("recsrcbillentryid") != srcBillEntryId) continue;
                BigDecimal unitRecDiscount = (BigDecimal)this.getModel().getValue("unitrecdiscount", recRowIndex);
                this.getModel().setValue("recrollbackamount", (Object)unitRecDiscount.multiply(baseQty), recRowIndex);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "outchannelid": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getCommonOwnerFitler());
                break;
            }
            case "inchannelid": {
                if (this.isNullOutChannel()) {
                    e.setCancel(true);
                    return;
                }
                long outchannelid = DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("outchannelid"));
                Object transBillType = this.getValue("transbilltype");
                if ("0".equals(transBillType)) {
                    QFilter qFilter = new QFilter("id", "=", (Object)outchannelid);
                    F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)qFilter);
                    break;
                }
                Set<Long> channelIdSet = this.getSubChannelIds();
                channelIdSet.remove(outchannelid);
                QFilter qFilter = new QFilter("id", "in", channelIdSet);
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)qFilter);
                break;
            }
            case "serialid": {
                DynamicObject itemEntry = this.getCurrentRowInfo("itementry");
                if (itemEntry == null) break;
                ArrayList<QFilter> filters = new ArrayList<QFilter>();
                filters.add(new QFilter("itemid", "=", (Object)itemEntry.getLong("itemid_id")));
                filters.add(new QFilter("channelid", "=", this.getModel().getValue("outchannelid_id")));
                filters.add(new QFilter("channelstockid", "=", this.getModel().getValue("outwarehouseid_h_id")));
                filters.add(new QFilter("snstatus", "=", (Object)SnStatusEnum.INSTOCK.getValue()));
                long lotId = itemEntry.getLong("lotid_id");
                if (lotId != 0L) {
                    filters.add(new QFilter("lotid", "=", (Object)lotId));
                }
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, filters);
                break;
            }
            case "deliveryaddressid": {
                long transChannelId = (Long)this.getModel().getValue("transbillchannelid_id");
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)new QFilter("orderchannel", "=", (Object)transChannelId));
                break;
            }
        }
        this.setEntryF7Select(e);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        RowDataEntity[] rowDataEntities = e.getRowDataEntities();
        if ("itementry".equals(entryName)) {
            DynamicObject outChannelDynObj = this.getF7Value("outchannelid");
            DynamicObject inChannelDynObj = this.getF7Value("inchannelid");
            for (RowDataEntity rowDataEntity : rowDataEntities) {
                int rowIndex = rowDataEntity.getRowIndex();
                this.setValue("outownerid", outChannelDynObj, rowIndex);
                this.setValue("outkeeperid", outChannelDynObj, rowIndex);
                this.setValue("inownerid", inChannelDynObj, rowIndex);
                this.setValue("inkeeperid", inChannelDynObj, rowIndex);
                this.setEntryWarehouseId(rowIndex);
            }
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        this.recalSumQty();
    }

    private void setEntryF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        int rowIndex = e.getRow();
        switch (key) {
            case "itemid": {
                if (this.isNullOutChannel()) {
                    e.setCancel(true);
                    return;
                }
                List<QFilter> allQFilterList = this.getItemFilter();
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, allQFilterList);
                break;
            }
            case "unit": {
                this.setUnitIdF7Select(e, rowIndex);
                break;
            }
            case "outwarehouseid_h": 
            case "outwarehouseid": {
                if (this.isNullOutChannel()) {
                    e.setCancel(true);
                    return;
                }
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)new QFilter("ownerchannelid", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("outchannelid"))));
                break;
            }
            case "inwarehouseid_h": 
            case "inwarehouseid": {
                if (this.isNullInChannel()) {
                    e.setCancel(true);
                    return;
                }
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)new QFilter("ownerchannelid", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("inchannelid"))));
                break;
            }
            case "outlocationid": {
                if (this.isNullOutWarehouse(rowIndex)) {
                    e.setCancel(true);
                    return;
                }
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)new QFilter("warehouseid", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("outwarehouseid", rowIndex))));
                break;
            }
            case "inlocationid": {
                if (this.isNullInWarehouse(rowIndex)) {
                    e.setCancel(true);
                    return;
                }
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)new QFilter("warehouseid", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("inwarehouseid", rowIndex))));
                break;
            }
        }
    }

    private void setUnitIdF7Select(BeforeF7SelectEvent e, int rowIndex) {
        if (this.isNullItemId(rowIndex)) {
            e.setCancel(true);
            return;
        }
        Object materialId = this.getF7PKValue("materialid", rowIndex);
        Object baseUnitId = this.getF7PKValue("baseunit", rowIndex);
        List fixconunitlist = QueryUtil.getAssistMUListResult((Long)(materialId == null ? Long.valueOf(0L) : Long.valueOf(materialId.toString())), (Long)(baseUnitId == null ? Long.valueOf(0L) : Long.valueOf(baseUnitId.toString())), (String)"1");
        QFilter fixconFilter = new QFilter("id", "in", (Object)fixconunitlist);
        F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)fixconFilter);
    }

    private List<QFilter> getItemFilter() {
        long channelId;
        long saleOrgId = DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("saleorgid"));
        ArrayList<QFilter> allQFilters = ItemNSaleControlUtil.getItemFilterBySaleChannel((long)saleOrgId, (long)0L, (long)(channelId = DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("outchannelid"))));
        if (allQFilters == null) {
            allQFilters = new ArrayList<QFilter>(1);
            allQFilters.add(new QFilter("id", "=", (Object)0));
        }
        return allQFilters;
    }

    public boolean isNullOutChannel() {
        DynamicObject dynObj = this.getF7Value("outchannelid");
        if (dynObj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8c03\u51fa\u6e20\u9053\u3002", (String)"TransBillEdit_0", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean isNullInChannel() {
        DynamicObject dynObj = this.getF7Value("inchannelid");
        if (dynObj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8c03\u5165\u6e20\u9053\u3002", (String)"TransBillEdit_1", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean isNullOutWarehouse(int rowIndex) {
        DynamicObject dynObj = this.getF7Value("outwarehouseid", rowIndex);
        if (dynObj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8c03\u51fa\u4ed3\u5e93\u3002", (String)"TransBillEdit_2", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean isNullInWarehouse(int rowIndex) {
        DynamicObject dynObj = this.getF7Value("inwarehouseid", rowIndex);
        if (dynObj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8c03\u5165\u4ed3\u5e93\u3002", (String)"TransBillEdit_3", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean isNullItemId(int rowIndex) {
        DynamicObject dynObj = this.getF7Value("itemid", rowIndex);
        if (dynObj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5546\u54c1\u7f16\u7801\u3002", (String)"TransBillEdit_4", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private List<QFilter> getSNFilterByItemId(int rowIndex) {
        long keeperId;
        String keeperType;
        long ownerId;
        String ownerType;
        long stockTypeId;
        long stockStatusId;
        long locationId;
        long wareHouseId;
        Date expireDate;
        Date productDate;
        long lotId;
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(20);
        DynamicObject itemDynObj = this.getF7Value("itemid", rowIndex);
        long itemId = DynamicObjectUtils.getPkValue((DynamicObject)itemDynObj);
        if (itemId == 0L) {
            return filterList;
        }
        filterList.add(new QFilter("itemid", "=", (Object)itemId));
        long auxptyId = DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("auxptyid", rowIndex));
        if (auxptyId > 0L) {
            filterList.add(new QFilter("auxptyid", "=", (Object)auxptyId));
        }
        filterList.add(new QFilter("snstatus", "=", (Object)SnStatusEnum.INSTOCK.getValue()));
        filterList.add(new QFilter("lockstatus", "=", (Object)Character.valueOf('0')));
        Object outChannelId = this.getF7PKValue("outchannelid");
        if (null != outChannelId) {
            filterList.add(new QFilter("channelid", "=", outChannelId));
        }
        if ((lotId = DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("lotid", rowIndex))) > 0L) {
            QFilter lotIdFilter = new QFilter("lotid", "=", (Object)lotId);
            filterList.add(lotIdFilter);
        }
        if (null != (productDate = (Date)this.getValue("productdate", rowIndex))) {
            filterList.add(new QFilter("productdate", "=", (Object)DateUtil.formatDate((Date)productDate)));
        }
        if (null != (expireDate = (Date)this.getValue("expiredate", rowIndex))) {
            filterList.add(new QFilter("effectivedate", "=", (Object)DateUtil.formatDate((Date)expireDate)));
        }
        if ((wareHouseId = DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("outwarehouseid", rowIndex))) > 0L) {
            filterList.add(new QFilter("channelstockid", "=", (Object)wareHouseId));
        }
        if ((locationId = DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("outlocationid", rowIndex))) > 0L) {
            filterList.add(new QFilter("channellocationid", "=", (Object)locationId));
        }
        if ((stockStatusId = DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("outstockstatusid", rowIndex))) > 0L) {
            filterList.add(new QFilter("channelstockstatusid", "=", (Object)stockStatusId));
        }
        if ((stockTypeId = DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("outstocktypeid", rowIndex))) > 0L) {
            filterList.add(new QFilter("channelstocktypeid", "=", (Object)stockTypeId));
        }
        if (StringUtils.isNotEmpty((String)(ownerType = this.getStringValue("outownertype", rowIndex)))) {
            filterList.add(new QFilter("ownertype", "=", (Object)ownerType));
        }
        if ((ownerId = DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("outownerid", rowIndex))) > 0L) {
            filterList.add(new QFilter("ownerid", "=", (Object)ownerId));
        }
        if (StringUtils.isNotEmpty((String)(keeperType = this.getStringValue("outkeepertype", rowIndex)))) {
            filterList.add(new QFilter("keepertype", "=", (Object)keeperType));
        }
        if ((keeperId = DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("outkeeperid", rowIndex))) > 0L) {
            filterList.add(new QFilter("keeperid", "=", (Object)keeperId));
        }
        return filterList;
    }

    private void showLotInfoF7(int rowIndex) {
        ArrayList<String> showFields = new ArrayList<String>(10);
        showFields.add("number");
        showFields.add("productdate");
        showFields.add("expiredate");
        ListShowParameter listShowParam = ShowFormHelper.createShowListForm((String)"ococic_lot", (boolean)false, (int)2);
        listShowParam.setCustomParam("entity", (Object)"ococic_lot");
        listShowParam.setCustomParam("entry", (Object)"ococic_lotdate");
        listShowParam.setCustomParam("isEntryMain", (Object)Boolean.TRUE);
        listShowParam.setCustomParam("showFields", showFields);
        LspWapper lspWapper = new LspWapper(listShowParam);
        lspWapper.clearPlugins();
        lspWapper.registerScript("kingdee.occ.occba.mainpage.dynamicformlistscriptplugin");
        lspWapper.setMergeRow(false);
        listShowParam.setAppId("ococic");
        ListFilterParameter listFilter = new ListFilterParameter();
        listFilter.setQFilters(this.getLotFilterByItemId(rowIndex));
        listShowParam.setListFilterParameter(listFilter);
        listShowParam.setCaption(ResManager.loadKDString((String)"\u5546\u54c1\u6279\u53f7", (String)"TransBillEdit_5", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "lotnumber");
        listShowParam.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)listShowParam);
    }

    private List<QFilter> getLotFilterByItemId(int rowIndex) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(3);
        DynamicObject itemDynObj = this.getF7Value("itemid", rowIndex);
        long itemId = DynamicObjectUtils.getPkValue((DynamicObject)itemDynObj);
        if (itemId == 0L) {
            return filters;
        }
        filters.add(new QFilter("itemid", "=", (Object)itemId));
        filters.add(new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue()));
        long auxptyId = DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("auxptyid", rowIndex));
        if (auxptyId > 0L) {
            filters.add(new QFilter("auxptyid", "=", (Object)auxptyId));
        }
        return filters;
    }

    private void setLotInfoByLot(long lotId, long lotEntryId, String lotNumber, int rowIndex) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(3);
        if (lotId > 0L) {
            filterList.add(new QFilter("id", "=", (Object)lotId));
        }
        if (lotEntryId > 0L) {
            filterList.add(new QFilter(String.join((CharSequence)".", "ococic_lotdate", "id"), "=", (Object)lotEntryId));
        }
        if (StringUtils.isNotEmpty((String)lotNumber)) {
            filterList.add(new QFilter("number", "=", (Object)lotNumber));
        }
        DynamicObjectCollection lotDynObjColl = null;
        if (!CommonUtils.isNull(filterList)) {
            lotDynObjColl = QueryServiceHelper.query((String)"ococic_lot", (String)String.join((CharSequence)",", "number", "id", "auxptyid", OcocicLotConst.EF_lotdate_productdate, OcocicLotConst.EF_lotdate_expiredate), (QFilter[])filterList.toArray(new QFilter[filterList.size()]));
        }
        if (CommonUtils.isNull(lotDynObjColl)) {
            this.setValue("lotnumber", null, rowIndex);
        } else if (lotDynObjColl != null && lotDynObjColl.size() == 1) {
            DynamicObject lotDynObj = (DynamicObject)lotDynObjColl.get(0);
            long auxptyId = lotDynObj.getLong("auxptyid");
            if (this.getF7PKValue("auxptyid", rowIndex) == null && auxptyId > 0L) {
                this.setValue("auxptyid", auxptyId, rowIndex);
            }
            this.setValue("lotid", lotDynObj.getLong("id"), rowIndex, false);
            this.setValue("lotnumber", lotDynObj.getString("number"), rowIndex, false);
            this.setValue("productdate", lotDynObj.getDate(OcocicLotConst.EF_lotdate_productdate), rowIndex, false);
            this.setValue("expiredate", lotDynObj.getString(OcocicLotConst.EF_lotdate_expiredate), rowIndex, false);
        } else if (lotDynObjColl != null && lotDynObjColl.size() > 1) {
            if (this.isNullItemId(rowIndex)) {
                return;
            }
            this.showLotInfoF7(rowIndex);
        }
    }

    private void changeDiscountType(String fieldName, Object oldValue, int rowIndex) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        int discountRateScale = 4;
        String discountType = (String)model.getValue("discounttype", rowIndex);
        BigDecimal discountRate = (BigDecimal)model.getValue("discount", rowIndex);
        if (discountRate == null) {
            discountRate = BigDecimal.ZERO;
        }
        if (null != discountRate && DiscountTypeEnum.DISRATE.getValue().equals(discountType)) {
            discountRate = discountRate.setScale(discountRateScale, 4);
            model.setValue("discount", (Object)discountRate, rowIndex);
            if (discountRate.compareTo(BigDecimalConstants.ONEHUNDRED) > 0) {
                this.setValue(fieldName, oldValue, rowIndex, false);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u6298\u6263\u7387\u65f6\uff0c\u5355\u4f4d\u6298\u6263\uff08\u7387\uff09\u4e0d\u80fd\u5927\u4e8e100%\u3002", (String)"TransBillEdit_6", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
                return;
            }
            view.setEnable(Boolean.TRUE, rowIndex, new String[]{"discount"});
        } else if (null != discountRate && DiscountTypeEnum.UNITDIS.getValue().equals(discountType)) {
            DynamicObject settleCurrencyDynObj = this.getF7Value("settlecurrencyid");
            if (settleCurrencyDynObj != null) {
                discountRateScale = settleCurrencyDynObj.getInt("amtprecision");
            }
            if (this.isVerifyDiscount(discountRate = discountRate.setScale(discountRateScale, 4), fieldName, oldValue, rowIndex)) {
                model.setValue("discount", (Object)discountRate, rowIndex);
                view.setEnable(Boolean.TRUE, rowIndex, new String[]{"discount"});
            }
        } else {
            model.setValue("discount", null, rowIndex);
            view.setEnable(Boolean.FALSE, rowIndex, new String[]{"discount"});
            model.setValue("discountamount", null, rowIndex);
        }
    }

    private boolean isVerifyDiscount(BigDecimal discountRate, String fieldName, Object oldValue, int rowIndex) {
        boolean isTax = this.getBooleanValue("istax");
        if (isTax) {
            BigDecimal priceAndTax = BigDecimalUtil.toBigDecimal((Object)this.getModel().getValue("taxprice", rowIndex));
            if (discountRate.compareTo(priceAndTax) > 0) {
                this.setValue(fieldName, oldValue, rowIndex, false);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u5355\u4f4d\u6298\u6263\u989d\u65f6\uff0c\u5355\u4f4d\u6298\u6263\uff08\u7387\uff09\u4e0d\u80fd\u5927\u4e8e\u542b\u7a0e\u5355\u4ef7\u3002", (String)"TransBillEdit_7", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
                return false;
            }
        } else {
            BigDecimal price = BigDecimalUtil.toBigDecimal((Object)this.getModel().getValue("price", rowIndex));
            if (discountRate.compareTo(price) > 0) {
                this.setValue(fieldName, oldValue, rowIndex, false);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u5355\u4f4d\u6298\u6263\u989d\u65f6\uff0c\u5355\u4f4d\u6298\u6263\uff08\u7387\uff09\u4e0d\u80fd\u5927\u4e8e\u5355\u4ef7\u3002", (String)"TransBillEdit_8", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    private void batchSetEntryWarehouseId() {
        DynamicObjectCollection entryColl = this.getModel().getEntryEntity("itementry");
        int size = entryColl.size();
        for (int i = 0; i < size; ++i) {
            this.setEntryWarehouseId(i);
        }
    }

    private void setEntryWarehouseId(int rowIndex) {
        Object outWarehouseId = this.getF7PKValue("outwarehouseid_h");
        Object inWarehouseId = this.getF7PKValue("inwarehouseid_h");
        if (this.getF7PKValue("outwarehouseid", rowIndex) == null) {
            this.setValue("outwarehouseid", outWarehouseId, rowIndex);
        }
        if (this.getF7PKValue("inwarehouseid", rowIndex) == null) {
            this.setValue("inwarehouseid", inWarehouseId, rowIndex);
        }
    }

    private void setBillTransBillType() {
        String formId;
        DynamicObject billTypeParam;
        DynamicObject billType = this.getF7Value("billtypeid");
        if (null != billType && (billTypeParam = BillTypeParameterHelper.getBillTypeParameterByConstants((String)(formId = this.getModel().getDataEntity().getDataEntityType().getName()), (long)billType.getLong("id"))) != null) {
            String transbillDriver;
            DynamicObject datasources;
            String transmode;
            String businesstype = billTypeParam.getString("transbilltype");
            if (businesstype != null) {
                this.setValue("transbilltype", businesstype);
                if (!"0".equals(businesstype)) {
                    this.setValue("inchannelid", null);
                }
            }
            if ((transmode = billTypeParam.getString("transmode")) != null) {
                this.setValue("transmode", transmode);
            }
            if ((datasources = billTypeParam.getDynamicObject("datasources")) != null) {
                this.setValue("datasources", datasources);
            }
            if (StringUtils.isNotNull((String)(transbillDriver = billTypeParam.getString("transbilldriver")))) {
                this.setValue("transbilldriver", transbillDriver);
            }
        }
    }

    private void checkSnExist(List<String> snList) {
        DynamicObjectCollection billEntryEntity = this.getModel().getEntryEntity("itementry");
        if (billEntryEntity != null && !billEntryEntity.isEmpty()) {
            for (DynamicObject billEntry : billEntryEntity) {
                DynamicObjectCollection subEntryList = billEntry.getDynamicObjectCollection("subentryentity");
                if (subEntryList == null || subEntryList.isEmpty()) continue;
                for (DynamicObject subEntry : subEntryList) {
                    String snnum = subEntry.getString("serialnumber");
                    if (!StringUtils.isNotNull((String)snnum) || !snList.contains(snnum)) continue;
                    snList.remove(snnum);
                }
            }
        }
    }

    private void addSnToEntry(List<String> snList) {
        if (snList == null || snList.isEmpty()) {
            return;
        }
        String snStatus = SnStatusEnum.INSTOCK.getValue();
        long channelId = (Long)this.getModel().getValue("outchannelid_id");
        JSONObject result = CSerialHelper.getSerialDataByScanNumber(snList, (Long)channelId, (String)snStatus);
        JSONArray data = result.getJSONArray("data");
        if (!data.isEmpty()) {
            HashMap<String, List<JSONObject>> snKeyMap = new HashMap<String, List<JSONObject>>();
            for (JSONObject json : data.toJavaList(JSONObject.class)) {
                String key = String.join((CharSequence)"_", json.getString("itemid"), json.getString("auxptyid"), json.getString("lotid"), json.getString("channelstockid"), json.getString("channellocationid"), json.getString("channelstockstatusid"), json.getString("channelstocktypeid"), json.getString("ownerid"), json.getString("ownertype"), json.getString("keeperid"), json.getString("keepertype"), json.getString("projectid"), this.formatDate(json.getDate("productdate")), this.formatDate(json.getDate("effectivedate")));
                if (snKeyMap.containsKey(key) && snKeyMap.get(key) != null) {
                    ((List)snKeyMap.get(key)).add(json);
                    continue;
                }
                ArrayList<JSONObject> jsonList = new ArrayList<JSONObject>();
                jsonList.add(json);
                snKeyMap.put(key, jsonList);
            }
            this.snMatchEntry(snKeyMap);
            this.snAddEntry(snKeyMap);
            DynamicObjectCollection billEntryEntity = this.getModel().getEntryEntity("itementry");
            BusinessDataServiceHelper.loadRefence((Object[])billEntryEntity.toArray(), (IDataEntityType)billEntryEntity.getDynamicObjectType());
            this.getModel().setValue("itementry", (Object)billEntryEntity);
            this.getModel().updateEntryCache(billEntryEntity);
            this.getView().updateView();
            this.recalSumQty();
        } else {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5e8f\u5217\u53f7:%s", (String)"TransBillEdit_9", (String)"occ-ococic-formplugin", (Object[])new Object[0]), Arrays.toString(snList.toArray())));
        }
    }

    private void recalSumQty() {
        BigDecimal sumqty = BigDecimal.ZERO;
        DynamicObjectCollection entity = this.getModel().getEntryEntity("itementry");
        for (DynamicObject entry : entity) {
            BigDecimal qty = entry.getBigDecimal("approveqty");
            sumqty = sumqty.add(qty);
        }
        this.setValue("sumqty", sumqty);
    }

    private String formatDate(Date date) {
        if (date != null) {
            return new SimpleDateFormat("yyyy-MM-dd").format(date);
        }
        return "";
    }

    private void snAddEntry(Map<String, List<JSONObject>> snKeyMap) {
        DynamicObjectCollection billEntryEntity = this.getModel().getEntryEntity("itementry");
        if (!snKeyMap.isEmpty()) {
            for (Map.Entry<String, List<JSONObject>> snMapEntry : snKeyMap.entrySet()) {
                List<JSONObject> jsonList = snMapEntry.getValue();
                DynamicObject billEntry = billEntryEntity.addNew();
                billEntry.set("itemid_id", (Object)jsonList.get(0).getLong("itemid"));
                billEntry.set("auxptyid_id", (Object)jsonList.get(0).getLong("auxptyid"));
                billEntry.set("lotnumber", (Object)jsonList.get(0).getString("lotnum"));
                billEntry.set("lotid_id", (Object)jsonList.get(0).getLong("lotid"));
                billEntry.set("outwarehouseid_id", (Object)jsonList.get(0).getLong("channelstockid"));
                billEntry.set("outlocationid_id", (Object)jsonList.get(0).getLong("channellocationid"));
                billEntry.set("outstockstatusid_id", (Object)jsonList.get(0).getLong("channelstockstatusid"));
                billEntry.set("outstocktypeid_id", (Object)jsonList.get(0).getLong("channelstocktypeid"));
                billEntry.set("outownerid_id", (Object)jsonList.get(0).getLong("ownerid"));
                billEntry.set("outownertype", (Object)jsonList.get(0).getString("ownertype"));
                billEntry.set("outkeeperid_id", (Object)jsonList.get(0).getLong("keeperid"));
                billEntry.set("outkeepertype", (Object)jsonList.get(0).getString("keepertype"));
                billEntry.set("outprojectid_id", (Object)jsonList.get(0).getLong("projectid"));
                billEntry.set("productdate", (Object)jsonList.get(0).getDate("productdate"));
                billEntry.set("expiredate", (Object)jsonList.get(0).getDate("effectivedate"));
                billEntry.set("inwarehouseid", this.getModel().getValue("inwarehouseid_h"));
                billEntry.set("instockstatus_id", (Object)1042689155454212096L);
                billEntry.set("instocktype_id", (Object)1042808009622820864L);
                billEntry.set("inownerid", this.getModel().getValue("inchannelid"));
                billEntry.set("inownertype", (Object)"ocdbd_channel");
                billEntry.set("inkeeperid", this.getModel().getValue("inchannelid"));
                billEntry.set("inkeepertype", (Object)"ocdbd_channel");
                long materialId = jsonList.get(0).getLong("material");
                billEntry.set("materialid_id", (Object)materialId);
                BigDecimal snQty = new BigDecimal(jsonList.size());
                billEntry.set("serialqty", (Object)snQty);
                long snUnitId = jsonList.get(0).getLong("serialunit");
                long unitId = jsonList.get(0).getLong("stockunit");
                long baseUnitId = jsonList.get(0).getLong("baseunit");
                long assistUnitId = jsonList.get(0).getLong("assistunit");
                billEntry.set("serialunitid_id", (Object)snUnitId);
                billEntry.set("unit_id", (Object)unitId);
                billEntry.set("assistunitid_id", (Object)assistUnitId);
                billEntry.set("baseunit_id", (Object)baseUnitId);
                BigDecimal baseQty = UnitConvertHelper.calculateDestQty((BigDecimal)snQty, (Long)materialId, (Long)snUnitId, (Long)baseUnitId);
                billEntry.set("approvebaseqty", (Object)baseQty);
                BigDecimal qty = UnitConvertHelper.calculateDestQty((BigDecimal)baseQty, (Long)materialId, (Long)baseUnitId, (Long)unitId);
                billEntry.set("approveqty", (Object)qty);
                BigDecimal assistQty = UnitConvertHelper.calculateDestQty((BigDecimal)baseQty, (Long)materialId, (Long)baseUnitId, (Long)assistUnitId);
                billEntry.set("approveassistqty", (Object)assistQty);
                DynamicObjectCollection snEntry = billEntry.getDynamicObjectCollection("subentryentity");
                for (JSONObject json : jsonList) {
                    DynamicObject sn = snEntry.addNew();
                    sn.set("serialnumber", (Object)json.getString("serialno"));
                    sn.set("serialid_id", (Object)json.getLong("serialid"));
                }
            }
        }
    }

    private void snMatchEntry(Map<String, List<JSONObject>> snKeyMap) {
        DynamicObjectCollection billEntryEntity = this.getModel().getEntryEntity("itementry");
        if (billEntryEntity != null && !billEntryEntity.isEmpty()) {
            int rowindex = 0;
            for (DynamicObject billEntry : billEntryEntity) {
                ++rowindex;
                String key = String.join((CharSequence)"_", billEntry.getString("itemid_id"), billEntry.getString("auxptyid_id"), billEntry.getString("lotid_id"), billEntry.getString("outwarehouseid_id"), billEntry.getString("outlocationid_id"), billEntry.getString("outstockstatusid_id"), billEntry.getString("outstocktypeid_id"), billEntry.getString("outownerid_id"), billEntry.getString("outownertype"), billEntry.getString("outkeeperid_id"), billEntry.getString("outkeepertype"), billEntry.getString("outprojectid_id"), this.formatDate(billEntry.getDate("productdate")), this.formatDate(billEntry.getDate("expiredate")));
                if (!snKeyMap.containsKey(key)) continue;
                String srcbillnumber = billEntry.getString("srcbillnumber");
                BigDecimal snQty = billEntry.getBigDecimal("serialqty");
                DynamicObjectCollection snEntry = billEntry.getDynamicObjectCollection("subentryentity");
                if (!StringUtils.isEmpty((String)srcbillnumber)) {
                    int snEntryCount = snKeyMap.get(key).size();
                    if (!CollectionUtils.isEmpty((Collection)snEntry)) {
                        snEntryCount += snEntry.size();
                    }
                    if (snEntryCount > snQty.intValue()) {
                        snKeyMap.clear();
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\uff0c\u5e8f\u5217\u53f7\u6570\u91cf\u5df2\u8d85\u5546\u54c1\u6570\u91cf\uff01", (String)"TransBillEdit_10", (String)"occ-ococic-formplugin", (Object[])new Object[0]), rowindex));
                        return;
                    }
                } else {
                    snQty = snQty.add(new BigDecimal(snKeyMap.get(key).size()));
                    billEntry.set("serialqty", (Object)snQty);
                    long snUnitId = billEntry.getLong("serialunitid_id");
                    long unitId = billEntry.getLong("unit_id");
                    long baseUnitId = billEntry.getLong("baseunit_id");
                    long assistUnitId = billEntry.getLong("assistunitid_id");
                    long materialId = billEntry.getLong("materialid_id");
                    BigDecimal baseQty = UnitConvertHelper.calculateDestQty((BigDecimal)snQty, (Long)materialId, (Long)snUnitId, (Long)baseUnitId);
                    billEntry.set("approvebaseqty", (Object)baseQty);
                    BigDecimal qty = UnitConvertHelper.calculateDestQty((BigDecimal)baseQty, (Long)materialId, (Long)baseUnitId, (Long)unitId);
                    billEntry.set("approveqty", (Object)qty);
                    BigDecimal assistQty = UnitConvertHelper.calculateDestQty((BigDecimal)baseQty, (Long)materialId, (Long)baseUnitId, (Long)assistUnitId);
                    billEntry.set("approveassistqty", (Object)assistQty);
                }
                for (JSONObject json : snKeyMap.get(key)) {
                    DynamicObject sn = snEntry.addNew();
                    sn.set("serialnumber", (Object)json.getString("serialno"));
                    sn.set("serialid_id", (Object)json.getLong("serialid"));
                }
                snKeyMap.remove(key);
            }
        }
    }

    private void setSettleOrg(long saleOrgId) {
        Map map;
        Object settleorgId = null;
        if (saleOrgId != 0L && !CollectionUtils.isEmpty((Map)(map = OrgUnitServiceHelper.getCompanyByOrg((Long)saleOrgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE)))) {
            settleorgId = map.get("id");
        }
        this.setValue("settleorgid", settleorgId);
        this.setExRateTable();
    }

    private Set<Long> getSubChannelIds() {
        List channelIdList = CUserHelper.getAuthorizedChannelIdList();
        long transChannelId = DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("transbillchannelid"));
        channelIdList.add(transChannelId);
        channelIdList.remove(0L);
        HashSet<Long> channelIdSet = new HashSet<Long>(channelIdList);
        return this.searchSubChannelId(channelIdSet, channelIdSet);
    }

    private Set<Long> searchSubChannelId(Set<Long> channelIdSet, Set<Long> totalChanelIds) {
        if (channelIdSet == null || channelIdSet.isEmpty()) {
            return totalChanelIds;
        }
        QFilter qFilter = new QFilter("parent", "in", channelIdSet);
        qFilter.and("parent", ">", (Object)0L);
        List subChannelIdList = QueryServiceHelper.queryPrimaryKeys((String)"ocdbd_channel", (QFilter[])qFilter.toArray(), null, (int)-1);
        if (subChannelIdList == null || subChannelIdList.isEmpty()) {
            return totalChanelIds;
        }
        Set<Long> subChannelIds = subChannelIdList.stream().map(r -> (Long)r).filter(r -> totalChanelIds.contains(r)).collect(Collectors.toSet());
        totalChanelIds.addAll(subChannelIds);
        return this.searchSubChannelId(subChannelIds, totalChanelIds);
    }

    private void setExRateTable() {
        DynamicObject settleOrgDynObj = this.getF7Value("settleorgid");
        long exratetableId = 0L;
        long basecurrrencyId = 0L;
        DynamicObject accountingSysDynObj = SaleOrderBusinessHelper.getAccountingSysbase((long)DynamicObjectUtils.getPkValue((DynamicObject)settleOrgDynObj));
        if (accountingSysDynObj != null) {
            exratetableId = accountingSysDynObj.getLong("exratetable");
            basecurrrencyId = accountingSysDynObj.getLong("basecurrrency");
        }
        long settleCurId = DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("settlecurrencyid"));
        BigDecimal exchangeRate = SaleOrderBusinessHelper.getExchangeRate((long)settleCurId, (long)basecurrrencyId, (long)exratetableId, (Date)((Date)this.getModel().getValue("bizdate")));
        this.setValue("exchangeratetable", exratetableId > 0L ? Long.valueOf(exratetableId) : null);
        this.setValue("exchangerate", exchangeRate);
        this.setValue("basecurrencyid", basecurrrencyId > 0L ? Long.valueOf(basecurrrencyId) : null);
        this.exChangeRateEnable();
    }

    private void exChangeRateEnable() {
        Object baseCurDynObj = this.getF7PKValue("basecurrencyid");
        Object settleCurDynObj = this.getF7PKValue("settlecurrencyid");
        boolean enable = settleCurDynObj != null && settleCurDynObj.equals(baseCurDynObj);
        this.getView().setEnable(Boolean.valueOf(!enable), new String[]{"exchangerate"});
    }

    protected void setTransBillChannel() {
        String transbillDriver = (String)this.getModel().getValue("transbilldriver");
        long transbillChannelId = 0L;
        long parent = 0L;
        switch (transbillDriver) {
            case "B": {
                DynamicObject inChannel = this.getF7Value("inchannelid");
                long inChannelId = 0L;
                if (inChannel != null) {
                    inChannelId = inChannel.getLong("id");
                    parent = inChannel.getLong("parent_id");
                }
                transbillChannelId = parent == 0L ? inChannelId : parent;
                break;
            }
            default: {
                DynamicObject outChannel = this.getF7Value("outchannelid");
                long outChannelId = 0L;
                if (outChannel != null) {
                    outChannelId = outChannel.getLong("id");
                    parent = outChannel.getLong("parent_id");
                }
                transbillChannelId = parent == 0L ? outChannelId : parent;
            }
        }
        this.setValue("transbillchannelid", transbillChannelId == 0L ? null : Long.valueOf(transbillChannelId));
    }
}

