/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ococic.formplugin.wb;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.botp.plugin.AbstractWriteBackPlugIn;
import kd.bos.entity.botp.plugin.args.AfterSaveSourceBillEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeReadSourceBillEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.common.pagemodel.OcocicChannelinbill;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.UserUtil;

public class StockInBillWriteBackPlugin
extends AbstractWriteBackPlugIn {
    private static final String SOURCEENTITY = "ocbsoc_delivery_record";
    private static final String SOURCESALEENTITY = "ocbsoc_saleorder";

    public void beforeReadSourceBill(BeforeReadSourceBillEventArgs e) {
        super.beforeReadSourceBill(e);
        if (SOURCEENTITY.equals(e.getSrcMainType().getName())) {
            e.getFieldKeys().add("signqty");
            e.getFieldKeys().add("refuseqty");
            e.getFieldKeys().add("deliverqty");
            e.getFieldKeys().add("closestatus");
            e.getFieldKeys().add("billstatus");
        }
        if (SOURCESALEENTITY.equals(e.getSrcMainType().getName())) {
            e.getFieldKeys().add("approvebaseqty");
            e.getFieldKeys().add("totalinstockbaseqty");
            e.getFieldKeys().add("signstatus");
            e.getFieldKeys().add("billstatus");
            e.getFieldKeys().add("entryclosestatus");
        }
    }

    public void afterSaveSourceBill(AfterSaveSourceBillEventArgs e) {
        DynamicObject[] srcDataEntities;
        BillEntityType srcSubMainType = e.getSrcSubMainType();
        String opType = this.getOpType();
        ArrayList<DynamicObject> saveValue = new ArrayList(16);
        boolean isAudit = opType.equalsIgnoreCase("audit");
        boolean isUnAudit = opType.equalsIgnoreCase("unaudit");
        if (SOURCEENTITY.equals(srcSubMainType.getName()) && (isAudit || isUnAudit)) {
            srcDataEntities = e.getSrcDataEntities();
            Map<Object, DynamicObject> deliveryRecordMap = this.querySrcData(srcDataEntities, SOURCEENTITY);
            saveValue = this.getDeliveryRecSaveValues(deliveryRecordMap, srcDataEntities);
            Set<Long> deliveryIdSet = Arrays.asList(srcDataEntities).stream().map(m -> m.getLong("id")).collect(Collectors.toSet());
            this.setDeliverySubEntrySignValue(saveValue, deliveryIdSet, isAudit);
        }
        if (SOURCESALEENTITY.equals(srcSubMainType.getName()) && (isAudit || isUnAudit)) {
            srcDataEntities = e.getSrcDataEntities();
            Map<Object, DynamicObject> saleOrderMap = this.querySrcData(srcDataEntities, SOURCESALEENTITY);
            saveValue = this.getSaleOrderSaveValues(saleOrderMap, srcDataEntities, isUnAudit);
        }
        DynamicObject[] saveValues = saveValue.toArray(new DynamicObject[saveValue.size()]);
        SaveServiceHelper.save((DynamicObject[])saveValues);
    }

    private Map<Object, DynamicObject> querySrcData(DynamicObject[] srcDataEntities, String sourceEntity) {
        if (srcDataEntities == null) {
            return new HashMap<Object, DynamicObject>(0);
        }
        HashSet<Object> srcPkValues = new HashSet<Object>(srcDataEntities.length);
        for (DynamicObject srcDataEntity : srcDataEntities) {
            srcPkValues.add(srcDataEntity.getPkValue());
        }
        return BusinessDataServiceHelper.loadFromCache((Object[])srcPkValues.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)sourceEntity));
    }

    private List<DynamicObject> getDeliveryRecSaveValues(Map<Object, DynamicObject> deliveryRecordMap, DynamicObject[] srcDataEntities) {
        if (deliveryRecordMap != null && deliveryRecordMap.size() > 0) {
            ArrayList<DynamicObject> saveValue = new ArrayList<DynamicObject>(deliveryRecordMap.size());
            for (DynamicObject srcEntity : srcDataEntities) {
                DynamicObject record = deliveryRecordMap.get(srcEntity.getPkValue());
                DynamicObjectCollection deliverydetails = record.getDynamicObjectCollection("deliverydetail");
                BigDecimal allsignSum = deliverydetails.stream().map(m -> m.getBigDecimal("signqty")).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal allrefuseSum = deliverydetails.stream().map(m -> m.getBigDecimal("refuseqty")).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (allsignSum.compareTo(BigDecimal.ZERO) > 0 || allrefuseSum.compareTo(BigDecimal.ZERO) > 0) {
                    if ("A".equals(srcEntity.getString("closestatus"))) {
                        record.set("billstatus", (Object)"D");
                    } else {
                        record.set("billstatus", (Object)"C");
                    }
                    record.set("signer", (Object)UserUtil.getCurrUserId());
                    record.set("signtime", (Object)TimeServiceHelper.now());
                } else {
                    record.set("billstatus", (Object)"B");
                    record.set("signer", null);
                    record.set("signtime", null);
                }
                saveValue.add(record);
            }
            return saveValue;
        }
        return new ArrayList<DynamicObject>(0);
    }

    private List<DynamicObject> getSaleOrderSaveValues(Map<Object, DynamicObject> saleOrderMap, DynamicObject[] srcDataEntities, boolean isUnAudit) {
        if (saleOrderMap != null && saleOrderMap.size() > 0) {
            ArrayList<DynamicObject> saveValue = new ArrayList<DynamicObject>(saleOrderMap.size());
            for (DynamicObject srcEntity : srcDataEntities) {
                DynamicObject saleOrder = saleOrderMap.get(srcEntity.getPkValue());
                DynamicObjectCollection itementry = saleOrder.getDynamicObjectCollection("itementry");
                if (CommonUtils.isNull((Object)itementry)) continue;
                this.setStatus(saleOrder, isUnAudit);
                saveValue.add(saleOrder);
                saveValue.addAll(this.setTotalBaseQty(saleOrder, isUnAudit));
            }
            return saveValue;
        }
        return new ArrayList<DynamicObject>(0);
    }

    private List<DynamicObject> setTotalBaseQty(DynamicObject srcDataEntity, boolean isUnAudit) {
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(16);
        DynamicObjectCollection itemEntrys = srcDataEntity.getDynamicObjectCollection("itementry");
        if (CollectionUtils.isEmpty((Collection)itemEntrys)) {
            return itemEntrys;
        }
        DynamicObject dynObj = ((DynamicObject)itemEntrys.get(0)).getDynamicObject("srcbillentity");
        if (dynObj != null && SOURCESALEENTITY.equals(dynObj.getPkValue())) {
            DynamicObject[] saleOrderDynObjs;
            Map<Long, List<DynamicObject>> itemEntryMap = itemEntrys.stream().collect(Collectors.groupingBy(obj -> obj.getLong("srcbillentryid")));
            Set srcBillIdSet = itemEntrys.stream().map(obj -> obj.getLong("srcbillid")).collect(Collectors.toSet());
            for (DynamicObject saleOrderDynObj : saleOrderDynObjs = BusinessDataServiceHelper.load((Object[])srcBillIdSet.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)SOURCESALEENTITY))) {
                if (!"G".equals(saleOrderDynObj.getString("pursalemodel"))) continue;
                DynamicObjectCollection orderEntryColl = saleOrderDynObj.getDynamicObjectCollection("itementry");
                boolean isSave = false;
                for (DynamicObject entryDynObj : orderEntryColl) {
                    long entryId = entryDynObj.getLong("id");
                    List<DynamicObject> list = itemEntryMap.get(entryId);
                    if (CollectionUtils.isEmpty(list)) continue;
                    BigDecimal allInStockBaseQty = list.stream().map(m -> m.getBigDecimal("totalinstockbaseqty")).reduce(BigDecimal.ZERO, BigDecimal::add);
                    entryDynObj.set("totalinstockbaseqty", (Object)allInStockBaseQty);
                    BigDecimal allSignBaseQty = list.stream().map(m -> m.getBigDecimal("totalsignedbaseqty")).reduce(BigDecimal.ZERO, BigDecimal::add);
                    entryDynObj.set("totalsignedbaseqty", (Object)allSignBaseQty);
                    isSave = true;
                }
                if (!isSave) continue;
                this.setStatus(saleOrderDynObj, isUnAudit);
                updateList.add(saleOrderDynObj);
            }
        }
        return updateList;
    }

    private void setStatus(DynamicObject saleOrder, boolean isUnAudit) {
        boolean inQty_LE_OutQty_Close;
        DynamicObjectCollection itementry = saleOrder.getDynamicObjectCollection("itementry");
        List itemEntryDynObjList = itementry.stream().filter(m -> (m.getLong("combinationid_id") == 0L || m.getLong("combineparentid") > 0L) && m.getString("entryclosestatus").equals("A")).collect(Collectors.toList());
        List itemEntryDynObjList_Close = itementry.stream().filter(m -> (m.getLong("combinationid_id") == 0L || m.getLong("combineparentid") > 0L) && m.getString("entryclosestatus").equals("B")).collect(Collectors.toList());
        BigDecimal totalInstockBaseQty = itemEntryDynObjList.stream().map(m -> m.getBigDecimal("totalinstockbaseqty")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalApproveBaseQty = itemEntryDynObjList.stream().map(m -> m.getBigDecimal("approvebaseqty")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalOutstockBaseQty = itemEntryDynObjList.stream().map(m -> m.getBigDecimal("totaloutstockbaseqty")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalInStockBaseQty_Close = itemEntryDynObjList_Close.stream().map(m -> m.getBigDecimal("totalinstockbaseqty")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalOutStockBaseQty_Close = itemEntryDynObjList_Close.stream().map(m -> m.getBigDecimal("totaloutstockbaseqty")).reduce(BigDecimal.ZERO, BigDecimal::add);
        boolean inQty_LE_OutQty = totalInstockBaseQty.compareTo(totalApproveBaseQty) >= 0;
        boolean bl = inQty_LE_OutQty_Close = totalInStockBaseQty_Close.compareTo(totalOutStockBaseQty_Close) >= 0;
        if (isUnAudit) {
            saleOrder.set("signstatus", (Object)"B");
        } else if (inQty_LE_OutQty && inQty_LE_OutQty_Close) {
            saleOrder.set("signstatus", (Object)"D");
        } else {
            saleOrder.set("signstatus", (Object)"C");
        }
        if (inQty_LE_OutQty && inQty_LE_OutQty_Close) {
            saleOrder.set("billstatus", (Object)"F");
        } else if (totalOutstockBaseQty.compareTo(totalApproveBaseQty) == 0) {
            saleOrder.set("billstatus", (Object)"E");
        } else if (totalOutstockBaseQty.compareTo(BigDecimal.ZERO) > 0 && totalOutstockBaseQty.compareTo(totalApproveBaseQty) < 0) {
            saleOrder.set("billstatus", (Object)"D");
        }
    }

    private void setDeliverySubEntrySignValue(List<DynamicObject> deliveryDynObjList, Set<Long> deliveryIdSet, boolean isAudit) {
        QFilter qFilter = new QFilter(OcocicChannelinbill.EF_billentry_sourceid, "in", deliveryIdSet);
        qFilter.and(OcocicChannelinbill.EF_billentry_srcbillentity, "=", (Object)SOURCEENTITY);
        DynamicObjectCollection channelSerialDynObjColl = QueryServiceHelper.query((String)"ococic_channelinbill", (String)String.join((CharSequence)",", "id", OcocicChannelinbill.E_subsnentryentity_id, OcocicChannelinbill.EF_subsnentryentity_serialnumber), (QFilter[])qFilter.toArray());
        if (!CommonUtils.isNull((Object)channelSerialDynObjColl)) {
            Set serialNumberSet = channelSerialDynObjColl.stream().map(obj -> obj.getString(OcocicChannelinbill.EF_subsnentryentity_serialnumber)).collect(Collectors.toSet());
            for (DynamicObject deliveryDynObj : deliveryDynObjList) {
                DynamicObjectCollection deliveryEntryColl = deliveryDynObj.getDynamicObjectCollection("deliverydetail");
                for (DynamicObject deliveryEntryDynObj : deliveryEntryColl) {
                    DynamicObjectCollection deliverySubEntryColl = deliveryEntryDynObj.getDynamicObjectCollection("subentryentity");
                    for (DynamicObject subEntryDynObj : deliverySubEntryColl) {
                        if (!serialNumberSet.contains(subEntryDynObj.getString("serialnumber"))) continue;
                        subEntryDynObj.set("issign", (Object)isAudit);
                    }
                }
            }
        }
    }
}

