/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ococic.formplugin.wb;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.botp.plugin.AbstractWriteBackPlugIn;
import kd.bos.entity.botp.plugin.args.AfterSaveSourceBillEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeReadSourceBillEventArgs;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class StockInToB2BReturnOrderWriteBackPlugin
extends AbstractWriteBackPlugIn {
    public void beforeReadSourceBill(BeforeReadSourceBillEventArgs e) {
        super.beforeReadSourceBill(e);
        if ("ocbsoc_returnorder".equals(e.getSrcMainType().getName())) {
            e.getFieldKeys().add("baseqty");
            e.getFieldKeys().add("sumpurreturnbaseqty");
            e.getFieldKeys().add("sumpurreturnassistqty");
            e.getFieldKeys().add("purreturnstatus");
            e.getFieldKeys().add("joinpurreturnbaseqty");
            e.getFieldKeys().add("joinpurreturnassistqty");
        }
    }

    public void afterSaveSourceBill(AfterSaveSourceBillEventArgs e) {
        BillEntityType srcSubMainType = e.getSrcSubMainType();
        String opType = this.getOpType();
        List<Object> saveValue = new ArrayList(16);
        if ("ocbsoc_returnorder".equals(srcSubMainType.getName())) {
            DynamicObject[] srcDataEntities;
            if (opType.equalsIgnoreCase("audit") || opType.equalsIgnoreCase("unaudit")) {
                srcDataEntities = e.getSrcDataEntities();
                Map<Object, DynamicObject> saleOrderMap = this.querySrcData(srcDataEntities, "ocbsoc_returnorder");
                saveValue = this.getReturnOrderSaveValues(saleOrderMap, srcDataEntities, true);
            } else if (opType.equalsIgnoreCase("save") || opType.equalsIgnoreCase("delete")) {
                srcDataEntities = e.getSrcDataEntities();
                Map<Object, DynamicObject> saleOrderMap = this.querySrcData(srcDataEntities, "ocbsoc_returnorder");
                saveValue = this.getReturnOrderSaveValues(saleOrderMap, srcDataEntities, false);
            }
        }
        if (!CollectionUtils.isEmpty(saveValue)) {
            DynamicObject[] saveValues = saveValue.toArray(new DynamicObject[saveValue.size()]);
            SaveServiceHelper.save((DynamicObject[])saveValues);
        }
    }

    private Map<Object, DynamicObject> querySrcData(DynamicObject[] srcDataEntities, String sourceEntity) {
        if (srcDataEntities == null) {
            return new HashMap<Object, DynamicObject>(0);
        }
        HashSet<Object> srcPkValues = new HashSet<Object>(srcDataEntities.length);
        for (DynamicObject srcDataEntity : srcDataEntities) {
            srcPkValues.add(srcDataEntity.getPkValue());
        }
        return BusinessDataServiceHelper.loadFromCache((Object[])srcPkValues.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)sourceEntity));
    }

    private List<DynamicObject> getReturnOrderSaveValues(Map<Object, DynamicObject> returnOrderMap, DynamicObject[] srcDataEntities, boolean isAudit) {
        if (returnOrderMap != null && returnOrderMap.size() > 0) {
            ArrayList<DynamicObject> saveValue = new ArrayList<DynamicObject>(returnOrderMap.size());
            for (DynamicObject srcEntity : srcDataEntities) {
                DynamicObject returnOrderDynObj = returnOrderMap.get(srcEntity.getPkValue());
                DynamicObjectCollection itementry = returnOrderDynObj.getDynamicObjectCollection("itementry");
                if (CollectionUtils.isEmpty((Collection)itementry)) continue;
                if (isAudit) {
                    BigDecimal totalReturnOutstockBaseQty = itementry.stream().map(m -> m.getBigDecimal("sumpurreturnbaseqty")).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal totalBaseQty = itementry.stream().map(m -> m.getBigDecimal("baseqty")).reduce(BigDecimal.ZERO, BigDecimal::add);
                    this.setPurReturnStatus(totalReturnOutstockBaseQty, totalBaseQty, returnOrderDynObj);
                    saveValue.add(returnOrderDynObj);
                    saveValue.addAll(this.setTotalPurReturnBaseQty(returnOrderDynObj));
                    continue;
                }
                saveValue.addAll(this.setJoinPurReturnBaseQty(returnOrderDynObj));
            }
            return saveValue;
        }
        return new ArrayList<DynamicObject>(0);
    }

    private void setPurReturnStatus(BigDecimal totalReturnOutstockBaseQty, BigDecimal totalBaseQty, DynamicObject returnOrderDynObj) {
        if (totalReturnOutstockBaseQty.compareTo(BigDecimal.ZERO) > 0) {
            if (totalReturnOutstockBaseQty.compareTo(totalBaseQty) == 0) {
                returnOrderDynObj.set("purreturnstatus", (Object)"E");
            } else {
                returnOrderDynObj.set("purreturnstatus", (Object)"D");
            }
        } else {
            returnOrderDynObj.set("purreturnstatus", (Object)"A");
        }
    }

    private List<DynamicObject> setTotalPurReturnBaseQty(DynamicObject srcDataEntity) {
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(16);
        DynamicObjectCollection itemEntrys = srcDataEntity.getDynamicObjectCollection("itementry");
        if (CollectionUtils.isEmpty((Collection)itemEntrys)) {
            return itemEntrys;
        }
        String srcBillEntity = ((DynamicObject)itemEntrys.get(0)).getString("srcbillentity");
        if ("ocbsoc_returnorder".equals(srcBillEntity)) {
            DynamicObject[] returnOrderDynObjs;
            Map<Long, List<DynamicObject>> itemEntryMap = itemEntrys.stream().collect(Collectors.groupingBy(obj -> obj.getLong("srcbillentryid")));
            Set srcBillIdSet = itemEntrys.stream().map(obj -> obj.getLong("srcbillid")).collect(Collectors.toSet());
            for (DynamicObject returnOrderDynObj : returnOrderDynObjs = BusinessDataServiceHelper.load((Object[])srcBillIdSet.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"ocbsoc_returnorder"))) {
                DynamicObjectCollection orderEntryColl = returnOrderDynObj.getDynamicObjectCollection("itementry");
                boolean isSave = false;
                for (DynamicObject entryDynObj : orderEntryColl) {
                    long entryId = entryDynObj.getLong("id");
                    List<DynamicObject> list = itemEntryMap.get(entryId);
                    if (CollectionUtils.isEmpty(list)) continue;
                    BigDecimal sumpurreturnbaseqty = list.stream().map(m -> m.getBigDecimal("sumpurreturnbaseqty")).reduce(BigDecimal.ZERO, BigDecimal::add);
                    entryDynObj.set("sumpurreturnbaseqty", (Object)sumpurreturnbaseqty);
                    BigDecimal sumpurreturnassistqty = list.stream().map(m -> m.getBigDecimal("sumpurreturnassistqty")).reduce(BigDecimal.ZERO, BigDecimal::add);
                    entryDynObj.set("sumpurreturnassistqty", (Object)sumpurreturnassistqty);
                    isSave = true;
                }
                if (!isSave) continue;
                BigDecimal totalReturnOutstockBaseQty = orderEntryColl.stream().map(m -> m.getBigDecimal("sumpurreturnbaseqty")).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal totalBaseQty = orderEntryColl.stream().map(m -> m.getBigDecimal("baseqty")).reduce(BigDecimal.ZERO, BigDecimal::add);
                this.setPurReturnStatus(totalReturnOutstockBaseQty, totalBaseQty, returnOrderDynObj);
                updateList.add(returnOrderDynObj);
            }
        }
        return updateList;
    }

    private List<DynamicObject> setJoinPurReturnBaseQty(DynamicObject srcDataEntity) {
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(16);
        DynamicObjectCollection itemEntrys = srcDataEntity.getDynamicObjectCollection("itementry");
        if (CollectionUtils.isEmpty((Collection)itemEntrys)) {
            return itemEntrys;
        }
        String srcBillEntity = ((DynamicObject)itemEntrys.get(0)).getString("srcbillentity");
        if ("ocbsoc_returnorder".equals(srcBillEntity)) {
            DynamicObject[] returnOrderDynObjs;
            Map<Long, List<DynamicObject>> itemEntryMap = itemEntrys.stream().collect(Collectors.groupingBy(obj -> obj.getLong("srcbillentryid")));
            Set srcBillIdSet = itemEntrys.stream().map(obj -> obj.getLong("srcbillid")).collect(Collectors.toSet());
            for (DynamicObject returnOrderDynObj : returnOrderDynObjs = BusinessDataServiceHelper.load((Object[])srcBillIdSet.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"ocbsoc_returnorder"))) {
                DynamicObjectCollection orderEntryColl = returnOrderDynObj.getDynamicObjectCollection("itementry");
                boolean isSave = false;
                for (DynamicObject entryDynObj : orderEntryColl) {
                    long entryId = entryDynObj.getLong("id");
                    List<DynamicObject> list = itemEntryMap.get(entryId);
                    if (CollectionUtils.isEmpty(list)) continue;
                    BigDecimal joinpurreturnbaseqty = list.stream().map(m -> m.getBigDecimal("joinpurreturnbaseqty")).reduce(BigDecimal.ZERO, BigDecimal::add);
                    entryDynObj.set("joinpurreturnbaseqty", (Object)joinpurreturnbaseqty);
                    BigDecimal joinpurreturnassistqty = list.stream().map(m -> m.getBigDecimal("joinpurreturnassistqty")).reduce(BigDecimal.ZERO, BigDecimal::add);
                    entryDynObj.set("joinpurreturnassistqty", (Object)joinpurreturnassistqty);
                    isSave = true;
                }
                if (!isSave) continue;
                updateList.add(returnOrderDynObj);
            }
        }
        return updateList;
    }
}

