/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ococic.formplugin.wb;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.botp.plugin.AbstractWriteBackPlugIn;
import kd.bos.entity.botp.plugin.args.AfterSaveSourceBillEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeReadSourceBillEventArgs;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class StockOutToB2BReturnOrderWriteBackPlugin
extends AbstractWriteBackPlugIn {
    public void beforeReadSourceBill(BeforeReadSourceBillEventArgs e) {
        super.beforeReadSourceBill(e);
        if ("ocbsoc_returnorder".equals(e.getSrcMainType().getName())) {
            e.getFieldKeys().add("baseqty");
            e.getFieldKeys().add("sumsalereturnbaseqty");
            e.getFieldKeys().add("salereturnstatus");
        }
    }

    public void afterSaveSourceBill(AfterSaveSourceBillEventArgs e) {
        BillEntityType srcSubMainType = e.getSrcSubMainType();
        String opType = this.getOpType();
        List<Object> saveValue = new ArrayList(16);
        if ("ocbsoc_returnorder".equals(srcSubMainType.getName()) && (opType.equalsIgnoreCase("audit") || opType.equalsIgnoreCase("unaudit"))) {
            DynamicObject[] srcDataEntities = e.getSrcDataEntities();
            Map<Object, DynamicObject> saleOrderMap = this.querySrcData(srcDataEntities, "ocbsoc_returnorder");
            saveValue = this.getReturnOrderSaveValues(saleOrderMap, srcDataEntities);
        }
        if (!CollectionUtils.isEmpty(saveValue)) {
            DynamicObject[] saveValues = saveValue.toArray(new DynamicObject[saveValue.size()]);
            SaveServiceHelper.save((DynamicObject[])saveValues);
        }
    }

    private Map<Object, DynamicObject> querySrcData(DynamicObject[] srcDataEntities, String sourceEntity) {
        if (srcDataEntities == null) {
            return new HashMap<Object, DynamicObject>(0);
        }
        HashSet<Object> srcPkValues = new HashSet<Object>(srcDataEntities.length);
        for (DynamicObject srcDataEntity : srcDataEntities) {
            srcPkValues.add(srcDataEntity.getPkValue());
        }
        return BusinessDataServiceHelper.loadFromCache((Object[])srcPkValues.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)sourceEntity));
    }

    private List<DynamicObject> getReturnOrderSaveValues(Map<Object, DynamicObject> returnOrderMap, DynamicObject[] srcDataEntities) {
        if (returnOrderMap != null && returnOrderMap.size() > 0) {
            ArrayList<DynamicObject> saveValue = new ArrayList<DynamicObject>(returnOrderMap.size());
            for (DynamicObject srcEntity : srcDataEntities) {
                DynamicObject returnOrderDynObj = returnOrderMap.get(srcEntity.getPkValue());
                DynamicObjectCollection itementry = returnOrderDynObj.getDynamicObjectCollection("itementry");
                if (CollectionUtils.isEmpty((Collection)itementry)) continue;
                BigDecimal totalReturnInstockBaseQty = itementry.stream().map(m -> m.getBigDecimal("sumsalereturnbaseqty")).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal totalBaseQty = itementry.stream().map(m -> m.getBigDecimal("baseqty")).reduce(BigDecimal.ZERO, BigDecimal::add);
                this.setPurReturnStatus(totalReturnInstockBaseQty, totalBaseQty, returnOrderDynObj);
                saveValue.add(returnOrderDynObj);
            }
            return saveValue;
        }
        return new ArrayList<DynamicObject>(0);
    }

    private void setPurReturnStatus(BigDecimal totalReturnInstockBaseQty, BigDecimal totalBaseQty, DynamicObject returnOrderDynObj) {
        if (totalReturnInstockBaseQty.compareTo(BigDecimal.ZERO) > 0) {
            if (totalReturnInstockBaseQty.compareTo(totalBaseQty) == 0) {
                returnOrderDynObj.set("salereturnstatus", (Object)"E");
            } else {
                returnOrderDynObj.set("salereturnstatus", (Object)"D");
            }
        } else {
            returnOrderDynObj.set("salereturnstatus", (Object)"A");
        }
    }
}

