/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ococic.formplugin.wb;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.botp.plugin.AbstractWriteBackPlugIn;
import kd.bos.entity.botp.plugin.args.AfterExcessCheckEventArgs;
import kd.bos.entity.botp.plugin.args.AfterSaveSourceBillEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeReadSourceBillEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class StockOutWriteBackSaleOrderPlugin
extends AbstractWriteBackPlugIn {
    private static final Log log = LogFactory.getLog(StockOutWriteBackSaleOrderPlugin.class);

    public void beforeReadSourceBill(BeforeReadSourceBillEventArgs e) {
        super.beforeReadSourceBill(e);
        if ("ocbsoc_saleorder".equals(e.getSrcMainType().getName())) {
            e.getFieldKeys().add("approvebaseqty");
            e.getFieldKeys().add("totaloutstockbaseqty");
            e.getFieldKeys().add("totalsignedbaseqty");
            e.getFieldKeys().add("signstatus");
            e.getFieldKeys().add("billstatus");
            e.getFieldKeys().add("entryclosestatus");
        }
    }

    public void afterExcessCheck(AfterExcessCheckEventArgs e) {
        super.afterExcessCheck(e);
        String opType = this.getOpType();
        BillEntityType srcSubMainType = e.getSrcSubMainType();
        if ("ocbsoc_saleorder".equals(srcSubMainType.getName()) && opType.equalsIgnoreCase("unaudit")) {
            DynamicObject srcActiveRow = e.getSrcActiveRow();
            DynamicObject targetActiveRow = e.getTargetActiveRow();
            DynamicObject outBill = (DynamicObject)targetActiveRow.getParent();
            DynamicObject saleOrder = (DynamicObject)((DynamicObject)srcActiveRow.getParent()).getParent();
            QFilter qFilter = new QFilter("billentry.mainbillid", "=", saleOrder.getPkValue());
            qFilter.and("deliverydetail.mainbillentity", "=", (Object)"ocbsoc_saleorder");
            qFilter.and("deliverydetail.srcbillentryid", "=", targetActiveRow.getPkValue());
            qFilter.and("billstatus", "=", (Object)"C");
            boolean exists = QueryServiceHelper.exists((String)"ocbsoc_delivery_record", (QFilter[])qFilter.toArray());
            if (exists) {
                e.setExcess(true);
                e.setMessage(ResManager.loadKDString((String)"\u51fa\u5e93\u5df2\u7b7e\u6536\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"StockOutWriteBackSaleOrderPlugin_0", (String)"occ-ococic-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void afterSaveSourceBill(AfterSaveSourceBillEventArgs e) {
        super.afterSaveSourceBill(e);
        BillEntityType srcSubMainType = e.getSrcSubMainType();
        String opType = this.getOpType();
        if ("ocbsoc_saleorder".equals(srcSubMainType.getName()) && (opType.equalsIgnoreCase("audit") || opType.equalsIgnoreCase("unaudit"))) {
            DynamicObject[] srcDataEntities = e.getSrcDataEntities();
            List ids = Arrays.asList(srcDataEntities).stream().map(m -> m.getPkValue()).collect(Collectors.toList());
            DynamicObject[] saleOrders = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"ocbsoc_saleorder"));
            ArrayList<DynamicObject> saveValue = new ArrayList<DynamicObject>(srcDataEntities.length);
            for (DynamicObject srcDataEntity : saleOrders) {
                DynamicObjectCollection itemEntrys = srcDataEntity.getDynamicObjectCollection("itementry");
                saveValue.add(srcDataEntity);
                BigDecimal allstockSum = itemEntrys.stream().map(m -> m.getBigDecimal("totaloutstockbaseqty")).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (allstockSum.compareTo(BigDecimal.ZERO) > 0) {
                    long count = itemEntrys.stream().filter(m -> m.getBigDecimal("approvebaseqty").compareTo(m.getBigDecimal("totaloutstockbaseqty")) > 0 && m.getString("entryclosestatus").equals("A")).count();
                    srcDataEntity.set("billstatus", (Object)(count > 0L ? "D" : "E"));
                    srcDataEntity.set("signstatus", (Object)"B");
                    continue;
                }
                srcDataEntity.set("billstatus", (Object)"C");
                srcDataEntity.set("signstatus", (Object)"A");
            }
            DynamicObject[] saveValues = saveValue.toArray(new DynamicObject[saveValue.size()]);
            SaveServiceHelper.save((DynamicObject[])saveValues);
        }
    }
}

