/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ococic.report.invacc;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.occ.ococic.business.helper.AvailableInventoryHelper;
import kd.occ.ococic.business.helper.UnitConvertHelper;
import kd.occ.ococic.pojo.AvailableInventoryParamVO;
import kd.occ.ococic.util.CommonUtils;

public class AvbInvQueryRptQuery
extends AbstractReportListDataPlugin {
    private static final String STOCKORG_ID = "stockorg_id";
    private static final String STOCK_ID = "stock_id";
    private static final String CHANNEL_ID = "channel_id";
    private static final String WAREHOUSE_ID = "warehouse_id";
    private static final String RESOURCECLASS_ID = "resourceclass_id";
    public static final String STOCKTYPENAME = "channelstocktypeid.name";

    public DataSet query(ReportQueryParam queryParam, Object arg1) throws Throwable {
        Map<Long, List<DynamicObject>> itemDynObjMap;
        FilterInfo filterInfo = queryParam.getFilter();
        Set<DynamicObject> itemDynObjSet = this.getItemDynObjSet(filterInfo, true);
        DataSet availableInvDataSet = this.queryScmAvailableInventory(filterInfo, itemDynObjSet);
        Set<DynamicObject> channelItemDynObjSet = this.getItemDynObjSet(filterInfo, false);
        DataSet channelinvaccDataSet = this.queryChannelInventory(filterInfo, channelItemDynObjSet);
        List<Field> fieldList = this.getFieldList();
        RowMeta rowMeta = new RowMeta(fieldList.toArray(new Field[fieldList.size()]));
        DataSetBuilder dataSetBuilder = Algo.create((String)"invAccQueryData").createDataSetBuilder(rowMeta);
        if (availableInvDataSet != null) {
            itemDynObjMap = itemDynObjSet.stream().collect(Collectors.groupingBy(obj -> obj.getLong("material")));
            this.appendAvailableInvDataSet(dataSetBuilder, availableInvDataSet, filterInfo, itemDynObjMap);
        }
        if (channelinvaccDataSet != null) {
            itemDynObjMap = channelItemDynObjSet.stream().collect(Collectors.groupingBy(obj -> obj.getLong("id")));
            this.appendChannelinvaccDataSet(dataSetBuilder, channelinvaccDataSet, filterInfo, itemDynObjMap);
        }
        DataSet filterDataSet = dataSetBuilder.build();
        DataSet queryInvDataSet = this.getGroupByInvDataSet(filterInfo, filterDataSet);
        return queryInvDataSet;
    }

    private DataSet getGroupByInvDataSet(FilterInfo filterInfo, DataSet filterDataSet) {
        DataSet queryInvDataSet = null;
        if (filterDataSet != null) {
            String filterStr = "1=1";
            DynamicObjectCollection resourceClassColl = filterInfo.getDynamicObjectCollection("resourceclass");
            if (!CommonUtils.isNull((Object)resourceClassColl)) {
                filterStr = "resourceclassid IN (" + String.join((CharSequence)",", resourceClassColl.stream().map(obj -> obj.getString("id")).collect(Collectors.toSet())) + ")";
            }
            boolean isShowZero = Boolean.parseBoolean(filterInfo.getValue("isshowzero").toString());
            boolean isShowAvbZero = Boolean.parseBoolean(filterInfo.getValue("isshowavbzero").toString());
            if (isShowZero && isShowAvbZero) {
                filterStr = filterStr + " AND baseqty<>0 AND avbbaseqty<>0";
            } else if (isShowZero && !isShowAvbZero) {
                filterStr = filterStr + " AND baseqty<>0";
            } else if (!isShowZero && isShowAvbZero) {
                filterStr = filterStr + " AND avbbaseqty<>0";
            }
            DataSet dataSet = filterDataSet.filter(filterStr);
            String[] groupByFields = this.getGroupByFieldList(filterInfo);
            queryInvDataSet = groupByFields.length > 0 ? dataSet.groupBy(groupByFields).sum("qty").sum("reserveqty").sum("avbqty").sum("baseqty").sum("reservebaseqty").sum("avbbaseqty").finish() : dataSet;
        }
        return queryInvDataSet;
    }

    private String[] getGroupByFieldList(FilterInfo filterInfo) {
        ArrayList<String> groupByFieldList = new ArrayList<String>(6);
        String group1 = String.valueOf(filterInfo.getValue("group1"));
        String group2 = String.valueOf(filterInfo.getValue("group2"));
        String group3 = String.valueOf(filterInfo.getValue("group3"));
        switch (group1) {
            case "1": {
                if ("3".equals(group2) && "0".equals(group3)) {
                    groupByFieldList.add("resourcestockid");
                    groupByFieldList.add("itemid");
                    groupByFieldList.add("materialid");
                    groupByFieldList.add("invtypeid");
                    groupByFieldList.add("invtypename");
                    groupByFieldList.add("baseunitid");
                    groupByFieldList.add("unitid");
                    break;
                }
                if (!"3".equals(group2) || !"4".equals(group3)) break;
                groupByFieldList.add("resourcestockid");
                groupByFieldList.add("itemid");
                groupByFieldList.add("materialid");
                groupByFieldList.add("auxptyid");
                groupByFieldList.add("invtypeid");
                groupByFieldList.add("invtypename");
                groupByFieldList.add("baseunitid");
                groupByFieldList.add("unitid");
                break;
            }
            case "2": {
                if ("3".equals(group2) && "0".equals(group3)) {
                    groupByFieldList.add("resourceclassid");
                    groupByFieldList.add("itemid");
                    groupByFieldList.add("materialid");
                    groupByFieldList.add("invtypeid");
                    groupByFieldList.add("invtypename");
                    groupByFieldList.add("baseunitid");
                    groupByFieldList.add("unitid");
                    break;
                }
                if (!"3".equals(group2) || !"4".equals(group3)) break;
                groupByFieldList.add("resourceclassid");
                groupByFieldList.add("itemid");
                groupByFieldList.add("materialid");
                groupByFieldList.add("auxptyid");
                groupByFieldList.add("invtypeid");
                groupByFieldList.add("invtypename");
                groupByFieldList.add("baseunitid");
                groupByFieldList.add("unitid");
                break;
            }
            case "3": {
                if ("4".equals(group2) && "0".equals(group3)) {
                    groupByFieldList.add("itemid");
                    groupByFieldList.add("materialid");
                    groupByFieldList.add("auxptyid");
                    groupByFieldList.add("invtypeid");
                    groupByFieldList.add("invtypename");
                    groupByFieldList.add("baseunitid");
                    groupByFieldList.add("unitid");
                    break;
                }
                if ("4".equals(group2) && "1".equals(group3)) {
                    groupByFieldList.add("itemid");
                    groupByFieldList.add("materialid");
                    groupByFieldList.add("auxptyid");
                    groupByFieldList.add("resourcestockid");
                    groupByFieldList.add("invtypeid");
                    groupByFieldList.add("invtypename");
                    groupByFieldList.add("baseunitid");
                    groupByFieldList.add("unitid");
                    break;
                }
                if ("4".equals(group2) && "2".equals(group3)) {
                    groupByFieldList.add("itemid");
                    groupByFieldList.add("materialid");
                    groupByFieldList.add("auxptyid");
                    groupByFieldList.add("resourceclassid");
                    groupByFieldList.add("invtypeid");
                    groupByFieldList.add("invtypename");
                    groupByFieldList.add("baseunitid");
                    groupByFieldList.add("unitid");
                    break;
                }
                if ("1".equals(group2) && "0".equals(group3)) {
                    groupByFieldList.add("itemid");
                    groupByFieldList.add("materialid");
                    groupByFieldList.add("resourcestockid");
                    groupByFieldList.add("invtypeid");
                    groupByFieldList.add("invtypename");
                    groupByFieldList.add("baseunitid");
                    groupByFieldList.add("unitid");
                    break;
                }
                if ("2".equals(group2) && "0".equals(group3)) {
                    groupByFieldList.add("itemid");
                    groupByFieldList.add("materialid");
                    groupByFieldList.add("resourceclassid");
                    groupByFieldList.add("invtypeid");
                    groupByFieldList.add("invtypename");
                    groupByFieldList.add("baseunitid");
                    groupByFieldList.add("unitid");
                    break;
                }
                if (!"0".equals(group2) || !"0".equals(group3)) break;
                groupByFieldList.add("itemid");
                groupByFieldList.add("materialid");
                groupByFieldList.add("invtypeid");
                groupByFieldList.add("invtypename");
                groupByFieldList.add("baseunitid");
                groupByFieldList.add("unitid");
                break;
            }
        }
        return groupByFieldList.toArray(new String[groupByFieldList.size()]);
    }

    private List<Field> getFieldList() {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        fieldList.add(new Field("resourcestockid", (DataType)DataType.LongType));
        fieldList.add(new Field("resourceclassid", (DataType)DataType.LongType));
        fieldList.add(new Field("itemid", (DataType)DataType.LongType));
        fieldList.add(new Field("materialid", (DataType)DataType.LongType));
        fieldList.add(new Field("auxptyid", (DataType)DataType.LongType));
        fieldList.add(new Field("baseunitid", (DataType)DataType.LongType));
        fieldList.add(new Field("unitid", (DataType)DataType.LongType));
        fieldList.add(new Field("invtypeid", (DataType)DataType.LongType));
        fieldList.add(new Field("invtypename", (DataType)DataType.StringType));
        fieldList.add(new Field("qty", (DataType)DataType.BigDecimalType));
        fieldList.add(new Field("reserveqty", (DataType)DataType.BigDecimalType));
        fieldList.add(new Field("avbqty", (DataType)DataType.BigDecimalType));
        fieldList.add(new Field("baseqty", (DataType)DataType.BigDecimalType));
        fieldList.add(new Field("reservebaseqty", (DataType)DataType.BigDecimalType));
        fieldList.add(new Field("avbbaseqty", (DataType)DataType.BigDecimalType));
        return fieldList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendAvailableInvDataSet(DataSetBuilder dataSetBuilder, DataSet invDataSet, FilterInfo filterInfo, Map<Long, List<DynamicObject>> itemDynObjMap) {
        DynamicObjectCollection resourceStockColl = filterInfo.getDynamicObjectCollection("resourcestock");
        Map<String, List<DynamicObject>> resourceStockMap = resourceStockColl.stream().collect(Collectors.groupingBy(obj -> obj.getLong(STOCKORG_ID) + "_" + obj.getLong(STOCK_ID)));
        try {
            Row dataSetRow = null;
            long materialId = 0L;
            while (invDataSet.hasNext()) {
                dataSetRow = invDataSet.next();
                List<DynamicObject> resourceStockObjList = resourceStockMap.get(dataSetRow.getLong("stockorgid") + "_" + dataSetRow.getLong("warehouseid"));
                materialId = dataSetRow.getLong("materialid");
                List<DynamicObject> itemObjList = itemDynObjMap.get(materialId);
                if (CommonUtils.isNull(resourceStockObjList)) continue;
                for (DynamicObject resourceStockObj : resourceStockObjList) {
                    for (DynamicObject itemObj : itemObjList) {
                        BigDecimal baseQty = dataSetRow.getBigDecimal("baseqty");
                        long unitId = itemObj.getLong("stockunit");
                        long baseUnitId = dataSetRow.getLong("baseunitid");
                        BigDecimal reserveBaseQty = dataSetRow.getBigDecimal("reservebaseqty");
                        BigDecimal avbBaseQty = dataSetRow.getBigDecimal("avbbaseqty");
                        dataSetBuilder.append(new Object[]{resourceStockObj.getLong("id"), resourceStockObj.getLong(RESOURCECLASS_ID), itemObj.getLong("id"), materialId, dataSetRow.getLong("auxptyid"), baseUnitId, itemObj.getLong("stockunit"), dataSetRow.getLong("invtypeid"), dataSetRow.getString("invtypename"), UnitConvertHelper.calculateDestQty((BigDecimal)baseQty, (Long)materialId, (Long)baseUnitId, (Long)unitId), UnitConvertHelper.calculateDestQty((BigDecimal)reserveBaseQty, (Long)materialId, (Long)baseUnitId, (Long)unitId), UnitConvertHelper.calculateDestQty((BigDecimal)avbBaseQty, (Long)materialId, (Long)baseUnitId, (Long)unitId), baseQty, reserveBaseQty, avbBaseQty});
                    }
                }
            }
        }
        finally {
            invDataSet.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendChannelinvaccDataSet(DataSetBuilder dataSetBuilder, DataSet invDataSet, FilterInfo filterInfo, Map<Long, List<DynamicObject>> itemDynObjMap) {
        DynamicObjectCollection resourceStockColl = filterInfo.getDynamicObjectCollection("resourcestock");
        Map<String, List<DynamicObject>> resourceStockMap = resourceStockColl.stream().collect(Collectors.groupingBy(obj -> obj.getLong(CHANNEL_ID) + "_" + obj.getLong(WAREHOUSE_ID)));
        try {
            Row dataSetRow = null;
            long materialId = 0L;
            while (invDataSet.hasNext()) {
                dataSetRow = invDataSet.next();
                List<DynamicObject> resourceStockObjList = resourceStockMap.get(dataSetRow.getLong("channelid") + "_" + dataSetRow.getLong("channelstockid"));
                long itemId = dataSetRow.getLong("itemid");
                if (itemDynObjMap.get(itemId) != null) {
                    materialId = itemDynObjMap.get(itemId).get(0).getLong("material");
                }
                if (CommonUtils.isNull(resourceStockObjList)) continue;
                for (DynamicObject resourceStockObj : resourceStockObjList) {
                    dataSetBuilder.append(new Object[]{resourceStockObj.getLong("id"), resourceStockObj.getLong(RESOURCECLASS_ID), dataSetRow.getLong("itemid"), materialId, dataSetRow.getLong("auxptyid"), dataSetRow.getLong("baseunitid"), dataSetRow.getLong("stockunitid"), dataSetRow.getLong("channelstocktypeid"), dataSetRow.getString(STOCKTYPENAME), dataSetRow.getLong("stockqty"), 0, dataSetRow.getLong("stockqty"), dataSetRow.getLong("baseqty"), 0, dataSetRow.getLong("baseqty")});
                }
            }
        }
        finally {
            invDataSet.close();
        }
    }

    private Set<DynamicObject> getItemDynObjSet(FilterInfo filterInfo, boolean isByScm) {
        String selectFileds = String.join((CharSequence)",", "id", "material", "stockunit", "baseunit");
        DynamicObjectCollection itemColl = filterInfo.getDynamicObjectCollection("item");
        if (!CommonUtils.isNull((Object)itemColl)) {
            QFilter filter = new QFilter("id", "in", itemColl.stream().map(obj -> obj.getPkValue()).collect(Collectors.toSet()));
            DynamicObjectCollection itemDynObjColl = QueryServiceHelper.query((String)"ocdbd_iteminfo", (String)selectFileds, (QFilter[])filter.toArray());
            HashSet<DynamicObject> itemDynObjSet = new HashSet<DynamicObject>(itemDynObjColl.size());
            itemDynObjSet.addAll((Collection<DynamicObject>)itemDynObjColl);
            return itemDynObjSet;
        }
        DynamicObjectCollection itemClassColl = filterInfo.getDynamicObjectCollection("itemclass");
        if (!CommonUtils.isNull((Object)itemClassColl)) {
            QFilter filter = new QFilter("itemclassentity.goodsclasssid", "in", itemClassColl.stream().map(obj -> obj.getPkValue()).collect(Collectors.toSet()));
            DynamicObjectCollection itemDynObjColl = QueryServiceHelper.query((String)"ocdbd_iteminfo", (String)selectFileds, (QFilter[])filter.toArray());
            HashSet<DynamicObject> itemDynObjSet = new HashSet<DynamicObject>(itemDynObjColl.size());
            itemDynObjSet.addAll((Collection<DynamicObject>)itemDynObjColl);
            return itemDynObjSet;
        }
        DynamicObjectCollection resourceStockColl = filterInfo.getDynamicObjectCollection("resourcestock");
        int count = resourceStockColl.size();
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(count);
        HashSet<Long> channelIdSet = new HashSet<Long>(count);
        for (int i = 0; i < count; ++i) {
            if (isByScm) {
                long sotckOrgId = ((DynamicObject)resourceStockColl.get(i)).getLong(STOCKORG_ID);
                if (sotckOrgId <= 0L) continue;
                filterList.add(BaseDataServiceHelper.getBaseDataFilter((String)"ocdbd_iteminfo", (Long)sotckOrgId));
                continue;
            }
            long channelId = ((DynamicObject)resourceStockColl.get(i)).getLong(CHANNEL_ID);
            if (channelId <= 0L) continue;
            channelIdSet.add(channelId);
        }
        if (!isByScm && !CommonUtils.isNull(channelIdSet)) {
            QFilter filter = new QFilter("id", "in", channelIdSet);
            DynamicObjectCollection channelDynObjColl = QueryServiceHelper.query((String)"ocdbd_channel", (String)"saleorg", (QFilter[])filter.toArray());
            HashSet<Long> bizgroupIdSet = new HashSet<Long>(channelDynObjColl.size());
            for (DynamicObject dynamicObject : channelDynObjColl) {
                long bizgroupId = dynamicObject.getLong("saleorg");
                if (!bizgroupIdSet.add(bizgroupId)) continue;
                filterList.add(BaseDataServiceHelper.getBaseDataFilter((String)"ocdbd_iteminfo", (Long)bizgroupId));
            }
        }
        HashSet<Object> itemDynObjSet = new HashSet<DynamicObject>(0);
        if (filterList.size() > 0) {
            QFilter blFilter = new QFilter("goodsbelong", "=", (Object)"0");
            DynamicObjectCollection itemDynObjColl = QueryServiceHelper.query((String)"ocdbd_iteminfo", (String)selectFileds, (QFilter[])((QFilter)filterList.get(0)).and(blFilter).toArray());
            itemDynObjSet = new HashSet(itemDynObjColl.size() * filterList.size());
            itemDynObjSet.addAll((Collection<DynamicObject>)itemDynObjColl);
            int size = filterList.size();
            for (int i = 1; i < size; ++i) {
                Set itemIdSet = itemDynObjSet.stream().map(obj -> obj.getLong("id")).collect(Collectors.toSet());
                itemDynObjColl = QueryServiceHelper.query((String)"ocdbd_iteminfo", (String)selectFileds, (QFilter[])((QFilter)filterList.get(i)).and(blFilter).toArray());
                for (DynamicObject itemDynObj : itemDynObjColl) {
                    if (itemIdSet.contains(itemDynObj.getLong("id"))) continue;
                    itemDynObjSet.add(itemDynObj);
                }
            }
        }
        return itemDynObjSet;
    }

    private DataSet queryScmAvailableInventory(FilterInfo filterInfo, Set<DynamicObject> itemDynObjSet) {
        AvailableInventoryParamVO availableInvParamVO = new AvailableInventoryParamVO();
        DynamicObjectCollection resourceStockColl = filterInfo.getDynamicObjectCollection("resourcestock");
        for (DynamicObject resourceStockDynObj : resourceStockColl) {
            if (resourceStockDynObj.getLong(STOCKORG_ID) <= 0L) continue;
            availableInvParamVO.getStockOrgIdSet().add(resourceStockDynObj.getLong(STOCKORG_ID));
            availableInvParamVO.getWarehouseIdSet().add(resourceStockDynObj.getLong(STOCK_ID));
        }
        for (DynamicObject itemDynObj : itemDynObjSet) {
            availableInvParamVO.getMaterialIdSet().add(itemDynObj.getLong("material"));
        }
        DynamicObjectCollection invtypeColl = filterInfo.getDynamicObjectCollection("invtype");
        if (!CommonUtils.isNull((Object)invtypeColl)) {
            for (DynamicObject invtypeDynObj : invtypeColl) {
                availableInvParamVO.getInvTypeIdSet().add(invtypeDynObj.getLong("id"));
            }
        }
        return AvailableInventoryHelper.queryScmAvailableInventory((AvailableInventoryParamVO)availableInvParamVO);
    }

    private DataSet queryChannelInventory(FilterInfo filterInfo, Set<DynamicObject> channelItemDynObjSet) {
        DynamicObjectCollection resourceStockColl = filterInfo.getDynamicObjectCollection("resourcestock");
        HashSet<Long> channelIdSet = new HashSet<Long>(resourceStockColl.size());
        HashSet<Long> channelStockIdSet = new HashSet<Long>(resourceStockColl.size());
        int size = resourceStockColl.size();
        for (int i = 0; i < size; ++i) {
            long channelId = ((DynamicObject)resourceStockColl.get(i)).getLong(CHANNEL_ID);
            long channelStockId = ((DynamicObject)resourceStockColl.get(i)).getLong(WAREHOUSE_ID);
            if (channelId > 0L) {
                channelIdSet.add(channelId);
            }
            if (channelStockId <= 0L) continue;
            channelStockIdSet.add(channelStockId);
        }
        if (channelIdSet.size() > 0 && channelStockIdSet.size() > 0 && !CommonUtils.isNull(channelItemDynObjSet)) {
            QFilter channelFilter = new QFilter("channelid", "in", (Object)resourceStockColl.stream().map(obj -> obj.getLong(CHANNEL_ID)).toArray());
            QFilter stockIdFilter = new QFilter("channelstockid", "in", (Object)resourceStockColl.stream().map(obj -> obj.getLong(WAREHOUSE_ID)).toArray());
            QFilter itemIdFilter = new QFilter("itemid", "in", (Object)channelItemDynObjSet.stream().map(obj -> obj.getLong("id")).toArray());
            String selectFields = String.join((CharSequence)",", "channelid", "channelstockid", "itemid", "auxptyid", "channelstocktypeid", STOCKTYPENAME, "baseunitid", "baseqty", "stockunitid", "stockqty");
            return QueryServiceHelper.queryDataSet((String)AvbInvQueryRptQuery.class.getName(), (String)"ococic_channelinvacc", (String)selectFields, (QFilter[])new QFilter[]{channelFilter, stockIdFilter, itemIdFilter}, (String)"");
        }
        return null;
    }
}

