/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ococic.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DateUtils {
    public static final String FORMAT_YMD = "yyyy-MM-dd";
    public static final String FORMAT_YMDHMS = "yyyy-MM-dd HH:mm:ss";
    public static final String FORMAT_yyyyMMdd = "yyyyMMdd";
    public static final DateTimeFormatter DATE_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
    public static final DateTimeFormatter DATETIME_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");

    public static Date truncateDate(Date dt) {
        if (dt == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        return new Date(cal.getTimeInMillis() / 1000L * 1000L);
    }

    public static Date getLastDay(Date date, int i) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(5, cal.get(5) - i);
        return cal.getTime();
    }

    public static Date getNextDay(Date date, int i) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(5, cal.get(5) + i);
        return cal.getTime();
    }

    public static int getDiffDays(Date beginDate, Date endDate) {
        if (beginDate == null || endDate == null) {
            throw new IllegalArgumentException("getDiffDays param is null!");
        }
        double distance = kd.bos.login.utils.DateUtils.getDistanceOfTwoDate((Date)beginDate, (Date)endDate);
        int days = 1 + (int)distance;
        return days;
    }

    public static int getDiffDaysIgnoreTime(Date beginDate, Date endDate) {
        beginDate = DateUtils.getDataFormat(beginDate, true);
        if (null == (endDate = DateUtils.getDataFormat(endDate, true))) {
            endDate = new Date();
        }
        if (null == beginDate) {
            beginDate = new Date();
        }
        return (int)((endDate.getTime() - beginDate.getTime()) / 86400000L);
    }

    public static Date getDataFormat(Date date, boolean isStart) {
        if (date == null) {
            return null;
        }
        String dateStr = new SimpleDateFormat(FORMAT_YMD).format(date);
        String suffix = " 00:00:00";
        if (!isStart) {
            suffix = " 23:59:59";
        }
        String source = dateStr + suffix;
        try {
            return new SimpleDateFormat(FORMAT_YMDHMS).parse(source);
        }
        catch (ParseException e) {
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
    }

    public static String formatString(Date date, String forPattern) {
        return new DateTime((Object)date).toString(DateTimeFormat.forPattern((String)forPattern));
    }

    public static int getDay(Date date) {
        return Integer.parseInt(new DateTime((Object)date).toString(DATE_FORMATTER).substring(8));
    }

    public static int getMonth(Date date) {
        return Integer.parseInt(new DateTime((Object)date).toString(DATE_FORMATTER).substring(5, 7));
    }

    public static int getYear(Date date) {
        return Integer.parseInt(new DateTime((Object)date).toString(DATE_FORMATTER).substring(0, 4));
    }

    public static Map<String, Date> getWeekDate() {
        HashMap<String, Date> weekDate = new HashMap<String, Date>();
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        int d = 0;
        d = cal.get(7) == 1 ? -6 : 2 - cal.get(7);
        cal.add(7, d);
        weekDate.put("beginDate", cal.getTime());
        cal.add(7, 6);
        weekDate.put("endDate", cal.getTime());
        return weekDate;
    }

    public static Date getMinMonthDate(Date date) {
        date = DateUtils.getDataFormat(date, true);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, calendar.getActualMinimum(5));
        return calendar.getTime();
    }

    public static Date getMaxMonthDate(Date date) {
        date = DateUtils.getDataFormat(date, false);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, calendar.getActualMaximum(5));
        return calendar.getTime();
    }

    public static boolean isSameDay(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            return false;
        }
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        return DateUtils.isSameDay(cal1, cal2);
    }

    public static boolean isSameDay(Calendar cal1, Calendar cal2) {
        if (cal1 == null || cal2 == null) {
            return false;
        }
        return cal1.get(0) == cal2.get(0) && cal1.get(1) == cal2.get(1) && cal1.get(6) == cal2.get(6);
    }

    public static boolean isSameMonth(Date d1, Date d2) {
        return DateUtils.isSameDay(DateUtils.getMinMonthDate(d1), DateUtils.getMinMonthDate(d1));
    }
}

