/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ococic.business.allotbill;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.util.CollectionUtils;
import kd.occ.ocbase.common.enums.allotbill.AllotType;
import kd.occ.ocbase.common.enums.allotbill.UpdateType;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ococic.business.allotbill.AllotResultHandler;
import kd.occ.ococic.pojo.AllotResultVO;

public class AllotBillHandler {
    public static final String getSKey(DynamicObject entry) {
        int sKeyHashCode = String.join((CharSequence)"#", DynamicObjectUtils.getDynamicObjectSPkValue((DynamicObject)entry, (String)"stockorg"), DynamicObjectUtils.getDynamicObjectSPkValue((DynamicObject)entry, (String)"warehouse"), DynamicObjectUtils.getDynamicObjectSPkValue((DynamicObject)entry, (String)"material"), DynamicObjectUtils.getDynamicObjectSPkValue((DynamicObject)entry, (String)"auxpty"), DynamicObjectUtils.getDynamicObjectSPkValue((DynamicObject)entry, (String)"baseunit")).hashCode();
        return String.valueOf(sKeyHashCode);
    }

    public static final String getPKey(DynamicObject entry) {
        int sKeyHashCode = String.join((CharSequence)"#", DynamicObjectUtils.getDynamicObjectSPkValue((DynamicObject)entry, (String)"item"), entry.getString("ckey")).hashCode();
        return String.valueOf(sKeyHashCode);
    }

    public static final String getCkey(DynamicObjectCollection subEntries) {
        String cKey = "";
        if (!CollectionUtils.isEmpty((Collection)subEntries)) {
            List<String> distinctSortChannelIdStringList = subEntries.stream().map(r -> DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)r, (String)"channel")).distinct().sorted().map(r -> String.valueOf(r)).collect(Collectors.toList());
            cKey = AllotBillHandler.getHashCodeString(distinctSortChannelIdStringList);
        }
        return cKey;
    }

    public static final AllotType getAllotType(DynamicObjectCollection subEntries) {
        AllotType allotType = null;
        if (!CollectionUtils.isEmpty((Collection)subEntries)) {
            long subEntriesSize = subEntries.stream().map(r -> DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)r, (String)"channel")).distinct().count();
            if (subEntriesSize > 1L) {
                allotType = AllotType.SHARE;
            } else if (subEntriesSize == 1L) {
                allotType = AllotType.PRIVATE;
            }
        }
        return allotType;
    }

    public static final String getHashCodeString(List<String> stringList) {
        String hashCodeStr = "";
        if (!CollectionUtils.isEmpty(stringList)) {
            int channelScopeHashCode = String.join((CharSequence)"#", stringList).hashCode();
            hashCodeStr = String.valueOf(channelScopeHashCode);
        }
        return hashCodeStr;
    }

    public static final boolean checkBeforeAudit(DynamicObject allotBill) {
        return AllotResultHandler.AllotResultInitCheck(AllotBillHandler.buildAllotResultVoList(allotBill));
    }

    public static final void audit(DynamicObject allotBill) {
        AllotResultHandler.initAllotResult(AllotBillHandler.buildAllotResultVoList(allotBill));
    }

    public static final List<AllotResultVO> buildAllotResultVoList(DynamicObject allotBill) {
        DynamicObjectCollection entries = allotBill.getDynamicObjectCollection("entryentity");
        ArrayList<AllotResultVO> allotResultVoList = new ArrayList<AllotResultVO>(entries.size() * 10);
        for (DynamicObject entry : entries) {
            DynamicObjectCollection subEntries = entry.getDynamicObjectCollection("subentryentity");
            for (DynamicObject subEntry : subEntries) {
                AllotResultVO vo = new AllotResultVO();
                vo.setEntity("ococic_allotbill");
                vo.setBillId(allotBill.getLong("id"));
                vo.setBillNo(allotBill.getString("billno"));
                vo.setEntryId(entry.getLong("id"));
                vo.setSubEntryId(subEntry.getLong("id"));
                vo.setInvalidBeginTime(allotBill.getDate("invalidbegintime"));
                vo.setInvalidEndTime(allotBill.getDate("invalidendtime"));
                vo.setUpdateType(UpdateType.parse((String)allotBill.getString("updatetype")));
                vo.setChannelId(DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)subEntry, (String)"channel"));
                vo.setcKey(entry.getString("ckey"));
                vo.setItemId(DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)entry, (String)"item"));
                vo.setMaterialId(DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)entry, (String)"material"));
                vo.setAuxptyId(DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)entry, (String)"auxpty"));
                vo.setStockOrgId(DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)entry, (String)"stockorg"));
                vo.setWarehouseId(DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)entry, (String)"warehouse"));
                vo.setBaseUnitId(DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)entry, (String)"baseunit"));
                vo.setAllotType(entry.getString("allottype"));
                vo.setBaseQty(entry.getBigDecimal("baseqty"));
                allotResultVoList.add(vo);
            }
        }
        return allotResultVoList;
    }
}

