/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ococic.business.allotbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.common.enums.ControlType;
import kd.occ.ocbase.common.util.CustomerParamsUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.StringUtils;
import kd.occ.ocbase.common.util.UserUtil;
import kd.occ.ococic.business.allotbill.AllotBillHandler;
import kd.occ.ococic.business.allotbill.AllotResultLogHandler;
import kd.occ.ococic.business.allotbill.AllotResultQtyHandler;
import kd.occ.ococic.business.allotbill.AllotResultWBHandler;
import kd.occ.ococic.pojo.AllotResultQueryParamVO;
import kd.occ.ococic.pojo.AllotResultQueryResultVO;
import kd.occ.ococic.pojo.AllotResultRRParamVO;
import kd.occ.ococic.pojo.AllotResultRRSubParamVO;
import kd.occ.ococic.pojo.AllotResultVO;

public class AllotResultHandler {
    private static String FAVBBBASEQTY = String.join((CharSequence)".", "resultqty", "avbbbaseqty");
    private static String FBASEQTY = String.join((CharSequence)".", "resultqty", "baseqty");
    private static String FRESERVEBASEQTY = String.join((CharSequence)".", "resultqty", "reservebaseqty");

    public static final void releaseAllotResult(AllotResultRRParamVO param) {
        long opUserId = (Long)UserUtil.getUserID();
        Date opTime = new Date();
        int batchSize = param.getSubParamList().size();
        Map<String, DynamicObject> allotResultWBMap = AllotResultWBHandler.loadAllotResultWB(param.getBillEntity(), param.getBillId());
        Set<Long> resultIdSet = allotResultWBMap.values().stream().flatMap(r -> r.getDynamicObjectCollection("entryentity").stream()).map(r -> r.getLong("allotresultid")).collect(Collectors.toSet());
        Map<Long, DynamicObject> reserveAllotResultMap = AllotResultHandler.loadAllotResultForId(resultIdSet);
        Set<Long> allotResultQtyIdSet = reserveAllotResultMap.values().stream().map(r -> DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)r, (String)"resultqty")).collect(Collectors.toSet());
        Map<Long, DynamicObject> reserveAllotResultQtyMap = AllotResultQtyHandler.loadAllotResultQty(allotResultQtyIdSet);
        ArrayList<DynamicObject> allotResultLogList = new ArrayList<DynamicObject>(batchSize);
        ControlType controlType = CustomerParamsUtil.getAllotControlType((Object)param.getSaleOrgId());
        param.setAllotControlType(controlType.toString());
        for (AllotResultRRSubParamVO subParam : param.getSubParamList()) {
            String key = AllotResultWBHandler.getAllotResultWBKey(param.getBillEntity(), param.getBillId(), subParam.getEntryId(), subParam.getSubEntryId());
            DynamicObject allotResultWB = allotResultWBMap.get(key);
            if (allotResultWB == null) {
                subParam.setSuccess(false);
                subParam.setErrorMessage(ResManager.loadKDString((String)"\u53ef\u9500\u91cf\u64a4\u9500\u5360\u7528\u5931\u8d25:\u5339\u914d\u4e0d\u5230\u53ef\u9500\u91cf\u5360\u7528\u8bb0\u5f55\u3002", (String)"AllotResultHandler_0", (String)"occ-ococic-business", (Object[])new Object[0]));
                continue;
            }
            BigDecimal sumReserveBaseQty = allotResultWB.getBigDecimal("sumreservebaseqty");
            BigDecimal releaseBaseQty = subParam.getBaseQty();
            if (sumReserveBaseQty.compareTo(subParam.getBaseQty()) < 0) {
                subParam.setSuccess(false);
                subParam.setErrorMessage(ResManager.loadKDString((String)"\u53ef\u9500\u91cf\u64a4\u9500\u5360\u7528\u5931\u8d25:\u8bf7\u6c42\u6570\u91cf\u8d85\u51fa\u5df2\u5360\u7528\u91cf\u3002", (String)"AllotResultHandler_1", (String)"occ-ococic-business", (Object[])new Object[0]));
                continue;
            }
            DynamicObjectCollection wbEntries = allotResultWB.getDynamicObjectCollection("entryentity");
            for (DynamicObject wbEntry : wbEntries) {
                BigDecimal cReleaseBaseQty;
                if (releaseBaseQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                BigDecimal reserveBaseQty = wbEntry.getBigDecimal("reservebaseqty");
                if (releaseBaseQty.compareTo(reserveBaseQty) <= 0) {
                    cReleaseBaseQty = releaseBaseQty;
                    releaseBaseQty = AllotResultHandler.release(allotResultLogList, reserveAllotResultMap, reserveAllotResultQtyMap, wbEntry, param, subParam, cReleaseBaseQty, releaseBaseQty, opUserId, opTime);
                    continue;
                }
                cReleaseBaseQty = reserveBaseQty;
                releaseBaseQty = AllotResultHandler.release(allotResultLogList, reserveAllotResultMap, reserveAllotResultQtyMap, wbEntry, param, subParam, cReleaseBaseQty, releaseBaseQty, opUserId, opTime);
            }
        }
        AllotResultQtyHandler.saveAllotResultQty(reserveAllotResultQtyMap.values());
        AllotResultHandler.saveAllotResult(reserveAllotResultMap.values());
        AllotResultLogHandler.saveAllotResultLog(allotResultLogList);
        AllotResultWBHandler.saveAllotResultWB(allotResultWBMap.values());
    }

    private static BigDecimal release(List<DynamicObject> allotResultLogList, Map<Long, DynamicObject> reserveAllotResultMap, Map<Long, DynamicObject> reserveAllotResultQtyMap, DynamicObject wbEntry, AllotResultRRParamVO param, AllotResultRRSubParamVO subParam, BigDecimal cReleaseBaseQty, BigDecimal releaseBaseQty, long opUserId, Date opTime) {
        BigDecimal reserveBaseQty = wbEntry.getBigDecimal("reservebaseqty");
        long allotResultId = wbEntry.getLong("allotresultid");
        wbEntry.set("reservebaseqty", (Object)reserveBaseQty.subtract(cReleaseBaseQty));
        DynamicObject allotResult = reserveAllotResultMap.get(allotResultId);
        allotResult.set("reservebaseqty", (Object)allotResult.getBigDecimal("reservebaseqty").subtract(cReleaseBaseQty));
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)allotResult, (String)"modifier", (long)opUserId);
        allotResult.set("modifytime", (Object)opTime);
        long allotResultQtyId = DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)allotResult, (String)"resultqty");
        DynamicObject allotResultQty = reserveAllotResultQtyMap.get(allotResultQtyId);
        allotResultQty.set("reservebaseqty", (Object)allotResultQty.getBigDecimal("reservebaseqty").subtract(cReleaseBaseQty));
        allotResultQty.set("avbbbaseqty", (Object)allotResultQty.getBigDecimal("baseqty").subtract(allotResultQty.getBigDecimal("reservebaseqty")));
        allotResultLogList.add(AllotResultLogHandler.buildAllotResultReleaseLog(param, subParam, allotResult, reserveBaseQty, opUserId, opTime));
        releaseBaseQty = releaseBaseQty.subtract(cReleaseBaseQty);
        return releaseBaseQty;
    }

    public static final void reserveAllotResult(AllotResultRRParamVO param) {
        long opUserId = (Long)UserUtil.getUserID();
        Date opTime = new Date();
        int batchSize = param.getSubParamList().size();
        ArrayList<DynamicObject> allotResultLogList = new ArrayList<DynamicObject>(batchSize);
        Map<String, DynamicObject> allotResultWBMap = AllotResultWBHandler.loadAllotResultWB(param.getBillEntity(), param.getBillId());
        HashSet<String> resultCodeSet = new HashSet<String>(batchSize);
        for (AllotResultRRSubParamVO subParam : param.getSubParamList()) {
            resultCodeSet.add(AllotResultHandler.getAllotReusltCode(param.getChannelId(), subParam.getItemId(), subParam.getAuxptyId(), subParam.getStockOrgId(), subParam.getWarehouseId(), subParam.getBaseUnitId()));
        }
        Map<String, List<DynamicObject>> groupResultMap = AllotResultHandler.loadAllotResultForCode(param.getRequestTime(), resultCodeSet);
        Set<Long> allotResultQtyIdSet = groupResultMap.values().stream().flatMap(r -> r.stream()).map(r -> DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)r, (String)"resultqty")).collect(Collectors.toSet());
        Map<Long, DynamicObject> reserveAllotResultQtyMap = AllotResultQtyHandler.loadAllotResultQty(allotResultQtyIdSet);
        ControlType controlType = CustomerParamsUtil.getAllotControlType((Object)param.getSaleOrgId());
        param.setAllotControlType(controlType.toString());
        for (AllotResultRRSubParamVO subParam : param.getSubParamList()) {
            if (!subParam.isSuccess()) continue;
            BigDecimal sRequestBaseQty = subParam.getBaseQty();
            if (BigDecimal.ZERO.compareTo(sRequestBaseQty) < 0) {
                BigDecimal sumAvbbBaseQty;
                String resultCode;
                List<DynamicObject> resultList;
                String allotResultWBKey = AllotResultWBHandler.getAllotResultWBKey(param.getBillEntity(), param.getBillId(), subParam.getEntryId(), subParam.getSubEntryId());
                DynamicObject allotResultWB = allotResultWBMap.get(allotResultWBKey);
                if (allotResultWB != null && BigDecimal.ZERO.compareTo(allotResultWB.getBigDecimal("sumreservebaseqty")) < 0) {
                    subParam.setSuccess(false);
                    subParam.setErrorMessage(ResManager.loadKDString((String)"\u53ef\u9500\u91cf\u5360\u7528\u5931\u8d25:\u5df2\u5b58\u5728\u53ef\u9500\u91cf\u5360\u7528\u8bb0\u5f55\u3002", (String)"AllotResultHandler_2", (String)"occ-ococic-business", (Object[])new Object[0]));
                    continue;
                }
                if (allotResultWB == null) {
                    allotResultWB = AllotResultWBHandler.newAllotResutWB(param.getBillEntity(), param.getBillId(), subParam.getEntryId(), subParam.getSubEntryId());
                    allotResultWBMap.put(allotResultWBKey, allotResultWB);
                }
                if ((resultList = groupResultMap.get(resultCode = AllotResultHandler.getAllotReusltCode(param.getChannelId(), subParam.getItemId(), subParam.getAuxptyId(), subParam.getStockOrgId(), subParam.getWarehouseId(), subParam.getBaseUnitId()))) == null) {
                    subParam.setSuccess(false);
                    subParam.setErrorMessage(ResManager.loadKDString((String)"\u53ef\u9500\u91cf\u5360\u7528\u5931\u8d25:\u65e0\u5339\u914d\u7684\u53ef\u9500\u91cf\u5206\u914d\u7ed3\u679c\u8bb0\u5f55\u3002", (String)"AllotResultHandler_3", (String)"occ-ococic-business", (Object[])new Object[0]));
                    continue;
                }
                if (ControlType.STRONG_CONTROL == controlType && sRequestBaseQty.compareTo(sumAvbbBaseQty = resultList.stream().map(r -> {
                    DynamicObject allotResultQty = (DynamicObject)reserveAllotResultQtyMap.get(DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)r, (String)"resultqty"));
                    BigDecimal avbbBaseQty = allotResultQty != null ? allotResultQty.getBigDecimal("avbbbaseqty") : BigDecimal.ZERO;
                    return avbbBaseQty.compareTo(BigDecimal.ZERO) > 0 ? avbbBaseQty : BigDecimal.ZERO;
                }).reduce(BigDecimal.ZERO, BigDecimal::add)) > 0) {
                    subParam.setSuccess(false);
                    subParam.setErrorMessage(ResManager.loadKDString((String)"\u53ef\u9500\u91cf\u5360\u7528\u5931\u8d25:\u53ef\u9500\u91cf\u65e0\u6cd5\u6ee1\u8db3\u6b64\u6b21\u7533\u8bf7\u3002", (String)"AllotResultHandler_4", (String)"occ-ococic-business", (Object[])new Object[0]));
                    continue;
                }
                AllotResultHandler.sortQueryResult(resultList);
                BigDecimal tRequestBaseQty = sRequestBaseQty;
                int resultListSize = resultList.size();
                for (int i = 0; i < resultListSize; ++i) {
                    if (tRequestBaseQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                    DynamicObject allotResult = resultList.get(i);
                    DynamicObject allotResultQty = reserveAllotResultQtyMap.get(DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)allotResult, (String)"resultqty"));
                    boolean isLast = i == resultListSize - 1;
                    tRequestBaseQty = AllotResultHandler.reserve(param, subParam, allotResult, allotResultQty, allotResultWB, allotResultLogList, tRequestBaseQty, opUserId, opTime, isLast);
                }
                continue;
            }
            subParam.setSuccess(false);
            subParam.setErrorMessage(ResManager.loadKDString((String)"\u53ef\u9500\u91cf\u5360\u7528\u5931\u8d25:\u8bf7\u6c42\u6570\u91cf\u4e3a\u96f6\u6216\u8d1f\u6570\u3002", (String)"AllotResultHandler_5", (String)"occ-ococic-business", (Object[])new Object[0]));
        }
        boolean isStrongControlFalse = false;
        if (ControlType.STRONG_CONTROL == controlType) {
            for (AllotResultRRSubParamVO subParam : param.getSubParamList()) {
                if (subParam.isSuccess()) continue;
                isStrongControlFalse = true;
                break;
            }
        }
        if (isStrongControlFalse) {
            for (AllotResultRRSubParamVO subParam : param.getSubParamList()) {
                subParam.setSuccess(false);
            }
        } else {
            AllotResultQtyHandler.saveAllotResultQty(reserveAllotResultQtyMap.values());
            AllotResultHandler.saveAllotResult(groupResultMap.values().stream().flatMap(r -> r.stream()).collect(Collectors.toList()));
            AllotResultLogHandler.saveAllotResultLog(allotResultLogList);
            AllotResultWBHandler.saveAllotResultWB(allotResultWBMap.values());
        }
    }

    private static BigDecimal reserve(AllotResultRRParamVO param, AllotResultRRSubParamVO subParam, DynamicObject allotResult, DynamicObject allotResultQty, DynamicObject allotResultWB, List<DynamicObject> allotResultLogList, BigDecimal tRequestBaseQty, long opUserId, Date opTime, boolean isLast) {
        BigDecimal fAvbbBaseQty = allotResultQty.getBigDecimal("avbbbaseqty");
        BigDecimal cRequestBaseQty = null;
        if (isLast) {
            cRequestBaseQty = tRequestBaseQty;
        } else {
            if (fAvbbBaseQty.compareTo(BigDecimal.ZERO) <= 0) {
                return tRequestBaseQty;
            }
            cRequestBaseQty = fAvbbBaseQty.compareTo(tRequestBaseQty) >= 0 ? tRequestBaseQty : fAvbbBaseQty;
        }
        BigDecimal reserveBaseQty = allotResult.getBigDecimal("reservebaseqty");
        BigDecimal fBaseQty = allotResultQty.getBigDecimal("baseqty");
        BigDecimal fReserveBaseQty = allotResultQty.getBigDecimal("reservebaseqty");
        BigDecimal[] reserveCaculatereQtyArray = AllotResultHandler.reserveCalucate(cRequestBaseQty, tRequestBaseQty, reserveBaseQty, fBaseQty, fReserveBaseQty, fAvbbBaseQty);
        allotResult.set("reservebaseqty", (Object)reserveCaculatereQtyArray[2]);
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)allotResult, (String)"modifier", (long)opUserId);
        allotResult.set("modifytime", (Object)opTime);
        allotResultQty.set("baseqty", (Object)reserveCaculatereQtyArray[3]);
        allotResultQty.set("reservebaseqty", (Object)reserveCaculatereQtyArray[4]);
        allotResultQty.set("avbbbaseqty", (Object)reserveCaculatereQtyArray[5]);
        allotResultLogList.add(AllotResultLogHandler.buildAllotResultReserveLog(param, subParam, allotResult, reserveCaculatereQtyArray[0], opUserId, opTime));
        AllotResultWBHandler.reserveAllotResutWB(allotResultWB, allotResult.getLong("id"), reserveCaculatereQtyArray[0]);
        return reserveCaculatereQtyArray[1];
    }

    private static BigDecimal[] reserveCalucate(BigDecimal cRequestBaseQty, BigDecimal tRequestBaseQty, BigDecimal reserveBaseQty, BigDecimal fBaseQty, BigDecimal fReserveBaseQty, BigDecimal fAvbbBaseQty) {
        reserveBaseQty = reserveBaseQty.add(cRequestBaseQty);
        fReserveBaseQty = fReserveBaseQty.add(cRequestBaseQty);
        fAvbbBaseQty = fBaseQty.subtract(fReserveBaseQty);
        tRequestBaseQty = tRequestBaseQty.subtract(cRequestBaseQty);
        return new BigDecimal[]{cRequestBaseQty, tRequestBaseQty, reserveBaseQty, fBaseQty, fReserveBaseQty, fAvbbBaseQty};
    }

    private static void sortQueryResult(List<DynamicObject> resultList) {
        Comparator<DynamicObject> comparatorByAllotType = Comparator.comparing(r -> r.getString("allottype"));
        Comparator<DynamicObject> comparatorByInvalidEndTime = Comparator.comparing(r -> r.getDate("invalidendtime"));
        resultList.sort(comparatorByAllotType.reversed().thenComparing(comparatorByInvalidEndTime));
    }

    public static final List<AllotResultQueryResultVO> queryAllotResult(List<AllotResultQueryParamVO> paramList) {
        if (!CollectionUtils.isEmpty(paramList)) {
            ArrayList<AllotResultQueryResultVO> resultVOList = new ArrayList<AllotResultQueryResultVO>(paramList.size());
            Map groupParamMap = paramList.stream().collect(Collectors.groupingBy(r -> r.getRequestTime(), Collectors.mapping(r -> AllotResultHandler.getAllotReusltCode(r), Collectors.toSet())));
            for (Map.Entry groupParamEntry : groupParamMap.entrySet()) {
                resultVOList.addAll(AllotResultHandler.queryAllotResult(groupParamEntry.getKey(), groupParamEntry.getValue()));
            }
            return AllotResultHandler.getResultMatchForParam(paramList, resultVOList);
        }
        return new ArrayList<AllotResultQueryResultVO>(0);
    }

    private static List<AllotResultQueryResultVO> getResultMatchForParam(List<AllotResultQueryParamVO> paramList, List<AllotResultQueryResultVO> resultVOList) {
        ArrayList<AllotResultQueryResultVO> resultList = new ArrayList<AllotResultQueryResultVO>(paramList.size());
        Map<String, List<AllotResultQueryResultVO>> groupResultVOMap = resultVOList.stream().collect(Collectors.groupingBy(r -> StringUtils.join((CharSequence)"#", (Object[])new Object[]{r.getChannelId(), r.getItemId(), r.getAuxptyId(), r.getStockOrgId(), r.getWarehouseId(), r.getRequestTime().getTime()})));
        for (AllotResultQueryParamVO param : paramList) {
            String key = StringUtils.join((CharSequence)"#", (Object[])new Object[]{param.getChannelId(), param.getItemId(), param.getAuxptyId(), param.getStockOrgId(), param.getWarehouseId(), param.getRequestTime().getTime()});
            List<AllotResultQueryResultVO> groupResultVOList = groupResultVOMap.get(key);
            if (CollectionUtils.isEmpty(groupResultVOList)) {
                resultList.add(new AllotResultQueryResultVO(param));
                continue;
            }
            for (AllotResultQueryResultVO groupResultVO : groupResultVOList) {
                groupResultVO.setCustomaryKey(param.getCustomaryKey());
                resultList.add(groupResultVO);
            }
        }
        return resultList;
    }

    private static DynamicObjectCollection queryAllotResultDynamicObjectCollection(Date requestTime, Set<String> resultCodeSet) {
        QFilter[] filters = new QFilter[]{new QFilter("invalidbegintime", "<=", (Object)requestTime), new QFilter("invalidendtime", ">", (Object)requestTime), new QFilter("resultcode", "in", resultCodeSet)};
        String selectFields = String.join((CharSequence)",", "id", "invalidendtime", "resultcode", "channel", "item", "material", "auxpty", "stockorg", "warehouse", "baseunit", "allottype", "reservebaseqty", "resultqty", FAVBBBASEQTY, FBASEQTY, FRESERVEBASEQTY);
        return QueryServiceHelper.query((String)"ococic_allotresult", (String)selectFields, (QFilter[])filters);
    }

    private static List<AllotResultQueryResultVO> queryAllotResult(Date requestTime, Set<String> resultCodeSet) {
        DynamicObjectCollection results = AllotResultHandler.queryAllotResultDynamicObjectCollection(requestTime, resultCodeSet);
        Map<String, List<DynamicObject>> groupResultMap = results.stream().collect(Collectors.groupingBy(r -> r.getString("resultcode")));
        ArrayList<AllotResultQueryResultVO> resultVOList = new ArrayList<AllotResultQueryResultVO>(groupResultMap.size());
        for (List<DynamicObject> groupResultList : groupResultMap.values()) {
            AllotResultQueryResultVO vo = null;
            for (DynamicObject groupResult : groupResultList) {
                if (vo == null) {
                    vo = new AllotResultQueryResultVO(requestTime, groupResult.getLong("channel"), groupResult.getLong("item"), groupResult.getLong("auxpty"), groupResult.getLong("stockorg"), groupResult.getLong("warehouse"), groupResult.getLong("baseunit"), BigDecimal.ZERO);
                }
                vo.setAvbbBaseQty(vo.getAvbbBaseQty().add(groupResult.getBigDecimal(FAVBBBASEQTY)));
            }
            resultVOList.add(vo);
        }
        return resultVOList;
    }

    private static Map<String, DynamicObject> queryAllotResult(Set<String> resultKeySet) {
        QFilter[] filters = new QFilter[]{new QFilter("resultkey", "in", resultKeySet)};
        String selectFields = String.join((CharSequence)",", "id", "resultqty", "resultkey", FAVBBBASEQTY, FBASEQTY, FRESERVEBASEQTY);
        DynamicObjectCollection results = QueryServiceHelper.query((String)"ococic_allotresult", (String)selectFields, (QFilter[])filters);
        return results.stream().collect(Collectors.toMap(r -> r.getString("resultkey"), r -> r));
    }

    public static final boolean AllotResultInitCheck(List<AllotResultVO> allotResultVoList) {
        if (!CollectionUtils.isEmpty(allotResultVoList)) {
            Map<String, AllotResultVO> allotResultKey2VoMap = allotResultVoList.stream().collect(Collectors.toMap(r -> AllotResultHandler.getAllotResultKey(r), r -> r, (a, b) -> a));
            Map<String, DynamicObject> qAllotRusultMap = AllotResultHandler.queryAllotResult(allotResultKey2VoMap.keySet());
            for (Map.Entry<String, AllotResultVO> allotResultKey2VoEntry : allotResultKey2VoMap.entrySet()) {
                AllotResultVO vo = allotResultKey2VoEntry.getValue();
                DynamicObject qAllotResult = qAllotRusultMap.get(allotResultKey2VoEntry.getKey());
                if (qAllotResult == null) continue;
                switch (vo.getUpdateType()) {
                    case QTY_ADD: {
                        if (qAllotResult.getBigDecimal(FBASEQTY).add(vo.getBaseQty()).compareTo(qAllotResult.getBigDecimal(FRESERVEBASEQTY)) >= 0) break;
                        return false;
                    }
                    case QTY_UPDATE: {
                        if (vo.getBaseQty().compareTo(qAllotResult.getBigDecimal(FRESERVEBASEQTY)) >= 0) break;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public static final void initAllotResult(List<AllotResultVO> allotResultVoList) {
        if (!CollectionUtils.isEmpty(allotResultVoList)) {
            int batchSize = allotResultVoList.size();
            long opUserId = (Long)UserUtil.getUserID();
            Date opTime = new Date();
            Map<String, AllotResultVO> allotResultKey2VoMap = allotResultVoList.stream().collect(Collectors.toMap(r -> AllotResultHandler.getAllotResultKey(r), r -> r, (a, b) -> a));
            Map<String, DynamicObject> allotRusultMap = AllotResultHandler.loadAllotResultForKey(allotResultKey2VoMap.keySet());
            ArrayList<AllotResultVO> addNewAllotResultVoList = new ArrayList<AllotResultVO>(batchSize);
            ArrayList<DynamicObject> updateAllotResultList = new ArrayList<DynamicObject>(batchSize);
            for (Map.Entry<String, AllotResultVO> allotResultKey2VoEntry : allotResultKey2VoMap.entrySet()) {
                AllotResultVO vo = allotResultKey2VoEntry.getValue();
                DynamicObject result = allotRusultMap.get(allotResultKey2VoEntry.getKey());
                if (result == null) {
                    addNewAllotResultVoList.add(vo);
                    continue;
                }
                updateAllotResultList.add(result);
            }
            List<DynamicObject> addNewLogList = AllotResultHandler.addnewAllotResult(addNewAllotResultVoList, opUserId, opTime);
            List<DynamicObject> updateLogList = AllotResultHandler.updateAllotResult(updateAllotResultList, allotResultKey2VoMap, opUserId, opTime);
            AllotResultLogHandler.saveAllotResultLog(Stream.concat(addNewLogList.stream(), updateLogList.stream()).collect(Collectors.toList()));
        }
    }

    private static List<DynamicObject> addnewAllotResult(List<AllotResultVO> allotResultVoList, long opUserId, Date opTime) {
        if (!CollectionUtils.isEmpty(allotResultVoList)) {
            int batchSize = allotResultVoList.size();
            HashMap<String, DynamicObject> allotResultQtyKey2QtyMap = new HashMap<String, DynamicObject>(batchSize);
            HashMap<String, DynamicObject> allotResultKey2ResultMap = new HashMap<String, DynamicObject>(batchSize);
            for (AllotResultVO vo : allotResultVoList) {
                DynamicObject allotResult = AllotResultHandler.buildNewAllotResult(allotResultQtyKey2QtyMap, vo, opUserId, opTime);
                allotResultKey2ResultMap.put(allotResult.getString("resultkey"), allotResult);
            }
            SaveServiceHelper.save((DynamicObject[])((DynamicObject[])allotResultQtyKey2QtyMap.values().stream().toArray(DynamicObject[]::new)));
            SaveServiceHelper.save((DynamicObject[])((DynamicObject[])allotResultKey2ResultMap.values().stream().toArray(DynamicObject[]::new)));
            ArrayList<DynamicObject> allotResultLogList = new ArrayList<DynamicObject>(batchSize);
            for (AllotResultVO vo : allotResultVoList) {
                String allotResultKey = AllotResultHandler.getAllotResultKey(vo);
                DynamicObject allotResult = (DynamicObject)allotResultKey2ResultMap.get(allotResultKey);
                allotResultLogList.add(AllotResultLogHandler.buildAllotResultLog(vo, allotResult.getLong("id"), opUserId, opTime));
            }
            return allotResultLogList;
        }
        return new ArrayList<DynamicObject>(0);
    }

    private static List<DynamicObject> updateAllotResult(List<DynamicObject> allotResultList, Map<String, AllotResultVO> allotResultKey2VoMap, long opUserId, Date opTime) {
        if (!CollectionUtils.isEmpty(allotResultList)) {
            int batchSize = allotResultList.size();
            HashMap<Long, DynamicObject> allotResultQtyMap = new HashMap<Long, DynamicObject>(batchSize);
            ArrayList<DynamicObject> allotResultLogList = new ArrayList<DynamicObject>(batchSize);
            for (DynamicObject allotResult : allotResultList) {
                AllotResultVO vo = allotResultKey2VoMap.get(allotResult.getString("resultkey"));
                long allotResultQtyId = DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)allotResult, (String)"resultqty");
                DynamicObject allotResultQty = (DynamicObject)allotResultQtyMap.get(allotResultQtyId);
                if (allotResultQty == null) {
                    allotResultQty = BusinessDataServiceHelper.loadSingle((Object)allotResultQtyId, (String)"ococic_allotresultqty");
                    BigDecimal reserveBaseQty = allotResultQty.getBigDecimal("reservebaseqty");
                    BigDecimal baseQty = allotResultQty.getBigDecimal("baseqty");
                    switch (vo.getUpdateType()) {
                        case QTY_ADD: {
                            baseQty = baseQty.add(vo.getBaseQty());
                            break;
                        }
                        case QTY_UPDATE: {
                            baseQty = vo.getBaseQty();
                        }
                    }
                    allotResultQty.set("baseqty", (Object)baseQty);
                    allotResultQty.set("avbbbaseqty", (Object)baseQty.subtract(reserveBaseQty));
                    allotResultQtyMap.put(allotResultQty.getLong("id"), allotResultQty);
                }
                DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)allotResult, (String)"modifier", (long)opUserId);
                allotResult.set("modifytime", (Object)opTime);
                DynamicObject allotResultLog = AllotResultLogHandler.buildAllotResultLog(vo, allotResult.getLong("id"), opUserId, opTime);
                allotResultLogList.add(allotResultLog);
            }
            SaveServiceHelper.save((DynamicObject[])((DynamicObject[])allotResultQtyMap.values().stream().toArray(DynamicObject[]::new)));
            SaveServiceHelper.save((DynamicObject[])((DynamicObject[])allotResultList.stream().toArray(DynamicObject[]::new)));
            return allotResultLogList;
        }
        return new ArrayList<DynamicObject>(0);
    }

    private static DynamicObject[] loadAllotResult(QFilter[] qFilterArray) {
        String selectProperties = String.join((CharSequence)",", "id", "channel", "item", "material", "auxpty", "stockorg", "warehouse", "baseunit", "resultqty", "reservebaseqty", "allottype", "invalidendtime", "modifier", "modifytime", "resultcode", "resultkey");
        return BusinessDataServiceHelper.load((String)"ococic_allotresult", (String)selectProperties, (QFilter[])qFilterArray);
    }

    private static Map<Long, DynamicObject> loadAllotResultForId(Set<Long> resultIdSet) {
        QFilter qFilter;
        DynamicObject[] allotResults;
        HashMap allotResultMap = new HashMap(0);
        if (!CollectionUtils.isEmpty(resultIdSet) && (allotResults = AllotResultHandler.loadAllotResult((qFilter = new QFilter("id", "in", resultIdSet)).toArray())) != null && allotResults.length > 0) {
            allotResultMap = (HashMap)Arrays.asList(allotResults).stream().collect(Collectors.toMap(r -> r.getLong("id"), r -> r));
        }
        return allotResultMap;
    }

    private static Map<String, List<DynamicObject>> loadAllotResultForCode(Date requestDate, Set<String> resultCodeSet) {
        QFilter[] qFilterArray;
        DynamicObject[] allotResults;
        HashMap allotResultMap = new HashMap(0);
        if (!CollectionUtils.isEmpty(resultCodeSet) && (allotResults = AllotResultHandler.loadAllotResult(qFilterArray = new QFilter[]{new QFilter("invalidbegintime", "<=", (Object)requestDate), new QFilter("invalidendtime", ">=", (Object)requestDate), new QFilter("resultcode", "in", resultCodeSet)})) != null && allotResults.length > 0) {
            allotResultMap = (HashMap)Arrays.asList(allotResults).stream().collect(Collectors.groupingBy(r -> r.getString("resultcode")));
        }
        return allotResultMap;
    }

    private static Map<String, DynamicObject> loadAllotResultForKey(Set<String> resultKeySet) {
        QFilter qFilter;
        DynamicObject[] allotResults;
        HashMap allotResultMap = new HashMap(0);
        if (!CollectionUtils.isEmpty(resultKeySet) && (allotResults = AllotResultHandler.loadAllotResult((qFilter = new QFilter("resultkey", "in", resultKeySet)).toArray())) != null && allotResults.length > 0) {
            allotResultMap = (HashMap)Arrays.asList(allotResults).stream().collect(Collectors.toMap(r -> r.getString("resultkey"), r -> r));
        }
        return allotResultMap;
    }

    private static DynamicObject buildNewAllotResult(Map<String, DynamicObject> allotResultQtyKey2QtyMap, AllotResultVO vo, long opUserId, Date opTime) {
        DynamicObject allotResult = AllotResultHandler.buildNewAllotResult(vo.getInvalidBeginTime(), vo.getInvalidEndTime(), vo.getcKey(), vo.getAllotType(), vo.getChannelId(), vo.getItemId(), vo.getMaterialId(), vo.getAuxptyId(), vo.getStockOrgId(), vo.getWarehouseId(), vo.getBaseUnitId(), opUserId, opTime);
        DynamicObject allotResultQty = allotResultQtyKey2QtyMap.get(allotResult.getString("resultqtykey"));
        if (allotResultQty == null) {
            allotResultQty = AllotResultQtyHandler.buildAddnewAllotResultQtyList(vo);
            allotResultQtyKey2QtyMap.put(allotResult.getString("resultqtykey"), allotResultQty);
        }
        allotResult.set("resultqty", (Object)allotResultQty);
        return allotResult;
    }

    private static DynamicObject buildNewAllotResult(Date bTime, Date eTime, String cKey, String allotType, long channelId, long itemId, long materialId, long auxptyId, long stockOrgId, long warehouseId, long baseUnitId, long opUserId, Date opTime) {
        DynamicObject allotResult = BusinessDataServiceHelper.newDynamicObject((String)"ococic_allotresult");
        allotResult.set("invalidbegintime", (Object)bTime);
        allotResult.set("invalidendtime", (Object)eTime);
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)allotResult, (String)"channel", (long)channelId);
        allotResult.set("ckey", (Object)cKey);
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)allotResult, (String)"item", (long)itemId);
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)allotResult, (String)"material", (long)materialId);
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)allotResult, (String)"auxpty", (long)auxptyId);
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)allotResult, (String)"stockorg", (long)stockOrgId);
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)allotResult, (String)"warehouse", (long)warehouseId);
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)allotResult, (String)"baseunit", (long)baseUnitId);
        allotResult.set("reservebaseqty", (Object)BigDecimal.ZERO);
        allotResult.set("resultkey", (Object)AllotResultHandler.getAllotResultKey(bTime, eTime, cKey, channelId, itemId, materialId, auxptyId, stockOrgId, warehouseId, baseUnitId));
        allotResult.set("resultqtykey", (Object)AllotResultQtyHandler.getAllotReusltQtyKey(bTime, eTime, cKey, itemId, materialId, auxptyId, stockOrgId, warehouseId, baseUnitId));
        allotResult.set("resultcode", (Object)AllotResultHandler.getAllotReusltCode(channelId, itemId, auxptyId, stockOrgId, warehouseId, baseUnitId));
        allotResult.set("allottype", (Object)allotType);
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)allotResult, (String)"creator", (long)opUserId);
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)allotResult, (String)"modifier", (long)opUserId);
        allotResult.set("createtime", (Object)opTime);
        allotResult.set("modifytime", (Object)opTime);
        return allotResult;
    }

    private static String getAllotResultKey(AllotResultVO vo) {
        return AllotResultHandler.getAllotResultKey(vo.getInvalidBeginTime(), vo.getInvalidEndTime(), vo.getcKey(), vo.getChannelId(), vo.getItemId(), vo.getMaterialId(), vo.getAuxptyId(), vo.getStockOrgId(), vo.getWarehouseId(), vo.getBaseUnitId());
    }

    private static String getAllotResultKey(Date bTime, Date eTime, String cKey, long channelId, long itemId, long materialId, long auxptyId, long stockOrgId, long warehouseId, long baseUnitId) {
        ArrayList<String> keyStringList = new ArrayList<String>(10);
        keyStringList.add(bTime == null ? "" : String.valueOf(bTime.getTime()));
        keyStringList.add(eTime == null ? "" : String.valueOf(eTime.getTime()));
        keyStringList.add(cKey);
        keyStringList.add(String.valueOf(channelId));
        keyStringList.add(String.valueOf(itemId));
        keyStringList.add(String.valueOf(materialId));
        keyStringList.add(String.valueOf(auxptyId));
        keyStringList.add(String.valueOf(stockOrgId));
        keyStringList.add(String.valueOf(warehouseId));
        keyStringList.add(String.valueOf(baseUnitId));
        return AllotBillHandler.getHashCodeString(keyStringList);
    }

    private static String getAllotReusltCode(AllotResultQueryParamVO vo) {
        return AllotResultHandler.getAllotReusltCode(vo.getChannelId(), vo.getItemId(), vo.getAuxptyId(), vo.getStockOrgId(), vo.getWarehouseId(), vo.getBaseUnitId());
    }

    private static String getAllotReusltCode(long channelId, long itemId, long auxptyId, long stockOrgId, long warehouseId, long baseUnitId) {
        ArrayList<String> keyStringList = new ArrayList<String>(5);
        keyStringList.add(String.valueOf(channelId));
        keyStringList.add(String.valueOf(itemId));
        keyStringList.add(String.valueOf(baseUnitId));
        keyStringList.add(String.valueOf(auxptyId));
        keyStringList.add(String.valueOf(stockOrgId));
        keyStringList.add(String.valueOf(warehouseId));
        return AllotBillHandler.getHashCodeString(keyStringList);
    }

    public static final void saveAllotResult(Collection<DynamicObject> allotResultCol) {
        if (!CollectionUtils.isEmpty(allotResultCol)) {
            SaveServiceHelper.save((DynamicObject[])((DynamicObject[])allotResultCol.stream().toArray(DynamicObject[]::new)));
        }
    }
}

