/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ococic.business.allotbill;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.common.enums.allotbill.UpdateType;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ococic.pojo.AllotResultRRParamVO;
import kd.occ.ococic.pojo.AllotResultRRSubParamVO;
import kd.occ.ococic.pojo.AllotResultVO;

public class AllotResultLogHandler {
    public static final void saveAllotResultLog(Collection<DynamicObject> allotResultLogCol) {
        if (!CollectionUtils.isEmpty(allotResultLogCol)) {
            SaveServiceHelper.save((DynamicObject[])((DynamicObject[])allotResultLogCol.stream().toArray(DynamicObject[]::new)));
        }
    }

    public static final DynamicObject buildAllotResultLog(AllotResultVO vo, long allotResultId, long opUserId, Date opTime) {
        return AllotResultLogHandler.newAllotResultLog(vo.getChannelId(), vo.getItemId(), vo.getMaterialId(), vo.getAuxptyId(), vo.getStockOrgId(), vo.getWarehouseId(), vo.getBaseUnitId(), vo.getBaseQty(), vo.getUpdateType(), vo.getEntity(), vo.getBillNo(), vo.getBillId(), vo.getEntryId(), vo.getSubEntryId(), allotResultId, opUserId, opTime);
    }

    public static final DynamicObject buildAllotResultReleaseLog(AllotResultRRParamVO vo, AllotResultRRSubParamVO subVO, DynamicObject allotResult, BigDecimal reserveBaseQty, long opUserId, Date opTime) {
        return AllotResultLogHandler.buildAllotResultLog(vo, subVO, allotResult, UpdateType.RESERVEQTY_SUBTRACT, reserveBaseQty, opUserId, opTime);
    }

    public static final DynamicObject buildAllotResultReserveLog(AllotResultRRParamVO vo, AllotResultRRSubParamVO subVO, DynamicObject allotResult, BigDecimal reserveBaseQty, long opUserId, Date opTime) {
        return AllotResultLogHandler.buildAllotResultLog(vo, subVO, allotResult, UpdateType.RESERVEQTY_ADD, reserveBaseQty, opUserId, opTime);
    }

    private static final DynamicObject buildAllotResultLog(AllotResultRRParamVO vo, AllotResultRRSubParamVO subVO, DynamicObject allotResult, UpdateType updateType, BigDecimal reserveBaseQty, long opUserId, Date opTime) {
        return AllotResultLogHandler.newAllotResultLog(DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)allotResult, (String)"channel"), DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)allotResult, (String)"item"), DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)allotResult, (String)"material"), DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)allotResult, (String)"auxpty"), DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)allotResult, (String)"stockorg"), DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)allotResult, (String)"warehouse"), DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)allotResult, (String)"baseunit"), reserveBaseQty, updateType, vo.getBillEntity(), vo.getBillNo(), vo.getBillId(), subVO.getEntryId(), subVO.getSubEntryId(), allotResult.getLong("id"), opUserId, opTime);
    }

    private static final DynamicObject newAllotResultLog(long channelId, long itemId, long materialId, long auxptyId, long stockOrgId, long warehouseId, long baseUnitId, BigDecimal baseQty, UpdateType updateType, String entity, String billNo, long billId, long entryId, long subEntryId, long allotResultId, long opUserId, Date opTime) {
        DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"ococic_allotresultlog");
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)log, (String)"channel", (long)channelId);
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)log, (String)"item", (long)itemId);
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)log, (String)"material", (long)materialId);
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)log, (String)"auxpty", (long)auxptyId);
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)log, (String)"stockorg", (long)stockOrgId);
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)log, (String)"warehouse", (long)warehouseId);
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)log, (String)"baseunit", (long)baseUnitId);
        log.set("baseqty", (Object)baseQty);
        log.set("updatetype", (Object)updateType.toString());
        log.set("billentity", (Object)entity);
        log.set("billno", (Object)billNo);
        log.set("billid", (Object)billId);
        log.set("entryid", (Object)entryId);
        log.set("subentryid", (Object)subEntryId);
        log.set("allotresultid", (Object)allotResultId);
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)log, (String)"creator", (long)opUserId);
        log.set("createtime", (Object)opTime);
        return log;
    }
}

