/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ococic.business.allotbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class AllotResultWBHandler {
    public static final String getAllotResultWBKey(DynamicObject allotResultWB) {
        return AllotResultWBHandler.getAllotResultWBKey(allotResultWB.getString("billentity"), allotResultWB.getLong("billid"), allotResultWB.getLong("entryid"), allotResultWB.getLong("subentryid"));
    }

    public static final String getAllotResultWBKey(String billEntity, long billId, long entryId, long subEntryId) {
        return String.join((CharSequence)"#", billEntity, String.valueOf(billId), String.valueOf(entryId), String.valueOf(subEntryId));
    }

    public static final void saveAllotResultWB(Collection<DynamicObject> allotResultWBCol) {
        if (!CollectionUtils.isEmpty(allotResultWBCol)) {
            int batchSize = allotResultWBCol.size();
            ArrayList<DynamicObject> newAllotResultWBList = new ArrayList<DynamicObject>(batchSize);
            ArrayList<DynamicObject> updateAllotResultWBList = new ArrayList<DynamicObject>(batchSize);
            ArrayList<DynamicObject> deleteAllotResultWBList = new ArrayList<DynamicObject>(batchSize);
            for (DynamicObject allotResultWB : allotResultWBCol) {
                if (allotResultWB.getPkValue() == null) {
                    newAllotResultWBList.add(allotResultWB);
                    continue;
                }
                DynamicObjectCollection wbEntries = allotResultWB.getDynamicObjectCollection("entryentity");
                ArrayList<DynamicObject> deleteWBEntryList = new ArrayList<DynamicObject>(wbEntries.size());
                BigDecimal sumReserveBaseQty = BigDecimal.ZERO;
                for (DynamicObject wbEntry : wbEntries) {
                    BigDecimal reserveBaseQty = wbEntry.getBigDecimal("reservebaseqty");
                    if (BigDecimal.ZERO.compareTo(reserveBaseQty) == 0) {
                        deleteWBEntryList.add(wbEntry);
                        continue;
                    }
                    sumReserveBaseQty = sumReserveBaseQty.add(reserveBaseQty);
                }
                if (!CollectionUtils.isEmpty(deleteWBEntryList)) {
                    wbEntries.removeAll(deleteWBEntryList);
                }
                allotResultWB.set("sumreservebaseqty", (Object)sumReserveBaseQty);
                if (BigDecimal.ZERO.compareTo(sumReserveBaseQty) == 0) {
                    deleteAllotResultWBList.add(allotResultWB);
                    continue;
                }
                updateAllotResultWBList.add(allotResultWB);
            }
            if (!CollectionUtils.isEmpty(newAllotResultWBList)) {
                SaveServiceHelper.save((DynamicObject[])((DynamicObject[])newAllotResultWBList.stream().toArray(DynamicObject[]::new)));
            }
            if (!CollectionUtils.isEmpty(updateAllotResultWBList)) {
                SaveServiceHelper.save((DynamicObject[])((DynamicObject[])updateAllotResultWBList.stream().toArray(DynamicObject[]::new)));
            }
            if (!CollectionUtils.isEmpty(deleteAllotResultWBList)) {
                DeleteServiceHelper.delete((IDataEntityType)((DynamicObject)deleteAllotResultWBList.get(0)).getDynamicObjectType(), (Object[])deleteAllotResultWBList.stream().map(r -> r.getPkValue()).toArray());
            }
        }
    }

    public static final void reserveAllotResutWB(DynamicObject allotResultWB, long allotResultId, BigDecimal reserveBaseQty) {
        if (allotResultWB != null) {
            DynamicObjectCollection entries = allotResultWB.getDynamicObjectCollection("entryentity");
            boolean isMatch = false;
            for (DynamicObject entry : entries) {
                if (entry.getLong("allotresultid") != allotResultId) continue;
                entry.set("reservebaseqty", (Object)reserveBaseQty.add(entry.getBigDecimal("reservebaseqty")));
                isMatch = true;
                break;
            }
            if (!isMatch) {
                DynamicObject entry = entries.addNew();
                entry.set("allotresultid", (Object)allotResultId);
                entry.set("reservebaseqty", (Object)reserveBaseQty);
            }
        }
    }

    public static final DynamicObject newAllotResutWB(String entity, long billId, long entryId, long subEntryId) {
        return AllotResultWBHandler.newAllotResutWB(entity, billId, entryId, subEntryId, new HashMap<Long, BigDecimal>(0));
    }

    private static DynamicObject newAllotResutWB(String entity, long billId, long entryId, long subEntryId, Map<Long, BigDecimal> reserveBaseQtyMap) {
        DynamicObject allotResultWB = BusinessDataServiceHelper.newDynamicObject((String)"ococic_allotresult_wb");
        allotResultWB.set("billentity", (Object)entity);
        allotResultWB.set("billid", (Object)billId);
        allotResultWB.set("entryid", (Object)entryId);
        allotResultWB.set("subentryid", (Object)subEntryId);
        DynamicObjectCollection entries = allotResultWB.getDynamicObjectCollection("entryentity");
        BigDecimal sumReserveBaseQty = BigDecimal.ZERO;
        for (Map.Entry<Long, BigDecimal> reserveQty : reserveBaseQtyMap.entrySet()) {
            DynamicObject entry = entries.addNew();
            entry.set("allotresultid", (Object)reserveQty.getKey());
            entry.set("reservebaseqty", (Object)reserveQty.getValue());
            sumReserveBaseQty = sumReserveBaseQty.add(reserveQty.getValue());
        }
        allotResultWB.set("sumreservebaseqty", (Object)sumReserveBaseQty);
        return allotResultWB;
    }

    private static String getAllotResultWBAllSelectProperties() {
        return String.join((CharSequence)",", "id", "billentity", "billid", "entryid", "subentryid", "sumreservebaseqty", String.join((CharSequence)".", "entryentity", "allotresultid"), String.join((CharSequence)".", "entryentity", "reservebaseqty"));
    }

    public static Map<String, DynamicObject> loadAllotResultWB(String entity, long billId) {
        QFilter[] filters;
        String selectProperties = AllotResultWBHandler.getAllotResultWBAllSelectProperties();
        DynamicObject[] allotResultWBArray = BusinessDataServiceHelper.load((String)"ococic_allotresult_wb", (String)selectProperties, (QFilter[])(filters = new QFilter[]{new QFilter("billentity", "=", (Object)entity), new QFilter("billid", "=", (Object)billId)}));
        if (allotResultWBArray != null && allotResultWBArray.length > 0) {
            return Arrays.asList(allotResultWBArray).stream().collect(Collectors.toMap(r -> AllotResultWBHandler.getAllotResultWBKey(r), r -> r));
        }
        return new HashMap<String, DynamicObject>(0);
    }
}

