/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ococic.business.channelinv;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.occ.ococic.business.channelinv.InvAccProcessor;
import kd.occ.ococic.enums.ChannelInvAccInOutTypeEnum;
import kd.occ.ococic.enums.OperateTypeEnum;
import kd.occ.ococic.pojo.ChannelInvAccLogVO;
import kd.occ.ococic.pojo.ChannelInvAccVO;

public class InBillInvAccProcessor
extends InvAccProcessor {
    @Override
    protected List<ChannelInvAccVO> getChannelInvAccVo(List<Long> billIdList, OperateTypeEnum operateType) {
        DynamicObject[] billDynObjs;
        ArrayList<ChannelInvAccVO> invAccVOList = new ArrayList<ChannelInvAccVO>();
        if (billIdList == null || billIdList.size() == 0) {
            return invAccVOList;
        }
        for (DynamicObject inBillDynObj : billDynObjs = BusinessDataServiceHelper.load((Object[])billIdList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"ococic_channelinbill"))) {
            DynamicObjectCollection entryColl = inBillDynObj.getDynamicObjectCollection("billentry");
            if (entryColl == null || entryColl.size() <= 0) continue;
            for (DynamicObject entryDynObj : entryColl) {
                ChannelInvAccVO invAccVO = new ChannelInvAccVO();
                invAccVO.setItemID(this.getBaseDataLongPkId(entryDynObj, "itemid"));
                invAccVO.setMaterialID(this.getBaseDataLongPkId(entryDynObj, "materialid"));
                invAccVO.setAuxPtyID(this.getBaseDataLongPkId(entryDynObj, "auxptyid"));
                invAccVO.setProjectID(this.getBaseDataLongPkId(entryDynObj, "projectid"));
                invAccVO.setProductDate(entryDynObj.getDate("producedate"));
                invAccVO.setEffectiveDate(entryDynObj.getDate("expirydate"));
                invAccVO.setChannelID(this.getBaseDataLongPkId(inBillDynObj, "inchannelid"));
                invAccVO.setSaleOrgID(this.getBaseDataLongPkId(inBillDynObj, "org"));
                invAccVO.setChannelStockId(this.getBaseDataLongPkId(entryDynObj, "warehouse"));
                invAccVO.setChannelLocationID(this.getBaseDataLongPkId(entryDynObj, "locationid"));
                invAccVO.setChannelStockStatusID(this.getBaseDataLongPkId(entryDynObj, "stockstatus"));
                invAccVO.setChannelStockTypeID(this.getBaseDataLongPkId(entryDynObj, "stocktype"));
                invAccVO.setOwnerID(this.getBaseDataLongPkId(entryDynObj, "ownerid"));
                invAccVO.setOwnerType(entryDynObj.getString("ownertype"));
                invAccVO.setKeeperID(this.getBaseDataLongPkId(entryDynObj, "keeperid"));
                invAccVO.setKeeperType(entryDynObj.getString("keepertype"));
                invAccVO.setBaseUnitID(this.getBaseDataLongPkId(entryDynObj, "baseunitid"));
                invAccVO.setBaseQty(entryDynObj.getBigDecimal("baseqty"));
                invAccVO.setLotID(this.getBaseDataLongPkId(entryDynObj, "lotnumberid"));
                invAccVO.setLotNum(entryDynObj.getString("lotnumber"));
                if ("1".equals(inBillDynObj.getString("inway"))) {
                    if (OperateTypeEnum.AUDIT == operateType) {
                        invAccVO.setInOutType(ChannelInvAccInOutTypeEnum.IN);
                    } else {
                        invAccVO.setInOutType(ChannelInvAccInOutTypeEnum.OUT);
                    }
                } else if (OperateTypeEnum.AUDIT == operateType) {
                    invAccVO.setInOutType(ChannelInvAccInOutTypeEnum.OUT);
                } else {
                    invAccVO.setInOutType(ChannelInvAccInOutTypeEnum.IN);
                }
                invAccVO.setBillId(inBillDynObj.getLong("id"));
                invAccVO.setBillEntryId(entryDynObj.getLong("id"));
                invAccVO.setBillEntryKey("billentry");
                invAccVO.setEntrySeq(entryDynObj.getLong("seq"));
                invAccVOList.add(invAccVO);
            }
        }
        return invAccVOList;
    }

    @Override
    protected List<ChannelInvAccLogVO> getChannelInvAccLogVo(List<Long> billIdList) {
        DynamicObject[] billDynObjs;
        ArrayList<ChannelInvAccLogVO> invAccLogVOList = new ArrayList<ChannelInvAccLogVO>();
        if (billIdList == null || billIdList.size() == 0) {
            return invAccLogVOList;
        }
        for (DynamicObject inBillDynObj : billDynObjs = BusinessDataServiceHelper.load((Object[])billIdList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"ococic_channelinbill"))) {
            DynamicObjectCollection entryColl = inBillDynObj.getDynamicObjectCollection("billentry");
            if (entryColl == null || entryColl.size() <= 0) continue;
            for (DynamicObject entryDynObj : entryColl) {
                ChannelInvAccLogVO invAccLotVO = new ChannelInvAccLogVO();
                invAccLotVO.setItemID(this.getBaseDataLongPkId(entryDynObj, "itemid"));
                invAccLotVO.setMaterialID(this.getBaseDataLongPkId(entryDynObj, "materialid"));
                invAccLotVO.setAuxPtyID(this.getBaseDataLongPkId(entryDynObj, "auxptyid"));
                invAccLotVO.setProjectID(this.getBaseDataLongPkId(entryDynObj, "projectid"));
                invAccLotVO.setProductDate(entryDynObj.getDate("producedate"));
                invAccLotVO.setEffectiveDate(entryDynObj.getDate("expirydate"));
                invAccLotVO.setChannelID(this.getBaseDataLongPkId(inBillDynObj, "inchannelid"));
                invAccLotVO.setSaleOrgID(this.getBaseDataLongPkId(inBillDynObj, "org"));
                invAccLotVO.setSaleChannelID(this.getBaseDataLongPkId(inBillDynObj, "sellorgchannel"));
                invAccLotVO.setChannelStockId(this.getBaseDataLongPkId(entryDynObj, "warehouse"));
                invAccLotVO.setChannelLocationID(this.getBaseDataLongPkId(entryDynObj, "locationid"));
                invAccLotVO.setChannelStockStatusID(this.getBaseDataLongPkId(entryDynObj, "stockstatus"));
                invAccLotVO.setChannelStockTypeID(this.getBaseDataLongPkId(entryDynObj, "stocktype"));
                invAccLotVO.setOwnerID(this.getBaseDataLongPkId(entryDynObj, "ownerid"));
                invAccLotVO.setOwnerType(entryDynObj.getString("ownertype"));
                invAccLotVO.setKeeperID(this.getBaseDataLongPkId(entryDynObj, "keeperid"));
                invAccLotVO.setKeeperType(entryDynObj.getString("keepertype"));
                invAccLotVO.setBaseUnitID(this.getBaseDataLongPkId(entryDynObj, "baseunitid"));
                invAccLotVO.setBaseQty(entryDynObj.getBigDecimal("baseqty"));
                invAccLotVO.setStockUnitId(this.getBaseDataLongPkId(entryDynObj, "unitid"));
                invAccLotVO.setAssistUnitId(this.getBaseDataLongPkId(entryDynObj, "assistunitid"));
                invAccLotVO.setLotID(this.getBaseDataLongPkId(entryDynObj, "lotnumberid"));
                invAccLotVO.setLotNum(entryDynObj.getString("lotnumber"));
                invAccLotVO.setBillID(inBillDynObj.getLong("id"));
                invAccLotVO.setBillEntityID("ococic_channelinbill");
                invAccLotVO.setBillNo(inBillDynObj.getString("billno"));
                invAccLotVO.setBillEntryID(entryDynObj.getLong("id"));
                invAccLogVOList.add(invAccLotVO);
            }
        }
        return invAccLogVOList;
    }
}

