/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ococic.business.channelinv;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ococic.business.channelinv.InvAccProcessor;
import kd.occ.ococic.enums.ChannelInvAccInOutTypeEnum;
import kd.occ.ococic.enums.OperateTypeEnum;
import kd.occ.ococic.pojo.ChannelInvAccLogVO;
import kd.occ.ococic.pojo.ChannelInvAccVO;

public class InventoryReportInvAccProcessor
extends InvAccProcessor {
    @Override
    protected List<ChannelInvAccVO> getChannelInvAccVo(List<Long> billIdList, OperateTypeEnum operateType) {
        DynamicObject[] billDynObjs;
        ArrayList<ChannelInvAccVO> invAccVOList = new ArrayList<ChannelInvAccVO>();
        if (CommonUtils.isNull(billIdList)) {
            return invAccVOList;
        }
        for (DynamicObject billDynObj : billDynObjs = BusinessDataServiceHelper.load((Object[])billIdList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"ococic_inventoryreport"))) {
            DynamicObjectCollection entryColl = billDynObj.getDynamicObjectCollection("entryentity");
            if (CommonUtils.isNull((Object)entryColl)) continue;
            for (DynamicObject entryDynObj : entryColl) {
                ChannelInvAccVO invAccVO = new ChannelInvAccVO();
                this.setChannelInvAccVO(invAccVO, billDynObj, entryDynObj);
                if (OperateTypeEnum.AUDIT == operateType) {
                    invAccVO.setInOutType(ChannelInvAccInOutTypeEnum.IN);
                } else {
                    invAccVO.setInOutType(ChannelInvAccInOutTypeEnum.OUT);
                }
                invAccVO.setBillId(billDynObj.getLong("id"));
                invAccVO.setBillEntryId(entryDynObj.getLong("id"));
                invAccVO.setBillEntryKey("entryentity");
                invAccVO.setEntrySeq(entryDynObj.getLong("seq"));
                invAccVOList.add(invAccVO);
            }
        }
        return invAccVOList;
    }

    @Override
    protected List<ChannelInvAccLogVO> getChannelInvAccLogVo(List<Long> billIdList) {
        DynamicObject[] billDynObjs;
        ArrayList<ChannelInvAccLogVO> invAccLogVOList = new ArrayList<ChannelInvAccLogVO>();
        if (CommonUtils.isNull(billIdList)) {
            return invAccLogVOList;
        }
        for (DynamicObject billDynObj : billDynObjs = BusinessDataServiceHelper.load((Object[])billIdList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"ococic_inventoryreport"))) {
            DynamicObjectCollection entryColl = billDynObj.getDynamicObjectCollection("entryentity");
            if (CommonUtils.isNull((Object)entryColl)) continue;
            for (DynamicObject entryDynObj : entryColl) {
                ChannelInvAccLogVO invAccLotVO = new ChannelInvAccLogVO();
                this.setChannelInvAccLogVO(invAccLotVO, billDynObj, entryDynObj);
                invAccLotVO.setStockUnitId(this.getBaseDataLongPkId(entryDynObj, "unitid"));
                invAccLotVO.setAssistUnitId(this.getBaseDataLongPkId(entryDynObj, "assistunitid"));
                invAccLotVO.setBillID(billDynObj.getLong("id"));
                invAccLotVO.setBillEntityID("ococic_inventoryreport");
                invAccLotVO.setBillNo(billDynObj.getString("billno"));
                invAccLotVO.setBillEntryID(entryDynObj.getLong("id"));
                invAccLogVOList.add(invAccLotVO);
            }
        }
        return invAccLogVOList;
    }

    private void setChannelInvAccVO(ChannelInvAccVO invAccVO, DynamicObject inBillDynObj, DynamicObject entryDynObj) {
        invAccVO.setItemID(this.getBaseDataLongPkId(entryDynObj, "itemid"));
        invAccVO.setMaterialID(this.getBaseDataLongPkId(entryDynObj, "materialid"));
        invAccVO.setAuxPtyID(this.getBaseDataLongPkId(entryDynObj, "auxptyid"));
        invAccVO.setProjectID(0L);
        invAccVO.setProductDate(entryDynObj.getDate("productdate"));
        invAccVO.setEffectiveDate(entryDynObj.getDate("expiredate"));
        invAccVO.setChannelID(this.getBaseDataLongPkId(inBillDynObj, "reportchannelid"));
        invAccVO.setSaleOrgID(this.getBaseDataLongPkId(inBillDynObj, "org"));
        invAccVO.setChannelStockId(this.getBaseDataLongPkId(entryDynObj, "warehouseid"));
        invAccVO.setChannelLocationID(this.getBaseDataLongPkId(entryDynObj, "locationid"));
        invAccVO.setChannelStockStatusID(this.getBaseDataLongPkId(entryDynObj, "stockstatusid"));
        invAccVO.setChannelStockTypeID(this.getBaseDataLongPkId(entryDynObj, "stocktypeid"));
        invAccVO.setOwnerID(this.getBaseDataLongPkId(entryDynObj, "ownerid"));
        invAccVO.setOwnerType(entryDynObj.getString("ownertype"));
        invAccVO.setKeeperID(this.getBaseDataLongPkId(entryDynObj, "keeperid"));
        invAccVO.setKeeperType(entryDynObj.getString("keepertype"));
        invAccVO.setBaseUnitID(this.getBaseDataLongPkId(entryDynObj, "baseunitid"));
        invAccVO.setBaseQty(entryDynObj.getBigDecimal("baseqty"));
        invAccVO.setLotID(this.getBaseDataLongPkId(entryDynObj, "lotnumberid"));
        invAccVO.setLotNum(entryDynObj.getString("lotnumber"));
    }

    private void setChannelInvAccLogVO(ChannelInvAccLogVO invAccLogVO, DynamicObject inBillDynObj, DynamicObject entryDynObj) {
        invAccLogVO.setItemID(this.getBaseDataLongPkId(entryDynObj, "itemid"));
        invAccLogVO.setMaterialID(this.getBaseDataLongPkId(entryDynObj, "materialid"));
        invAccLogVO.setAuxPtyID(this.getBaseDataLongPkId(entryDynObj, "auxptyid"));
        invAccLogVO.setProjectID(0L);
        invAccLogVO.setProductDate(entryDynObj.getDate("productdate"));
        invAccLogVO.setEffectiveDate(entryDynObj.getDate("expiredate"));
        invAccLogVO.setChannelID(this.getBaseDataLongPkId(inBillDynObj, "reportchannelid"));
        invAccLogVO.setSaleOrgID(this.getBaseDataLongPkId(inBillDynObj, "org"));
        invAccLogVO.setChannelStockId(this.getBaseDataLongPkId(entryDynObj, "warehouseid"));
        invAccLogVO.setChannelLocationID(this.getBaseDataLongPkId(entryDynObj, "locationid"));
        invAccLogVO.setChannelStockStatusID(this.getBaseDataLongPkId(entryDynObj, "stockstatusid"));
        invAccLogVO.setChannelStockTypeID(this.getBaseDataLongPkId(entryDynObj, "stocktypeid"));
        invAccLogVO.setOwnerID(this.getBaseDataLongPkId(entryDynObj, "ownerid"));
        invAccLogVO.setOwnerType(entryDynObj.getString("ownertype"));
        invAccLogVO.setKeeperID(this.getBaseDataLongPkId(entryDynObj, "keeperid"));
        invAccLogVO.setKeeperType(entryDynObj.getString("keepertype"));
        invAccLogVO.setBaseUnitID(this.getBaseDataLongPkId(entryDynObj, "baseunitid"));
        invAccLogVO.setBaseQty(entryDynObj.getBigDecimal("baseqty"));
        invAccLogVO.setLotID(this.getBaseDataLongPkId(entryDynObj, "lotnumberid"));
        invAccLogVO.setLotNum(entryDynObj.getString("lotnumber"));
    }
}

