/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ococic.business.channelinv;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.occ.ococic.business.channelinv.InvAccProcessor;
import kd.occ.ococic.enums.ChannelInvAccInOutTypeEnum;
import kd.occ.ococic.enums.OperateTypeEnum;
import kd.occ.ococic.pojo.ChannelInvAccLogVO;
import kd.occ.ococic.pojo.ChannelInvAccVO;
import kd.occ.ococic.util.CommonUtils;

public class OutBillInvAccProcessor
extends InvAccProcessor {
    @Override
    protected List<ChannelInvAccVO> getChannelInvAccVo(List<Long> billIdList, OperateTypeEnum operateType) {
        DynamicObject[] billDynObjs;
        ArrayList<ChannelInvAccVO> invAccVOList = new ArrayList<ChannelInvAccVO>();
        if (CommonUtils.isNull(billIdList)) {
            return invAccVOList;
        }
        for (DynamicObject outBillDynObj : billDynObjs = BusinessDataServiceHelper.load((Object[])billIdList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"ococic_channeloutbill"))) {
            DynamicObjectCollection entryColl = outBillDynObj.getDynamicObjectCollection("billentry");
            if (CommonUtils.isNull((Object)entryColl)) continue;
            for (DynamicObject entryDynObj : entryColl) {
                ChannelInvAccVO invAccVO = new ChannelInvAccVO();
                invAccVO.setItemID(this.getBaseDataLongPkId(entryDynObj, "itemid"));
                invAccVO.setMaterialID(this.getBaseDataLongPkId(entryDynObj, "materielid"));
                invAccVO.setAuxPtyID(this.getBaseDataLongPkId(entryDynObj, "auxptyid"));
                invAccVO.setProjectID(this.getBaseDataLongPkId(entryDynObj, "projectid"));
                invAccVO.setProductDate(entryDynObj.getDate("productdate"));
                invAccVO.setEffectiveDate(entryDynObj.getDate("expiredate"));
                invAccVO.setChannelID(this.getBaseDataLongPkId(outBillDynObj, "outchannelid"));
                invAccVO.setSaleOrgID(this.getBaseDataLongPkId(outBillDynObj, "org"));
                invAccVO.setChannelStockId(this.getBaseDataLongPkId(entryDynObj, "stockid"));
                invAccVO.setChannelLocationID(this.getBaseDataLongPkId(entryDynObj, "stockaddrid"));
                invAccVO.setChannelStockStatusID(this.getBaseDataLongPkId(entryDynObj, "stockstatusid"));
                invAccVO.setChannelStockTypeID(this.getBaseDataLongPkId(entryDynObj, "stocktypeid"));
                invAccVO.setOwnerID(this.getBaseDataLongPkId(entryDynObj, "ownerid"));
                invAccVO.setOwnerType(entryDynObj.getString("ownertype"));
                invAccVO.setKeeperID(this.getBaseDataLongPkId(entryDynObj, "keeperid"));
                invAccVO.setKeeperType(entryDynObj.getString("keepertype"));
                invAccVO.setBaseUnitID(this.getBaseDataLongPkId(entryDynObj, "baseunitid"));
                invAccVO.setBaseQty(entryDynObj.getBigDecimal("basequantity"));
                invAccVO.setLotID(this.getBaseDataLongPkId(entryDynObj, "lotid"));
                invAccVO.setLotNum(entryDynObj.getString("lotnumber"));
                if ("1".equals(outBillDynObj.getString("outdirection"))) {
                    if (OperateTypeEnum.AUDIT == operateType) {
                        invAccVO.setInOutType(ChannelInvAccInOutTypeEnum.OUT);
                    } else {
                        invAccVO.setInOutType(ChannelInvAccInOutTypeEnum.IN);
                    }
                } else if (OperateTypeEnum.AUDIT == operateType) {
                    invAccVO.setInOutType(ChannelInvAccInOutTypeEnum.IN);
                } else {
                    invAccVO.setInOutType(ChannelInvAccInOutTypeEnum.OUT);
                }
                invAccVO.setBillId(outBillDynObj.getLong("id"));
                invAccVO.setBillEntryId(entryDynObj.getLong("id"));
                invAccVO.setBillEntryKey("billentry");
                invAccVO.setEntrySeq(entryDynObj.getLong("seq"));
                invAccVOList.add(invAccVO);
            }
        }
        return invAccVOList;
    }

    @Override
    protected List<ChannelInvAccLogVO> getChannelInvAccLogVo(List<Long> billIdList) {
        DynamicObject[] billDynObjs;
        ArrayList<ChannelInvAccLogVO> invAccLogVOList = new ArrayList<ChannelInvAccLogVO>();
        if (billIdList == null || billIdList.size() == 0) {
            return invAccLogVOList;
        }
        for (DynamicObject outBillDynObj : billDynObjs = BusinessDataServiceHelper.load((Object[])billIdList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"ococic_channeloutbill"))) {
            DynamicObjectCollection entryColl = outBillDynObj.getDynamicObjectCollection("billentry");
            if (entryColl == null || entryColl.size() <= 0) continue;
            for (DynamicObject entryDynObj : entryColl) {
                ChannelInvAccLogVO invAccLotVO = new ChannelInvAccLogVO();
                invAccLotVO.setItemID(this.getBaseDataLongPkId(entryDynObj, "itemid"));
                invAccLotVO.setMaterialID(this.getBaseDataLongPkId(entryDynObj, "materielid"));
                invAccLotVO.setAuxPtyID(this.getBaseDataLongPkId(entryDynObj, "auxptyid"));
                invAccLotVO.setProjectID(this.getBaseDataLongPkId(entryDynObj, "projectid"));
                invAccLotVO.setProductDate(entryDynObj.getDate("productdate"));
                invAccLotVO.setEffectiveDate(entryDynObj.getDate("expiredate"));
                invAccLotVO.setChannelID(this.getBaseDataLongPkId(outBillDynObj, "outchannelid"));
                invAccLotVO.setSaleOrgID(this.getBaseDataLongPkId(outBillDynObj, "org"));
                invAccLotVO.setChannelStockId(this.getBaseDataLongPkId(entryDynObj, "stockid"));
                invAccLotVO.setChannelLocationID(this.getBaseDataLongPkId(entryDynObj, "stockaddrid"));
                invAccLotVO.setChannelStockStatusID(this.getBaseDataLongPkId(entryDynObj, "stockstatusid"));
                invAccLotVO.setChannelStockTypeID(this.getBaseDataLongPkId(entryDynObj, "stocktypeid"));
                invAccLotVO.setOwnerID(this.getBaseDataLongPkId(entryDynObj, "ownerid"));
                invAccLotVO.setOwnerType(entryDynObj.getString("ownertype"));
                invAccLotVO.setKeeperID(this.getBaseDataLongPkId(entryDynObj, "keeperid"));
                invAccLotVO.setKeeperType(entryDynObj.getString("keepertype"));
                invAccLotVO.setBaseUnitID(this.getBaseDataLongPkId(entryDynObj, "baseunitid"));
                invAccLotVO.setBaseQty(entryDynObj.getBigDecimal("basequantity"));
                invAccLotVO.setStockUnitId(this.getBaseDataLongPkId(entryDynObj, "unitid"));
                invAccLotVO.setAssistUnitId(this.getBaseDataLongPkId(entryDynObj, "auxptyunitid"));
                invAccLotVO.setLotID(this.getBaseDataLongPkId(entryDynObj, "lotid"));
                invAccLotVO.setLotNum(entryDynObj.getString("lotnumber"));
                invAccLotVO.setBillID(outBillDynObj.getLong("id"));
                invAccLotVO.setBillEntityID("ococic_channeloutbill");
                invAccLotVO.setBillNo(outBillDynObj.getString("billno"));
                invAccLotVO.setBillEntryID(entryDynObj.getLong("id"));
                invAccLogVOList.add(invAccLotVO);
            }
        }
        return invAccLogVOList;
    }
}

