/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ococic.business.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.enums.ococic.EntityInvQueryGroupByEnum;
import kd.occ.ocbase.common.enums.sysparam.InvSourceFrom;
import kd.occ.ocbase.common.pojo.ocic.EntityInvQueryBatchParam;
import kd.occ.ocbase.common.pojo.ocic.EntityInvQueryParam;
import kd.occ.ocbase.common.pojo.ocic.EntityInvQueryResult;
import kd.occ.ocbase.common.pojo.ocic.OcocicInvAccQueryParam;
import kd.occ.ocbase.common.pojo.ocic.OcocicInvAccQueryResult;
import kd.occ.ocbase.common.pojo.ocic.ScmcInvAccQueryParam;
import kd.occ.ocbase.common.pojo.ocic.ScmcInvAccQueryResult;
import kd.occ.ocbase.common.util.StringUtils;
import kd.occ.ocbase.common.util.SysParamsUtil;
import kd.occ.ococic.business.helper.OcocicInvAccQueryHelper;
import kd.occ.ococic.business.helper.ScmcInvAccQueryHelper;

public class EntityInvQueryHelper {
    public static final List<EntityInvQueryResult> queryEntityInventory(List<EntityInvQueryParam> params) {
        int batchSize = params.size();
        HashSet<Long> stockOrgIdSet = new HashSet<Long>(batchSize);
        HashSet<Long> warehouseIdSet = new HashSet<Long>(batchSize);
        HashSet<Long> itemIdSet = new HashSet<Long>(batchSize);
        HashSet<Long> auxPtyIdSet = new HashSet<Long>(batchSize);
        HashSet invTypeIdSet = new HashSet(batchSize);
        HashSet<Long> baseUnitIdSet = new HashSet<Long>(batchSize);
        for (EntityInvQueryParam param : params) {
            stockOrgIdSet.add(param.getStockOrgId());
            warehouseIdSet.add(param.getWarehouseId());
            itemIdSet.add(param.getItemId());
            auxPtyIdSet.add(param.getAuxPtyId());
            baseUnitIdSet.add(param.getBaseUnitId());
        }
        Map<Long, Set<Long>> material2ItemMap = params.stream().collect(Collectors.groupingBy(r -> r.getMaterialId(), Collectors.mapping(r -> r.getItemId(), Collectors.toSet())));
        List<EntityInvQueryResult> aivResults = EntityInvQueryHelper.queryEntityInventory(new EntityInvQueryBatchParam(itemIdSet, baseUnitIdSet, stockOrgIdSet, warehouseIdSet, auxPtyIdSet, invTypeIdSet), material2ItemMap, EntityInvQueryHelper.getScmcInvAccQueryGroupByFields(EntityInvQueryGroupByEnum.ISWAIUB));
        return EntityInvQueryHelper.getResultMatchForParam(params, aivResults);
    }

    private static List<EntityInvQueryResult> getResultMatchForParam(List<EntityInvQueryParam> params, List<EntityInvQueryResult> queryResultList) {
        int batchSize = params.size();
        Map<String, List<EntityInvQueryResult>> groupedResultMap = queryResultList.stream().collect(Collectors.groupingBy(r -> StringUtils.join((CharSequence)"#", (Object[])new Object[]{r.getItemId(), r.getMaterialId(), r.getBaseUnitId(), r.getAuxptyId(), r.getStockOrgId(), r.getWarehouseId()})));
        ArrayList<EntityInvQueryResult> returnResultList = new ArrayList<EntityInvQueryResult>(batchSize);
        for (EntityInvQueryParam param : params) {
            String key = StringUtils.join((CharSequence)"#", (Object[])new Object[]{param.getItemId(), param.getMaterialId(), param.getBaseUnitId(), param.getAuxPtyId(), param.getStockOrgId(), param.getWarehouseId()});
            List<EntityInvQueryResult> groupQueryResultList = groupedResultMap.get(key);
            EntityInvQueryResult cloneEntityInvQueryResult = new EntityInvQueryResult(param);
            if (CollectionUtils.isEmpty(groupQueryResultList)) {
                returnResultList.add(cloneEntityInvQueryResult);
                continue;
            }
            for (EntityInvQueryResult queryGroupResult : groupQueryResultList) {
                if (param.getInvTypeId() > 0L) {
                    if (param.getInvTypeId() != queryGroupResult.getInvTypeId()) continue;
                    EntityInvQueryHelper.entityInvQueryResultAdd(cloneEntityInvQueryResult, queryGroupResult);
                    continue;
                }
                EntityInvQueryHelper.entityInvQueryResultAdd(cloneEntityInvQueryResult, queryGroupResult);
            }
            returnResultList.add(cloneEntityInvQueryResult);
        }
        return returnResultList;
    }

    private static final void entityInvQueryResultAdd(EntityInvQueryResult firstEntityInvQueryResult, EntityInvQueryResult secordEntityInvQueryResult) {
        firstEntityInvQueryResult.setQty(firstEntityInvQueryResult.getQty().add(secordEntityInvQueryResult.getQty()));
        firstEntityInvQueryResult.setAvbbQty(firstEntityInvQueryResult.getAvbbQty().add(secordEntityInvQueryResult.getAvbbQty()));
        firstEntityInvQueryResult.setReserveQty(firstEntityInvQueryResult.getReserveQty().add(secordEntityInvQueryResult.getReserveQty()));
        firstEntityInvQueryResult.setBaseQty(firstEntityInvQueryResult.getBaseQty().add(secordEntityInvQueryResult.getBaseQty()));
        firstEntityInvQueryResult.setAvbbBaseQty(firstEntityInvQueryResult.getAvbbBaseQty().add(secordEntityInvQueryResult.getAvbbBaseQty()));
        firstEntityInvQueryResult.setReserveBaseQty(firstEntityInvQueryResult.getReserveBaseQty().add(secordEntityInvQueryResult.getReserveBaseQty()));
    }

    public static final List<EntityInvQueryResult> queryEntityInventory(EntityInvQueryBatchParam param, EntityInvQueryGroupByEnum groupby) {
        return EntityInvQueryHelper.queryEntityInventory(param, new HashMap<Long, Set<Long>>(0), EntityInvQueryHelper.getScmcInvAccQueryGroupByFields(groupby));
    }

    private static List<EntityInvQueryResult> queryEntityInventory(EntityInvQueryBatchParam param, Map<Long, Set<Long>> material2ItemMap, String ... groupbyFields) {
        if (CollectionUtils.isEmpty(material2ItemMap)) {
            material2ItemMap = EntityInvQueryHelper.material2ItemMap(param.getItemIdSet());
        }
        ArrayList<EntityInvQueryResult> aivResults = new ArrayList<EntityInvQueryResult>(material2ItemMap.size());
        InvSourceFrom invSourceFrom = SysParamsUtil.getInvSourceFrom();
        switch (invSourceFrom) {
            case YI_GOU: {
                List<OcocicInvAccQueryResult> ococicInvAccQueryResults = OcocicInvAccQueryHelper.ococicInvAccQuery(new OcocicInvAccQueryParam(param, material2ItemMap.keySet()), groupbyFields);
                for (OcocicInvAccQueryResult result : ococicInvAccQueryResults) {
                    Set<Long> itemIdSet = material2ItemMap.get(result.getMaterialId());
                    if (CollectionUtils.isEmpty(itemIdSet)) continue;
                    for (Long itemId : itemIdSet) {
                        aivResults.add(new EntityInvQueryResult((ScmcInvAccQueryResult)result, itemId.longValue()));
                    }
                }
                break;
            }
            default: {
                List<ScmcInvAccQueryResult> scmcInvAccQueryResults = ScmcInvAccQueryHelper.scmcInvAccQuery(new ScmcInvAccQueryParam(param, material2ItemMap.keySet()), groupbyFields);
                for (ScmcInvAccQueryResult result : scmcInvAccQueryResults) {
                    Set<Long> itemIdSet = material2ItemMap.get(result.getMaterialId());
                    if (CollectionUtils.isEmpty(itemIdSet)) continue;
                    for (Long itemId : itemIdSet) {
                        aivResults.add(new EntityInvQueryResult(result, itemId.longValue()));
                    }
                }
            }
        }
        return aivResults;
    }

    private static Map<Long, Set<Long>> material2ItemMap(Set<Long> itemIdSet) {
        QFilter qfilter = new QFilter("id", "in", itemIdSet);
        DynamicObjectCollection itemDynColl = QueryServiceHelper.query((String)"ocdbd_iteminfo", (String)String.join((CharSequence)",", "id", "material"), (QFilter[])qfilter.toArray());
        return itemDynColl.stream().collect(Collectors.groupingBy(obj -> obj.getLong("material"), Collectors.mapping(r -> r.getLong("id"), Collectors.toSet())));
    }

    private static String[] getScmcInvAccQueryGroupByFields(EntityInvQueryGroupByEnum groupby) {
        switch (groupby) {
            case ISWAIUB: {
                return new String[]{"org", "warehouse", "material", "auxpty", "invtype", "unit", "reserveqty"};
            }
        }
        return new String[]{"org", "warehouse", "material", "auxpty", "invtype", "keeper", "owner", "unit", "reserveqty"};
    }
}

