/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ococic.business.helper;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.business.helper.UnitConvertHelper;
import kd.occ.ocbase.common.enums.EnableStatusEnum;
import kd.occ.ocbase.common.enums.StatusEnum;
import kd.occ.ocbase.common.enums.channel.SystemPresetChannelFuction;
import kd.occ.ocbase.common.item.ConversionDirection;
import kd.occ.ocbase.common.util.DynamicObjectUtils;

public class InventoryReportHelper {
    private InventoryReportHelper() {
    }

    public static DynamicObject verifyChannelStockFunc(long channelId) {
        QFilter filter = new QFilter("id", "=", (Object)channelId);
        filter.and(new QFilter("channelfunctions.fbasedataid.id", "=", (Object)SystemPresetChannelFuction.STORAGE.toLong()));
        filter.and(new QFilter("invcontrolmode", "=", (Object)"B"));
        filter.and(new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue()));
        return QueryServiceHelper.queryOne((String)"ocdbd_channel", (String)String.join((CharSequence)",", "id", "saleorg"), (QFilter[])filter.toArray());
    }

    public static long getDefaultWareHouseId(long channelId) {
        if (channelId == 0L) {
            return 0L;
        }
        QFilter qFilter = new QFilter("ownerchannelid", "=", (Object)channelId);
        qFilter.and(new QFilter("isdefault", "=", (Object)"1"));
        qFilter.and(new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue()));
        qFilter.and(new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue()));
        DynamicObject dynObj = QueryServiceHelper.queryOne((String)"ococic_warehouse", (String)"id", (QFilter[])qFilter.toArray());
        return DynamicObjectUtils.getPkValue((DynamicObject)dynObj);
    }

    public static void calQtysByItemApproveQty(IDataModel model, int rowIndex) {
        DynamicObject entryDynObj = model.getEntryRowEntity("entryentity", rowIndex);
        DynamicObject item = entryDynObj.getDynamicObject("itemid");
        BigDecimal qty = entryDynObj.getBigDecimal("qty");
        DynamicObject unitDynObj = entryDynObj.getDynamicObject("unitid");
        BigDecimal assistQty = entryDynObj.getBigDecimal("assistqty");
        long materialId = entryDynObj.getLong(String.join((CharSequence)"_", "materialid", "id"));
        long baseUnitId = entryDynObj.getLong(String.join((CharSequence)"_", "baseunitid", "id"));
        BigDecimal baseQty = unitDynObj != null ? UnitConvertHelper.calculateDestQty((BigDecimal)qty, (Long)materialId, (Long)unitDynObj.getLong("id"), (Long)baseUnitId) : qty;
        String conversionfor = ConversionDirection.FOR_ASSISTUNIT.getConversionFor();
        if (item != null) {
            conversionfor = item.getString("conversionfor");
        }
        if (ConversionDirection.FOR_EACH.getConversionFor().equals(conversionfor) || ConversionDirection.FOR_ASSISTUNIT.getConversionFor().equals(conversionfor)) {
            long assisUnitId = entryDynObj.getLong(String.join((CharSequence)"_", "assistunitid", "id"));
            assistQty = assisUnitId > 0L ? UnitConvertHelper.calculateDestQty((BigDecimal)baseQty, (Long)materialId, (Long)baseUnitId, (Long)assisUnitId) : BigDecimal.ZERO;
        }
        model.setValue("baseqty", (Object)baseQty, rowIndex);
        model.setValue("assistqty", (Object)assistQty, rowIndex);
    }

    public static void calQtysByItemAssistApproveQty(IDataModel model, int rowIndex) {
        DynamicObject entryDynObj = model.getEntryRowEntity("entryentity", rowIndex);
        DynamicObject item = entryDynObj.getDynamicObject("itemid");
        String conversionfor = null;
        if (item != null) {
            conversionfor = item.getString("conversionfor");
        }
        BigDecimal qty = entryDynObj.getBigDecimal("qty");
        BigDecimal baseQty = entryDynObj.getBigDecimal("baseqty");
        long materialId = entryDynObj.getLong(String.join((CharSequence)"_", "materialid", "id"));
        long baseUnitId = entryDynObj.getLong(String.join((CharSequence)"_", "baseunitid", "id"));
        if (ConversionDirection.FOR_EACH.getConversionFor().equals(conversionfor) || ConversionDirection.FOR_MWASUREUNIT.getConversionFor().equals(conversionfor)) {
            DynamicObject unit = entryDynObj.getDynamicObject("unitid");
            if (unit != null) {
                BigDecimal assistQty = entryDynObj.getBigDecimal("assistqty");
                DynamicObject assisUnit = entryDynObj.getDynamicObject("assistunitid");
                if (assisUnit != null) {
                    qty = UnitConvertHelper.calculateDestQty((BigDecimal)assistQty, (Long)materialId, (Long)assisUnit.getLong("id"), (Long)unit.getLong("id"));
                    baseQty = UnitConvertHelper.calculateDestQty((BigDecimal)qty, (Long)materialId, (Long)unit.getLong("id"), (Long)baseUnitId);
                } else {
                    qty = BigDecimal.ZERO;
                    baseQty = BigDecimal.ZERO;
                }
            } else {
                qty = BigDecimal.ZERO;
                baseQty = BigDecimal.ZERO;
            }
        }
        model.setValue("qty", (Object)qty, rowIndex);
        model.setValue("baseqty", (Object)baseQty, rowIndex);
    }
}

