/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ococic.business.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.pojo.ocic.OcocicInvAccQueryParam;
import kd.occ.ocbase.common.pojo.ocic.OcocicInvAccQueryResult;
import kd.occ.ococic.util.StringUtils;

public class OcocicInvAccQueryHelper {
    public static List<DynamicObject> ococicInvAccQuery(OcocicInvAccQueryParam param) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(6);
        OcocicInvAccQueryHelper.buildOcocicInvAccQueryQfilter(filters, param.getStockOrgIdSet(), "org");
        OcocicInvAccQueryHelper.buildOcocicInvAccQueryQfilter(filters, param.getMaterialIdSet(), "material");
        OcocicInvAccQueryHelper.buildOcocicInvAccQueryQfilter(filters, param.getWarehouseIdSet(), "warehouse");
        OcocicInvAccQueryHelper.buildOcocicInvAccQueryQfilter(filters, param.getAuxPtyIdSet(), "auxpty");
        OcocicInvAccQueryHelper.buildOcocicInvAccQueryQfilter(filters, param.getInvTypeIdSet(), "invtype");
        OcocicInvAccQueryHelper.buildOcocicInvAccQueryQfilter(filters, param.getBaseUnitIdSet(), "baseunit");
        String selectFields = String.join((CharSequence)",", "id", "org", "warehouse", "location", "ownertype", "owner", "keepertype", "keeper", "invstatus", "invtype", "material", "auxpty", "lotnum", "project", "producedate", "expirydate", "baseunit", "unit", "unit2nd", "baseqty", "qty", "qty2nd", "reservebaseqty", "reserveqty", "reserveqty2nd", "avbbaseqty", "avbqty", "avbqty2nd");
        DynamicObjectCollection results = QueryServiceHelper.query((String)"ococic_inv_realbalance", (String)selectFields, (QFilter[])filters.toArray(new QFilter[6]));
        return CollectionUtils.isEmpty((Collection)results) ? new ArrayList(0) : results.stream().collect(Collectors.toList());
    }

    public static final List<OcocicInvAccQueryResult> ococicInvAccQuery(OcocicInvAccQueryParam param, String ... groupbyFields) {
        List<DynamicObject> results = OcocicInvAccQueryHelper.ococicInvAccQuery(param);
        return OcocicInvAccQueryHelper.buildOcocicInvAccQueryResultList(results, groupbyFields);
    }

    private static List<OcocicInvAccQueryResult> buildOcocicInvAccQueryResultList(List<DynamicObject> invAccQueryDataList, String ... groupbyFields) {
        List<Object> groupbyFieldList;
        ArrayList<OcocicInvAccQueryResult> results = new ArrayList<OcocicInvAccQueryResult>(invAccQueryDataList.size());
        if (groupbyFields == null || groupbyFields.length == 0) {
            groupbyFieldList = new ArrayList(7);
            groupbyFieldList.add("org");
            groupbyFieldList.add("warehouse");
            groupbyFieldList.add("material");
            groupbyFieldList.add("auxpty");
            groupbyFieldList.add("invtype");
            groupbyFieldList.add("keeper");
            groupbyFieldList.add("owner");
            groupbyFields = (String[])groupbyFieldList.stream().toArray(String[]::new);
        }
        groupbyFieldList = Arrays.asList(groupbyFields);
        Map<String, List<DynamicObject>> invAccQueryDataGroupByMap = invAccQueryDataList.stream().collect(Collectors.groupingBy(invAccQueryData -> StringUtils.join((CharSequence)"_", (Object[])groupbyFieldList.stream().map(groupbyField -> invAccQueryData.getString(groupbyField)).toArray())));
        for (List<DynamicObject> invAccQueryDatas : invAccQueryDataGroupByMap.values()) {
            OcocicInvAccQueryResult result = new OcocicInvAccQueryResult();
            for (DynamicObject invAccQueryData2 : invAccQueryDatas) {
                if (groupbyFieldList.contains("org")) {
                    result.setStockOrgId(invAccQueryData2.getLong("org"));
                }
                if (groupbyFieldList.contains("warehouse")) {
                    result.setWarehouseId(invAccQueryData2.getLong("warehouse"));
                }
                if (groupbyFieldList.contains("material")) {
                    result.setMaterialId(invAccQueryData2.getLong("material"));
                }
                if (groupbyFieldList.contains("auxpty")) {
                    result.setAuxptyId(invAccQueryData2.getLong("auxpty"));
                }
                if (groupbyFieldList.contains("invtype")) {
                    result.setInvTypeId(invAccQueryData2.getLong("invtype"));
                }
                if (groupbyFieldList.contains("keeper")) {
                    result.setKeeperId(invAccQueryData2.getLong("keeper"));
                    result.setKeeperType(invAccQueryData2.getString("keepertype"));
                }
                if (groupbyFieldList.contains("owner")) {
                    result.setOwnerId(invAccQueryData2.getLong("owner"));
                    result.setOwnerType(invAccQueryData2.getString("ownertype"));
                }
                result.setUnitId(invAccQueryData2.getLong("unit"));
                result.setQty(result.getQty().add(invAccQueryData2.getBigDecimal("qty")));
                result.setReserveQty(result.getReserveQty().add(invAccQueryData2.getBigDecimal("reserveqty")));
                result.setAvbbQty(result.getAvbbQty().add(invAccQueryData2.getBigDecimal("avbqty")));
                result.setBaseUnitId(invAccQueryData2.getLong("baseunit"));
                result.setBaseQty(result.getBaseQty().add(invAccQueryData2.getBigDecimal("baseqty")));
                result.setReserveBaseQty(result.getReserveBaseQty().add(invAccQueryData2.getBigDecimal("reservebaseqty")));
                result.setAvbbBaseQty(result.getAvbbBaseQty().add(invAccQueryData2.getBigDecimal("avbbaseqty")));
            }
            results.add(result);
        }
        return results;
    }

    private static void buildOcocicInvAccQueryQfilter(List<QFilter> filters, Set<Long> idSet, String qfilterKey) {
        if (!CollectionUtils.isEmpty(idSet)) {
            idSet.remove(0L);
            if (idSet.size() > 1) {
                filters.add(new QFilter(qfilterKey, "in", idSet));
            } else if (idSet.size() == 1) {
                filters.add(new QFilter(qfilterKey, "=", (Object)idSet.iterator().next()));
            }
        }
    }
}

