/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ococic.business.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.fulltext.QMatches;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.occ.ocbase.business.helper.ResourcePermHelper;
import kd.occ.ocbase.common.entity.ResourcePermInvAccResult;
import kd.occ.ococic.business.helper.AvailableInventoryHelper;
import kd.occ.ococic.business.helper.UnitConvertHelper;
import kd.occ.ococic.pojo.AvailableInventoryParamVO;
import kd.occ.ococic.util.CommonUtils;

public class ResourcePermInventoryHelper {
    private static final String STOCKTYPENAME = "channelstocktypeid.name";

    public static List<ResourcePermInvAccResult> queryAvailableInventory(String searchValue, String searchFields, List<Long> channelIds, List<Long> resourceStockIdList) {
        DynamicObjectCollection resourceStockDoColl = ResourcePermHelper.queryResourcePermResourceStockDoColl(channelIds, resourceStockIdList);
        if (CollectionUtils.isEmpty((Collection)resourceStockDoColl)) {
            return new ArrayList<ResourcePermInvAccResult>(0);
        }
        List<ResourcePermInvAccResult> resourcePermInvAccList = ResourcePermInventoryHelper.queryAvailableInventory(searchValue, searchFields, resourceStockDoColl);
        return resourcePermInvAccList;
    }

    private static List<ResourcePermInvAccResult> queryAvailableInventory(String searchValue, String searchFields, DynamicObjectCollection resourceStockDoColl) {
        Map<Long, List<DynamicObject>> itemDynObjMap;
        ArrayList<ResourcePermInvAccResult> resourcePermInvAccList = new ArrayList<ResourcePermInvAccResult>(0);
        if (CollectionUtils.isEmpty((Collection)resourceStockDoColl)) {
            return resourcePermInvAccList;
        }
        Set<DynamicObject> itemDynObjSet = ResourcePermInventoryHelper.queryItemDynObjSet(resourceStockDoColl, searchValue, searchFields, true);
        DataSet availableInvDataSet = ResourcePermInventoryHelper.queryScmAvailableInventory(resourceStockDoColl, itemDynObjSet);
        Set<DynamicObject> channelItemDynObjSet = ResourcePermInventoryHelper.queryItemDynObjSet(resourceStockDoColl, searchValue, searchFields, false);
        DataSet channelinvaccDataSet = ResourcePermInventoryHelper.queryChannelInventory(resourceStockDoColl, channelItemDynObjSet);
        if (availableInvDataSet != null) {
            itemDynObjMap = itemDynObjSet.stream().collect(Collectors.groupingBy(obj -> obj.getLong("material")));
            ResourcePermInventoryHelper.appendAvailableInvDataSet(resourcePermInvAccList, availableInvDataSet, resourceStockDoColl, itemDynObjMap);
        }
        if (channelinvaccDataSet != null) {
            itemDynObjMap = itemDynObjSet.stream().collect(Collectors.groupingBy(obj -> obj.getLong("id")));
            ResourcePermInventoryHelper.appendChannelinvaccDataSet(resourcePermInvAccList, channelinvaccDataSet, resourceStockDoColl, itemDynObjMap);
        }
        return resourcePermInvAccList;
    }

    private static Set<DynamicObject> queryItemDynObjSet(DynamicObjectCollection resourceStockColl, String searchValue, String searchFields, boolean isByScm) {
        String selectFileds = String.join((CharSequence)",", "id", "material", "stockunit", "baseunit");
        if (StringUtils.isNotEmpty((CharSequence)searchValue)) {
            QFilter filter = new QFilter("enable", "=", (Object)"1");
            filter.and(QMatches.ftlike((String[])new String[]{searchValue}, (String[])new String[]{searchFields}));
            DynamicObjectCollection itemDynObjColl = QueryServiceHelper.query((String)"ocdbd_iteminfo", (String)selectFileds, (QFilter[])filter.toArray());
            if (CollectionUtils.isEmpty((Collection)itemDynObjColl)) {
                return new HashSet<DynamicObject>(0);
            }
            HashSet<DynamicObject> itemDynObjSet = new HashSet<DynamicObject>(itemDynObjColl.size());
            itemDynObjSet.addAll((Collection<DynamicObject>)itemDynObjColl);
            return itemDynObjSet;
        }
        int count = resourceStockColl.size();
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(count);
        HashSet<Long> channelIdSet = new HashSet<Long>(count);
        for (int i = 0; i < count; ++i) {
            if (isByScm) {
                long stockOrgId = ((DynamicObject)resourceStockColl.get(i)).getLong("stockorg");
                if (stockOrgId <= 0L) continue;
                filterList.add(BaseDataServiceHelper.getBaseDataFilter((String)"ocdbd_iteminfo", (Long)stockOrgId));
                continue;
            }
            long channelId = ((DynamicObject)resourceStockColl.get(i)).getLong("channel");
            if (channelId <= 0L) continue;
            channelIdSet.add(channelId);
        }
        if (!isByScm && !CommonUtils.isNull(channelIdSet)) {
            QFilter qFilter = new QFilter("id", "in", channelIdSet);
            DynamicObjectCollection channelDynObjColl = QueryServiceHelper.query((String)"ocdbd_channel", (String)"saleorg", (QFilter[])qFilter.toArray());
            HashSet<Long> bizgroupIdSet = new HashSet<Long>(channelDynObjColl.size());
            for (DynamicObject dynamicObject : channelDynObjColl) {
                long bizgroupId = dynamicObject.getLong("saleorg");
                if (!bizgroupIdSet.add(bizgroupId)) continue;
                filterList.add(BaseDataServiceHelper.getBaseDataFilter((String)"ocdbd_iteminfo", (Long)bizgroupId));
            }
        }
        HashSet<Object> itemDynObjSet = new HashSet<DynamicObject>(0);
        if (filterList.size() > 0) {
            DynamicObjectCollection itemDynObjColl = QueryServiceHelper.query((String)"ocdbd_iteminfo", (String)selectFileds, (QFilter[])((QFilter)filterList.get(0)).toArray());
            itemDynObjSet = new HashSet(itemDynObjColl.size() * filterList.size());
            itemDynObjSet.addAll((Collection<DynamicObject>)itemDynObjColl);
            int size = filterList.size();
            for (int i = 1; i < size; ++i) {
                Set itemIdSet = itemDynObjSet.stream().map(obj -> obj.getLong("id")).collect(Collectors.toSet());
                itemDynObjColl = QueryServiceHelper.query((String)"ocdbd_iteminfo", (String)selectFileds, (QFilter[])((QFilter)filterList.get(i)).toArray());
                for (DynamicObject itemDynObj : itemDynObjColl) {
                    if (itemIdSet.contains(itemDynObj.getLong("id"))) continue;
                    itemDynObjSet.add(itemDynObj);
                }
            }
        }
        return itemDynObjSet;
    }

    private static DataSet queryScmAvailableInventory(DynamicObjectCollection resourceStockColl, Set<DynamicObject> itemDynObjSet) {
        AvailableInventoryParamVO availableInvParamVO = new AvailableInventoryParamVO();
        for (DynamicObject resourceStockDynObj : resourceStockColl) {
            if (resourceStockDynObj.getLong("stockorg") <= 0L) continue;
            availableInvParamVO.getStockOrgIdSet().add(resourceStockDynObj.getLong("stockorg"));
            availableInvParamVO.getWarehouseIdSet().add(resourceStockDynObj.getLong("stock"));
        }
        for (DynamicObject itemDynObj : itemDynObjSet) {
            availableInvParamVO.getMaterialIdSet().add(itemDynObj.getLong("material"));
        }
        return AvailableInventoryHelper.queryScmAvailableInventory(availableInvParamVO);
    }

    private static DataSet queryChannelInventory(DynamicObjectCollection resourceStockColl, Set<DynamicObject> channelItemDynObjSet) {
        HashSet<Long> channelIdSet = new HashSet<Long>(resourceStockColl.size());
        HashSet<Long> channelStockIdSet = new HashSet<Long>(resourceStockColl.size());
        int size = resourceStockColl.size();
        for (int i = 0; i < size; ++i) {
            long channelId = ((DynamicObject)resourceStockColl.get(i)).getLong("channel");
            long channelStockId = ((DynamicObject)resourceStockColl.get(i)).getLong("warehouse");
            if (channelId > 0L) {
                channelIdSet.add(channelId);
            }
            if (channelStockId <= 0L) continue;
            channelStockIdSet.add(channelStockId);
        }
        if (channelIdSet.size() > 0 && channelStockIdSet.size() > 0 && !CommonUtils.isNull(channelItemDynObjSet)) {
            QFilter channelFilter = new QFilter("channelid", "in", (Object)resourceStockColl.stream().map(obj -> obj.getLong("channel")).toArray());
            QFilter stockIdFilter = new QFilter("channelstockid", "in", (Object)resourceStockColl.stream().map(obj -> obj.getLong("warehouse")).toArray());
            QFilter itemIdFilter = new QFilter("itemid", "in", (Object)channelItemDynObjSet.stream().map(obj -> obj.getLong("id")).toArray());
            String selectFields = String.join((CharSequence)",", "channelid", "channelstockid", "channelstockid.erpwarehouseid", "itemid", "auxptyid", "channelstocktypeid", STOCKTYPENAME, "baseunitid", "baseqty", "stockunitid", "stockqty");
            return QueryServiceHelper.queryDataSet((String)ResourcePermInventoryHelper.class.getName(), (String)"ococic_channelinvacc", (String)selectFields, (QFilter[])new QFilter[]{channelFilter, stockIdFilter, itemIdFilter}, (String)"");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void appendAvailableInvDataSet(List<ResourcePermInvAccResult> resourcePermInvAccList, DataSet invDataSet, DynamicObjectCollection resourceStockColl, Map<Long, List<DynamicObject>> itemDynObjMap) {
        Map<String, List<DynamicObject>> resourceStockMap = resourceStockColl.stream().collect(Collectors.groupingBy(obj -> obj.getLong("stockorg") + "_" + obj.getLong("stock")));
        try {
            Row dataSetRow = null;
            long materialId = 0L;
            while (invDataSet.hasNext()) {
                dataSetRow = invDataSet.next();
                List<DynamicObject> resourceStockObjList = resourceStockMap.get(dataSetRow.getLong("stockorgid") + "_" + dataSetRow.getLong("warehouseid"));
                materialId = dataSetRow.getLong("materialid");
                List<DynamicObject> itemObjList = itemDynObjMap.get(materialId);
                if (CommonUtils.isNull(resourceStockObjList)) continue;
                for (DynamicObject resourceStockObj : resourceStockObjList) {
                    for (DynamicObject itemObj : itemObjList) {
                        BigDecimal baseQty = dataSetRow.getBigDecimal("baseqty");
                        long unitId = itemObj.getLong("stockunit");
                        long baseUnitId = dataSetRow.getLong("baseunitid");
                        BigDecimal reserveBaseQty = dataSetRow.getBigDecimal("reservebaseqty");
                        BigDecimal avbBaseQty = dataSetRow.getBigDecimal("avbbaseqty");
                        ResourcePermInvAccResult resourcePermInvAccResult = new ResourcePermInvAccResult();
                        resourcePermInvAccResult.setResourceStockId(resourceStockObj.getLong("id"));
                        resourcePermInvAccResult.setResourceClassId(resourceStockObj.getLong("resourceclass"));
                        resourcePermInvAccResult.setWarehouseId(dataSetRow.getLong("warehouseid").longValue());
                        resourcePermInvAccResult.setItemId(itemObj.getLong("id"));
                        resourcePermInvAccResult.setMaterialId(materialId);
                        resourcePermInvAccResult.setAuxptyId(dataSetRow.getLong("auxptyid").longValue());
                        resourcePermInvAccResult.setBaseUnitId(baseUnitId);
                        resourcePermInvAccResult.setUnitId(itemObj.getLong("stockunit"));
                        resourcePermInvAccResult.setInvTypeId(dataSetRow.getLong("invtypeid").longValue());
                        resourcePermInvAccResult.setInvTypeName(dataSetRow.getString("invtypename"));
                        resourcePermInvAccResult.setQty(UnitConvertHelper.calculateDestQty(baseQty, materialId, baseUnitId, unitId));
                        resourcePermInvAccResult.setReserveQty(UnitConvertHelper.calculateDestQty(reserveBaseQty, materialId, baseUnitId, unitId));
                        resourcePermInvAccResult.setAvbQty(UnitConvertHelper.calculateDestQty(avbBaseQty, materialId, baseUnitId, unitId));
                        resourcePermInvAccResult.setBaseQty(baseQty);
                        resourcePermInvAccResult.setReserveBaseQty(reserveBaseQty);
                        resourcePermInvAccResult.setAvbBaseQty(avbBaseQty);
                        resourcePermInvAccList.add(resourcePermInvAccResult);
                    }
                }
            }
        }
        finally {
            invDataSet.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void appendChannelinvaccDataSet(List<ResourcePermInvAccResult> resourcePermInvAccList, DataSet invDataSet, DynamicObjectCollection resourceStockColl, Map<Long, List<DynamicObject>> itemDynObjMap) {
        Map<String, List<DynamicObject>> resourceStockMap = resourceStockColl.stream().collect(Collectors.groupingBy(obj -> obj.getLong("channel") + "_" + obj.getLong("warehouse")));
        try {
            Row dataSetRow = null;
            long materialId = 0L;
            while (invDataSet.hasNext()) {
                dataSetRow = invDataSet.next();
                List<DynamicObject> resourceStockObjList = resourceStockMap.get(dataSetRow.getLong("channelid") + "_" + dataSetRow.getLong("channelstockid"));
                long itemId = dataSetRow.getLong("itemid");
                if (itemDynObjMap.get(itemId) != null) {
                    materialId = itemDynObjMap.get(itemId).get(0).getLong("material");
                }
                if (CommonUtils.isNull(resourceStockObjList)) continue;
                for (DynamicObject resourceStockObj : resourceStockObjList) {
                    ResourcePermInvAccResult resourcePermInvAccResult = new ResourcePermInvAccResult();
                    resourcePermInvAccResult.setResourceStockId(resourceStockObj.getLong("id"));
                    resourcePermInvAccResult.setResourceClassId(resourceStockObj.getLong("resourceclass"));
                    resourcePermInvAccResult.setWarehouseId(dataSetRow.getLong("channelstockid.erpwarehouseid").longValue());
                    resourcePermInvAccResult.setOcWarehouseId(dataSetRow.getLong("channelstockid").longValue());
                    resourcePermInvAccResult.setItemId(dataSetRow.getLong("itemid").longValue());
                    resourcePermInvAccResult.setMaterialId(materialId);
                    resourcePermInvAccResult.setAuxptyId(dataSetRow.getLong("auxptyid").longValue());
                    resourcePermInvAccResult.setBaseUnitId(dataSetRow.getLong("baseunitid").longValue());
                    resourcePermInvAccResult.setUnitId(dataSetRow.getLong("stockunitid").longValue());
                    resourcePermInvAccResult.setInvTypeId(dataSetRow.getLong("channelstocktypeid").longValue());
                    resourcePermInvAccResult.setInvTypeName(dataSetRow.getString(STOCKTYPENAME));
                    resourcePermInvAccResult.setQty(dataSetRow.getBigDecimal("stockqty"));
                    resourcePermInvAccResult.setReserveQty(BigDecimal.ZERO);
                    resourcePermInvAccResult.setAvbQty(dataSetRow.getBigDecimal("stockqty"));
                    resourcePermInvAccResult.setBaseQty(dataSetRow.getBigDecimal("baseqty"));
                    resourcePermInvAccResult.setReserveBaseQty(BigDecimal.ZERO);
                    resourcePermInvAccResult.setAvbBaseQty(dataSetRow.getBigDecimal("baseqty"));
                    resourcePermInvAccList.add(resourcePermInvAccResult);
                }
            }
        }
        finally {
            invDataSet.close();
        }
    }
}

