/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ococic.business.helper;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.occ.ocbase.business.helper.BizServiceHelper;
import kd.occ.ocbase.common.pojo.ocic.ScmcInvAccQueryParam;
import kd.occ.ocbase.common.pojo.ocic.ScmcInvAccQueryResult;
import kd.occ.ococic.util.CommonUtils;
import kd.occ.ococic.util.StringUtils;

public class ScmcInvAccQueryHelper {
    private static Log logger = LogFactory.getLog(ScmcInvAccQueryHelper.class);

    public static List<Map<String, Object>> invAccQueryExtForInner(ScmcInvAccQueryParam param) {
        ArrayList invAccQueryDataList = BizServiceHelper.scmcInvAccQuery(ScmcInvAccQueryHelper.buildScmcInvAccQueryParamsMap(param));
        logger.info("\u4f9b\u5e94\u94fe\u5373\u65f6\u5e93\u5b58\u56de\u53c2\uff1a" + JSONObject.toJSONString((Object)invAccQueryDataList));
        if (CommonUtils.isNull((Object)invAccQueryDataList)) {
            invAccQueryDataList = new ArrayList(0);
        }
        return invAccQueryDataList;
    }

    public static final List<ScmcInvAccQueryResult> scmcInvAccQuery(ScmcInvAccQueryParam param, String ... groupbyField) {
        List<Map<String, Object>> invAccQueryDataList = ScmcInvAccQueryHelper.invAccQueryExtForInner(param);
        return ScmcInvAccQueryHelper.buildInvAccQueryExtForInnerDataSet(invAccQueryDataList, groupbyField);
    }

    private static List<ScmcInvAccQueryResult> buildInvAccQueryExtForInnerDataSet(List<Map<String, Object>> invAccQueryDataList, String ... groupbyFields) {
        List<Object> groupbyFieldList;
        ArrayList<ScmcInvAccQueryResult> results = new ArrayList<ScmcInvAccQueryResult>(invAccQueryDataList.size());
        if (groupbyFields == null || groupbyFields.length == 0) {
            groupbyFieldList = new ArrayList(7);
            groupbyFieldList.add("org");
            groupbyFieldList.add("warehouse");
            groupbyFieldList.add("material");
            groupbyFieldList.add("auxpty");
            groupbyFieldList.add("invtype");
            groupbyFieldList.add("keeper");
            groupbyFieldList.add("owner");
            groupbyFields = (String[])groupbyFieldList.stream().toArray(String[]::new);
        }
        groupbyFieldList = Arrays.asList(groupbyFields);
        Map<String, List<Map>> invAccQueryDataGroupByMap = invAccQueryDataList.stream().collect(Collectors.groupingBy(invAccQueryData -> StringUtils.join((CharSequence)"_", (Object[])groupbyFieldList.stream().map(groupbyField -> invAccQueryData.get(groupbyField)).toArray())));
        for (List<Map> invAccQueryDatas : invAccQueryDataGroupByMap.values()) {
            ScmcInvAccQueryResult result = new ScmcInvAccQueryResult();
            for (Map invAccQueryData2 : invAccQueryDatas) {
                if (groupbyFieldList.contains("org")) {
                    result.setStockOrgId(((Long)invAccQueryData2.get("org")).longValue());
                }
                if (groupbyFieldList.contains("warehouse")) {
                    result.setWarehouseId(((Long)invAccQueryData2.get("warehouse")).longValue());
                }
                if (groupbyFieldList.contains("material")) {
                    result.setMaterialId(((Long)invAccQueryData2.get("material")).longValue());
                }
                if (groupbyFieldList.contains("auxpty")) {
                    result.setAuxptyId(((Long)invAccQueryData2.get("auxpty")).longValue());
                }
                if (groupbyFieldList.contains("invtype")) {
                    result.setInvTypeId(((Long)invAccQueryData2.get("invtype")).longValue());
                }
                if (groupbyFieldList.contains("keeper")) {
                    result.setKeeperId(((Long)invAccQueryData2.get("keeper")).longValue());
                    result.setKeeperType((String)invAccQueryData2.get("keepertype"));
                }
                if (groupbyFieldList.contains("owner")) {
                    result.setOwnerId(((Long)invAccQueryData2.get("owner")).longValue());
                    result.setOwnerType((String)invAccQueryData2.get("ownertype"));
                }
                result.setUnitId(((Long)invAccQueryData2.get("unit")).longValue());
                result.setQty(result.getQty().add(new BigDecimal(invAccQueryData2.get("qty").toString())));
                result.setReserveQty(result.getReserveQty().add(new BigDecimal(invAccQueryData2.get("reserveqty").toString())));
                result.setAvbbQty(result.getAvbbQty().add(new BigDecimal(invAccQueryData2.get("avbbqty").toString())));
                result.setBaseUnitId(((Long)invAccQueryData2.get("baseunit")).longValue());
                result.setBaseQty(result.getBaseQty().add(new BigDecimal(invAccQueryData2.get("baseqty").toString())));
                result.setReserveBaseQty(result.getReserveBaseQty().add(new BigDecimal(invAccQueryData2.get("reservoeqty").toString())));
                result.setAvbbBaseQty(result.getAvbbBaseQty().add(new BigDecimal(invAccQueryData2.get("avbbaseqty").toString())));
            }
            results.add(result);
        }
        return results;
    }

    private static Map<String, Object> buildScmcInvAccQueryParamsMap(ScmcInvAccQueryParam param) {
        LinkedHashMap<String, Object> paramsDataMap = new LinkedHashMap<String, Object>(6);
        ScmcInvAccQueryHelper.putParamsDataMap(paramsDataMap, "org", param.getStockOrgIdSet());
        ScmcInvAccQueryHelper.putParamsDataMap(paramsDataMap, "warehouse", param.getWarehouseIdSet());
        ScmcInvAccQueryHelper.putParamsDataMap(paramsDataMap, "material", param.getMaterialIdSet());
        ScmcInvAccQueryHelper.putParamsDataMap(paramsDataMap, "auxpty", param.getAuxPtyIdSet());
        ScmcInvAccQueryHelper.putParamsDataMap(paramsDataMap, "baseunit", param.getBaseUnitIdSet());
        ScmcInvAccQueryHelper.putParamsDataMap(paramsDataMap, "invtype", param.getInvTypeIdSet());
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(1);
        paramsMap.put("data", paramsDataMap);
        logger.info("\u4f9b\u5e94\u94fe\u5373\u65f6\u5e93\u5b58\u4f20\u53c2\uff1a" + JSONObject.toJSONString(paramsMap));
        return paramsMap;
    }

    private static void putParamsDataMap(LinkedHashMap<String, Object> paramsDataMap, String paramsDataMapKey, Set<Long> idSet) {
        if (!CollectionUtils.isEmpty(idSet)) {
            if (idSet.size() > 1) {
                idSet.remove(0L);
            }
            LinkedHashMap<String, Set<Long>> idMap = new LinkedHashMap<String, Set<Long>>(1);
            idMap.put("id", idSet);
            paramsDataMap.put(paramsDataMapKey, idMap);
        }
    }
}

