/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ococic.business.sharedinventory;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.pojo.ocic.ScmcInvAccQueryParam;
import kd.occ.ococic.business.helper.ScmcInvAccQueryHelper;
import kd.occ.ococic.business.sharedinventory.AvailableInventoryService;
import kd.occ.ococic.pojo.AvailableInventoryParamVO;
import kd.occ.ococic.pojo.AvailableInventoryResultVO;
import kd.occ.ococic.util.CommonUtils;
import kd.occ.ococic.util.StringUtils;

public class AvailableInventoryServiceImpl
implements AvailableInventoryService {
    @Override
    public DataSet queryScmAvailableInventory(AvailableInventoryParamVO availableInvParamVO) {
        if (availableInvParamVO == null || CommonUtils.isNull((Object)availableInvParamVO.getStockOrgIdSet()) || CommonUtils.isNull((Object)availableInvParamVO.getMaterialIdSet()) || CommonUtils.isNull((Object)availableInvParamVO.getWarehouseIdSet())) {
            return null;
        }
        ScmcInvAccQueryParam param = new ScmcInvAccQueryParam(availableInvParamVO.getStockOrgIdSet(), availableInvParamVO.getWarehouseIdSet(), availableInvParamVO.getMaterialIdSet());
        param.setAuxPtyIdSet(availableInvParamVO.getAuxPtyIDSet());
        param.setInvTypeIdSet(availableInvParamVO.getInvTypeIdSet());
        param.setBaseUnitIdSet(availableInvParamVO.getBaseUnitIDSet());
        List<Map<String, Object>> invAccQueryDataList = ScmcInvAccQueryHelper.invAccQueryExtForInner(param);
        return this.getSumMatchAvailableInvDataSet(invAccQueryDataList);
    }

    private DataSet getSumMatchAvailableInvDataSet(List<Map<String, Object>> invAccQueryDataList) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        fieldList.add(new Field("stockorgid", (DataType)DataType.LongType));
        fieldList.add(new Field("warehouseid", (DataType)DataType.LongType));
        fieldList.add(new Field("materialid", (DataType)DataType.LongType));
        fieldList.add(new Field("auxptyid", (DataType)DataType.LongType));
        fieldList.add(new Field("baseunitid", (DataType)DataType.LongType));
        fieldList.add(new Field("avbbaseqty", (DataType)DataType.BigDecimalType));
        fieldList.add(new Field("invtypeid", (DataType)DataType.LongType));
        fieldList.add(new Field("invtypename", (DataType)DataType.StringType));
        fieldList.add(new Field("baseqty", (DataType)DataType.BigDecimalType));
        fieldList.add(new Field("reservebaseqty", (DataType)DataType.BigDecimalType));
        fieldList.add(new Field("keepertype", (DataType)DataType.StringType));
        fieldList.add(new Field("keeperid", (DataType)DataType.LongType));
        fieldList.add(new Field("ownertype", (DataType)DataType.StringType));
        fieldList.add(new Field("ownerid", (DataType)DataType.LongType));
        RowMeta rowMeta = new RowMeta(fieldList.toArray(new Field[fieldList.size()]));
        DataSetBuilder dataSetBuilder = Algo.create((String)"invAccQueryData").createDataSetBuilder(rowMeta);
        Object[] invtypeId = invAccQueryDataList.stream().map(dataMap -> dataMap.get("invtype")).toArray();
        QFilter filter = new QFilter("id", "in", (Object)invtypeId);
        DynamicObjectCollection invTypeColl = QueryServiceHelper.query((String)"bd_invtype", (String)String.join((CharSequence)",", "id", "name"), (QFilter[])filter.toArray());
        Map<Long, List<DynamicObject>> invTypeMap = invTypeColl.stream().collect(Collectors.groupingBy(obj -> obj.getLong("id")));
        Map<String, List<Map>> invAccQueryDataMap = invAccQueryDataList.stream().collect(Collectors.groupingBy(obj -> StringUtils.join((CharSequence)"_", (Object[])new Object[]{obj.get("material"), obj.get("auxpty"), obj.get("baseunit"), obj.get("org"), obj.get("warehouse"), obj.get("invtype")})));
        for (Map.Entry<String, List<Map>> dataEntry : invAccQueryDataMap.entrySet()) {
            Map dataMap2 = dataEntry.getValue().get(0);
            BigDecimal sumBaseQty = BigDecimal.valueOf(dataEntry.getValue().stream().mapToDouble(obj -> Double.parseDouble(obj.get("baseqty").toString())).sum());
            BigDecimal sumAvbBaseQty = BigDecimal.valueOf(dataEntry.getValue().stream().mapToDouble(obj -> Double.parseDouble(obj.get("avbbaseqty").toString())).sum());
            BigDecimal sumReserveBaseQty = BigDecimal.valueOf(dataEntry.getValue().stream().mapToDouble(obj -> Double.parseDouble(obj.get("reservoeqty").toString())).sum());
            long invTypeId = Long.parseLong(dataMap2.get("invtype").toString());
            dataSetBuilder.append(new Object[]{dataMap2.get("org"), dataMap2.get("warehouse"), dataMap2.get("material"), dataMap2.get("auxpty"), dataMap2.get("baseunit"), sumAvbBaseQty, invTypeId, invTypeMap.get(invTypeId) == null ? "" : invTypeMap.get(invTypeId).get(0).getString("name"), sumBaseQty, sumReserveBaseQty, dataMap2.get("keepertype"), dataMap2.get("keeper"), dataMap2.get("ownertype"), dataMap2.get("owner")});
        }
        DataSet availableInvDataSet = dataSetBuilder.build();
        return availableInvDataSet;
    }

    private DataSet getMatchAvailableInvDataSet(List<Map<String, Object>> invAccQueryDataList) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        fieldList.add(new Field("stockorgid", (DataType)DataType.LongType));
        fieldList.add(new Field("warehouseid", (DataType)DataType.LongType));
        fieldList.add(new Field("materialid", (DataType)DataType.LongType));
        fieldList.add(new Field("auxptyid", (DataType)DataType.LongType));
        fieldList.add(new Field("baseunitid", (DataType)DataType.LongType));
        fieldList.add(new Field("avbbaseqty", (DataType)DataType.BigDecimalType));
        fieldList.add(new Field("invtypeid", (DataType)DataType.LongType));
        fieldList.add(new Field("invtypename", (DataType)DataType.StringType));
        fieldList.add(new Field("unitid", (DataType)DataType.LongType));
        fieldList.add(new Field("qty", (DataType)DataType.BigDecimalType));
        fieldList.add(new Field("reserveqty", (DataType)DataType.BigDecimalType));
        fieldList.add(new Field("avbqty", (DataType)DataType.BigDecimalType));
        fieldList.add(new Field("baseqty", (DataType)DataType.BigDecimalType));
        fieldList.add(new Field("reservebaseqty", (DataType)DataType.BigDecimalType));
        RowMeta rowMeta = new RowMeta(fieldList.toArray(new Field[fieldList.size()]));
        DataSetBuilder dataSetBuilder = Algo.create((String)"invAccQueryData").createDataSetBuilder(rowMeta);
        Object[] invtypeId = invAccQueryDataList.stream().map(dataMap -> dataMap.get("invtype")).toArray();
        QFilter filter = new QFilter("id", "in", (Object)invtypeId);
        DynamicObjectCollection invTypeColl = QueryServiceHelper.query((String)"bd_invtype", (String)String.join((CharSequence)",", "id", "name"), (QFilter[])filter.toArray());
        Map<Long, List<DynamicObject>> invTypeMap = invTypeColl.stream().collect(Collectors.groupingBy(obj -> obj.getLong("id")));
        for (Map<String, Object> dataMap2 : invAccQueryDataList) {
            long invTypeId = Long.parseLong(dataMap2.get("invtype").toString());
            dataSetBuilder.append(new Object[]{dataMap2.get("org"), dataMap2.get("warehouse"), dataMap2.get("material"), dataMap2.get("auxpty"), dataMap2.get("baseunit"), dataMap2.get("avbbaseqty"), invTypeId, invTypeMap.get(invTypeId).get(0).getString("name"), dataMap2.get("unit"), dataMap2.get("qty"), dataMap2.get("reserveqty"), dataMap2.get("avbbqty"), dataMap2.get("baseqty"), dataMap2.get("reservoeqty")});
        }
        DataSet availableInvDataSet = dataSetBuilder.build();
        return availableInvDataSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AvailableInventoryResultVO> queryAvailableInventory(long stockOrgId, long warehosueId, Set<Long> itemIdSet) {
        if (CommonUtils.isNull(itemIdSet) || stockOrgId == 0L) {
            return new ArrayList<AvailableInventoryResultVO>(0);
        }
        ArrayList<AvailableInventoryResultVO> availableInvResultVOList = new ArrayList<AvailableInventoryResultVO>(itemIdSet.size());
        QFilter qfilter = new QFilter("id", "in", itemIdSet);
        DynamicObjectCollection itemDynColl = QueryServiceHelper.query((String)"ocdbd_iteminfo", (String)"id,material", (QFilter[])qfilter.toArray());
        if (!CommonUtils.isNull((Object)itemDynColl)) {
            Set materialIdSet = itemDynColl.stream().map(obj -> obj.getLong("material")).collect(Collectors.toSet());
            HashSet<Long> stockOrgIdSet = new HashSet<Long>(1);
            stockOrgIdSet.add(stockOrgId);
            HashSet<Long> warehouseIdSet = new HashSet<Long>(1);
            warehouseIdSet.add(warehosueId);
            ScmcInvAccQueryParam param = new ScmcInvAccQueryParam(stockOrgIdSet, warehouseIdSet, materialIdSet);
            List<Map<String, Object>> invAccQueryDataList = ScmcInvAccQueryHelper.invAccQueryExtForInner(param);
            if (CommonUtils.isNull(invAccQueryDataList)) {
                return availableInvResultVOList;
            }
            try (DataSet availableInvDataSet = this.getMatchAvailableInvDataSet(invAccQueryDataList);){
                Row availableInvRow = null;
                Map<Long, List<DynamicObject>> itemDynCollMap = itemDynColl.stream().collect(Collectors.groupingBy(obj -> obj.getLong("material")));
                while (availableInvDataSet.hasNext()) {
                    availableInvRow = availableInvDataSet.next();
                    Long materialId = availableInvRow.getLong("materialid");
                    if (itemDynCollMap.get(materialId) == null) continue;
                    for (DynamicObject itemDynObj : itemDynCollMap.get(materialId)) {
                        AvailableInventoryResultVO invResultVO = new AvailableInventoryResultVO();
                        invResultVO.setItemId(itemDynObj.getLong("id"));
                        invResultVO.setInvTypeId(availableInvRow.getLong("invtypeid").longValue());
                        invResultVO.setStockOrgId(availableInvRow.getLong("stockorgid").longValue());
                        invResultVO.setWarehouseId(availableInvRow.getLong("warehouseid").longValue());
                        invResultVO.setAuxptyId(availableInvRow.getLong("auxptyid").longValue());
                        invResultVO.setUnitId(availableInvRow.getLong("unitid").longValue());
                        invResultVO.setQty(availableInvRow.getBigDecimal("qty"));
                        invResultVO.setReserveQty(availableInvRow.getBigDecimal("reserveqty"));
                        invResultVO.setAvbQty(availableInvRow.getBigDecimal("avbqty"));
                        availableInvResultVOList.add(invResultVO);
                    }
                }
            }
        }
        return availableInvResultVOList;
    }
}

