/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ococic.business.sharedinventory;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ococic.business.sharedinventory.OverSalePolicyService;
import kd.occ.ococic.pojo.OccupancyPolicyParamVO;
import kd.occ.ococic.pojo.OccupancyPolicyResultVO;
import kd.occ.ococic.pojo.OverSalePolicyParamVO;
import kd.occ.ococic.pojo.OverSalePolicyResultVO;
import kd.occ.ococic.util.CommonUtils;

public class OverSalePolicyServiceImpl
implements OverSalePolicyService {
    private static final String[] policyFieldsStr = new String[]{"id", "entryid", "iscontrol", "unit", "baseunitid", "alwoversaleqty", "oversaledqty", "canoversaleqty", "alwoversalebaseqty", "oversaledbaseqty", "canoversalebaseqty", "invtype", "exparrdate", "auditdate", "begindt", "enddt"};

    @Override
    public List<OverSalePolicyResultVO> matchOverSalePolicy(List<OverSalePolicyParamVO> policyParamVOList) {
        if (CommonUtils.isNull(policyParamVOList)) {
            return new ArrayList<OverSalePolicyResultVO>(0);
        }
        ArrayList<OverSalePolicyResultVO> salePolicyResultList = new ArrayList<OverSalePolicyResultVO>(policyParamVOList.size());
        DataSet salePolicyDataSet = this.getSalePolicyDataSet(policyParamVOList);
        DataSet matchPolicyDataSet = this.getMatchPolicyDataSet(policyParamVOList, salePolicyDataSet);
        while (matchPolicyDataSet.hasNext()) {
            boolean isExistPolicy;
            Row matchPolicyRow = matchPolicyDataSet.next();
            List<String> fieldList = Arrays.asList(matchPolicyDataSet.getRowMeta().getFieldNames());
            if (fieldList.size() == 17 || !fieldList.contains("id") || matchPolicyRow.get("id") == null) {
                isExistPolicy = false;
            } else {
                String source = matchPolicyRow.getString("source");
                boolean bl = isExistPolicy = matchPolicyRow.getDate("bizdate").compareTo(matchPolicyRow.getDate("begindt")) >= 0 && matchPolicyRow.getDate("bizdate").compareTo(matchPolicyRow.getDate("enddt")) <= 0;
                if (!StringUtils.equals((CharSequence)source, (CharSequence)"1")) {
                    isExistPolicy = isExistPolicy && matchPolicyRow.getDate("deliverydate").compareTo(matchPolicyRow.getDate("exparrdate")) >= 0;
                }
            }
            salePolicyResultList.add(this.getSalePolicyResultVo(matchPolicyRow, isExistPolicy));
        }
        return salePolicyResultList;
    }

    private DataSet getSalePolicyDataSet(List<OverSalePolicyParamVO> policyParamVOList) {
        String ruleSelectedFields = String.join((CharSequence)",", "id", "auditdate", this.joinSelectField("resoustockid", "stockorg"), this.joinSelectField("resoustockid", "stock"), "shopscope", this.joinSelectField("shopscopeentity", "shopid"), String.join((CharSequence)".", "policyentity", "id") + " " + "entryid", this.joinSelectField("policyentity", "item"), this.joinSelectField("policyentity", "material"), this.joinSelectField("policyentity", "iscontrol"), this.joinSelectField("policyentity", "unit"), this.joinSelectField("policyentity", "baseunitid"), this.joinSelectField("policyentity", "alwoversaleqty"), this.joinSelectField("policyentity", "oversaledqty"), this.joinSelectField("policyentity", "canoversaleqty"), this.joinSelectField("policyentity", "alwoversalebaseqty"), this.joinSelectField("policyentity", "oversaledbaseqty"), this.joinSelectField("policyentity", "canoversalebaseqty"), this.joinSelectField("policyentity", "exparrdate"), this.joinSelectField("policyentity", "begindt"), this.joinSelectField("policyentity", "enddt"), this.joinSelectField("policyentity", "invtype"));
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(9);
        filterList.add(new QFilter("status", "=", (Object)"C"));
        filterList.add(new QFilter("enable", "=", (Object)"1"));
        filterList.add(new QFilter("oversaletype", "=", (Object)"1"));
        String channelIdStr = "shopscopeentity.shopid";
        QFilter channelFilter = new QFilter(channelIdStr, "in", policyParamVOList.stream().map(OverSalePolicyParamVO::getSaleChannelID).collect(Collectors.toSet()));
        channelFilter = channelFilter.or(new QFilter("shopscope", "=", (Object)"0"));
        filterList.add(channelFilter);
        filterList.add(new QFilter(String.join((CharSequence)".", "policyentity", "rowenable"), "=", (Object)"1"));
        filterList.add(new QFilter(String.join((CharSequence)".", "policyentity", "item"), "in", policyParamVOList.stream().map(OverSalePolicyParamVO::getItemId).collect(Collectors.toSet())));
        filterList.add(new QFilter(String.join((CharSequence)".", "policyentity", "material"), "in", policyParamVOList.stream().map(OverSalePolicyParamVO::getMaterialId).collect(Collectors.toSet())));
        OverSalePolicyParamVO minDeliveryDate = policyParamVOList.stream().min(Comparator.comparing(OverSalePolicyParamVO::getBizDate)).get();
        OverSalePolicyParamVO maxDeliveryDate = policyParamVOList.stream().max(Comparator.comparing(OverSalePolicyParamVO::getBizDate)).get();
        filterList.add(new QFilter(String.join((CharSequence)".", "policyentity", "begindt"), "<=", (Object)minDeliveryDate.getBizDate()));
        filterList.add(new QFilter(String.join((CharSequence)".", "policyentity", "enddt"), ">=", (Object)maxDeliveryDate.getBizDate()));
        filterList.add(new QFilter(String.join((CharSequence)".", "policyentity", "invtype"), "in", policyParamVOList.stream().map(OverSalePolicyParamVO::getInvtypeId).collect(Collectors.toSet())));
        DataSet salePolicyDataSet = QueryServiceHelper.queryDataSet((String)OverSalePolicyServiceImpl.class.getName(), (String)"ococic_oversalepolicy", (String)ruleSelectedFields, (QFilter[])filterList.toArray(new QFilter[8]), (String)"");
        return salePolicyDataSet;
    }

    private String joinSelectField(String str1, String str2) {
        return String.join((CharSequence)".", str1, str2) + " " + str2;
    }

    private DataSet getMatchPolicyDataSet(List<OverSalePolicyParamVO> policyParamVOList, DataSet salePolicyDataSet) {
        ArrayList<Field> fieldList = new ArrayList<Field>(16);
        fieldList.add(new Field("seq", (DataType)DataType.IntegerType));
        fieldList.add(new Field("saleorgid", (DataType)DataType.LongType));
        fieldList.add(new Field("salechannelid", (DataType)DataType.LongType));
        fieldList.add(new Field("itemid", (DataType)DataType.LongType));
        fieldList.add(new Field("materialid", (DataType)DataType.LongType));
        fieldList.add(new Field("billbaseunitid", (DataType)DataType.LongType));
        fieldList.add(new Field("baseunitqty", (DataType)DataType.BigDecimalType));
        fieldList.add(new Field("billunitid", (DataType)DataType.LongType));
        fieldList.add(new Field("unitqty", (DataType)DataType.BigDecimalType));
        fieldList.add(new Field("deliverydate", (DataType)DataType.DateType));
        fieldList.add(new Field("bizdate", (DataType)DataType.DateType));
        fieldList.add(new Field("stockorgid", (DataType)DataType.LongType));
        fieldList.add(new Field("stockid", (DataType)DataType.LongType));
        fieldList.add(new Field("invtypeid", (DataType)DataType.LongType));
        fieldList.add(new Field("distributionModeId", (DataType)DataType.LongType));
        fieldList.add(new Field("customerKey", (DataType)DataType.StringType));
        fieldList.add(new Field("source", (DataType)DataType.StringType));
        RowMeta rowMeta = new RowMeta(fieldList.toArray(new Field[0]));
        DataSetBuilder dataSetBuilder = Algo.create((String)"matchSalePolicyData").createDataSetBuilder(rowMeta);
        int seq = 1;
        for (OverSalePolicyParamVO policyParamVo : policyParamVOList) {
            dataSetBuilder.append(new Object[]{seq, policyParamVo.getSaleOrgId(), policyParamVo.getSaleChannelID(), policyParamVo.getItemId(), policyParamVo.getMaterialId(), policyParamVo.getBaseUnitID(), policyParamVo.getBaseUnitQty(), policyParamVo.getUnitId(), policyParamVo.getUnitQty(), policyParamVo.getDeliveryDate(), policyParamVo.getBizDate(), policyParamVo.getStockOrgId(), policyParamVo.getStockId(), policyParamVo.getInvtypeId(), policyParamVo.getDistributionModeId(), policyParamVo.getCustomerKey(), policyParamVo.getSource()});
            ++seq;
        }
        DataSet policyParamDataSet = dataSetBuilder.build();
        if (salePolicyDataSet != null && salePolicyDataSet.hasNext()) {
            DataSet copySalePolicyDataSet = salePolicyDataSet.copy();
            DataSet copySalePolicyDataSet1 = salePolicyDataSet.copy();
            DataSet matchChannelPolicyDataSet = policyParamDataSet.join(copySalePolicyDataSet.filter("shopscope='1'")).on("salechannelid", "shopid").on("itemid", "item").on("billbaseunitid", "baseunitid").on("stockorgid", "stockorg").on("stockid", "stock").on("invtypeid", "invtype").select(policyParamDataSet.getRowMeta().getFieldNames(), policyFieldsStr).finish();
            DataSet matchPolicyDataSet = policyParamDataSet.join(copySalePolicyDataSet1.filter("shopscope='0'")).on("itemid", "item").on("billbaseunitid", "baseunitid").on("stockorgid", "stockorg").on("stockid", "stock").on("invtypeid", "invtype").select(policyParamDataSet.getRowMeta().getFieldNames(), policyFieldsStr).finish();
            DataSet union = matchChannelPolicyDataSet.union(matchPolicyDataSet);
            DataSet policyDataSet = policyParamDataSet.leftJoin(union).on("seq", "seq").select(policyParamDataSet.getRowMeta().getFieldNames(), policyFieldsStr).finish();
            return policyDataSet;
        }
        return policyParamDataSet;
    }

    private OverSalePolicyResultVO getSalePolicyResultVo(Row matchPolicyRow, boolean isExistPolicy) {
        OverSalePolicyResultVO salePolicyResultVo = new OverSalePolicyResultVO();
        salePolicyResultVo.setSaleOrgId(matchPolicyRow.getLong("saleorgid").longValue());
        salePolicyResultVo.setSaleChannelId(matchPolicyRow.getLong("salechannelid").longValue());
        salePolicyResultVo.setItemId(matchPolicyRow.getLong("itemid").longValue());
        salePolicyResultVo.setMaterialId(matchPolicyRow.getLong("materialid").longValue());
        salePolicyResultVo.setBaseUnitID(matchPolicyRow.getLong("billbaseunitid").longValue());
        salePolicyResultVo.setBaseUnitQty(matchPolicyRow.getBigDecimal("baseunitqty"));
        salePolicyResultVo.setUnitId(matchPolicyRow.getLong("billunitid").longValue());
        salePolicyResultVo.setUnitQty(matchPolicyRow.getBigDecimal("unitqty"));
        salePolicyResultVo.setStockOrgId(matchPolicyRow.getLong("stockorgid").longValue());
        salePolicyResultVo.setStockId(matchPolicyRow.getLong("stockid").longValue());
        salePolicyResultVo.setInvtypeId(matchPolicyRow.getLong("invtypeid").longValue());
        salePolicyResultVo.setDistributionModeId(matchPolicyRow.getLong("distributionModeId").longValue());
        salePolicyResultVo.setCustomerKey(matchPolicyRow.getString("customerKey"));
        String status = "3";
        if (isExistPolicy) {
            salePolicyResultVo.setControlQty(Boolean.parseBoolean(matchPolicyRow.getString("iscontrol")));
            salePolicyResultVo.setPolicyUnitId(matchPolicyRow.getLong("unit").longValue());
            salePolicyResultVo.setPolicyBaseUnitID(matchPolicyRow.getLong("baseunitid").longValue());
            salePolicyResultVo.setAlwOverSaleQty(matchPolicyRow.getBigDecimal("alwoversaleqty"));
            salePolicyResultVo.setAlwOverSaleBaseQty(matchPolicyRow.getBigDecimal("alwoversalebaseqty"));
            salePolicyResultVo.setCanOverSaleQty(matchPolicyRow.getBigDecimal("canoversaleqty"));
            salePolicyResultVo.setCanOverSaleBaseQty(matchPolicyRow.getBigDecimal("canoversalebaseqty"));
            salePolicyResultVo.setOverSaledQty(matchPolicyRow.getBigDecimal("oversaledqty"));
            salePolicyResultVo.setOverSaledBaseQty(matchPolicyRow.getBigDecimal("oversaledbaseqty"));
            salePolicyResultVo.setOverSalePolicyId(matchPolicyRow.getLong("id").longValue());
            salePolicyResultVo.setOverSalePolicyEntryId(matchPolicyRow.getLong("entryid").longValue());
            salePolicyResultVo.setExparrDate(matchPolicyRow.getDate("exparrdate"));
            status = salePolicyResultVo.getBaseUnitQty().compareTo(salePolicyResultVo.getCanOverSaleBaseQty()) > 0 ? "2" : "1";
        }
        salePolicyResultVo.setInvStatus(status);
        return salePolicyResultVo;
    }

    @Override
    public List<OccupancyPolicyResultVO> occupancyOverSalePolicy(List<OccupancyPolicyParamVO> policyParamVOList) {
        if (CommonUtils.isNull(policyParamVOList)) {
            return new ArrayList<OccupancyPolicyResultVO>(0);
        }
        DataSet salePolicyDataSet = this.getOccupancySalePolicyDataSet(policyParamVOList.stream().map(OccupancyPolicyParamVO::getPolicyId).collect(Collectors.toSet()), policyParamVOList.stream().map(OccupancyPolicyParamVO::getPolicyEntryId).collect(Collectors.toSet()));
        return this.updateOverSalePolicy(policyParamVOList, salePolicyDataSet, "0");
    }

    private List<OccupancyPolicyResultVO> updateOverSalePolicy(List<OccupancyPolicyParamVO> policyParamVOList, DataSet salePolicyDataSet, String occupancyType) {
        List<OccupancyPolicyResultVO> unMatchPolicyResultVOList = this.verifySalePolicyDataSet(policyParamVOList, salePolicyDataSet);
        if (unMatchPolicyResultVOList.size() > 0) {
            ArrayList paramVOList = new ArrayList(policyParamVOList.size());
            Map<String, List<OccupancyPolicyParamVO>> policyParamVOMap = policyParamVOList.stream().collect(Collectors.groupingBy(paramVO -> StringUtils.join((Object[])new Serializable[]{"_", paramVO.getBillFormId(), Long.valueOf(paramVO.getBillId()), Long.valueOf(paramVO.getBillEntryId()), Long.valueOf(paramVO.getPolicyId()), Long.valueOf(paramVO.getPolicyEntryId()), Integer.valueOf(paramVO.getCustomerKey())})));
            for (OccupancyPolicyResultVO unMatchPolicyResult : unMatchPolicyResultVOList) {
                String key = StringUtils.join((Object[])new Serializable[]{"_", unMatchPolicyResult.getBillFormId(), Long.valueOf(unMatchPolicyResult.getBillId()), Long.valueOf(unMatchPolicyResult.getBillEntryId()), Long.valueOf(unMatchPolicyResult.getPolicyId()), Long.valueOf(unMatchPolicyResult.getPolicyEntryId()), Integer.valueOf(unMatchPolicyResult.getCustomerKey())});
                policyParamVOMap.remove(key);
            }
            policyParamVOList = new ArrayList<OccupancyPolicyParamVO>(16);
            for (List value : policyParamVOMap.values()) {
                policyParamVOList.addAll(value);
            }
        }
        if (CommonUtils.isNull(policyParamVOList)) {
            return unMatchPolicyResultVOList;
        }
        ArrayList<Object[]> sqlParams = new ArrayList<Object[]>(policyParamVOList.size());
        for (OccupancyPolicyParamVO paramVO2 : policyParamVOList) {
            Object[] sqlParamObj = new Object[]{new SqlParameter(":FOVERSALEDQTY", 3, (Object)paramVO2.getActualQty()), new SqlParameter(":FOVERSALEDBASEQTY", 3, (Object)paramVO2.getActualBaseQty()), new SqlParameter(":FCANOVERSALEQTY", 3, (Object)paramVO2.getActualQty()), new SqlParameter(":FCANOVERSALEBASEQTY", 3, (Object)paramVO2.getActualBaseQty()), new SqlParameter(":FID", -5, (Object)paramVO2.getPolicyId()), new SqlParameter(":FENTRYID", -5, (Object)paramVO2.getPolicyEntryId())};
            sqlParams.add(sqlParamObj);
        }
        String updateSql = "UPDATE T_OCDBD_OSPOLICYDTL SET FOVERSALEDQTY=FOVERSALEDQTY+?,FOVERSALEDBASEQTY=FOVERSALEDBASEQTY+?,FCANOVERSALEQTY=FCANOVERSALEQTY-?,FCANOVERSALEBASEQTY=FCANOVERSALEBASEQTY-? WHERE FID=? AND FENTRYID=?";
        DB.executeBatch((DBRoute)DBRoute.of((String)"drp"), (String)updateSql, sqlParams);
        this.saveOccupancyRecords(policyParamVOList, occupancyType);
        return unMatchPolicyResultVOList;
    }

    private List<OccupancyPolicyResultVO> verifySalePolicyDataSet(List<OccupancyPolicyParamVO> policyParamVOList, DataSet salePolicyDataSet) {
        ArrayList<OccupancyPolicyResultVO> unMatchPolicyResultVOList = new ArrayList<OccupancyPolicyResultVO>(policyParamVOList.size());
        ArrayList<Field> fieldList = new ArrayList<Field>(14);
        fieldList.add(new Field("billformid", (DataType)DataType.StringType));
        fieldList.add(new Field("billid", (DataType)DataType.LongType));
        fieldList.add(new Field("billentryid", (DataType)DataType.LongType));
        fieldList.add(new Field("billnumber", (DataType)DataType.StringType));
        fieldList.add(new Field("id", (DataType)DataType.LongType));
        fieldList.add(new Field("entryid", (DataType)DataType.LongType));
        fieldList.add(new Field("baseunitqty", (DataType)DataType.BigDecimalType));
        fieldList.add(new Field("customerKey", (DataType)DataType.IntegerType));
        RowMeta rowMeta = new RowMeta(fieldList.toArray(new Field[0]));
        DataSetBuilder dataSetBuilder = Algo.create((String)"updateSalePolicyData").createDataSetBuilder(rowMeta);
        for (OccupancyPolicyParamVO policyParamVo : policyParamVOList) {
            dataSetBuilder.append(new Object[]{policyParamVo.getBillFormId(), policyParamVo.getBillId(), policyParamVo.getBillEntryId(), policyParamVo.getBillNumber(), policyParamVo.getPolicyId(), policyParamVo.getPolicyEntryId(), policyParamVo.getActualBaseQty(), policyParamVo.getCustomerKey()});
        }
        DataSet policyParamDataSet = dataSetBuilder.build();
        if (salePolicyDataSet != null && salePolicyDataSet.hasNext()) {
            String key;
            Row policyRow;
            String[] policyFieldsStr = new String[]{"canoversalebaseqty"};
            DataSet policyDataSet = policyParamDataSet.join(salePolicyDataSet).on("id", "id").on("entryid", "entryid").select(policyParamDataSet.getRowMeta().getFieldNames(), policyFieldsStr).finish();
            HashMap<String, BigDecimal> sumActualBaseQtyMap = new HashMap<String, BigDecimal>(16);
            DataSet copyPolicyDataSet = policyDataSet.copy();
            while (copyPolicyDataSet.hasNext()) {
                policyRow = copyPolicyDataSet.next();
                key = StringUtils.join((Object[])new Serializable[]{"_", policyRow.getLong("id"), policyRow.getLong("entryid")});
                BigDecimal actualBaseQty = policyRow.getBigDecimal("baseunitqty");
                BigDecimal sumActualBaseQty = sumActualBaseQtyMap.getOrDefault(key, BigDecimal.ZERO);
                sumActualBaseQtyMap.put(key, sumActualBaseQty.add(actualBaseQty));
            }
            while (policyDataSet.hasNext()) {
                policyRow = policyDataSet.next();
                key = StringUtils.join((Object[])new Serializable[]{"_", policyRow.getLong("id"), policyRow.getLong("entryid")});
                if (((BigDecimal)sumActualBaseQtyMap.get(key)).compareTo(policyRow.getBigDecimal("canoversalebaseqty")) <= 0) continue;
                OccupancyPolicyResultVO unPolicyResultVO = new OccupancyPolicyResultVO();
                unPolicyResultVO.setBillFormId(policyRow.getString("billformid"));
                unPolicyResultVO.setBillId(policyRow.getLong("billid").longValue());
                unPolicyResultVO.setBillEntryId(policyRow.getLong("billentryid").longValue());
                unPolicyResultVO.setBillNumber(policyRow.getString("billnumber"));
                unPolicyResultVO.setPolicyId(policyRow.getLong("id").longValue());
                unPolicyResultVO.setPolicyEntryId(policyRow.getLong("entryid").longValue());
                unPolicyResultVO.setErrorMsg(ResManager.loadKDString((String)"\u8d1f\u5356\u653f\u7b56\u4e2d\u7684\u53ef\u8d1f\u5356\u91cf\u4e0d\u80fd\u5141\u8bb8\u8d1f\u6570\u91cf\uff1a\u6b64\u6b21\u8981\u66f4\u65b0\u7684\u5360\u7528\u6570\u91cf\u5927\u4e8e\u8d1f\u5356\u653f\u7b56\u4e2d\u7684\u53ef\u8d1f\u5356\u91cf\u3002", (String)"OverSalePolicyServiceImpl_0", (String)"occ-ococic-business", (Object[])new Object[0]));
                unMatchPolicyResultVOList.add(unPolicyResultVO);
            }
        }
        return unMatchPolicyResultVOList;
    }

    private void saveOccupancyRecords(List<OccupancyPolicyParamVO> policyParamVOList, String occupancyType) {
        ArrayList<DynamicObject> occupancyDynObjList = new ArrayList<DynamicObject>(policyParamVOList.size());
        Date createDate = TimeServiceHelper.now();
        String userId = RequestContext.get().getUserId();
        String ipAddress = RequestContext.get().getLoginIP();
        for (OccupancyPolicyParamVO occupancyParamVO : policyParamVOList) {
            DynamicObject newOccupancyDynObj = BusinessDataServiceHelper.newDynamicObject((String)"ococic_occupyrecords");
            newOccupancyDynObj.set("createtime", (Object)createDate);
            newOccupancyDynObj.set("billentityid", (Object)occupancyParamVO.getBillFormId());
            newOccupancyDynObj.set("billid", (Object)occupancyParamVO.getBillId());
            newOccupancyDynObj.set("billentryid", (Object)occupancyParamVO.getBillEntryId());
            newOccupancyDynObj.set("billno", (Object)occupancyParamVO.getBillNumber());
            newOccupancyDynObj.set("policyid", (Object)occupancyParamVO.getPolicyId());
            newOccupancyDynObj.set("policyentryid", (Object)occupancyParamVO.getPolicyEntryId());
            newOccupancyDynObj.set("itemid", (Object)occupancyParamVO.getItemId());
            newOccupancyDynObj.set("itemclass", (Object)occupancyParamVO.getItemClassId());
            newOccupancyDynObj.set("brand", (Object)occupancyParamVO.getBrandId());
            newOccupancyDynObj.set("materialid", (Object)occupancyParamVO.getMaterialId());
            newOccupancyDynObj.set("auxptyid", (Object)occupancyParamVO.getAuxptyId());
            newOccupancyDynObj.set("unitid", (Object)occupancyParamVO.getUnitId());
            newOccupancyDynObj.set("baseunitid", (Object)occupancyParamVO.getBaseUnitId());
            newOccupancyDynObj.set("qty", (Object)occupancyParamVO.getQty());
            newOccupancyDynObj.set("baseqty", (Object)occupancyParamVO.getBaseQty());
            newOccupancyDynObj.set("actualqty", (Object)occupancyParamVO.getActualQty());
            newOccupancyDynObj.set("actualbaseqty", (Object)occupancyParamVO.getActualBaseQty());
            newOccupancyDynObj.set("type", (Object)occupancyType);
            newOccupancyDynObj.set("creator", (Object)userId);
            newOccupancyDynObj.set("ipaddress", (Object)ipAddress);
            occupancyDynObjList.add(newOccupancyDynObj);
        }
        SaveServiceHelper.save((DynamicObject[])occupancyDynObjList.toArray(new DynamicObject[0]));
    }

    private DataSet getOccupancySalePolicyDataSet(Set<Long> policyIdSet, Set<Long> policyEntryIdSet) {
        String ruleSelectedFields = String.join((CharSequence)",", "id", String.join((CharSequence)".", "policyentity", "id") + " " + "entryid", this.joinSelectField("policyentity", "canoversaleqty"), this.joinSelectField("policyentity", "canoversalebaseqty"));
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", policyIdSet), new QFilter(String.join((CharSequence)".", "policyentity", "id"), "in", policyEntryIdSet)};
        return QueryServiceHelper.queryDataSet((String)OverSalePolicyServiceImpl.class.getName(), (String)"ococic_oversalepolicy", (String)ruleSelectedFields, (QFilter[])filters, (String)"");
    }

    @Override
    public void releaseOverSalePolicy(String billFormId, Map<Long, List<Long>> billIdMap) {
        if (CommonUtils.isNull(billIdMap)) {
            return;
        }
        DynamicObjectCollection occupancyRecordsColl = this.getOccupancyRecordsColl(billFormId, billIdMap);
        ArrayList<OccupancyPolicyParamVO> policyParamVOList = new ArrayList<OccupancyPolicyParamVO>(occupancyRecordsColl.size());
        HashSet<Long> policyIdSet = new HashSet<Long>(billIdMap.size());
        HashSet<Long> policyEntryIdSet = new HashSet<Long>(billIdMap.size());
        for (DynamicObject recordDynObj : occupancyRecordsColl) {
            if (!policyEntryIdSet.add(recordDynObj.getLong("policyentryid"))) continue;
            policyIdSet.add(recordDynObj.getLong("policyid"));
            policyParamVOList.add(this.newOccupancyPolicyParamVO(billFormId, recordDynObj));
        }
        DataSet salePolicyDataSet = this.getOccupancySalePolicyDataSet(policyIdSet, policyEntryIdSet);
        this.updateOverSalePolicy(policyParamVOList, salePolicyDataSet, "1");
    }

    private DynamicObjectCollection getOccupancyRecordsColl(String billFormId, Map<Long, List<Long>> billIdMap) {
        HashSet<Long> billIdSet = new HashSet<Long>(billIdMap.size());
        HashSet billEntryIdSet = new HashSet(billIdMap.size());
        for (Map.Entry<Long, List<Long>> entry : billIdMap.entrySet()) {
            billIdSet.add(entry.getKey());
            billEntryIdSet.addAll(entry.getValue());
        }
        QFilter[] filters = new QFilter[]{new QFilter("billid", "in", billIdSet), new QFilter("billentryid", "in", billEntryIdSet), new QFilter("billentityid", "=", (Object)billFormId), new QFilter("type", "=", (Object)Character.valueOf('0'))};
        return QueryServiceHelper.query((String)"ococic_occupyrecords", (String)String.join((CharSequence)",", "billid", "billentryid", "billno", "policyid", "policyentryid", "itemid", "materialid", "auxptyid", "unitid", "baseunitid", "qty", "baseqty", "actualqty", "actualbaseqty", "itemclass", "brand"), (QFilter[])filters, (String)"createtime desc ");
    }

    private OccupancyPolicyParamVO newOccupancyPolicyParamVO(String billFormId, DynamicObject recordDynObj) {
        OccupancyPolicyParamVO policyParamVo = new OccupancyPolicyParamVO();
        policyParamVo.setBillFormId(billFormId);
        policyParamVo.setBillId(recordDynObj.getLong("billid"));
        policyParamVo.setBillEntryId(recordDynObj.getLong("billentryid"));
        policyParamVo.setBillNumber(recordDynObj.getString("billno"));
        policyParamVo.setPolicyId(recordDynObj.getLong("policyid"));
        policyParamVo.setPolicyEntryId(recordDynObj.getLong("policyentryid"));
        policyParamVo.setItemId(recordDynObj.getLong("itemid"));
        policyParamVo.setItemClassId(recordDynObj.getLong("itemclass"));
        policyParamVo.setBrandId(recordDynObj.getLong("brand"));
        policyParamVo.setMaterialId(recordDynObj.getLong("materialid"));
        policyParamVo.setAuxptyId(recordDynObj.getLong("auxptyid"));
        policyParamVo.setUnitId(recordDynObj.getLong("unitid"));
        policyParamVo.setBaseUnitId(recordDynObj.getLong("baseunitid"));
        policyParamVo.setQty(BigDecimal.ZERO.subtract(recordDynObj.getBigDecimal("qty")));
        policyParamVo.setBaseQty(BigDecimal.ZERO.subtract(recordDynObj.getBigDecimal("baseqty")));
        policyParamVo.setActualQty(BigDecimal.ZERO.subtract(recordDynObj.getBigDecimal("actualqty")));
        policyParamVo.setActualBaseQty(BigDecimal.ZERO.subtract(recordDynObj.getBigDecimal("actualbaseqty")));
        return policyParamVo;
    }
}

