/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ococic.business.sharedinventory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.pagemodel.OcdbdItemInfo;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.ItemClassUtil;
import kd.occ.ocbase.common.util.StringUtils;
import kd.occ.ococic.business.sharedinventory.SharedDistributionRulesService;
import kd.occ.ococic.pojo.DistributionRulesParamVO;
import kd.occ.ococic.pojo.DistributionRulesResultVO;

public class SharedDistributionRulesServiceImpl
implements SharedDistributionRulesService {
    private static Log log = LogFactory.getLog(SharedDistributionRulesServiceImpl.class);

    @Override
    public List<DistributionRulesResultVO> matchDistributionRules(List<DistributionRulesParamVO> rulesParamVOList) {
        if (CommonUtils.isNull(rulesParamVOList)) {
            return new ArrayList<DistributionRulesResultVO>(0);
        }
        if ((rulesParamVOList = rulesParamVOList.stream().filter(rulesParam -> rulesParam.getSaleOrgId() > 0L && rulesParam.getItemId() > 0L && rulesParam.getAdminDivisionId() > 0L).collect(Collectors.toList())).size() == 0) {
            return new ArrayList<DistributionRulesResultVO>(0);
        }
        long begin = System.currentTimeMillis();
        Set<Long> adminDivisionIdSet = rulesParamVOList.stream().map(DistributionRulesParamVO::getAdminDivisionId).collect(Collectors.toSet());
        QFilter filter = new QFilter("level", "in", (Object)new Integer[]{1, 2, 3});
        Map adminDivisionDynObjMap = BusinessDataServiceHelper.loadFromCache((String)"bd_admindivision", (String)"id,country,level,parent", (QFilter[])filter.toArray());
        filter = new QFilter("id", "in", adminDivisionIdSet);
        filter.and(new QFilter("level", "=", (Object)4));
        Map streetDynObjMap = BusinessDataServiceHelper.loadFromCache((String)"bd_admindivision", (String)"id,country,level,parent", (QFilter[])filter.toArray());
        adminDivisionDynObjMap.putAll(streetDynObjMap);
        if (!CommonUtils.isNull((Object)adminDivisionDynObjMap)) {
            Collection adminDivisionDynObjColl = adminDivisionDynObjMap.values();
            adminDivisionIdSet.removeAll(adminDivisionDynObjColl.stream().map(obj -> obj.getLong("id")).collect(Collectors.toSet()));
            Map<Long, List<DynamicObject>> adminDivisionMap = adminDivisionDynObjColl.stream().collect(Collectors.groupingBy(obj -> obj.getLong("id")));
            Map<Long, List<DistributionRulesParamVO>> map = rulesParamVOList.stream().collect(Collectors.groupingBy(DistributionRulesParamVO::getAdminDivisionId));
            for (Map.Entry<Long, List<DistributionRulesParamVO>> mapEntry : map.entrySet()) {
                List<DistributionRulesParamVO> paramVOList = mapEntry.getValue();
                List adminDivisionDynList = adminDivisionDynObjColl.stream().filter(obj -> obj.getLong("id") == ((Long)mapEntry.getKey()).longValue()).collect(Collectors.toList());
                if (CommonUtils.isNull(adminDivisionDynList)) continue;
                DynamicObject adminDivisionDynObj = (DynamicObject)adminDivisionDynList.get(0);
                int level = adminDivisionDynObj.getInt("level");
                switch (level) {
                    case 4: {
                        this.setAdminDivisionInfoByStreet(adminDivisionMap, adminDivisionDynObj, paramVOList);
                        break;
                    }
                    case 3: {
                        this.setAdminDivisionInfoByCounty(adminDivisionMap, adminDivisionDynObj, paramVOList);
                        break;
                    }
                    case 2: {
                        this.setAdminDivisionInfoByCity(adminDivisionDynObj, paramVOList);
                        break;
                    }
                    case 1: {
                        this.setAdminDivisionInfoByProvince(adminDivisionDynObj, paramVOList);
                        break;
                    }
                }
                rulesParamVOList.addAll(paramVOList);
            }
        }
        if (adminDivisionIdSet.size() > 0) {
            this.setAdminDivisionInfoByCountry(adminDivisionIdSet, rulesParamVOList);
        }
        log.info("setAdminDivisionInfo end:" + (System.currentTimeMillis() - begin));
        rulesParamVOList.addAll(this.getSaleOrgItemRuleParamVOList(rulesParamVOList));
        begin = System.currentTimeMillis();
        Set itemIdSet = rulesParamVOList.stream().map(DistributionRulesParamVO::getItemId).collect(Collectors.toSet());
        QFilter qfilter = new QFilter("id", "in", itemIdSet);
        DynamicObjectCollection itemClassDynColl = QueryServiceHelper.query((String)"ocdbd_iteminfo", (String)String.join((CharSequence)",", "id", OcdbdItemInfo.Q_EF_classstandardid, OcdbdItemInfo.Q_EF_goodsclasssid), (QFilter[])qfilter.toArray());
        if (!CommonUtils.isNull((Object)itemClassDynColl)) {
            rulesParamVOList.addAll(this.getItemClassRuleParamVOList(itemClassDynColl, rulesParamVOList));
        }
        log.info("getItemClassRuleParamVOList end:" + (System.currentTimeMillis() - begin));
        begin = System.currentTimeMillis();
        DataSet distributionRulesDataSet = this.getDistributionRulesParamDataSet(rulesParamVOList);
        log.info("getDistributionRulesParamDataSet end:" + (System.currentTimeMillis() - begin));
        return this.createRulesResultVOList(distributionRulesDataSet);
    }

    private List<DistributionRulesParamVO> getSaleOrgItemRuleParamVOList(List<DistributionRulesParamVO> rulesParamVOList) {
        ArrayList<DistributionRulesParamVO> saleOrgItemRuleParamVOList = new ArrayList<DistributionRulesParamVO>(rulesParamVOList.size());
        for (DistributionRulesParamVO rulesParamVO : rulesParamVOList) {
            rulesParamVO.put((Object)"itemclassid", (Object)0);
            rulesParamVO.put((Object)"rulesseq", (Object)1);
            DistributionRulesParamVO addRulesParamVO = new DistributionRulesParamVO();
            addRulesParamVO.setSaleOrgId(rulesParamVO.getSaleOrgId());
            addRulesParamVO.setChannelId(0L);
            addRulesParamVO.setItemId(rulesParamVO.getItemId());
            addRulesParamVO.put((Object)"itemclassid", (Object)0);
            addRulesParamVO.setAdminDivisionId(rulesParamVO.getAdminDivisionId());
            addRulesParamVO.put((Object)"countryid", rulesParamVO.get((Object)"countryid"));
            addRulesParamVO.put((Object)"provinceid", rulesParamVO.get((Object)"provinceid"));
            addRulesParamVO.put((Object)"cityid", rulesParamVO.get((Object)"cityid"));
            addRulesParamVO.put((Object)"countyid", rulesParamVO.get((Object)"countyid"));
            addRulesParamVO.put((Object)"sortseq", rulesParamVO.get((Object)"sortseq"));
            addRulesParamVO.put((Object)"rulesseq", (Object)2);
            saleOrgItemRuleParamVOList.add(addRulesParamVO);
        }
        return saleOrgItemRuleParamVOList;
    }

    private List<DistributionRulesParamVO> getItemClassRuleParamVOList(DynamicObjectCollection itemClassDynColl, List<DistributionRulesParamVO> rulesParamVOList) {
        ArrayList<DistributionRulesParamVO> itemClassRuleParamVOList = new ArrayList<DistributionRulesParamVO>(rulesParamVOList.size());
        Set classStandardIdSet = itemClassDynColl.stream().map(obj -> obj.getLong(OcdbdItemInfo.Q_EF_classstandardid)).collect(Collectors.toSet());
        Map itemClassMap = ItemClassUtil.queryAllItemClassId(classStandardIdSet);
        for (DynamicObject itemClassDynObj : itemClassDynColl) {
            for (DistributionRulesParamVO rulesParamVO : rulesParamVOList) {
                List itemclassids;
                if (rulesParamVO.getItemId() != itemClassDynObj.getLong("id") || CommonUtils.isNull((Object)(itemclassids = (List)itemClassMap.get(itemClassDynObj.getLong(OcdbdItemInfo.Q_EF_goodsclasssid))))) continue;
                for (Object itemclassid : itemclassids) {
                    DistributionRulesParamVO addRulesParamVO = new DistributionRulesParamVO();
                    addRulesParamVO.setSaleOrgId(rulesParamVO.getSaleOrgId());
                    addRulesParamVO.setChannelId(rulesParamVO.getChannelId());
                    addRulesParamVO.setItemId(rulesParamVO.getItemId());
                    addRulesParamVO.put((Object)"itemclassid", itemclassid);
                    addRulesParamVO.setAdminDivisionId(rulesParamVO.getAdminDivisionId());
                    addRulesParamVO.put((Object)"countryid", rulesParamVO.get((Object)"countryid"));
                    addRulesParamVO.put((Object)"provinceid", rulesParamVO.get((Object)"provinceid"));
                    addRulesParamVO.put((Object)"cityid", rulesParamVO.get((Object)"cityid"));
                    addRulesParamVO.put((Object)"countyid", rulesParamVO.get((Object)"countyid"));
                    addRulesParamVO.put((Object)"sortseq", rulesParamVO.get((Object)"sortseq"));
                    if ("1".equals(rulesParamVO.get((Object)"rulesseq").toString())) {
                        addRulesParamVO.put((Object)"rulesseq", (Object)3);
                    } else if ("2".equals(rulesParamVO.get((Object)"rulesseq").toString())) {
                        addRulesParamVO.put((Object)"rulesseq", (Object)4);
                    }
                    itemClassRuleParamVOList.add(addRulesParamVO);
                }
            }
        }
        return itemClassRuleParamVOList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DistributionRulesResultVO> createRulesResultVOList(DataSet distributionRulesDataSet) {
        ArrayList<DistributionRulesResultVO> rulesResultVOList = new ArrayList<DistributionRulesResultVO>(100);
        try {
            HashSet<String> keySet = new HashSet<String>(20);
            while (distributionRulesDataSet.hasNext()) {
                Row rulesDataSetRow = distributionRulesDataSet.next();
                DistributionRulesResultVO rulesResultVO = new DistributionRulesResultVO();
                String key = StringUtils.join((CharSequence)"_", (Object[])new Object[]{rulesDataSetRow.getInteger("sortseq"), rulesDataSetRow.getLong("saleorgid"), rulesDataSetRow.getLong("itemid"), rulesDataSetRow.getLong("itemclassid"), rulesDataSetRow.getLong("countryid"), rulesDataSetRow.getLong("provinceid"), rulesDataSetRow.getLong("cityid"), rulesDataSetRow.getLong("countyid"), rulesDataSetRow.getLong("adminDivisionId"), rulesDataSetRow.getLong("mode"), rulesDataSetRow.getLong("branch"), rulesDataSetRow.getLong("stock"), rulesDataSetRow.getLong("inventoryorg"), rulesDataSetRow.getLong("erpstock"), rulesDataSetRow.getLong("priority")});
                if (keySet.contains(key)) continue;
                keySet.add(key);
                rulesResultVO.setSaleChannelId(rulesDataSetRow.getLong("salechannelid").longValue());
                rulesResultVO.setSaleOrgId(rulesDataSetRow.getLong("saleorgid").longValue());
                rulesResultVO.setItemId(rulesDataSetRow.getLong("itemid").longValue());
                rulesResultVO.setAdminDivisionId(rulesDataSetRow.getLong("adminDivisionId").longValue());
                rulesResultVO.setDistributionModeId(rulesDataSetRow.getLong("mode").longValue());
                rulesResultVO.setDeliveryChannelId(rulesDataSetRow.getLong("branch").longValue());
                rulesResultVO.setChannelWarehouseId(rulesDataSetRow.getLong("stock").longValue());
                rulesResultVO.setStockOrgId(rulesDataSetRow.getLong("inventoryorg").longValue());
                rulesResultVO.setWarehouseId(rulesDataSetRow.getLong("erpstock").longValue());
                rulesResultVO.setPriority(rulesDataSetRow.getInteger("priority").intValue());
                rulesResultVOList.add(rulesResultVO);
            }
        }
        finally {
            distributionRulesDataSet.close();
        }
        return rulesResultVOList;
    }

    private void setAdminDivisionInfoByStreet(Map<Long, List<DynamicObject>> adminDivisionMap, DynamicObject adminDivisionDynObj, List<DistributionRulesParamVO> rulesParamVOList) {
        ArrayList<DistributionRulesParamVO> parentRulesParamVOList = new ArrayList<DistributionRulesParamVO>(rulesParamVOList.size());
        for (DistributionRulesParamVO rulesParamVO : rulesParamVOList) {
            DynamicObject countyDynObj = adminDivisionMap.get(adminDivisionDynObj.getLong("parent_id")).get(0);
            long cityId = countyDynObj.getLong("parent_id");
            DynamicObject cityDynObj = adminDivisionMap.get(cityId).get(0);
            rulesParamVO.put((Object)"countryid", (Object)countyDynObj.getLong("country_id"));
            rulesParamVO.put((Object)"provinceid", (Object)cityDynObj.getLong("parent_id"));
            rulesParamVO.put((Object)"cityid", (Object)cityId);
            rulesParamVO.put((Object)"countyid", (Object)countyDynObj.getLong("id"));
            rulesParamVO.put((Object)"sortseq", (Object)1);
            parentRulesParamVOList.addAll(this.createParentRulesParamVO(rulesParamVO, countyDynObj.getLong("country_id"), cityDynObj.getLong("parent_id"), cityId));
        }
        rulesParamVOList.addAll(parentRulesParamVOList);
    }

    private void setAdminDivisionInfoByCounty(Map<Long, List<DynamicObject>> adminDivisionMap, DynamicObject adminDivisionDynObj, List<DistributionRulesParamVO> rulesParamVOList) {
        ArrayList<DistributionRulesParamVO> parentRulesParamVOList = new ArrayList<DistributionRulesParamVO>(rulesParamVOList.size());
        for (DistributionRulesParamVO rulesParamVO : rulesParamVOList) {
            DynamicObject countyDynObj = adminDivisionMap.get(adminDivisionDynObj.getLong("parent_id")).get(0);
            long cityId = countyDynObj.getLong("parent_id");
            DynamicObject cityDynObj = adminDivisionMap.get(cityId).get(0);
            rulesParamVO.put((Object)"countryid", (Object)countyDynObj.getLong("country_id"));
            rulesParamVO.put((Object)"provinceid", (Object)cityDynObj.getLong("parent_id"));
            rulesParamVO.put((Object)"cityid", (Object)cityId);
            rulesParamVO.put((Object)"countyid", (Object)countyDynObj.getLong("id"));
            rulesParamVO.put((Object)"sortseq", (Object)1);
            parentRulesParamVOList.addAll(this.createParentRulesParamVO(rulesParamVO, countyDynObj.getLong("country_id"), cityDynObj.getLong("parent_id"), cityId));
        }
        rulesParamVOList.addAll(parentRulesParamVOList);
    }

    private List<DistributionRulesParamVO> createParentRulesParamVO(DistributionRulesParamVO rulesParamVO, long countryId, long provinceId, long cityId) {
        ArrayList<DistributionRulesParamVO> parentRulesParamVOList = new ArrayList<DistributionRulesParamVO>(3);
        DistributionRulesParamVO parentRulesParamVO = new DistributionRulesParamVO();
        parentRulesParamVO.setChannelId(rulesParamVO.getChannelId());
        parentRulesParamVO.setSaleOrgId(rulesParamVO.getSaleOrgId());
        parentRulesParamVO.setItemId(rulesParamVO.getItemId());
        parentRulesParamVO.setAdminDivisionId(rulesParamVO.getAdminDivisionId());
        parentRulesParamVO.put((Object)"countryid", (Object)countryId);
        parentRulesParamVO.put((Object)"provinceid", (Object)provinceId);
        parentRulesParamVO.put((Object)"cityid", (Object)cityId);
        parentRulesParamVO.put((Object)"countyid", (Object)0);
        parentRulesParamVO.put((Object)"sortseq", (Object)2);
        parentRulesParamVOList.add(parentRulesParamVO);
        parentRulesParamVO = new DistributionRulesParamVO();
        parentRulesParamVO.setChannelId(rulesParamVO.getChannelId());
        parentRulesParamVO.setSaleOrgId(rulesParamVO.getSaleOrgId());
        parentRulesParamVO.setItemId(rulesParamVO.getItemId());
        parentRulesParamVO.setAdminDivisionId(rulesParamVO.getAdminDivisionId());
        parentRulesParamVO.put((Object)"countryid", (Object)countryId);
        parentRulesParamVO.put((Object)"provinceid", (Object)provinceId);
        parentRulesParamVO.put((Object)"cityid", (Object)0);
        parentRulesParamVO.put((Object)"countyid", (Object)0);
        parentRulesParamVO.put((Object)"sortseq", (Object)3);
        parentRulesParamVOList.add(parentRulesParamVO);
        parentRulesParamVO = new DistributionRulesParamVO();
        parentRulesParamVO.setChannelId(rulesParamVO.getChannelId());
        parentRulesParamVO.setSaleOrgId(rulesParamVO.getSaleOrgId());
        parentRulesParamVO.setItemId(rulesParamVO.getItemId());
        parentRulesParamVO.setAdminDivisionId(rulesParamVO.getAdminDivisionId());
        parentRulesParamVO.put((Object)"countryid", (Object)countryId);
        parentRulesParamVO.put((Object)"provinceid", (Object)0);
        parentRulesParamVO.put((Object)"cityid", (Object)0);
        parentRulesParamVO.put((Object)"countyid", (Object)0);
        parentRulesParamVO.put((Object)"sortseq", (Object)4);
        parentRulesParamVOList.add(parentRulesParamVO);
        return parentRulesParamVOList;
    }

    private void setAdminDivisionInfoByCity(DynamicObject cityDynObj, List<DistributionRulesParamVO> rulesParamVOList) {
        ArrayList<DistributionRulesParamVO> parentRulesParamVOList = new ArrayList<DistributionRulesParamVO>(rulesParamVOList.size());
        for (DistributionRulesParamVO rulesParamVO : rulesParamVOList) {
            long adminDivisionId = rulesParamVO.getAdminDivisionId();
            rulesParamVO.put((Object)"countryid", (Object)cityDynObj.getLong("country_id"));
            rulesParamVO.put((Object)"provinceid", (Object)cityDynObj.getLong("parent_id"));
            rulesParamVO.put((Object)"cityid", (Object)adminDivisionId);
            rulesParamVO.put((Object)"countyid", (Object)0);
            rulesParamVO.put((Object)"sortseq", (Object)2);
            DistributionRulesParamVO parentRulesParamVO = new DistributionRulesParamVO();
            parentRulesParamVO.setChannelId(rulesParamVO.getChannelId());
            parentRulesParamVO.setSaleOrgId(rulesParamVO.getSaleOrgId());
            parentRulesParamVO.setItemId(rulesParamVO.getItemId());
            parentRulesParamVO.setAdminDivisionId(rulesParamVO.getAdminDivisionId());
            parentRulesParamVO.put((Object)"countryid", (Object)cityDynObj.getLong("country_id"));
            parentRulesParamVO.put((Object)"provinceid", (Object)cityDynObj.getLong("parent_id"));
            parentRulesParamVO.put((Object)"cityid", (Object)0);
            parentRulesParamVO.put((Object)"countyid", (Object)0);
            parentRulesParamVO.put((Object)"sortseq", (Object)3);
            parentRulesParamVOList.add(parentRulesParamVO);
            parentRulesParamVO = new DistributionRulesParamVO();
            parentRulesParamVO.setChannelId(rulesParamVO.getChannelId());
            parentRulesParamVO.setSaleOrgId(rulesParamVO.getSaleOrgId());
            parentRulesParamVO.setItemId(rulesParamVO.getItemId());
            parentRulesParamVO.setAdminDivisionId(rulesParamVO.getAdminDivisionId());
            parentRulesParamVO.put((Object)"countryid", (Object)cityDynObj.getLong("country_id"));
            parentRulesParamVO.put((Object)"provinceid", (Object)0);
            parentRulesParamVO.put((Object)"cityid", (Object)0);
            parentRulesParamVO.put((Object)"countyid", (Object)0);
            parentRulesParamVO.put((Object)"sortseq", (Object)4);
            parentRulesParamVOList.add(parentRulesParamVO);
        }
        rulesParamVOList.addAll(parentRulesParamVOList);
    }

    private void setAdminDivisionInfoByProvince(DynamicObject provinceDynObj, List<DistributionRulesParamVO> rulesParamVOList) {
        ArrayList<DistributionRulesParamVO> parentRulesParamVOList = new ArrayList<DistributionRulesParamVO>(rulesParamVOList.size());
        for (DistributionRulesParamVO rulesParamVO : rulesParamVOList) {
            long adminDivisionId = rulesParamVO.getAdminDivisionId();
            rulesParamVO.put((Object)"countryid", (Object)provinceDynObj.getLong("country_id"));
            rulesParamVO.put((Object)"provinceid", (Object)adminDivisionId);
            rulesParamVO.put((Object)"cityid", (Object)0);
            rulesParamVO.put((Object)"countyid", (Object)0);
            rulesParamVO.put((Object)"sortseq", (Object)3);
            DistributionRulesParamVO parentRulesParamVO = new DistributionRulesParamVO();
            parentRulesParamVO.setChannelId(rulesParamVO.getChannelId());
            parentRulesParamVO.setSaleOrgId(rulesParamVO.getSaleOrgId());
            parentRulesParamVO.setItemId(rulesParamVO.getItemId());
            parentRulesParamVO.setAdminDivisionId(rulesParamVO.getAdminDivisionId());
            parentRulesParamVO.put((Object)"countryid", (Object)provinceDynObj.getLong("country_id"));
            parentRulesParamVO.put((Object)"provinceid", (Object)0);
            parentRulesParamVO.put((Object)"cityid", (Object)0);
            parentRulesParamVO.put((Object)"countyid", (Object)0);
            parentRulesParamVO.put((Object)"sortseq", (Object)4);
            parentRulesParamVOList.add(parentRulesParamVO);
        }
        rulesParamVOList.addAll(parentRulesParamVOList);
    }

    private void setAdminDivisionInfoByCountry(Set<Long> adminDivisionIdSet, List<DistributionRulesParamVO> rulesParamVOList) {
        for (DistributionRulesParamVO rulesParamVO : rulesParamVOList) {
            long adminDivisionId = rulesParamVO.getAdminDivisionId();
            if (!adminDivisionIdSet.contains(adminDivisionId)) continue;
            rulesParamVO.put((Object)"countryid", (Object)adminDivisionId);
            rulesParamVO.put((Object)"provinceid", (Object)0);
            rulesParamVO.put((Object)"cityid", (Object)0);
            rulesParamVO.put((Object)"countyid", (Object)0);
            rulesParamVO.put((Object)"sortseq", (Object)4);
        }
    }

    private DataSet getDistributionRulesParamDataSet(List<DistributionRulesParamVO> rulesParamVOList) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        fieldList.add(new Field("sortseq", (DataType)DataType.IntegerType));
        fieldList.add(new Field("rulesseq", (DataType)DataType.IntegerType));
        fieldList.add(new Field("salechannelid", (DataType)DataType.LongType));
        fieldList.add(new Field("saleorgid", (DataType)DataType.LongType));
        fieldList.add(new Field("itemid", (DataType)DataType.LongType));
        fieldList.add(new Field("itemclassid", (DataType)DataType.LongType));
        fieldList.add(new Field("adminDivisionId", (DataType)DataType.LongType));
        fieldList.add(new Field("countryid", (DataType)DataType.LongType));
        fieldList.add(new Field("provinceid", (DataType)DataType.LongType));
        fieldList.add(new Field("cityid", (DataType)DataType.LongType));
        fieldList.add(new Field("countyid", (DataType)DataType.LongType));
        RowMeta rowMeta = new RowMeta(fieldList.toArray(new Field[0]));
        DataSetBuilder dataSetBuilder = Algo.create((String)"RulesParamData").createDataSetBuilder(rowMeta);
        int listSize = rulesParamVOList.size();
        HashSet<Long> itemIdSet = new HashSet<Long>(listSize);
        HashSet<Long> saleChannelIdSet = new HashSet<Long>(listSize);
        HashSet<Long> saleOrgIdSet = new HashSet<Long>(listSize);
        HashSet<Object> countryIdSet = new HashSet<Object>(listSize);
        HashSet<Object> provinceIdSet = new HashSet<Object>(listSize);
        HashSet<Object> cityIdSet = new HashSet<Object>(listSize);
        HashSet<Object> countyIdSet = new HashSet<Object>(listSize);
        HashSet<Object> itemClassIdSet = new HashSet<Object>(listSize);
        for (DistributionRulesParamVO rulesParamVO : rulesParamVOList) {
            itemIdSet.add(rulesParamVO.getItemId());
            saleOrgIdSet.add(rulesParamVO.getSaleOrgId());
            if (rulesParamVO.getChannelId() > 0L) {
                saleChannelIdSet.add(rulesParamVO.getChannelId());
            }
            countryIdSet.add(rulesParamVO.get((Object)"countryid"));
            provinceIdSet.add(rulesParamVO.get((Object)"provinceid"));
            cityIdSet.add(rulesParamVO.get((Object)"cityid"));
            countyIdSet.add(rulesParamVO.get((Object)"countyid"));
            itemClassIdSet.add(rulesParamVO.get((Object)"itemclassid"));
            dataSetBuilder.append(new Object[]{rulesParamVO.get((Object)"sortseq"), rulesParamVO.get((Object)"rulesseq"), rulesParamVO.getChannelId(), rulesParamVO.getSaleOrgId(), rulesParamVO.getItemId(), rulesParamVO.get((Object)"itemclassid"), rulesParamVO.getAdminDivisionId(), rulesParamVO.get((Object)"countryid"), rulesParamVO.get((Object)"provinceid"), rulesParamVO.get((Object)"cityid"), rulesParamVO.get((Object)"countyid")});
        }
        DataSet rulesParamDataSet = dataSetBuilder.build();
        String ruleSelectedFields = String.join((CharSequence)",", "salebranch", "saleorg", "goods", "country", "province", "city", "county", "itemclass", "mode", "branch", "stock", "inventoryorg", "erpstock", "priority");
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(9);
        saleChannelIdSet.add(0L);
        filterList.add(new QFilter("salebranch", "in", saleChannelIdSet));
        filterList.add(new QFilter("saleorg", "in", saleOrgIdSet));
        itemIdSet.add(0L);
        filterList.add(new QFilter("goods", "in", itemIdSet));
        itemClassIdSet.add(0L);
        filterList.add(new QFilter("itemclass", "in", itemClassIdSet));
        filterList.add(new QFilter("country", "in", countryIdSet));
        filterList.add(new QFilter("province", "in", provinceIdSet));
        filterList.add(new QFilter("city", "in", cityIdSet));
        filterList.add(new QFilter("county", "in", countyIdSet));
        filterList.add(new QFilter("enable", "=", (Object)"1"));
        DataSet distributionRulesDataSet = QueryServiceHelper.queryDataSet((String)SharedDistributionRulesServiceImpl.class.getName(), (String)"ocdbd_distributionrules", (String)ruleSelectedFields, (QFilter[])filterList.toArray(new QFilter[9]), (String)"");
        DataSet itemDataSet = rulesParamDataSet.rightJoin(distributionRulesDataSet.filter("itemclass = 0 AND goods>0")).on("salechannelid", "salebranch").on("saleorgid", "saleorg").on("itemid", "goods").on("itemclassid", "itemclass").on("countryid", "country").on("provinceid", "province").on("cityid", "city").on("countyid", "county").select(rulesParamDataSet.getRowMeta().getFieldNames(), new String[]{"mode", "branch", "stock", "inventoryorg", "erpstock", "priority"}).finish().filter("rulesseq IN (1,2)");
        DataSet itemClassDataSet = rulesParamDataSet.rightJoin(distributionRulesDataSet.filter("itemclass > 0 AND goods=0")).on("salechannelid", "salebranch").on("saleorgid", "saleorg").on("itemclassid", "itemclass").on("countryid", "country").on("provinceid", "province").on("cityid", "city").on("countyid", "county").select(rulesParamDataSet.getRowMeta().getFieldNames(), new String[]{"mode", "branch", "stock", "inventoryorg", "erpstock", "priority"}).finish().filter("rulesseq IN (3,4)");
        DataSet noItemClassDataSet = rulesParamDataSet.rightJoin(distributionRulesDataSet.filter("itemclass = 0 AND goods=0")).on("salechannelid", "salebranch").on("saleorgid", "saleorg").on("itemclassid", "itemclass").on("countryid", "country").on("provinceid", "province").on("cityid", "city").on("countyid", "county").select(rulesParamDataSet.getRowMeta().getFieldNames(), new String[]{"mode", "branch", "stock", "inventoryorg", "erpstock", "priority"}).finish();
        return itemDataSet.union(itemClassDataSet).union(noItemClassDataSet).orderBy(new String[]{"rulesseq", "sortseq", "salechannelid", "itemid", "saleorgid", "itemclassid", "adminDivisionId", "priority"});
    }

    public List<DynamicObject> getClassParentIds(DynamicObject itemClassDynObj) {
        long id = itemClassDynObj.getLong("id");
        List classids = ItemClassUtil.queryClassList((Object)id);
        if (classids == null) {
            return new ArrayList<DynamicObject>(0);
        }
        ArrayList<DynamicObject> itemclassids = new ArrayList<DynamicObject>(classids.size());
        for (Object classid : classids) {
            id = Long.parseLong(classid.toString());
            DynamicObject dyo = BusinessDataServiceHelper.loadSingle((Object)id, (String)"mdr_item_class");
            itemclassids.add(dyo);
        }
        return itemclassids;
    }
}

